/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.deployments;

import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDockerDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.deployments.APIDeployerImageBuilderService;
import com.dataiku.dip.deployer.apideployer.deployments.AbstractAPIServiceDockerDeploymentConfigManager;
import com.dataiku.dip.utils.DKUDateUtils;
import org.apache.commons.lang.StringUtils;

public class K8SDeploymentConfigManager
extends AbstractAPIServiceDockerDeploymentConfigManager {
    private final K8SAPIServiceDeployment deployment;
    private final K8SAPIDeploymentInfra infra;

    public K8SDeploymentConfigManager(K8SAPIServiceDeployment deployment, K8SAPIDeploymentInfra infra) {
        this.deployment = deployment;
        this.infra = infra;
    }

    @Override
    protected AbstractAPIServiceDockerDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    protected AbstractAPIDockerDeploymentInfra getInfra() {
        return this.infra;
    }

    @Override
    public String getImageName() {
        return (String)(StringUtils.isBlank((String)this.infra.imagesNamePrefix) ? "" : this.infra.imagesNamePrefix + "/") + "apimodel-" + APIDeployerImageBuilderService.sanitizeDeploymentId(this.deployment.id);
    }

    @Override
    public String generateImageVersion() {
        return "r-" + DKUDateUtils.isoFormatFileFriendlyLocalNow();
    }
}

