/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.infra;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.deployer.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.deployer.apideployer.monitoring.AzureMLActivityMetricsFetchingService;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.DeployerUtils;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLHttpClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AzureMLInfraManager
implements ApiNodeInfraManager {
    private final AzureMLAPIDeploymentInfra infra;
    @Autowired
    private AzureMLActivityMetricsFetchingService azureMLActivityMetricsFetchingService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.infra.azure.manager");

    public AzureMLInfraManager(AzureMLAPIDeploymentInfra infra) {
        this.infra = infra;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public InfoMessage.InfoMessages checkInfraStatus_NT(AuthCtx authCtx) {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        boolean isMissingWorkspace = StringUtils.isBlank((String)this.infra.azWorkspace);
        boolean isMissingResourceGroup = StringUtils.isBlank((String)this.infra.azResourceGroup);
        boolean isMissingSubscription = StringUtils.isBlank((String)this.infra.azSubscription);
        if (isMissingWorkspace || isMissingResourceGroup || isMissingSubscription) {
            if (isMissingWorkspace) {
                messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_MISSING_WORKSPACE, "Azure workspace is empty.");
            }
            if (isMissingResourceGroup) {
                messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_MISSING_RESOURCE_GROUP, "Azure resource group is empty.");
            }
            if (isMissingSubscription) {
                messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_MISSING_SUBSCRIPTION, "Azure subscription is empty.");
            }
            return messages;
        }
        try (AzureMLHttpClient azureMLClient = AzureMLUtils.getAzureMLClient_NT(authCtx, this.infra.authConnection, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());){
            azureMLClient.listOnlineEndpoints_NT(this.infra.azWorkspace, this.infra.azResourceGroup, this.infra.azSubscription);
        }
        catch (Exception e) {
            String errorMessage = "AzureML request failed with error " + String.valueOf(e);
            messages.withFatal((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_AZUREML_ERROR, errorMessage);
            logger.error((Object)errorMessage);
        }
        return messages;
    }

    @Override
    public ActivityMetric.TimeAndMetricsByDeploymentAndEndpoint getActivityMetrics_NT(AuthCtx authCtx, int connectTimeout, int socketTimeout, String overridingConnectionName) {
        return this.azureMLActivityMetricsFetchingService.getInfraActivityMetrics_NT(authCtx, this.infra, connectTimeout, socketTimeout, overridingConnectionName);
    }
}

