/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.datamodel.config;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.StaticAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentHook;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.MultiAutomationNodeInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.SingleAutomationNodeInfra;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@PolyJSON(value={@Mapping(type="STATIC", value=StaticAPIDeploymentInfra.class), @Mapping(type="K8S", value=K8SAPIDeploymentInfra.class), @Mapping(type="AZURE_ML", value=AzureMLAPIDeploymentInfra.class), @Mapping(type="DATABRICKS", value=DatabricksAPIDeploymentInfra.class), @Mapping(type="SAGEMAKER", value=SageMakerAPIDeploymentInfra.class), @Mapping(type="SNOWPARK", value=SnowparkAPIDeploymentInfra.class), @Mapping(type="VERTEX_AI", value=VertexAIAPIDeploymentInfra.class), @Mapping(type="AUTOMATION_NODE", value=SingleAutomationNodeInfra.class), @Mapping(type="MULTI_AUTOMATION_NODE", value=MultiAutomationNodeInfra.class)})
public abstract class AbstractDeploymentInfra {
    @JSON.FileTransient
    public String id;
    public List<PermissionItem> permissions = new ArrayList<PermissionItem>();
    public String stage;
    public VersionTag creationTag;
    public VersionTag versionTag;
    public GovernCheckPolicy governCheckPolicy = GovernCheckPolicy.NO_CHECK;
    public DeploymentHookSettings deploymentHookSettings = new DeploymentHookSettings();
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.datamodel.config");

    protected AbstractDeploymentInfra() {
    }

    protected AbstractDeploymentInfra(String id, String stage, String userIdentifier, @Nullable GovernCheckPolicy governCheckPolicy) {
        this.id = id;
        this.stage = stage;
        this.versionTag = this.creationTag = new VersionTag(userIdentifier);
        this.governCheckPolicy = governCheckPolicy == null ? GovernCheckPolicy.NO_CHECK : governCheckPolicy;
    }

    protected void verifyFieldExistingDeployments(Object oldField, Object newField, String fieldName) {
        if (!Objects.equals(oldField, newField)) {
            throw ErrorContext.iaef((String)"The %s of the infrastructure cannot be modified (old value: %s, new value: %s) since there are existing deployments.", (Object)fieldName, (Object[])new Object[]{oldField, newField});
        }
    }

    public void verifyFields(AuthCtx authCtx, AbstractDeploymentInfra oldInfra) throws IOException {
    }

    public void verifyHookChangePermission(AuthCtx authCtx, AbstractDeploymentInfra oldInfra) throws DKUSecurityException {
        if (!authCtx.isAdmin() && !Objects.equals(this.deploymentHookSettings.runHooksAsUser, oldInfra.deploymentHookSettings.runHooksAsUser)) {
            throw new DKUSecurityException("You do not have permission to change the hooks");
        }
    }

    public void encryptFields(PasswordEncryptionService passwordEncryptionService) {
    }

    public abstract String getKey();

    public boolean hasDeploymentHooksEnabled() {
        return this.numberOfPreDeploymentHooksEnabled() + this.numberOfPostDeploymentHooksEnabled() > 0L;
    }

    public long numberOfPreDeploymentHooksEnabled() {
        return this.deploymentHookSettings.preDeploymentHooks.stream().filter(h -> h.enabled).count();
    }

    public long numberOfPostDeploymentHooksEnabled() {
        return this.deploymentHookSettings.postDeploymentHooks.stream().filter(h -> h.enabled).count();
    }

    public List<AbstractDeploymentHook> getDeploymentHooks(boolean preHooks) {
        return preHooks ? this.deploymentHookSettings.preDeploymentHooks : this.deploymentHookSettings.postDeploymentHooks;
    }

    public abstract InfraType getInfraType();

    public static enum GovernCheckPolicy {
        PREVENT,
        WARN,
        NO_CHECK;

    }

    public static class DeploymentHookSettings {
        public static final int DEFAULT_MAX_HOOKS_KERNELS = DKUApp.getParams().getIntParam("dku.deployer.hooks.kernels.defaultMaxPerInfra", Integer.valueOf(3));
        public String hookCodeEnvName;
        public String runHooksAsUser;
        public int maxHooksKernels = DEFAULT_MAX_HOOKS_KERNELS;
        public List<AbstractDeploymentHook> preDeploymentHooks = new ArrayList<AbstractDeploymentHook>();
        public List<AbstractDeploymentHook> postDeploymentHooks = new ArrayList<AbstractDeploymentHook>();
    }

    @UIModel
    public static enum InfraType {
        STATIC(BaseType.API),
        K8S(BaseType.API),
        SAGEMAKER(BaseType.API),
        VERTEX_AI(BaseType.API),
        AZURE_ML(BaseType.API),
        DATABRICKS(BaseType.API),
        SNOWPARK(BaseType.API),
        AUTOMATION_NODE(BaseType.PROJECT),
        MULTI_AUTOMATION_NODE(BaseType.PROJECT);

        public final BaseType baseType;

        private InfraType(BaseType baseType) {
            this.baseType = baseType;
        }

        public static enum BaseType {
            API,
            PROJECT;

        }
    }

    public static class PermissionItem {
        public String group;
        public boolean read;
        public boolean deploy;
        public boolean admin;
    }
}

