/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.deployments.actions;

import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentHeavyStatus;
import com.dataiku.dip.deployer.common.deployments.actions.DeploymentAction;
import com.dataiku.dip.deployer.common.deployments.actions.DeploymentActionsService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.server.SpringUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeploymentActionHandle
implements AutoCloseable {
    @Nonnull
    private final DeploymentAction action;
    @Nonnull
    private final FutureThread<?> futureThread;
    @Nullable
    private AbstractDeploymentHeavyStatus heavyStatus;
    @Nullable
    private VersionTag deploymentTag;

    public DeploymentActionHandle(@Nonnull DeploymentAction action, @Nonnull FutureThread<?> futureThread) {
        this.action = action;
        this.futureThread = futureThread;
    }

    @Override
    public void close() throws IOException, CodedException {
        ((DeploymentActionsService)SpringUtils.getBean(DeploymentActionsService.class)).endDeploymentAction(this.action, this.futureThread, this.heavyStatus, this.deploymentTag);
    }

    public void setHeavyStatus(@Nonnull AbstractDeploymentHeavyStatus heavyStatus) {
        this.heavyStatus = heavyStatus;
    }

    public void setActionDeploymentTag(@Nonnull VersionTag deploymentTag) {
        this.deploymentTag = deploymentTag;
    }
}

