/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.projectdeployer.datamodel.config;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.projectdeployer.infra.AbstractAutomationNodeInfraManager;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.security.AuthCtx;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractProjectDeploymentInfra
extends AbstractDeploymentInfra {
    public boolean autoconfigureFromNodesDirectory;
    public boolean trustAllSSLCertificates;
    public List<ProjectRemappingSettings.ConnectionRemapping> defaultConnectionRemapping = new ArrayList<ProjectRemappingSettings.ConnectionRemapping>();
    public List<ProjectRemappingSettings.ContainerExecRemapping> defaultContainerExecRemapping = new ArrayList<ProjectRemappingSettings.ContainerExecRemapping>();
    public boolean enableContainerExecRemapping;
    public boolean setDeployAsUser;
    public boolean mandatoryDeployAsUser;
    public String deployAsUser;
    public List<SimpleKeyValue> perProjectDeployAsUser = new ArrayList<SimpleKeyValue>();
    public boolean overrideRunAsUser;
    public String runAsUser;
    public List<SimpleKeyValue> perProjectRunAsUser = new ArrayList<SimpleKeyValue>();
    public boolean restartWebAppsOnUpdate;
    public ProjectStandardsPolicy projectStandardsPolicy = new ProjectStandardsPolicy();
    public PermissionsPropagationPolicy permissionsPropagationPolicy = PermissionsPropagationPolicy.NONE;

    protected AbstractProjectDeploymentInfra() {
    }

    protected AbstractProjectDeploymentInfra(String id, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        super(id, stage, userIdentifier, governCheckPolicy);
        this.restartWebAppsOnUpdate = true;
    }

    @Override
    public String getKey() {
        return "automation+" + this.id;
    }

    public abstract AbstractAutomationNodeInfraManager getInfraManager(AuthCtx var1, int var2, int var3);

    public String getDeployAsUserForTargetProject(String targetProjectKey) {
        if (!this.setDeployAsUser) {
            return null;
        }
        return this.perProjectDeployAsUser.stream().filter(pp -> StringUtils.equals((String)pp.key, (String)targetProjectKey)).findFirst().map(pp -> pp.value).orElse(this.deployAsUser);
    }

    public String getRunAsUserForTargetProject(String targetProjectKey) {
        if (!this.overrideRunAsUser) {
            return null;
        }
        return this.perProjectRunAsUser.stream().filter(pp -> StringUtils.equals((String)pp.key, (String)targetProjectKey)).findFirst().map(pp -> pp.value).orElse(this.runAsUser);
    }

    public String getProxyUserForTargetProject(AuthCtx authCtx, String targetProjectKey) {
        if (!this.setDeployAsUser) {
            return authCtx.getIdentifier();
        }
        String resolvedDeployAsUser = this.getDeployAsUserForTargetProject(targetProjectKey);
        if (StringUtils.isEmpty((String)resolvedDeployAsUser)) {
            if (this.mandatoryDeployAsUser && StringUtils.isEmpty((String)resolvedDeployAsUser)) {
                throw new IllegalArgumentException("Infra " + this.id + " requires a deployAs user to be defined for target project " + targetProjectKey + " but none defined");
            }
            return authCtx.getIdentifier();
        }
        return resolvedDeployAsUser;
    }

    public static class ProjectStandardsPolicy {
        public ProjectStandardsCheckPolicy checkPolicy = ProjectStandardsCheckPolicy.ALLOW;
        public int maxSeverity = 0;
        public int errorCheckSeverityHandling = 0;
        public boolean allowLegacyBundles = true;
        public boolean allowSkippedReports;
    }

    public static enum PermissionsPropagationPolicy {
        NONE,
        READ_ONLY,
        ALL;

    }

    public static enum ProjectStandardsCheckPolicy {
        PREVENT,
        WARN,
        ALLOW;

    }
}

