/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.output;

import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.export.CustomExporterPythonKernel;
import com.dataiku.dip.export.CustomPythonExportersService;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.LoadedPythonExporter;
import com.dataiku.dip.export.output.ExportOutput;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.io.JavaBlockLink;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.io.SimplePythonKernelFactory;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.io.SocketBlockLinkInteraction;
import com.dataiku.dip.io.SocketBlockLinkKernelException;
import com.dataiku.dip.output.CSVOutputFormatter;
import com.dataiku.dip.security.DSSAuthCtx;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ContainerizedCustomPythonExportOutput
implements ExportOutput {
    protected final DSSAuthCtx authCtx;
    protected final String projectKey;
    protected final JsonObject config;
    protected final LoadedPythonExporter loaded;
    protected final ContainerExecRuntimeConfig containerConfig;
    protected final CustomPythonExportersService customPythonExporterService;
    protected JavaBlockLink link;
    private SimplePythonKernel kernel;
    private SingleCommandKernelLink.IOCallable<SecretProtectedKernelLink.AcknowledgeResponse> commandResult;
    private final CSVOutputFormatter formatter;
    private OutputStream csvOutputStream;
    private ColumnFactory cf;
    private static final Logger logger = Logger.getLogger((String)"dip.pyexporter.containerized.output");

    public ContainerizedCustomPythonExportOutput(DSSAuthCtx authCtx, String projectKey, JsonObject config, LoadedPythonExporter loaded, ContainerExecRuntimeConfig containerConfig, CustomPythonExportersService customPythonExporterService) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.config = config;
        this.loaded = loaded;
        this.containerConfig = containerConfig;
        this.customPythonExporterService = customPythonExporterService;
        this.formatter = this.getCsvWriter();
    }

    private CSVOutputFormatter getCsvWriter() {
        CSVFormatConfig config = CSVFormatConfig.getStandardTabExcelFormat();
        config.setSeparatorStr(",");
        config.parseHeaderRow = false;
        return new CSVOutputFormatter(config);
    }

    protected String getDestinationFilePath() {
        return null;
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, Schema schema, ColumnFactory cf) throws Exception {
        this.cf = cf;
        String envName = new CodeEnvSelector().getCodeEnvNameForPlugin(this.loaded.ownerPluginId);
        HashMap<String, String> extraEnv = new HashMap<String, String>();
        extraEnv.put("DKU_PLUGIN_ID", this.loaded.getOwnerPluginId());
        SimplePythonKernel kernel = SimplePythonKernelFactory.prepareKernel(this.authCtx, this.projectKey, null, envName, "dataiku.exporter.server", false, false, null, this.containerConfig, "export", "export-", false, false, extraEnv);
        kernel.start();
        this.link = kernel.getLink();
        for (SchemaColumn column : schema.getColumns()) {
            cf.column(column.getName());
        }
        PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.customPythonExporterService.getExpandedPluginSettings(this.loaded.getType(), this.authCtx, this.projectKey, this.config);
        String code = this.customPythonExporterService.getCode(this.loaded.getType());
        CustomExporterPythonKernel.PythonCommand command = new CustomExporterPythonKernel.PythonCommand("export", this.loaded.getExportBehavior(), code, schema, expandedPluginSettings.config, expandedPluginSettings.pluginConfig);
        command.sendFileBack = this.sendFileBack();
        command.destinationFilePath = this.getDestinationFilePath();
        this.link.sendRequest((Object)command);
        this.csvOutputStream = this.link.sendStreamAsync(0x100000);
        this.formatter.header(cf, this.csvOutputStream);
        this.commandResult = () -> this.checkResult();
        logger.info((Object)"Kernel ready to export");
    }

    protected SecretProtectedKernelLink.AcknowledgeResponse checkResult() throws IOException {
        SecretProtectedKernelLink.AcknowledgeResponse r = (SecretProtectedKernelLink.AcknowledgeResponse)this.link.receiveJsonResponse(SecretProtectedKernelLink.AcknowledgeResponse.class);
        if (r == null) {
            SocketBlockLinkInteraction.SocketBlockLinkKernelError e = (SocketBlockLinkInteraction.SocketBlockLinkKernelError)this.link.receiveJsonResponse(SocketBlockLinkInteraction.SocketBlockLinkKernelError.class);
            throw new SocketBlockLinkKernelException("Failed to export", e);
        }
        return r;
    }

    protected CustomExporterPythonKernel.SendFileBackMode sendFileBack() {
        return CustomExporterPythonKernel.SendFileBackMode.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stream(RowInputStream stream) throws Exception {
        logger.info((Object)"Start streaming");
        try {
            try {
                try {
                    Row row = stream.next();
                    while (row != null) {
                        this.formatter.format(row, this.cf, this.csvOutputStream);
                        row = stream.next();
                    }
                    this.formatter.footer(this.cf, this.csvOutputStream);
                }
                finally {
                    this.csvOutputStream.close();
                }
                logger.info((Object)"Done streaming");
            }
            catch (Throwable throwable) {
                logger.info((Object)"Python worker closing");
                if (this.commandResult != null) {
                    SecretProtectedKernelLink.AcknowledgeResponse ack = (SecretProtectedKernelLink.AcknowledgeResponse)this.commandResult.call();
                    logger.info((Object)("Exported " + ack.count + " rows"));
                } else {
                    logger.info((Object)"Python streaming not started, nothing to clean");
                }
                throw throwable;
            }
            logger.info((Object)"Python worker closing");
            if (this.commandResult != null) {
                SecretProtectedKernelLink.AcknowledgeResponse ack = (SecretProtectedKernelLink.AcknowledgeResponse)this.commandResult.call();
                logger.info((Object)("Exported " + ack.count + " rows"));
            } else {
                logger.info((Object)"Python streaming not started, nothing to clean");
            }
        }
        catch (SocketBlockLinkException e) {
            throw e;
        }
        finally {
            logger.info((Object)"Cleaning up python worker");
            if (this.link != null) {
                this.link.close();
                this.link = null;
            }
            if (this.kernel != null) {
                this.kernel.close();
                this.kernel = null;
            }
        }
    }

    @Override
    public long getWrittenBytes() throws Exception {
        return 0L;
    }

    @Override
    public void close() {
    }

    @Override
    public void checkFeasability(ExportService.LocalExportJob job) {
    }
}

