/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.exposition.AbstractKubernetesExpositionHandler;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.ExpositionDesc;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionParams;
import com.dataiku.dip.futures.IStateLabelAggregator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.facet.CountMap;
import com.dataiku.dip.util.DKUNetUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.webapps.backend.NginxUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class AbstractIngressExposition {
    private static Logger logger = Logger.getLogger((String)"dip.webapp.expose");

    public static ParamDesc getPortParamDesc() {
        ParamDesc port = new ParamDesc();
        port.type = ParamDesc.Type.INT;
        port.mandatory = true;
        port.name = "port";
        port.label = "Port";
        port.defaultValue = 80;
        port.description = "Leave any value <= 0 for auto";
        return port;
    }

    public static ParamDesc getPortNameParamDesc() {
        ParamDesc desc = new ParamDesc();
        desc.type = ParamDesc.Type.STRING;
        desc.mandatory = false;
        desc.name = "portName";
        desc.label = "Port name";
        desc.defaultValue = null;
        desc.description = "Optional: name this port to reference it reliably in Ingress rules";
        return desc;
    }

    public static ParamDesc getSchemeParamDesc() {
        ParamDesc scheme = new ParamDesc();
        scheme.type = ParamDesc.Type.SELECT;
        scheme.name = "scheme";
        scheme.label = "Scheme";
        scheme.defaultValue = "http";
        scheme.selectChoices = Lists.newArrayList();
        scheme.selectChoices.add(new ParamDesc.SelectChoice().withLabel("HTTP").withValue("http"));
        scheme.selectChoices.add(new ParamDesc.SelectChoice().withLabel("HTTPS").withValue("https"));
        return scheme;
    }

    public static ParamDesc getForcedUrlParamDesc() {
        ParamDesc forcedUrl = new ParamDesc();
        forcedUrl.type = ParamDesc.Type.STRING;
        forcedUrl.name = "forcedUrl";
        forcedUrl.label = "Public URL";
        forcedUrl.description = "Base URL to present to the user for accessing services deployed by this ingress";
        return forcedUrl;
    }

    public static ParamDesc getExtraHostsParamDesc() {
        ParamDesc extraHosts = new ParamDesc();
        extraHosts.type = ParamDesc.Type.STRINGS;
        extraHosts.name = "extraHosts";
        extraHosts.label = "Additional hosts";
        extraHosts.description = "Hosts to use in the rules of the ingress. If non-empty, you may use * to add a catch-all rule. Be careful, using a wildcard will redirect all calls targeting the node.";
        return extraHosts;
    }

    public static ParamDesc getHostForDSS() {
        ParamDesc hostForDSS = new ParamDesc();
        hostForDSS.type = ParamDesc.Type.STRING;
        hostForDSS.name = "hostForDSS";
        hostForDSS.label = "Host used by DSS";
        hostForDSS.description = "Host that DSS will use (for https or when the ingress has several rules with different hosts)";
        return hostForDSS;
    }

    public static ExpositionDesc getDesc() {
        ParamDesc serviceAnnotations = new ParamDesc();
        serviceAnnotations.type = ParamDesc.Type.KEY_VALUE_LIST;
        serviceAnnotations.name = "serviceAnnotations";
        serviceAnnotations.label = "Service annotations";
        ParamDesc ingressAnnotations = new ParamDesc();
        ingressAnnotations.type = ParamDesc.Type.KEY_VALUE_LIST;
        ingressAnnotations.name = "ingressAnnotations";
        ingressAnnotations.label = "Ingress annotations";
        return new ExpositionDesc().withParam(serviceAnnotations).withParam(ingressAnnotations);
    }

    public static abstract class AbstractIngressExpositionHandler<T extends AbstractIngressExpositionParams>
    extends AbstractKubernetesExpositionHandler {
        protected final T params;
        protected int port;
        protected String scheme;
        protected String forcedUrl;
        protected List<String> serviceFiles;
        private IStateLabelAggregator stateLabelAggregator;
        private boolean closed;
        private ExpositionHandler.ExpositionStatus status = new ExpositionHandler.ExpositionStatus();

        AbstractIngressExpositionHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, T params, ExposedEndpointConsumer endpointConsumer) {
            super(authCtx, projectKey, containerConfig, endpointConsumer);
            this.params = params;
        }

        @Override
        public void cleanup() {
            this.closed = true;
            if (this.serviceFiles != null) {
                logger.info((Object)"Remove ingress service");
                try {
                    KubernetesExecUtils.delete(this.authCtx, this.projectKey, this.containerConfig, true, this.serviceFiles.toArray(new String[0]));
                }
                catch (IOException e) {
                    logger.error((Object)"Could not stop Kubernetes service", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"Interrupted while stopping Kubernetes service", (Throwable)e);
                }
            }
        }

        @Override
        public void init(Exposables.Exposable exposable, IStateLabelAggregator stateLabelAggregator) throws IOException {
            this.stateLabelAggregator = stateLabelAggregator;
            super.init(exposable, stateLabelAggregator);
            logger.info((Object)"Add ingress service");
            HashMap<String, String> serviceAnnotations = new HashMap<String, String>(this.annotations);
            HashMap<String, String> ingressAnnotations = new HashMap<String, String>(this.annotations);
            for (ExpositionParams.Annotation kv : ((AbstractIngressExpositionParams)this.params).serviceAnnotations) {
                if (!StringUtils.isNotBlank((String)kv.from)) continue;
                serviceAnnotations.put(kv.from, StringUtils.defaultIfBlank((String)kv.to, (String)""));
            }
            for (ExpositionParams.Annotation kv : ((AbstractIngressExpositionParams)this.params).ingressAnnotations) {
                if (!StringUtils.isNotBlank((String)kv.from)) continue;
                ingressAnnotations.put(kv.from, StringUtils.defaultIfBlank((String)kv.to, (String)""));
            }
            this.scheme = ((AbstractIngressExpositionParams)this.params).getScheme();
            if (((AbstractIngressExpositionParams)this.params).getPort() > 0) {
                this.port = ((AbstractIngressExpositionParams)this.params).getPort();
            } else {
                int n = this.port = "https".equals(this.scheme) ? 443 : 80;
            }
            if (StringUtils.isNotBlank((String)((AbstractIngressExpositionParams)this.params).getForcedUrl())) {
                this.forcedUrl = ((AbstractIngressExpositionParams)this.params).getForcedUrl();
            }
            List<String> extraFiles = this.getExtra(serviceAnnotations, ingressAnnotations);
            int servicePort = DKUNetUtils.findUnusedK8SPort();
            File serviceFile = new File(this.tmpDir, "service_" + this.executionId + ".yaml");
            String servicePortName = this.getPortName();
            Object servicePortNameFragment = StringUtils.isNotBlank((String)servicePortName) ? "\n    name: " + servicePortName : "";
            String serviceSnippet = String.format("  type: %s\n  ports:\n  - port: %d%s\n    targetPort: %d\n    protocol: TCP", this.getServiceType(), servicePort, servicePortNameFragment, this.exposedPort);
            String serviceDesc = KubernetesExecUtils.getServiceConf(this.namePrefix, this.executionId, serviceSnippet, this.labels, serviceAnnotations, this.selectors);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("service=\n" + serviceDesc));
            }
            DKUFileUtils.writeFileUTF8((File)serviceFile, (String)serviceDesc);
            ArrayList tls = Lists.newArrayList();
            List<String> secretFiles = null;
            if (((AbstractIngressExpositionParams)this.params).tlsTermination) {
                secretFiles = this.getIngressTLS(tls);
            }
            String ingressClassNameSpec = this.getIngressClassNameSpec();
            File ingressFile = new File(this.tmpDir, "ingress_" + this.executionId + ".yaml");
            String ingressDesc = KubernetesExecUtils.getIngressConf(this.namePrefix, this.executionId, servicePort, servicePortName, this.getServicePath(), this.labels, ingressAnnotations, tls, this.containerConfig, ingressClassNameSpec);
            logger.info((Object)("ingress before expansion for hosts=\n" + ingressDesc));
            List<String> hosts = this.expandRuleForHosts();
            if (!hosts.isEmpty()) {
                logger.info((Object)("Expand for hosts=" + JSON.log(hosts)));
                DumperOptions dumperOptions = new DumperOptions();
                dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
                Yaml yamlHandler = new Yaml(dumperOptions);
                JsonObject ingressJson = JSON.toJsonObject((Object)yamlHandler.load(ingressDesc), (String[])new String[0]);
                JsonArray rulesArray = ingressJson.getAsJsonObject("spec").getAsJsonArray("rules");
                JsonObject ruleObj = rulesArray.get(0).getAsJsonObject();
                rulesArray.remove(0);
                for (String host : Sets.newHashSet(hosts)) {
                    JsonObject rule = (JsonObject)JSON.deepCopy((Object)ruleObj);
                    if (StringUtils.isNotBlank((String)host) && !"*".equals(host)) {
                        rule.addProperty("host", host);
                    }
                    rulesArray.add((JsonElement)rule);
                }
                ingressDesc = yamlHandler.dump(JSON.toJavaLongPreserving((JsonElement)ingressJson));
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("expanded to=\n" + ingressDesc));
                }
            }
            DKUFileUtils.writeFileUTF8((File)ingressFile, (String)ingressDesc);
            this.serviceFiles = Lists.newArrayList((Object[])new String[]{"-f", serviceFile.getAbsolutePath(), "-f", ingressFile.getAbsolutePath()});
            if (secretFiles != null) {
                this.serviceFiles.addAll(secretFiles);
            }
            if (extraFiles != null) {
                this.serviceFiles.addAll(extraFiles);
            }
        }

        protected List<String> expandRuleForHosts() {
            return Lists.newArrayList(((AbstractIngressExpositionParams)this.params).getExtraHosts());
        }

        protected Map<String, String> getProxiedHeaders() {
            HashMap headers = Maps.newHashMap();
            if (StringUtils.isNotBlank((String)((AbstractIngressExpositionParams)this.params).getHostForDSS())) {
                headers.put("Host", ((AbstractIngressExpositionParams)this.params).getHostForDSS());
            }
            return headers;
        }

        protected abstract String expositionType();

        protected abstract List<String> getIngressTLS(List<KubernetesExecUtils.IngressTLS> var1) throws IOException;

        protected abstract String getServicePath();

        protected abstract String getPublicServicePath();

        protected boolean shouldAddPublicApiPath() {
            return true;
        }

        protected abstract List<String> getExtra(Map<String, String> var1, Map<String, String> var2) throws IOException;

        protected String getServiceType() {
            return "NodePort";
        }

        @Nullable
        protected String getPortName() {
            return null;
        }

        protected abstract String getIngressClassNameSpec();

        protected void checkServiceStartFailure(DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
        }

        @Override
        public void start(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            int serviceStart = new DKUtils.ExecBuilder().withCwd(this.tmpDir).withEnv(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig)).withArgs(KubernetesExecUtils.getKubeCtlApplyCommand(this.authCtx, this.projectKey, this.containerConfig, this.serviceFiles.toArray(new String[0]))).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)expositionLog).withErrorConsumer((DKUtils.ExecSubscription)expositionLog).withTimestamps(true).withLineContext("[ig] ").exec();
            if (serviceStart != 0) {
                this.checkServiceStartFailure(smartLogTailBuilder);
                throw ProcessDiedException.getExceptionOnProcessDeath((String)"Failed to start kubernetes service", null, null, (boolean)false, (Integer)serviceStart, (DKUtils.SmartLogTailBuilder)smartLogTailBuilder);
            }
        }

        @Override
        public void waitReady(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            JsonObject obj;
            String host;
            long pollInterval = KubernetesExecUtils.getWebappsPollingPeriodInMillis();
            Closeable ipState = this.stateLabelAggregator.startWaitingOn("Waiting on ingress IP");
            do {
                Thread.sleep(pollInterval);
            } while ((host = AbstractIngressExpositionHandler.getIngressHost(obj = this.describeIngress(expositionLog, smartLogTailBuilder))) == null);
            ipState.close();
            NginxUtils.waitForHost(host, this.stateLabelAggregator);
            ExposedEndpointConsumer.ExposedEndpoint endpoint = new ExposedEndpointConsumer.ExposedEndpoint(this.expositionType(), null, this.scheme, host, this.port, this.getPublicServicePath(), ExposedEndpointConsumer.ExposedEndpointAvailability.PUBLIC).withForcedUrl(this.forcedUrl).withHeaders(this.getProxiedHeaders());
            this.endpointConsumer.registerPort(endpoint);
            this.status.endpoints.add(endpoint);
            CountMap<String> backendsStates = this.getBackendsStates(expositionLog, smartLogTailBuilder);
            if (backendsStates.size() > 0) {
                Closeable state = null;
                while (!(backendsStates.containsKey("Healthy") || backendsStates.containsKey("healthy") || backendsStates.containsKey("HEALTHY"))) {
                    if (state != null) {
                        state.close();
                        state = null;
                    }
                    ArrayList chunks = Lists.newArrayList();
                    for (Map.Entry<String, MutableInt> entry : backendsStates) {
                        chunks.add(entry.getKey() + " (" + String.valueOf(entry.getValue()) + ")");
                    }
                    state = this.stateLabelAggregator.startWaitingOn("Waiting on ingress backends (" + Joiner.on((String)", ").join((Iterable)chunks) + ")");
                    Thread.sleep(pollInterval);
                    backendsStates = this.getBackendsStates(expositionLog, smartLogTailBuilder);
                }
                if (state != null) {
                    state.close();
                }
            }
            this.status.isHealthy = true;
        }

        @Override
        public ExpositionHandler.ExpositionStatus getStatus(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            JsonObject obj;
            String host;
            ExpositionHandler.ExpositionStatus status = new ExpositionHandler.ExpositionStatus();
            if (!this.closed && (host = AbstractIngressExpositionHandler.getIngressHost(obj = this.describeIngress(expositionLog, smartLogTailBuilder))) != null) {
                ExposedEndpointConsumer.ExposedEndpoint endpoint = new ExposedEndpointConsumer.ExposedEndpoint(this.expositionType(), null, this.scheme, host, this.port, this.getPublicServicePath(), ExposedEndpointConsumer.ExposedEndpointAvailability.PUBLIC, this.shouldAddPublicApiPath()).withForcedUrl(this.forcedUrl).withHeaders(this.getProxiedHeaders());
                status.endpoints.add(endpoint);
                CountMap<String> backendsStates = this.getBackendsStates(obj);
                status.isHealthy = backendsStates.size() > 0 ? backendsStates.containsKey("Healthy") || backendsStates.containsKey("healthy") || backendsStates.containsKey("HEALTHY") : true;
            }
            return status;
        }

        private CountMap<String> getBackendsStates(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws IOException, InterruptedException, Exception {
            try {
                JsonObject obj = this.describeIngress(expositionLog, smartLogTailBuilder);
                return this.getBackendsStates(obj);
            }
            catch (Exception e) {
                logger.warn((Object)"unable to check for the presence of a backends annotation", (Throwable)e);
                return new CountMap<String>();
            }
        }

        private CountMap<String> getBackendsStates(JsonObject obj) {
            CountMap<String> counts = new CountMap<String>();
            if (obj.has("metadata") && obj.getAsJsonObject("metadata").has("annotations") && obj.getAsJsonObject("metadata").getAsJsonObject("annotations").has("ingress.kubernetes.io/backends")) {
                String annotation = obj.getAsJsonObject("metadata").getAsJsonObject("annotations").get("ingress.kubernetes.io/backends").getAsString();
                Map backends = (Map)JSON.parse((String)annotation, (TypeToken)new TypeToken<Map<String, String>>(){});
                for (Map.Entry backend : backends.entrySet()) {
                    counts.inc((String)backend.getValue());
                }
            }
            return counts;
        }

        private JsonObject describeIngress(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws IOException, InterruptedException, Exception {
            JsonObject obj;
            String ingressId = this.namePrefix + "-ingress-" + this.executionId;
            this.status.raw = obj = AbstractKubernetesExpositionHandler.describeIngress(this.authCtx, this.projectKey, expositionLog, smartLogTailBuilder, this.containerConfig, this.tmpDir, ingressId, "[ig] ");
            return obj;
        }

        @Override
        public ExposedEndpointConsumer.ExposedEndpoint getExpectedExposedEndpoint() {
            return new ExposedEndpointConsumer.ExposedEndpoint(this.expositionType(), null, this.scheme, "${K8S_SERVICE_ADDRESS}", this.port, this.getPublicServicePath(), ExposedEndpointConsumer.ExposedEndpointAvailability.PUBLIC).withForcedUrl(this.forcedUrl).withHeaders(this.getProxiedHeaders());
        }
    }

    public static abstract class AbstractIngressExpositionParams
    implements ExpositionParams {
        public List<ExpositionParams.Annotation> serviceAnnotations = Lists.newArrayList();
        public List<ExpositionParams.Annotation> ingressAnnotations = Lists.newArrayList();
        public boolean tlsTermination = false;
        public List<TLSCertHost> tlsCertHosts = Lists.newArrayList();
        public int port = 80;
        public String scheme = "http";
        public String forcedUrl;
        public List<String> extraHosts = Lists.newArrayList();
        public String hostForDSS;

        public String getScheme() {
            return this.scheme;
        }

        public int getPort() {
            return this.port;
        }

        public String getForcedUrl() {
            return this.forcedUrl;
        }

        public String getHostForDSS() {
            return this.hostForDSS;
        }

        public List<String> getExtraHosts() {
            return this.extraHosts;
        }

        public void expandParametersInPlace(VariablesContext vc) {
            for (ExpositionParams.Annotation annotation : this.serviceAnnotations) {
                annotation.expandParametersInPlace(vc);
            }
            for (ExpositionParams.Annotation annotation : this.ingressAnnotations) {
                annotation.expandParametersInPlace(vc);
            }
            if (StringUtils.isNotBlank((String)this.forcedUrl)) {
                this.forcedUrl = vc.expandAllowUnresolved(this.forcedUrl);
            }
        }
    }

    public static class TLSCertHost {
        public String secretName = null;
        public String keyPath = null;
        public String crtPath = null;
        public List<String> hosts = Lists.newArrayList();
        public String hostForDSS;
    }
}

