/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionDesc;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionParams;
import com.dataiku.dip.futures.IStateLabelAggregator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.DKUNetUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DockerDirectExposition {
    public static final ExpositionMeta META = new ExpositionMeta(){

        @Override
        public String getType() {
            return "docker_direct";
        }

        @Override
        public Class<? extends ExpositionParams> getParamsClass() {
            return DockerDirectExpositionParams.class;
        }

        @Override
        public ExpositionDesc getDesc(ExpositionMeta.ExpositionUsageContext usageContext) {
            ParamDesc allInterfaces = new ParamDesc();
            allInterfaces.type = ParamDesc.Type.BOOLEAN;
            allInterfaces.name = "allInterfaces";
            allInterfaces.label = "Expose on all interfaces";
            allInterfaces.description = "Makes the process reachable from outside the DSS host";
            return new ExpositionDesc().withType(this.getType()).withMeta(new DkuComponentMetadata("Docker", "Backend running in docker on machine accessible directly", null, null)).withParam(allInterfaces);
        }

        @Override
        public long getMaxStartWait(AuthCtx authCtx) {
            return 60000L;
        }

        @Override
        public boolean handles(Exposables.ExposableKind kind) {
            return kind == Exposables.ExposableKind.WEBAPP;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig containerConfig) {
            return containerConfig.type == ContainerExecRuntimeConfig.Container.DOCKER;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig.Container containerType) {
            return containerType == ContainerExecRuntimeConfig.Container.DOCKER;
        }

        @Override
        public ExpositionHandler buildHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, Exposition exposition, ExposedEndpointConsumer endpointConsumer) {
            DockerDirectExpositionParams params = exposition.getParamsAs(DockerDirectExpositionParams.class);
            return new DockerDirectExpositionHandler(endpointConsumer, params);
        }

        @Override
        public void expandParametersInPlace(VariablesContext vc, Exposition exposition) {
        }
    };
    private static Logger logger = Logger.getLogger((String)"dip.webapp.exposition.docker");

    private static class DockerDirectExpositionHandler
    implements ExpositionHandler {
        private final ExposedEndpointConsumer endpointConsumer;
        private final DockerDirectExpositionParams params;
        private int port;
        private ExpositionHandler.ExpositionStatus status = new ExpositionHandler.ExpositionStatus();
        private boolean closed;

        DockerDirectExpositionHandler(ExposedEndpointConsumer endpointConsumer, DockerDirectExpositionParams params) {
            this.endpointConsumer = endpointConsumer;
            this.params = params;
        }

        @Override
        public void cleanup() {
            this.closed = true;
        }

        @Override
        public void init(Exposables.Exposable exposable, IStateLabelAggregator stateLabelAggregator) throws IOException {
            Exposables.DockerExposable dockerExposable = (Exposables.DockerExposable)exposable;
            this.port = DKUNetUtils.findUnusedPort();
            logger.info((Object)("Pick port " + this.port + " for docker"));
            ArrayList removed = Lists.newArrayList();
            removed.add(Lists.newArrayList((Object[])new Pattern[]{Pattern.compile(Pattern.quote("--network")), Pattern.compile(".+")}));
            ArrayList added = Lists.newArrayList();
            added.add(Lists.newArrayList((Object[])new String[]{"--network", "bridge"}));
            String expositionPortSpec = Integer.toString(this.port) + ":" + Integer.toString(dockerExposable.getContainerizedPort());
            expositionPortSpec = this.params.allInterfaces ? "0.0.0.0:" + expositionPortSpec : "127.0.0.1:" + expositionPortSpec;
            added.add(Lists.newArrayList((Object[])new String[]{"-p", expositionPortSpec}));
            dockerExposable.alterCommandLine(removed, new ArrayList<SimpleKeyValue>(), added);
        }

        @Override
        public void start(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            ExposedEndpointConsumer.ExposedEndpoint endpoint = new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), null, null, null, this.port, null, this.params.allInterfaces ? ExposedEndpointConsumer.ExposedEndpointAvailability.PUBLIC : ExposedEndpointConsumer.ExposedEndpointAvailability.LOCAL);
            this.endpointConsumer.registerPort(endpoint);
            this.status.endpoints.add(endpoint);
            this.status.isHealthy = true;
        }

        @Override
        public void waitReady(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
        }

        @Override
        public ExpositionHandler.ExpositionStatus getStatus(DKUtils.LineSubscriptionAttacher expositionLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            return this.closed ? new ExpositionHandler.ExpositionStatus() : this.status;
        }

        @Override
        public ExposedEndpointConsumer.ExposedEndpoint getExpectedExposedEndpoint() {
            return new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), null, null, null, this.port, null, this.params.allInterfaces ? ExposedEndpointConsumer.ExposedEndpointAvailability.PUBLIC : ExposedEndpointConsumer.ExposedEndpointAvailability.LOCAL);
        }
    }

    public static class DockerDirectExpositionParams
    implements ExpositionParams {
        public boolean allInterfaces;
    }
}

