/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.azureml;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.AzureMLConnection;
import com.dataiku.dip.connections.ConnectionWithAzureAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.ICodedException;
import com.dataiku.dip.externalinfras.ExternalInfraEndpoint;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLEnvironment;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLModel;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineDeployment;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineEndpoint;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResource;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResourceIdentifier;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLVersionedResourceIdentifier;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLHttpClient;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.savedmodels.proxymodelversions.ProxyModelVersionConfiguration;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.RateLimiterRegistry;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.RateLimiter;
import com.dataiku.dss.shadelib.io.swagger.models.Swagger;
import com.dataiku.dss.shadelib.io.swagger.models.parameters.BodyParameter;
import com.dataiku.dss.shadelib.io.swagger.models.parameters.Parameter;
import com.dataiku.dss.shadelib.io.swagger.parser.SwaggerParser;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AzureMLUtils {
    public static final String AZUREML_RATE_LIMITER_NAME = "azureMLUtils";
    public static final double DEFAULT_AZUREML_RATE_LIMIT = 5.0;
    public static final String AZUREML_EXTENSION_DIR_PROPERTY_KEY = "dku.deployer.deployment.azureml.extension-dir";
    public static final String AZUREML_SESSION_CONFIG_FOLDER_ENV_KEY = "AZURE_CONFIG_DIR";
    public static final String AZUREML_EXTENSION_DIR_ENV_KEY = "AZURE_EXTENSION_DIR";
    public static final String DKU_AZURE_CLI_LOGIN_PERFORMED = "DKU_AZURE_CLI_LOGIN_PERFORMED";
    public static final String DKU_AZURE_PASS = "AZ_PASS";
    public static final String DEFAULTS_CONFIG_GROUP_KEY = "group";
    public static final String DEFAULTS_CONFIG_WORKSPACE_KEY = "workspace";
    public static final String DEFAULTS_CONFIG_ACR_KEY = "acr";
    private static final String AZUREML_CLI_ML_CREATE_ACTION = "create";
    private static final String AZUREML_CLI_ML_SHOW_ACTION = "show";
    private static final String AZUREML_CLI_ML_INVOKE_ACTION = "invoke";
    private static final String AZUREML_CLI_ML_UPDATE_ACTION = "update";
    private static final String AZUREML_CLI_ML_GET_CREDENTIALS_ACTION = "get-credentials";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.externalinfras.azureml.utils");

    private AzureMLUtils() {
    }

    private static RateLimiter getAzureMLRateLimiter() {
        return RateLimiterRegistry.forName(AZUREML_RATE_LIMITER_NAME, 5.0);
    }

    public static void checkRate(String action) {
        double waited = AzureMLUtils.getAzureMLRateLimiter().acquire();
        if (waited > 0.0) {
            logger.infoV("Waited %.3f seconds for '%s' (rate-limited by '%s')", new Object[]{waited, action, AZUREML_RATE_LIMITER_NAME});
        }
    }

    private static String sanitizeLocationParam(@Nonnull String location) {
        return location.toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "");
    }

    private static String sanitizeWorkspaceParam(@Nonnull String workspace) {
        return workspace.replaceAll("[^A-Za-z0-9\\-_]", "");
    }

    private static String sanitizeSubscriptionParam(@Nonnull String subscription) {
        return subscription.replaceAll("[^a-z0-9\\-]", "");
    }

    private static String sanitizeResourceGroupParam(@Nonnull String resourceGroup) {
        return resourceGroup.replaceAll("[&\\|;\\$><`\\ !]", "");
    }

    private static void addAdditionalCommonParams(List<String> command) {
        command.add("--only-show-errors");
        if (!command.contains("-o")) {
            command.add("-o");
            command.add("json");
        }
    }

    private static void addWorkspaceParam(List<String> command, String workspace) {
        command.add("--workspace-name");
        command.add(AzureMLUtils.sanitizeWorkspaceParam(workspace));
    }

    private static void addResourceGroupParam(List<String> command, String resourceGroup) {
        command.add("--resource-group");
        command.add(AzureMLUtils.sanitizeResourceGroupParam(resourceGroup));
    }

    private static void addSubscriptionParam(List<String> command, String subscription) {
        command.add("--subscription");
        command.add(AzureMLUtils.sanitizeSubscriptionParam(subscription));
    }

    private static List<String> getAzureCLILoginBaseCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("az");
        command.add("login");
        return command;
    }

    private static List<String> getAzureCLIServicePrincipalLoginCommand(String tenantId, String appId) {
        String readPasswordCommand = "read -s AZ_PASS";
        List<String> loginCommand = AzureMLUtils.getAzureCLILoginBaseCommand();
        loginCommand.add("--service-principal");
        loginCommand.add("-u");
        loginCommand.add(appId);
        loginCommand.add("-p");
        loginCommand.add("$AZ_PASS");
        loginCommand.add("--tenant");
        loginCommand.add(tenantId);
        AzureMLUtils.addAdditionalCommonParams(loginCommand);
        ArrayList<String> bashCommand = new ArrayList<String>();
        bashCommand.add("/bin/bash");
        bashCommand.add("-c");
        bashCommand.add(readPasswordCommand + " ; " + String.join((CharSequence)" ", loginCommand));
        return bashCommand;
    }

    private static List<String> getAzureCLIVMBaseCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("az");
        command.add("vm");
        return command;
    }

    private static List<String> getAzureCLIAccountShowBaseCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("az");
        command.add("account");
        command.add(AZUREML_CLI_ML_SHOW_ACTION);
        return command;
    }

    private static List<String> getAzureCLIConfigGetBaseCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("az");
        command.add("config");
        command.add("get");
        return command;
    }

    private static List<String> getAzureCLIMLBaseCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("az");
        command.add("ml");
        return command;
    }

    private static List<String> getAzureCLIMLWorkspaceBaseCommand() {
        List<String> command = AzureMLUtils.getAzureCLIMLBaseCommand();
        command.add(DEFAULTS_CONFIG_WORKSPACE_KEY);
        return command;
    }

    private static List<String> getAzureCLIMLWorkspaceActionCommand(String action, String resourceGroup, String subscription, List<String> params) {
        List<String> command = AzureMLUtils.getAzureCLIMLWorkspaceBaseCommand();
        command.add(action);
        command.addAll(params);
        AzureMLUtils.addResourceGroupParam(command, resourceGroup);
        AzureMLUtils.addSubscriptionParam(command, subscription);
        AzureMLUtils.addAdditionalCommonParams(command);
        return command;
    }

    private static List<String> getAzureCLIMLWorkspaceShowCommand(String workspace, String resourceGroup, String subscription, List<String> params) {
        ArrayList<String> showParams = new ArrayList<String>();
        showParams.add("--name");
        showParams.add(AzureMLUtils.sanitizeWorkspaceParam(workspace));
        showParams.addAll(params);
        return AzureMLUtils.getAzureCLIMLWorkspaceActionCommand(AZUREML_CLI_ML_SHOW_ACTION, resourceGroup, subscription, showParams);
    }

    private static List<String> getAzureCLIMLResourceActionCommand(String resourceType, String workspace, String resourceGroup, String subscription, String action, List<String> params) {
        List<String> command = AzureMLUtils.getAzureCLIMLBaseCommand();
        command.add(resourceType);
        command.add(action);
        command.addAll(params);
        AzureMLUtils.addWorkspaceParam(command, workspace);
        AzureMLUtils.addResourceGroupParam(command, resourceGroup);
        AzureMLUtils.addSubscriptionParam(command, subscription);
        AzureMLUtils.addAdditionalCommonParams(command);
        return command;
    }

    private static List<String> getAzureCLIMLResourceActionCommand(AzureMLResource resource, String action, List<String> params) {
        return AzureMLUtils.getAzureCLIMLResourceActionCommand(resource.getResourceIdentifier(), resource.getResourceType(), action, params);
    }

    private static List<String> getAzureCLIMLResourceActionCommand(AzureMLResourceIdentifier resourceIdentifier, String resourceType, String action, List<String> params) {
        return AzureMLUtils.getAzureCLIMLResourceActionCommand(resourceType, resourceIdentifier.workspace, resourceIdentifier.resourceGroup, resourceIdentifier.subscription, action, params);
    }

    private static File createResourceYamlConfig(AzureMLResource resource, File contextDir) throws IOException {
        File resourceConfig = new File(contextDir, resource.getResourceType() + ".yaml");
        String modelYamlConfig = resource.toYamlConfig();
        logger.infoV("AzureML '%s' config to create:\n%s", new Object[]{resource.getResourceTypeLabel(), modelYamlConfig});
        DKUFileUtils.writeFileUTF8((File)resourceConfig, (String)modelYamlConfig);
        return resourceConfig;
    }

    private static File createTempFileForInvocation(File contextDir, JsonObject query) throws IOException {
        String content = JSON.json((Object)query);
        File inputFile = File.createTempFile("invoke_input", ".json", contextDir);
        DKUFileUtils.writeFileUTF8((File)inputFile, (String)content);
        return inputFile;
    }

    private static List<String> getAzureCLIMLResourceCreateCommand(AzureMLResource resource, File contextDir, @Nonnull List<String> params) throws IOException {
        File resourceConfig = AzureMLUtils.createResourceYamlConfig(resource, contextDir);
        ArrayList<String> createParams = new ArrayList<String>();
        createParams.add("--file");
        createParams.add(resourceConfig.getAbsolutePath());
        createParams.addAll(params);
        return AzureMLUtils.getAzureCLIMLResourceActionCommand(resource, AZUREML_CLI_ML_CREATE_ACTION, createParams);
    }

    private static List<String> getAzureCLIMLResourceUpdateCommand(AzureMLResource resource, File contextDir, @Nonnull List<String> params) throws IOException {
        File resourceConfig = AzureMLUtils.createResourceYamlConfig(resource, contextDir);
        ArrayList<String> updateParams = new ArrayList<String>();
        updateParams.add("--name");
        updateParams.add(resource.name);
        updateParams.add("--file");
        updateParams.add(resourceConfig.getAbsolutePath());
        updateParams.addAll(params);
        return AzureMLUtils.getAzureCLIMLResourceActionCommand(resource, AZUREML_CLI_ML_UPDATE_ACTION, updateParams);
    }

    private static List<String> getAzureCLIMLResourceGetCredentialsCommand(String resourceType, String name, String workspace, String resourceGroup, String subscription, @Nonnull List<String> params) {
        ArrayList<String> getCredentials = new ArrayList<String>();
        getCredentials.add("--name");
        getCredentials.add(name);
        getCredentials.addAll(params);
        return AzureMLUtils.getAzureCLIMLResourceActionCommand(resourceType, workspace, resourceGroup, subscription, AZUREML_CLI_ML_GET_CREDENTIALS_ACTION, getCredentials);
    }

    private static List<String> getAzureCLIMLResourceTagsUpdateCommand(AzureMLResource resource, Map<String, String> previousTags, @Nonnull List<String> params) {
        ArrayList<String> updateTagsParams = new ArrayList<String>();
        updateTagsParams.add("--name");
        updateTagsParams.add(resource.name);
        if (resource.getResourceIdentifier() instanceof AzureMLVersionedResourceIdentifier) {
            updateTagsParams.add("--version");
            updateTagsParams.add(((AzureMLVersionedResourceIdentifier)resource.getResourceIdentifier()).version);
        }
        if (resource instanceof AzureMLOnlineDeployment) {
            updateTagsParams.add("--endpoint-name");
            updateTagsParams.add(resource.getResourceIdentifier().parentResourceName);
        }
        for (Map.Entry<String, String> entry : resource.tags.entrySet()) {
            updateTagsParams.add("--set");
            updateTagsParams.add("tags." + entry.getKey() + "=" + entry.getValue());
        }
        List tagKeysToRemove = previousTags.keySet().stream().filter(tagKey -> !resource.tags.containsKey(tagKey)).collect(Collectors.toList());
        for (String tagKey2 : tagKeysToRemove) {
            updateTagsParams.add("--remove");
            updateTagsParams.add("tags." + tagKey2);
        }
        updateTagsParams.addAll(params);
        return AzureMLUtils.getAzureCLIMLResourceActionCommand(resource, AZUREML_CLI_ML_UPDATE_ACTION, updateTagsParams);
    }

    private static List<String> getAzureCLIMLEndpointInvokeCommand(AzureMLResourceIdentifier resourceIdentifier, JsonObject query, File contextDir, @Nonnull List<String> params) throws IOException {
        File queryFile = AzureMLUtils.createTempFileForInvocation(contextDir, query);
        ArrayList<String> showParams = new ArrayList<String>();
        showParams.add("--name");
        showParams.add(resourceIdentifier.name);
        showParams.add("--request-file");
        showParams.add(queryFile.getAbsolutePath());
        showParams.addAll(params);
        return AzureMLUtils.getAzureCLIMLResourceActionCommand(resourceIdentifier, "online-endpoint", AZUREML_CLI_ML_INVOKE_ACTION, showParams);
    }

    private static <T> T execAzureMLCommandAndGetOutputWithErrorInException_NT(AzureSession azureSession, List<String> command, TypeToken<T> typeToken) throws IOException, InterruptedException {
        Map<String, String> env = azureSession.getSessionEnv();
        return AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(command, typeToken, env, null);
    }

    private static <T> T execAzureMLCommandAndGetOutputWithErrorInException_NT(List<String> command, TypeToken<T> typeToken, Map<String, String> env, @Nullable String input) throws IOException, InterruptedException {
        TransactionContext.assertNoAttachedTransaction();
        DKUtils.ExecutionResults results = DKUtils.execAndGetOutputAndErrors((String[])command.toArray(new String[0]), env, (String)input);
        if (results.rv == 0) {
            String output = results.out;
            Pattern p = Pattern.compile("(^\\.+)");
            Matcher m = p.matcher(output);
            if (m.find()) {
                output = m.replaceFirst("");
            }
            try {
                return (T)JSON.parse((String)output, typeToken);
            }
            catch (Exception e) {
                logger.error((Object)("Error while parsing the output '" + results.out + "' when executing the command '" + String.join((CharSequence)" ", command) + "'"), (Throwable)e);
                throw e;
            }
        }
        throw new IOException("Error received when executing the command '" + String.join((CharSequence)" ", command) + "'\n" + results.err);
    }

    public static Map<String, String> getDefaultsConfig_NT() throws IOException, InterruptedException {
        List<String> getConfigCommand = AzureMLUtils.getAzureCLIConfigGetBaseCommand();
        getConfigCommand.add("defaults");
        AzureMLUtils.addAdditionalCommonParams(getConfigCommand);
        List<DefaultsConfig> defaultsConfigList = AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(getConfigCommand, new TypeToken<List<DefaultsConfig>>(){}, new HashMap<String, String>(), null);
        return defaultsConfigList.stream().collect(Collectors.toMap(DefaultsConfig::getName, DefaultsConfig::getValue));
    }

    public static AzureSession loginOrCheckAzure_NT(AuthCtx authCtx, @Nullable String connectionName) throws AzureAuthenticationException, IOException, DKUSecurityException {
        AzureSession azureSession;
        String loginSessionId = SecretKeyGenerator.generate((int)8);
        AzureMLConnection connection = null;
        if (StringUtils.isNotBlank((CharSequence)connectionName)) {
            connection = (AzureMLConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, connectionName);
        }
        ProxySettings proxySettings = ExternalInfrasUtils.getProxy(connection);
        if (connection != null && connection.params.authType != AzureConnection.AuthType.ENVIRONMENT) {
            logger.infoV("Trying to login into azure using service principal configuration from connection '%s'...", new Object[]{connectionName});
            azureSession = new ServicePrincipalAzureSession(loginSessionId, authCtx, connectionName, proxySettings);
        } else {
            logger.infoV("Checking login into azure is already done", new Object[0]);
            azureSession = new EnvironmentAzureSession(loginSessionId, proxySettings);
        }
        ((AzureSession)azureSession).doLoginOrCheck_NT();
        return azureSession;
    }

    public static Optional<AzureSubscription> getSubscription_NT(AzureSession session, String name) throws IOException, InterruptedException {
        AzureMLUtils.checkRate("Show AzureML subscription");
        List<String> accountShowCommand = AzureMLUtils.getAzureCLIAccountShowBaseCommand();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            accountShowCommand.add("--name");
            accountShowCommand.add(name);
        }
        AzureMLUtils.addAdditionalCommonParams(accountShowCommand);
        try {
            AzureSubscription subscription = AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(session, accountShowCommand, new TypeToken<AzureSubscription>(){});
            return Optional.of(subscription);
        }
        catch (Exception e) {
            if (e.getMessage().contains("not found")) {
                logger.debugV("AzureML Subscription '%s' does not exist.", new Object[]{name});
                return Optional.empty();
            }
            logger.errorV((Throwable)e, "Error while retrieving AzureML subscription with name '%s'.", new Object[]{name});
            throw e;
        }
    }

    public static Optional<AzureSubscription> getDefaultSubscription_NT(AzureSession session) throws IOException, InterruptedException {
        return AzureMLUtils.getSubscription_NT(session, "");
    }

    public static List<String> getInstanceTypes_NT(AzureSession session, String location, String subscription) throws IOException, InterruptedException {
        AzureMLUtils.checkRate("List AzureML instance types");
        logger.debugV("Retrieving AzureML Instance Types for location '%s'.", new Object[]{location});
        List<String> listSizesCommand = AzureMLUtils.getAzureCLIVMBaseCommand();
        listSizesCommand.add("list-sizes");
        listSizesCommand.add("--location");
        listSizesCommand.add(AzureMLUtils.sanitizeLocationParam(location));
        AzureMLUtils.addAdditionalCommonParams(listSizesCommand);
        AzureMLUtils.addSubscriptionParam(listSizesCommand, subscription);
        List<String> instanceTypes = new ArrayList<String>();
        try {
            List<InstanceType> parsedInstanceTypes = AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(session, listSizesCommand, new TypeToken<List<InstanceType>>(){});
            instanceTypes = parsedInstanceTypes.stream().map(instanceType -> instanceType.name).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error((Object)"Error while retrieving the list of available Azure instances.", (Throwable)e);
        }
        return instanceTypes;
    }

    public static Optional<BasicWorkspace> retrieveWorkspace_NT(AzureSession session, String workspace, String resourceGroup, String subscription) throws IOException, InterruptedException {
        try {
            AzureMLUtils.checkRate("Retrieve AzureML Workspace");
            logger.debugV("Retrieving AzureML Workspace with name '%s'.", new Object[]{workspace});
            List<String> showWorkspaceCommand = AzureMLUtils.getAzureCLIMLWorkspaceShowCommand(workspace, resourceGroup, subscription, new ArrayList<String>());
            BasicWorkspace basicWorkspace = AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(session, showWorkspaceCommand, new TypeToken<BasicWorkspace>(){});
            logger.debugV("AzureML Workspace '%s' successfully retrieved.", new Object[]{basicWorkspace.name});
            return Optional.of(basicWorkspace);
        }
        catch (Exception e) {
            if (e.getMessage().contains("Code: ResourceNotFound")) {
                logger.debugV("AzureML Workspace '%s' does not exist.", new Object[]{workspace});
                return Optional.empty();
            }
            logger.errorV((Throwable)e, "Error while retrieving AzureML Model with name '%s'.", new Object[]{workspace});
            throw e;
        }
    }

    private static void fillResourceWithMissingFields(AzureMLResource resource, AzureMLResourceIdentifier resourceId) {
        AzureMLUtils.fillResourceWithMissingFields(resource, resourceId.workspace, resourceId.subscription);
    }

    private static void fillResourceWithMissingFields(AzureMLResource resource, String workspace, String subscription) {
        resource.workspace = workspace;
        resource.subscription = subscription;
    }

    private static File createSampleFile(File contextDir) throws IOException {
        File sampleFile = new File(contextDir, "sampleFile.txt");
        DKUFileUtils.writeFileUTF8((File)sampleFile, (String)" ");
        return sampleFile;
    }

    public static AzureMLModel createModel_NT(AzureSession session, @Nonnull AzureMLModel azureMLModel, File contextDir) throws IOException, InterruptedException {
        try {
            AzureMLUtils.checkRate("Create AzureML Model");
            logger.debugV("Creating AzureML Model with name '%s'.", new Object[]{azureMLModel.name});
            azureMLModel.path = AzureMLUtils.createSampleFile(contextDir).getAbsolutePath();
            List<String> createModelCommand = AzureMLUtils.getAzureCLIMLResourceCreateCommand(azureMLModel, contextDir, new ArrayList<String>());
            AzureMLModel azureMLModelCreated = AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(session, createModelCommand, new TypeToken<AzureMLModel>(){});
            AzureMLUtils.fillResourceWithMissingFields(azureMLModelCreated, azureMLModel.getResourceIdentifier());
            logger.debugV("AzureML Model '%s' successfully created.", new Object[]{azureMLModelCreated.name});
            return azureMLModelCreated;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while creating AzureML Model with config '%s'.", new Object[]{JSON.log((Object)azureMLModel)});
            throw e;
        }
    }

    public static AzureMLEnvironment createEnvironment_NT(AzureSession session, AzureMLEnvironment azureMLEnvironment, File contextDir) throws IOException, InterruptedException {
        try {
            AzureMLUtils.checkRate("Create AzureML Environment");
            logger.debugV("Creating AzureML Environment with name '%s'.", new Object[]{azureMLEnvironment.name});
            List<String> createEnvironmentCommand = AzureMLUtils.getAzureCLIMLResourceCreateCommand(azureMLEnvironment, contextDir, new ArrayList<String>());
            AzureMLEnvironment azureMLEnvironmentCreated = AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(session, createEnvironmentCommand, new TypeToken<AzureMLEnvironment>(){});
            AzureMLUtils.fillResourceWithMissingFields(azureMLEnvironmentCreated, azureMLEnvironment.getResourceIdentifier());
            logger.debugV("AzureML Environment '%s' successfully created.", new Object[]{azureMLEnvironmentCreated.name});
            return azureMLEnvironmentCreated;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while creating AzureML Environment with config '%s'.", new Object[]{JSON.log((Object)azureMLEnvironment)});
            throw e;
        }
    }

    public static String retrieveOnlineEndpointCredentials_NT(AzureSession session, String name, String workspace, String resourceGroup, String subscription) throws IOException, InterruptedException {
        try {
            AzureMLUtils.checkRate("Retrieve credentials for AzureML Online Endpoint");
            logger.debugV("Retrieving credentials for AzureML Online Endpoint with name '%s'.", new Object[]{name});
            List<String> getOnlineEndpointCredentialsCommand = AzureMLUtils.getAzureCLIMLResourceGetCredentialsCommand("online-endpoint", name, workspace, resourceGroup, subscription, new ArrayList<String>());
            AzureMLOnlineEndpointCredentials azureMLOnlineEndpointCredentials = AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(session, getOnlineEndpointCredentialsCommand, new TypeToken<AzureMLOnlineEndpointCredentials>(){});
            return azureMLOnlineEndpointCredentials.getToken();
        }
        catch (Exception e) {
            if (e.getMessage().contains("Code: ResourceNotFound")) {
                logger.debugV("AzureML Online Endpoint '%s' does not exist.", new Object[]{name});
                return null;
            }
            logger.errorV((Throwable)e, "Error while retrieving credentials for AzureML Online Endpoint '%s'.", new Object[]{name});
            throw e;
        }
    }

    public static AzureMLOnlineEndpoint createOnlineEndpoint_NT(AzureSession session, AzureMLOnlineEndpoint azureMLOnlineEndpoint, File contextDir) throws IOException, InterruptedException {
        try {
            AzureMLUtils.checkRate("Create AzureML Online Endpoint");
            logger.debugV("Creating AzureML Online Endpoint with name '%s'.", new Object[]{azureMLOnlineEndpoint.name});
            List<String> params = Arrays.asList("--local", "false");
            List<String> createOnlineEndpointCommand = AzureMLUtils.getAzureCLIMLResourceCreateCommand(azureMLOnlineEndpoint, contextDir, params);
            AzureMLOnlineEndpoint azureMLOnlineEndpointCreated = AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(session, createOnlineEndpointCommand, new TypeToken<AzureMLOnlineEndpoint>(){});
            AzureMLUtils.fillResourceWithMissingFields(azureMLOnlineEndpointCreated, azureMLOnlineEndpoint.getResourceIdentifier());
            logger.debugV("AzureML Online Endpoint '%s' successfully created.", new Object[]{azureMLOnlineEndpointCreated.name});
            return azureMLOnlineEndpointCreated;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while creating AzureML Online Endpoint with config '%s'.", new Object[]{JSON.log((Object)azureMLOnlineEndpoint)});
            throw e;
        }
    }

    public static AzureMLOnlineEndpoint updateOnlineEndpoint_NT(AzureSession session, AzureMLOnlineEndpoint azureMLOnlineEndpointToUpdate, File contextDir) throws IOException, InterruptedException {
        try {
            AzureMLUtils.checkRate("Update AzureML Online Endpoint");
            logger.debugV("Updating AzureML Online Endpoint with name %s.", new Object[]{azureMLOnlineEndpointToUpdate.name});
            List<String> params = Arrays.asList("--local", "false");
            List<String> updateOnlineEndpointCommand = AzureMLUtils.getAzureCLIMLResourceUpdateCommand(azureMLOnlineEndpointToUpdate, contextDir, params);
            AzureMLOnlineEndpoint azureMLOnlineEndpointUpdated = AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(session, updateOnlineEndpointCommand, new TypeToken<AzureMLOnlineEndpoint>(){});
            AzureMLUtils.fillResourceWithMissingFields(azureMLOnlineEndpointUpdated, azureMLOnlineEndpointToUpdate.getResourceIdentifier());
            logger.debugV("AzureML Online Endpoint %s successfully updated.", new Object[]{azureMLOnlineEndpointUpdated.name});
            return azureMLOnlineEndpointUpdated;
        }
        catch (Exception e) {
            logger.errorV("Error while updating AzureML Online Endpoint with config %s.", new Object[]{JSON.log((Object)azureMLOnlineEndpointToUpdate)});
            throw e;
        }
    }

    public static AzureMLOnlineDeployment createOnlineDeployment_NT(AzureSession session, AzureMLOnlineDeployment azureMLOnlineDeployment, File contextDir) throws IOException, InterruptedException {
        try {
            AzureMLUtils.checkRate("Create AzureML Online Deployment");
            logger.debugV("Creating AzureML Online Deployment with name '%s' in Online Endpoint '%s'.", new Object[]{azureMLOnlineDeployment.name, azureMLOnlineDeployment.endpointName});
            List<String> params = Arrays.asList("--local", "false", "--all-traffic");
            List<String> createOnlineDeploymentCommand = AzureMLUtils.getAzureCLIMLResourceCreateCommand(azureMLOnlineDeployment, contextDir, params);
            AzureMLOnlineDeployment azureMLOnlineDeploymentCreated = AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(session, createOnlineDeploymentCommand, new TypeToken<AzureMLOnlineDeployment>(){});
            AzureMLUtils.fillResourceWithMissingFields(azureMLOnlineDeploymentCreated, azureMLOnlineDeployment.getResourceIdentifier());
            logger.debugV("AzureML Online Deployment '%s' in Online Endpoint '%s' successfully created.", new Object[]{azureMLOnlineDeploymentCreated.name, azureMLOnlineDeploymentCreated.endpointName});
            return azureMLOnlineDeploymentCreated;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while creating AzureML Online deployment with config '%s'.", new Object[]{JSON.log((Object)azureMLOnlineDeployment)});
            throw e;
        }
    }

    public static String invokeEndpoint_NT(AzureSession session, AzureMLResourceIdentifier endpointIdentifier, JsonObject query, File contextDir) throws IOException, InterruptedException {
        try {
            logger.debugV("Invoke Azure ML Endpoint with name %s.", new Object[]{endpointIdentifier.name});
            List<String> invokeCommand = AzureMLUtils.getAzureCLIMLEndpointInvokeCommand(endpointIdentifier, query, contextDir, new ArrayList<String>());
            String output = AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(session, invokeCommand, new TypeToken<String>(){});
            logger.debugV("Invocation succeeded.", new Object[0]);
            return output;
        }
        catch (Exception e) {
            logger.errorV("Error while invoking Azure ML endpoint with name %s.", new Object[]{endpointIdentifier.name});
            throw e;
        }
    }

    public static AzureMLOnlineDeployment updateOnlineDeployment_NT(AzureSession session, AzureMLOnlineDeployment azureMLOnlineDeployment, File contextDir) throws IOException, InterruptedException {
        try {
            AzureMLUtils.checkRate("Update AzureML Online Deployment");
            logger.debugV("Updating AzureML Online Deployment with name %s in Online Endpoint '%s'.", new Object[]{azureMLOnlineDeployment.name, azureMLOnlineDeployment.endpointName});
            List<String> params = Arrays.asList("--local", "false", "--endpoint-name", azureMLOnlineDeployment.endpointName);
            List<String> updateOnlineDeploymentCommand = AzureMLUtils.getAzureCLIMLResourceUpdateCommand(azureMLOnlineDeployment, contextDir, params);
            AzureMLOnlineDeployment azureMLOnlineDeploymentUpdated = AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(session, updateOnlineDeploymentCommand, new TypeToken<AzureMLOnlineDeployment>(){});
            AzureMLUtils.fillResourceWithMissingFields(azureMLOnlineDeploymentUpdated, azureMLOnlineDeployment.getResourceIdentifier());
            logger.debugV("AzureML Online Deployment %s in Online Endpoint '%s' successfully updated.", new Object[]{azureMLOnlineDeploymentUpdated.name, azureMLOnlineDeploymentUpdated.endpointName});
            return azureMLOnlineDeploymentUpdated;
        }
        catch (Exception e) {
            logger.errorV("Error while updating AzureML Online deployment with config %s.", new Object[]{JSON.log((Object)azureMLOnlineDeployment)});
            throw e;
        }
    }

    public static AzureMLResource updateResourceTags_NT(AzureSession session, AzureMLResource resourceToUpdate, Map<String, String> previousTags) throws IOException, InterruptedException {
        try {
            List<String> updateTagsCommand = AzureMLUtils.getAzureCLIMLResourceTagsUpdateCommand(resourceToUpdate, previousTags, new ArrayList<String>());
            AzureMLResource updatedResource = (AzureMLResource)AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(session, updateTagsCommand, TypeToken.get(resourceToUpdate.getClass()));
            logger.debugV("AzureML %s '%s' tags successfully updated.", new Object[]{resourceToUpdate.getResourceTypeLabel(), updatedResource.name});
            return updatedResource;
        }
        catch (Exception e) {
            logger.errorV("Error while updating AzureML %s tags with config '%s'.", new Object[]{resourceToUpdate.getResourceTypeLabel(), JSON.log((Object)resourceToUpdate)});
            throw e;
        }
    }

    public static TokenCredential getAzureMLCredentials_NT(AuthCtx authCtx, @Nullable AzureMLConnection azureMLConnection) throws AzureAuthenticationException {
        ProxySettings environmentProxySettings = ExternalInfrasUtils.getProxy(azureMLConnection);
        if (azureMLConnection != null) {
            try {
                logger.infoV("Trying to login into azure using service principal configuration from connection '%s'...", new Object[]{azureMLConnection.name});
                ConnectionWithBasicCredential.CredentialResolutionContext resolutionCtx = new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null).withUseTokenCache(true);
                ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials creds = azureMLConnection.getFullyResolvedCredentials_fsLike(resolutionCtx, ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials.class);
                return creds.toTokenCredential(resolutionCtx, azureMLConnection);
            }
            catch (Exception e) {
                String message = "Failed to authenticate with Azure using the provided Service Principal.";
                logger.error((Object)message, (Throwable)e);
                throw new AzureAuthenticationException(message);
            }
        }
        try {
            return ConnectionWithAzureAuthCredentials.getDefaultAzureCredential(environmentProxySettings);
        }
        catch (Exception e) {
            String message = "Error while trying to retrieve credentials from the environment. Make sure you have prepared your DSS instance for DefaultAzureCredential to work.";
            logger.error((Object)message, (Throwable)e);
            throw new AzureAuthenticationException(message);
        }
    }

    public static AzureMLHttpClient getAzureMLClient_NT(AuthCtx authCtx, @Nullable String connectionName, int defaultConnectTimeout, int defaultSocketTimeout) throws AzureAuthenticationException, IOException, DKUSecurityException {
        AzureMLConnection azureMLConnection = (AzureMLConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, connectionName);
        int connectTimeout = defaultConnectTimeout;
        int socketTimeout = defaultSocketTimeout;
        if (azureMLConnection != null) {
            connectTimeout = azureMLConnection.getDkuPropertiesAsParams().getIntParam("dku.connection.connectTimeoutMs", Integer.valueOf(connectTimeout));
            socketTimeout = azureMLConnection.getDkuPropertiesAsParams().getIntParam("dku.connection.socketTimeoutMs", Integer.valueOf(socketTimeout));
        }
        TokenCredential credentials = AzureMLUtils.getAzureMLCredentials_NT(authCtx, azureMLConnection);
        ProxySettings proxySettings = ExternalInfrasUtils.getProxy(azureMLConnection);
        return new AzureMLHttpClient(proxySettings, credentials, connectTimeout, socketTimeout);
    }

    public static ProxyModelVersionConfiguration.ConsolidatedEndpointInfo getConsolidatedEndpointInfo_NT(AuthCtx authCtx, String connectionName, String endpointName, String workspace, String resourceGroup, String subscriptionId, int connectTimeout, int socketTimeout) throws AzureAuthenticationException, IOException, DKUSecurityException {
        try (AzureMLHttpClient azureMLClient = AzureMLUtils.getAzureMLClient_NT(authCtx, connectionName, connectTimeout, socketTimeout);){
            if (StringUtils.isEmpty((CharSequence)endpointName) || StringUtils.isEmpty((CharSequence)workspace) || StringUtils.isEmpty((CharSequence)resourceGroup) || StringUtils.isEmpty((CharSequence)subscriptionId)) {
                ProxyModelVersionConfiguration.ErrorEndpointInfo errorEI = new ProxyModelVersionConfiguration.ErrorEndpointInfo();
                errorEI.errorMessage = String.format("Endpoint name, workspace, resource group and subscription should be defined (name: '%s', workspace: '%s', resource group: '%s', subscription: '%s')", endpointName, workspace, resourceGroup, subscriptionId);
                ProxyModelVersionConfiguration.ErrorEndpointInfo errorEndpointInfo = errorEI;
                return errorEndpointInfo;
            }
            AzureMLResourceIdentifier onlineEndpointIdentifier = new AzureMLResourceIdentifier(endpointName, workspace, resourceGroup, subscriptionId);
            Optional<AzureMLOnlineEndpoint> azureMLOnlineEndpointOpt = azureMLClient.retrieveOnlineEndpoint_NT(onlineEndpointIdentifier);
            if (!azureMLOnlineEndpointOpt.isPresent()) {
                ProxyModelVersionConfiguration.ErrorEndpointInfo errorEI = new ProxyModelVersionConfiguration.ErrorEndpointInfo();
                errorEI.errorMessage = String.format("Could not retrieve information on Azure ML endpoint named '%s' in workspace '%s', resource group '%s' and subscription '%s'", endpointName, workspace, resourceGroup, subscriptionId);
                ProxyModelVersionConfiguration.ErrorEndpointInfo errorEndpointInfo = errorEI;
                return errorEndpointInfo;
            }
            DSSAzureMLConsolidatedEndpointInfo ret = new DSSAzureMLConsolidatedEndpointInfo();
            Optional<String> tenantId = azureMLClient.retrieveSubscriptions_NT().stream().filter(subscription -> subscription.getSubscriptionId().equals(subscriptionId)).map(subscription -> subscription.tenantId).findFirst();
            if (tenantId.isPresent()) {
                ret.retrievedByTenantId = tenantId.get();
            } else {
                logger.warnV("Could not retrieve tenant ID for subscription '%s'", new Object[]{subscriptionId});
                ret.retrievedByTenantId = null;
            }
            ret.endpointInfo = azureMLOnlineEndpointOpt.get();
            for (String deploymentName : ret.endpointInfo.traffic.keySet()) {
                Optional<AzureMLOnlineDeployment> azureMLOnlineDeploymentOpt = azureMLClient.retrieveOnlineDeployment_NT(new AzureMLResourceIdentifier(deploymentName, endpointName, workspace, resourceGroup, subscriptionId));
                if (azureMLOnlineDeploymentOpt.isPresent()) {
                    AzureMLOnlineDeployment azureMLOnlineDeployment = azureMLOnlineDeploymentOpt.get();
                    ret.deployments.add(azureMLOnlineDeployment);
                    String modelName = azureMLOnlineDeployment.getModelName();
                    String modelVersion = azureMLOnlineDeployment.getModelVersion();
                    if (StringUtils.isNotEmpty((CharSequence)modelName) && StringUtils.isNotEmpty((CharSequence)modelVersion)) {
                        Optional<AzureMLModel> azureMLModelOpt = azureMLClient.retrieveModel_NT(new AzureMLVersionedResourceIdentifier(modelName, workspace, resourceGroup, subscriptionId, modelVersion));
                        if (azureMLModelOpt.isPresent()) {
                            ret.modelByDeployment.put(azureMLOnlineDeployment.name, azureMLModelOpt.get());
                            continue;
                        }
                        logger.warnV("Could not retrieve information on version '%s' of model '%s' in workspace '%s', resource group '%s' and subscription '%s'", new Object[]{modelVersion, modelName, workspace, resourceGroup, subscriptionId});
                        continue;
                    }
                    logger.warnV("Model name and version are required to retrieve info. Got model '%s' and version '%s'", new Object[]{modelName, modelVersion});
                    continue;
                }
                logger.warnV("Could not retrieve information on deployment '%s' of endpoint '%s' in workspace '%s', resource group '%s' and subscription '%s'", new Object[]{deploymentName, endpointName, workspace, resourceGroup, subscriptionId});
            }
            if (StringUtils.isNotEmpty((CharSequence)ret.endpointInfo.openapiURI)) {
                try {
                    ret.openAPI = azureMLClient.getAPIDoc_NT(onlineEndpointIdentifier, ret.endpointInfo.location);
                    Swagger swagger = new SwaggerParser().parse(ret.openAPI);
                    for (Parameter param : swagger.getPath("/score").getPost().getParameters()) {
                        if (!(param instanceof BodyParameter)) continue;
                        BodyParameter bodyParameter = (BodyParameter)param;
                        if (StringUtils.isNotEmpty((CharSequence)bodyParameter.getSchema().getReference())) {
                            JsonPath pathResolver = JsonPath.compile((String)bodyParameter.getSchema().getReference().replace("#", "$").replace("/", "."), (Predicate[])new Predicate[0]);
                            ret.input = (LinkedHashMap)((LinkedHashMap)pathResolver.read(ret.openAPI)).get("properties");
                        } else {
                            ret.input = bodyParameter.getSchema().getProperties();
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    logger.debug((Object)"Failed to parse API doc and retrieve input format", (Throwable)e);
                }
            }
            DSSAzureMLConsolidatedEndpointInfo dSSAzureMLConsolidatedEndpointInfo = ret;
            return dSSAzureMLConsolidatedEndpointInfo;
        }
    }

    public static List<ExternalInfraEndpoint> listOnlineEndpoints_NT(AuthCtx user, String authConnectionName, String workspace, String resourceGroup, String subscription, int connectTimeout, int socketTimeout) throws Exception {
        AzureMLConnection connection = (AzureMLConnection)ExternalInfrasUtils.getAndCheckConnection(user, authConnectionName);
        String tenantId = connection != null ? connection.params.tenantId : null;
        try (AzureMLHttpClient azureMLClient = AzureMLUtils.getAzureMLClient_NT(user, authConnectionName, connectTimeout, socketTimeout);){
            List<ExternalInfraEndpoint> list = azureMLClient.listOnlineEndpoints_NT(workspace, resourceGroup, subscription).stream().map(d -> {
                Pair<DeploymentHealth, InfoMessage.InfoMessages> health = AzureMLUtils.getExternalEndpointHealth(d);
                return new ExternalInfraEndpoint(null, d.name, d.kind + " / " + d.location, (DeploymentHealth)((Object)((Object)health.first)), (InfoMessage.InfoMessages)health.second, AzureMLUtils.getEndpointResourceLink(d.name, subscription, resourceGroup, workspace, tenantId));
            }).sorted((e1, e2) -> StringUtils.compare((String)e1.name, (String)e2.name)).collect(Collectors.toList());
            return list;
        }
    }

    public static FutureResponse<List<ExternalInfraEndpoint>> startListEndpoints_NT(DSSAuthCtx user, String authConnectionName, String projectKey, String workspace, String resourceGroup, String subscription, int connectTimeout, int socketTimeout) throws Exception {
        FutureService futureService = (FutureService)((Object)SpringUtils.getBean(FutureService.class));
        EndpointListingFutureThread elft = new EndpointListingFutureThread(user, authConnectionName, projectKey, workspace, resourceGroup, subscription, connectTimeout, socketTimeout);
        return futureService.runFuture(elft, 0L, new TypeToken<FutureResponse<List<ExternalInfraEndpoint>>>(){});
    }

    private static String getEndpointResourceLink(String endpointName, String subscription, String resourceGroup, String workspace, String tenantId) {
        String wsid = String.format("wsid=/subscriptions/%s/resourcegroups/%s/providers/Microsoft.MachineLearningServices/workspaces/%s", subscription, resourceGroup, workspace);
        String tid = "&" + (String)(tenantId != null ? "tid=" + tenantId : "");
        return String.format("https://ml.azure.com/endpoints/realtime/%s?%s%s", endpointName, wsid, tid);
    }

    public static Pair<DeploymentHealth, InfoMessage.InfoMessages> getEndpointHealthFromState(@Nonnull AzureMLResource.ResourceProvisioningState resourceProvisioningState) {
        DeploymentHealth endpointHealth;
        InfoMessage.InfoMessages endpointHealthMessages = new InfoMessage.InfoMessages();
        if (AzureMLResource.ResourceProvisioningState.CREATING.equals((Object)resourceProvisioningState)) {
            endpointHealth = DeploymentHealth.UNKNOWN;
            endpointHealthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_AZUREML_ENDPOINT_CREATING_STATE, "");
        } else if (AzureMLResource.ResourceProvisioningState.DELETING.equals((Object)resourceProvisioningState)) {
            endpointHealth = DeploymentHealth.WARNING;
            endpointHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_AZUREML_ENDPOINT_DELETING_STATE, "");
        } else if (AzureMLResource.ResourceProvisioningState.UPDATING.equals((Object)resourceProvisioningState)) {
            endpointHealth = DeploymentHealth.UNKNOWN;
            endpointHealthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_AZUREML_ENDPOINT_UPDATING_STATE, "");
        } else if (AzureMLResource.ResourceProvisioningState.SUCCEEDED.equals((Object)resourceProvisioningState)) {
            endpointHealth = DeploymentHealth.HEALTHY;
        } else if (AzureMLResource.ResourceProvisioningState.FAILED.equals((Object)resourceProvisioningState)) {
            endpointHealth = DeploymentHealth.UNHEALTHY;
            endpointHealthMessages.withError((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_AZUREML_ENDPOINT_FAILED_STATE, "");
        } else if (AzureMLResource.ResourceProvisioningState.CANCELED.equals((Object)resourceProvisioningState)) {
            endpointHealth = DeploymentHealth.UNHEALTHY;
            endpointHealthMessages.withError((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_AZUREML_ENDPOINT_CANCELED_STATE, "");
        } else {
            endpointHealth = DeploymentHealth.UNKNOWN;
            endpointHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_AZUREML_UNKNOWN_STATE, "The AzureML Online Endpoint is in status %s", new Object[]{resourceProvisioningState != null ? resourceProvisioningState.getName() : ""});
        }
        return new Pair((Object)endpointHealth, (Object)endpointHealthMessages);
    }

    private static Pair<DeploymentHealth, InfoMessage.InfoMessages> getExternalEndpointHealth(@Nonnull AzureMLOnlineEndpoint onlineEndpoint) {
        Pair<DeploymentHealth, InfoMessage.InfoMessages> stateHealthPair = AzureMLUtils.getEndpointHealthFromState(onlineEndpoint.provisioningState);
        Pair<DeploymentHealth, InfoMessage.InfoMessages> trafficHealthPair = AzureMLUtils.getExternalEndpointHealthFromTraffic(onlineEndpoint);
        DeploymentHealth resultHealth = ((DeploymentHealth)((Object)stateHealthPair.first)).getSeverer((DeploymentHealth)((Object)trafficHealthPair.first));
        InfoMessage.InfoMessages resultMessages = new InfoMessage.InfoMessages();
        resultMessages.mergeFrom((InfoMessage.InfoMessages)stateHealthPair.second);
        resultMessages.mergeFrom((InfoMessage.InfoMessages)trafficHealthPair.second);
        return new Pair((Object)resultHealth, (Object)resultMessages);
    }

    private static Pair<DeploymentHealth, InfoMessage.InfoMessages> getExternalEndpointHealthFromTraffic(@Nonnull AzureMLOnlineEndpoint onlineEndpoint) {
        DeploymentHealth trafficHealth = DeploymentHealth.HEALTHY;
        InfoMessage.InfoMessages trafficHealthMessages = new InfoMessage.InfoMessages();
        int totalTraffic = onlineEndpoint.traffic.values().stream().mapToInt(Integer::intValue).sum();
        if (onlineEndpoint.traffic.isEmpty()) {
            trafficHealth = DeploymentHealth.UNHEALTHY;
            trafficHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_ENDPOINT_HAS_NO_MODEL_DEPLOYED, "Online Endpoint '%s' has no deployment", new Object[]{onlineEndpoint.name});
        } else if (totalTraffic == 0) {
            trafficHealth = DeploymentHealth.UNHEALTHY;
            trafficHealthMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_ENDPOINT_HAS_NO_TRAFFIC, "Online Endpoint '%s' has no traffic available", new Object[]{onlineEndpoint.name});
        }
        return new Pair((Object)trafficHealth, (Object)trafficHealthMessages);
    }

    public static abstract class AzureSession
    implements AutoCloseable {
        public String sessionId;
        public List<AzureSubscription> subscriptions = new ArrayList<AzureSubscription>();
        public boolean loggedIn = false;
        public ProxySettings proxySettings;

        AzureSession(String sessionId, ProxySettings proxySettings) {
            this.sessionId = sessionId;
            this.proxySettings = proxySettings;
            logger.infoV("Created Azure session with id '%s' for Azure authentication", new Object[]{sessionId});
        }

        public Optional<AzureSubscription> getDefaultSubscription() {
            return this.subscriptions.stream().filter(subscription -> subscription.isDefault).findFirst();
        }

        public Map<String, String> getSessionEnv() {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put(AzureMLUtils.DKU_AZURE_CLI_LOGIN_PERFORMED, this.loggedIn ? "1" : "0");
            if (!this.proxySettings.hasProxy()) {
                return env;
            }
            env.put("HTTP_PROXY", "http://" + this.proxySettings.getAsString());
            env.put("HTTPS_PROXY", "http://" + this.proxySettings.getAsString());
            return env;
        }

        public abstract void doLoginOrCheck_NT() throws AzureAuthenticationException;

        @Override
        public void close() {
            logger.infoV("Closing Azure session '%s'.", new Object[]{this.sessionId});
        }
    }

    public static class ServicePrincipalAzureSession
    extends AzureSession {
        public AuthCtx authCtx;
        public File configFolder;
        public File extensionDir;
        @Nonnull
        public String connectionName;

        private ServicePrincipalAzureSession(String sessionId, AuthCtx authCtx, @Nonnull String connectionName, ProxySettings proxySettings) throws IOException {
            super(sessionId, proxySettings);
            this.authCtx = authCtx;
            this.connectionName = connectionName;
            this.configFolder = this.generateTmpCLIConfigFolder(sessionId);
            this.extensionDir = new File(this.resolveAzureCLIExtensionsDir());
        }

        @Override
        public Map<String, String> getSessionEnv() {
            Map<String, String> env = super.getSessionEnv();
            if (Objects.nonNull(this.configFolder)) {
                env.put(AzureMLUtils.AZUREML_SESSION_CONFIG_FOLDER_ENV_KEY, this.configFolder.getAbsolutePath());
            }
            env.put(AzureMLUtils.AZUREML_EXTENSION_DIR_ENV_KEY, this.extensionDir.getAbsolutePath());
            return env;
        }

        private void doLogin_NT(List<String> loginCommand, String secret) throws AzureAuthenticationException {
            try {
                logger.info((Object)"Executing Azure login command...");
                List<AzureSubscription> retrievedSubscriptions = AzureMLUtils.execAzureMLCommandAndGetOutputWithErrorInException_NT(loginCommand, new TypeToken<List<AzureSubscription>>(){}, this.getSessionEnv(), secret);
                this.subscriptions.addAll(retrievedSubscriptions);
                this.loggedIn = true;
                logger.infoV("Successfully logged in into Azure with sessionId '%s' and using Service Principal mechanism.", new Object[]{this.sessionId});
            }
            catch (IOException | InterruptedException e) {
                String message = "Failed to authenticate with Azure using the provided Service Principal.";
                logger.error((Object)message, (Throwable)e);
                this.close();
                throw new AzureAuthenticationException(message, e);
            }
        }

        @Override
        public void doLoginOrCheck_NT() throws AzureAuthenticationException {
            try {
                AzureMLConnection connection = (AzureMLConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, this.connectionName);
                ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials creds = connection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials.class);
                String tenantId = connection.params.tenantId;
                String appId = creds.oauth2AppId;
                String secret = creds.oauth2AppSecret;
                List<String> loginCommand = AzureMLUtils.getAzureCLIServicePrincipalLoginCommand(tenantId, appId);
                this.doLogin_NT(loginCommand, secret);
            }
            catch (DKUSecurityException | IOException e) {
                String message = "Failed to authenticate with Azure using the provided Service Principal.";
                logger.error((Object)message, e);
                this.close();
                throw new AzureAuthenticationException(message);
            }
        }

        @Override
        public void close() {
            try {
                logger.infoV("Closing Azure session '%s'.", new Object[]{this.sessionId});
                if (this.configFolder != null) {
                    logger.infoV("Removing temporary directory '%s' for Azure session '%s'.", new Object[]{this.configFolder.getAbsolutePath(), this.sessionId});
                    DKUFileUtils.deleteDirectory((File)this.configFolder);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to delete temporary directory associated to Azure session '%s': " + this.configFolder.getAbsolutePath() + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }

        private File generateTmpCLIConfigFolder(String sessionId) throws IOException {
            File tmpDir = DKUApp.getFile((String[])new String[]{"tmp", "managed-infrastructure-azureml", "login-" + sessionId});
            logger.infoV("Creating temporary directory '%s' as config folder for the Azure login session '%s'", new Object[]{tmpDir.getAbsolutePath(), sessionId});
            DKUFileUtils.mkdirs((File)tmpDir);
            return tmpDir;
        }

        private String resolveAzureCLIExtensionsDir() {
            String extensionsDir = DKUApp.getParams().getParam(AzureMLUtils.AZUREML_EXTENSION_DIR_PROPERTY_KEY);
            if (!StringUtils.isBlank((CharSequence)extensionsDir)) {
                logger.infoV("Resolved AzureML extensions dir from dip.properties as '%s'.", new Object[]{extensionsDir});
                return extensionsDir;
            }
            extensionsDir = System.getenv(AzureMLUtils.AZUREML_EXTENSION_DIR_ENV_KEY);
            if (!StringUtils.isBlank((CharSequence)extensionsDir)) {
                logger.infoV("Resolved AzureML extensions dir from the already system defined environment var '%s' as '%s'.", new Object[]{AzureMLUtils.AZUREML_EXTENSION_DIR_ENV_KEY, extensionsDir});
                return extensionsDir;
            }
            Path defaultExtensionsPath = Paths.get(System.getProperty("user.home"), ".azure", "cliextensions");
            extensionsDir = defaultExtensionsPath.toString();
            logger.infoV("Assigned default value for AzureML extensions dir as '%s'.", new Object[]{extensionsDir});
            return extensionsDir;
        }
    }

    public static class EnvironmentAzureSession
    extends AzureSession {
        private EnvironmentAzureSession(String sessionId, ProxySettings proxySettings) {
            super(sessionId, proxySettings);
        }

        @Override
        public void doLoginOrCheck_NT() throws AzureAuthenticationException {
            try {
                TransactionContext.assertNoAttachedTransaction();
                logger.info((Object)"Checking an Azure log in is already done by retrieving the default subscription...");
                Optional<AzureSubscription> subscription = AzureMLUtils.getDefaultSubscription_NT(this);
                subscription.ifPresent(this.subscriptions::add);
                this.loggedIn = true;
                logger.infoV("Successfully checked that a proper Azure log in is done.", new Object[0]);
            }
            catch (IOException | InterruptedException e) {
                String message = "Error while checking that a proper log in for Azure is done in the environment. Make sure you have prepared your local machine for 'az' running the corresponding login command.";
                logger.error((Object)message, (Throwable)e);
                this.close();
                throw new AzureAuthenticationException(message);
            }
        }
    }

    public static class AzureSubscription {
        public String id;
        public String tenantId;
        public boolean isDefault;
    }

    public static class BasicWorkspace {
        public String id;
        public String name;
        public String location;
    }

    private static class AzureMLOnlineEndpointCredentials {
        public String primaryKey;
        public String secondaryKey;
        public String accessToken;

        public String getToken() {
            if (StringUtils.isNotEmpty((CharSequence)this.primaryKey)) {
                return this.primaryKey;
            }
            return this.accessToken;
        }
    }

    public static class AzureAuthenticationException
    extends Exception
    implements ICodedException {
        public AzureAuthenticationException(String message) {
            super(message);
        }

        public AzureAuthenticationException(String message, Throwable cause) {
            super(message, cause);
        }

        public InfoMessage.MessageCode getCode() {
            return AuthenticationCodes.ERR_AZUREML_LOGIN_FAILED;
        }

        public static enum AuthenticationCodes implements InfoMessage.MessageCode
        {
            ERR_AZUREML_LOGIN_FAILED("Login to Azure failed", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_CONNECTIONS);

            private final String title;
            private final InfoMessage.FixabilityCategory fixability;

            private AuthenticationCodes(String title, InfoMessage.FixabilityCategory fixability) {
                this.title = title;
                this.fixability = fixability;
            }

            public String getCode() {
                return this.name();
            }

            public String getCodeTitle() {
                return this.title;
            }

            public InfoMessage.FixabilityCategory getFixability() {
                return this.fixability;
            }
        }
    }

    public static class DSSAzureMLConsolidatedEndpointInfo
    extends ProxyModelVersionConfiguration.ConsolidatedEndpointInfo {
        public List<AzureMLOnlineDeployment> deployments = new ArrayList<AzureMLOnlineDeployment>();
        public AzureMLOnlineEndpoint endpointInfo;
        public Map<String, AzureMLModel> modelByDeployment = new HashMap<String, AzureMLModel>();
        public Map input;
        public String openAPI;
        public String retrievedByTenantId;

        @Override
        public InfoMessage.InfoMessages computeDifferences(@Nonnull ProxyModelVersionConfiguration.ConsolidatedEndpointInfo other) {
            String currentDep;
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            if (other.getClass() == ProxyModelVersionConfiguration.ErrorEndpointInfo.class) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Remote endpoint error", ((ProxyModelVersionConfiguration.ErrorEndpointInfo)other).errorMessage));
                return ret;
            }
            if (this.getClass() != other.getClass()) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Wrong type", "Type mismatch between configuration and remote endpoint"));
                return ret;
            }
            DSSAzureMLConsolidatedEndpointInfo azureMLOther = (DSSAzureMLConsolidatedEndpointInfo)other;
            if (azureMLOther.deployments.isEmpty()) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Deployments differ", "There is no model currently deployed on endpoint"));
                return ret;
            }
            String initialDep = this.deployments.stream().map(d -> d.name).sorted().collect(Collectors.joining(", "));
            if (!initialDep.equals(currentDep = azureMLOther.deployments.stream().map(d -> d.name).sorted().collect(Collectors.joining(", ")))) {
                String msg = String.format("At version creation: '%s'.%nCurrently on remote endpoint: '%s'.", initialDep, currentDep);
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Deployments differ", msg));
            } else {
                boolean modelDiffers = false;
                for (Map.Entry<String, AzureMLModel> elem : this.modelByDeployment.entrySet()) {
                    AzureMLModel initialValue = elem.getValue();
                    AzureMLModel currentValue = azureMLOther.modelByDeployment.get(elem.getKey());
                    if (initialValue.name.equals(currentValue.name)) continue;
                    modelDiffers = true;
                    String msg = String.format("At version creation: '%s'.%nCurrently on remote endpoint: '%s'.", initialValue.name, currentValue.name);
                    ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Models differ", msg));
                }
                if (!modelDiffers && !this.endpointInfo.traffic.equals(azureMLOther.endpointInfo.traffic)) {
                    String msg = String.format("At version creation: '%s'.%nCurrently on remote endpoint: '%s'.", this.endpointInfo.traffic.entrySet().stream().map(e -> (String)e.getKey() + " -> " + String.valueOf(e.getValue())).collect(Collectors.joining(", ")), azureMLOther.endpointInfo.traffic.entrySet().stream().map(e -> (String)e.getKey() + " -> " + String.valueOf(e.getValue())).collect(Collectors.joining(", ")));
                    ret.addMessage(new InfoMessage(InfoMessage.Severity.WARNING, "Traffic configuration differs", msg));
                }
            }
            if (ret.messages.isEmpty()) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.INFO, "Information matches", "The endpoint has the same configuration as when this DSS saved model version was created"));
            }
            return ret;
        }
    }

    public static class EndpointListingFutureThread
    extends FutureThread<List<ExternalInfraEndpoint>> {
        private final String authConnectionName;
        private final String projectKey;
        private final String workspace;
        private final String resourceGroup;
        private final String subscription;
        private List<ExternalInfraEndpoint> result;
        private final FuturePayload futurePayload;
        private final int connectTimeout;
        private final int socketTimeout;

        public EndpointListingFutureThread(DSSAuthCtx user, String authConnectionName, String projectKey, String workspace, String resourceGroup, String subscription, int connectTimeout, int socketTimeout) {
            super(user);
            this.authConnectionName = authConnectionName;
            this.projectKey = projectKey;
            this.workspace = workspace;
            this.resourceGroup = resourceGroup;
            this.subscription = subscription;
            this.futurePayload = this.buildFuturePayload();
            this.connectTimeout = connectTimeout;
            this.socketTimeout = socketTimeout;
        }

        public FuturePayload buildFuturePayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "list_azureml_endpoints";
            String id = this.workspace + "_" + this.resourceGroup + "_" + this.subscription;
            fp.targets.add(new FuturePayload.FuturePayloadTarget(this.projectKey, id, id, "BUNDLE"));
            fp.displayName = "List endpoints in workspace " + this.workspace + ", resource group " + this.resourceGroup + ", subscription " + this.subscription;
            return fp;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public List<ExternalInfraEndpoint> getResult() {
            return this.result;
        }

        public void execute() throws Exception {
            this.result = AzureMLUtils.listOnlineEndpoints_NT(this.owner, this.authConnectionName, this.workspace, this.resourceGroup, this.subscription, this.connectTimeout, this.socketTimeout);
        }
    }

    private static class InstanceType {
        String name;

        private InstanceType() {
        }
    }

    private static class DefaultsConfig {
        String name;
        String value;

        private DefaultsConfig() {
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

