/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.snowpark;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.deployer.common.DeployerUtils;
import com.dataiku.dip.externalinfras.ExternalInfraEndpoint;
import com.dataiku.dip.externalinfras.snowpark.SnowparkUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.security.DSSAuthCtx;
import java.util.List;
import javax.annotation.Nonnull;

public class SnowparkFutureThreads {
    private SnowparkFutureThreads() {
    }

    public static class EndpointsListing
    extends FutureThread<List<ExternalInfraEndpoint>> {
        @Nonnull
        private final DSSAuthCtx user;
        @Nonnull
        private final SnowflakeConnection connection;
        @Nonnull
        private final String database;
        @Nonnull
        private final String schema;
        private List<ExternalInfraEndpoint> result;
        private final FuturePayload futurePayload = new FuturePayload();

        public EndpointsListing(@Nonnull DSSAuthCtx user, @Nonnull SnowflakeConnection connection, @Nonnull String database, @Nonnull String schema) {
            super(user);
            this.user = user;
            this.connection = connection;
            this.database = database;
            this.schema = schema;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public List<ExternalInfraEndpoint> getResult() {
            return this.result;
        }

        public void execute() throws Exception {
            try (SQLConnectionProvider.SQLConnectionWrapper sqlConnectionWrapper = SnowparkUtils.createSQLWrapper_NT(this.connection, this.user, null, null, this.database, this.schema, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());){
                this.result = SnowparkUtils.listEndpoints_NT(sqlConnectionWrapper);
            }
        }
    }
}

