/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.vertexai;

import com.dataiku.dip.externalinfras.ExternalInfrasInputValidator;
import com.dataiku.dip.utils.ErrorContext;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class VertexAIInputValidator
extends ExternalInfrasInputValidator {
    private static final Pattern VERTEX_AI_PROJECT_ID_PATTERN = Pattern.compile("^[a-z][a-z0-9-]{4,28}[a-z0-9]$");
    private static final String VERTEX_AI_REGION_NAME_PATTERN = "^[a-zA-Z][a-zA-Z0-9-]{0,30}\\d$";
    private static final Pattern VERTEX_AI_ENDPOINT_ID_PATTERN = Pattern.compile("^(?!-)(?!.*-$)[a-zA-Z0-9-]{1,63}$");
    private static final int VERTEX_AI_ENDPOINT_ID_MAX_LENGTH = 63;

    public static void validateRegionName(@Nullable String regionName) {
        if (StringUtils.isEmpty((CharSequence)regionName)) {
            throw new IllegalArgumentException("Vertex AI region should not be empty.");
        }
        if (!VertexAIInputValidator.matches(Pattern.compile(VERTEX_AI_REGION_NAME_PATTERN), regionName)) {
            throw new IllegalArgumentException(String.format("Invalid Vertex AI region: %s", regionName));
        }
    }

    public static void validateProjectId(@Nullable String projectId) {
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            throw new IllegalArgumentException("Vertex AI project should not be empty.");
        }
        if (!VertexAIInputValidator.matches(VERTEX_AI_PROJECT_ID_PATTERN, projectId)) {
            throw new IllegalArgumentException(String.format("Invalid Vertex AI project ID: %s", projectId));
        }
    }

    public static void validateEndpointId(@Nullable String endpointId) {
        if (StringUtils.isEmpty((CharSequence)endpointId)) {
            throw new IllegalArgumentException("Vertex AI endpoint id should not be empty.");
        }
        if (endpointId.length() > 63) {
            throw ErrorContext.iaef((String)"Endpoint id length is greater than 63: %s", (Object)endpointId, (Object[])new Object[0]);
        }
        if (!VertexAIInputValidator.matches(VERTEX_AI_ENDPOINT_ID_PATTERN, endpointId)) {
            throw new IllegalArgumentException(String.format("Invalid Vertex AI endpoint id: %s", endpointId));
        }
    }
}

