/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class HiveBasicSerDeParser {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.hive");

    public static JSONObject parseStruct(String value, SchemaColumn objColumn, char[] separators, int level) {
        if (level >= separators.length) {
            throw ErrorContext.iae((String)"Structure is too deep, cannot parse");
        }
        JSONObject ret = new JSONObject();
        assert (objColumn.getType() == Type.OBJECT);
        if (objColumn.objectFields == null) {
            throw ErrorContext.iae((String)"Cannot parse a Hive struct column with no object fields");
        }
        if (value == null || value.isEmpty()) {
            return ret;
        }
        char sep = separators[level];
        String[] values = StringUtils.split((String)value, (char)sep);
        assert (values.length > 0);
        if (values.length != objColumn.objectFields.size()) {
            logger.warnV("STRUCT/OBJECT [%s]: columns count mismatch, schema has %d, found %d in value %s", new Object[]{objColumn.getName(), objColumn.objectFields.size(), values.length, value});
            return ret;
        }
        for (int i = 0; i < values.length; ++i) {
            String v = values[i];
            SchemaColumn col = (SchemaColumn)objColumn.objectFields.get(i);
            String sval = null;
            switch (col.getType()) {
                case ARRAY: {
                    sval = HiveBasicSerDeParser.parseArray(v, col, separators, level + 1);
                    break;
                }
                case OBJECT: {
                    sval = HiveBasicSerDeParser.parseStruct(v, col, separators, level + 1);
                    break;
                }
                case MAP: {
                    sval = HiveBasicSerDeParser.parseMap(v, col, separators, level + 1);
                    break;
                }
                default: {
                    sval = v;
                }
            }
            ret.put(col.getName(), (Object)sval);
        }
        return ret;
    }

    public static JSONObject parseMap(String value, SchemaColumn mapColumn, char[] separators, int level) {
        if (level >= separators.length - 1) {
            throw ErrorContext.iae((String)"Structure is too deep, cannot parse");
        }
        JSONObject ret = new JSONObject();
        assert (mapColumn.getType() == Type.MAP);
        if (mapColumn.mapKeys == null) {
            throw ErrorContext.iae((String)"Cannot parse a Hive map column with no map key type");
        }
        if (mapColumn.mapValues == null) {
            throw ErrorContext.iae((String)"Cannot parse a Hive map column with no map value type");
        }
        if (value == null || value.isEmpty()) {
            return ret;
        }
        char arraySep = separators[level];
        char keySep = separators[level + 1];
        String[] values = StringUtils.split((String)value, (char)arraySep);
        assert (values.length > 0);
        for (String val : values) {
            String[] kv = StringUtils.split((String)val, (char)keySep);
            if (kv.length != 2) {
                logger.warn((Object)("Malformed map entry " + val));
                continue;
            }
            ret.put((switch (mapColumn.mapKeys.getType()) {
                case Type.ARRAY -> HiveBasicSerDeParser.parseArray(kv[0], mapColumn.mapKeys, separators, level + 2);
                case Type.OBJECT -> HiveBasicSerDeParser.parseStruct(kv[0], mapColumn.mapKeys, separators, level + 2);
                case Type.MAP -> HiveBasicSerDeParser.parseMap(kv[0], mapColumn.mapKeys, separators, level + 2);
                default -> kv[0];
            }).toString(), (Object)(switch (mapColumn.mapValues.getType()) {
                case Type.ARRAY -> HiveBasicSerDeParser.parseArray(kv[1], mapColumn.mapValues, separators, level + 2);
                case Type.OBJECT -> HiveBasicSerDeParser.parseStruct(kv[1], mapColumn.mapValues, separators, level + 2);
                case Type.MAP -> HiveBasicSerDeParser.parseMap(kv[1], mapColumn.mapValues, separators, level + 2);
                default -> kv[1];
            }));
        }
        return ret;
    }

    public static JSONArray parseArray(String value, SchemaColumn arrayColumn, char[] separators, int level) {
        if (level >= separators.length) {
            throw ErrorContext.iae((String)"Structure is too deep, cannot parse");
        }
        JSONArray ret = new JSONArray();
        assert (arrayColumn.getType() == Type.ARRAY);
        if (arrayColumn.arrayContent == null) {
            throw ErrorContext.iae((String)"Cannot parse a Hive array column with no array content type");
        }
        if (value == null || value.isEmpty()) {
            return ret;
        }
        SchemaColumn arrayContent = arrayColumn.arrayContent;
        char sep = separators[level];
        String[] values = StringUtils.split((String)value, (char)sep);
        assert (values.length > 0);
        block5: for (String val : values) {
            switch (arrayContent.getType()) {
                case ARRAY: {
                    ret.put((Object)HiveBasicSerDeParser.parseArray(val, arrayContent, separators, level + 1));
                    continue block5;
                }
                case OBJECT: {
                    ret.put((Object)HiveBasicSerDeParser.parseStruct(val, arrayContent, separators, level + 1));
                    continue block5;
                }
                case MAP: {
                    ret.put((Object)HiveBasicSerDeParser.parseMap(val, arrayContent, separators, level + 1));
                    continue block5;
                }
                default: {
                    ret.put((Object)val);
                }
            }
        }
        return ret;
    }

    public static String serializeStruct(JSONObject struct, SchemaColumn col, char[] separators, int level) {
        if (level >= separators.length) {
            throw ErrorContext.iae((String)"Structure is too deep, cannot parse");
        }
        assert (col.getType() == Type.OBJECT);
        if (col.objectFields == null) {
            throw ErrorContext.iae((String)"Cannot serialize a Hive struct column with no fields");
        }
        char sep = separators[level];
        ArrayList<String> elts = new ArrayList<String>();
        for (int i = 0; i < col.objectFields.size(); ++i) {
            String key = ((SchemaColumn)col.objectFields.get(i)).getName();
            String val = switch (((SchemaColumn)col.objectFields.get(i)).getType()) {
                case Type.ARRAY -> HiveBasicSerDeParser.serializeArray(struct.getJSONArray(key), (SchemaColumn)col.objectFields.get(i), separators, level + 1);
                case Type.MAP -> HiveBasicSerDeParser.serializeMap(struct.getJSONObject(key), (SchemaColumn)col.objectFields.get(i), separators, level + 1);
                case Type.OBJECT -> HiveBasicSerDeParser.serializeStruct(struct.getJSONObject(key), (SchemaColumn)col.objectFields.get(i), separators, level + 1);
                default -> struct.get(key).toString();
            };
            if (val == null) {
                val = "";
            }
            elts.add(val);
        }
        return StringUtils.join(elts, (char)sep);
    }

    public static String serializeMap(JSONObject obj, SchemaColumn col, char[] separators, int level) {
        if (level >= separators.length - 1) {
            throw ErrorContext.iae((String)"Structure is too deep, cannot parse");
        }
        assert (col.getType() == Type.MAP);
        if (col.mapKeys == null || col.mapValues == null) {
            throw ErrorContext.iae((String)"Cannot parse a Hive array column with no array content type");
        }
        char arraySep = separators[level];
        char mapSep = separators[level + 1];
        ArrayList<CallSite> elts = new ArrayList<CallSite>();
        Iterator it = obj.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            elts.add((CallSite)((Object)(key + mapSep + (switch (col.mapValues.getType()) {
                case Type.ARRAY -> HiveBasicSerDeParser.serializeArray(obj.getJSONArray(key), col.mapValues, separators, level + 2);
                case Type.MAP -> HiveBasicSerDeParser.serializeMap(obj.getJSONObject(key), col.mapValues, separators, level + 2);
                case Type.OBJECT -> HiveBasicSerDeParser.serializeStruct(obj.getJSONObject(key), col.mapValues, separators, level + 2);
                default -> obj.get(key).toString();
            }))));
        }
        return StringUtils.join(elts, (char)arraySep);
    }

    public static String serializeArray(JSONArray array, SchemaColumn col, char[] separators, int level) {
        if (level >= separators.length) {
            throw ErrorContext.iae((String)"Structure is too deep, cannot parse");
        }
        assert (col.getType() == Type.ARRAY);
        if (col.arrayContent == null) {
            throw ErrorContext.iae((String)("Cannot parse a Hive array column with no array content type (col: " + JSON.log((Object)col) + ")"));
        }
        char sep = separators[level];
        ArrayList<String> elts = new ArrayList<String>();
        block5: for (int i = 0; i < array.length(); ++i) {
            switch (col.arrayContent.getType()) {
                case ARRAY: {
                    elts.add(HiveBasicSerDeParser.serializeArray(array.getJSONArray(i), col.arrayContent, separators, level + 1));
                    continue block5;
                }
                case MAP: {
                    elts.add(HiveBasicSerDeParser.serializeMap(array.getJSONObject(i), col.arrayContent, separators, level + 1));
                    continue block5;
                }
                case OBJECT: {
                    elts.add(HiveBasicSerDeParser.serializeStruct(array.getJSONObject(i), col.arrayContent, separators, level + 1));
                    continue block5;
                }
                default: {
                    elts.add(array.get(i).toString());
                }
            }
        }
        return StringUtils.join(elts, (char)sep);
    }

    private HiveBasicSerDeParser() {
    }
}

