/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.langchain;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.agents.blocks.custom.CustomBlocksGraphBlocksService;
import com.dataiku.dip.agents.blocks.custom.LoadedCustomBlocksGraphBlock;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.llm.langchain.AbstractAgentLLMClient;
import com.dataiku.dip.llm.langchain.PythonLLMServer;
import com.dataiku.dip.llm.langchain.PythonLLMServerKernelPool;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class ToolsUsingAgentLLMClient
extends AbstractAgentLLMClient {
    private static final String PY_CLAZZ_V1 = "dataiku.llm.python.tools_using.ToolUsingAgent";
    private static final String PY_CLAZZ_V2 = "dataiku.llm.python.tools_using_2.ToolUsingAgent";
    private static final String PY_CLAZZ_BLOCK_GRAPH = "dataiku.llm.python.blocks_graph.BlocksGraphAgent";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.agent");

    public ToolsUsingAgentLLMClient(DSSAuthCtx authCtx, String projectKey, SavedModel sm, SavedModel.SavedModelInlineVersion smiv, boolean devKernel) {
        super(authCtx, projectKey, sm, smiv, devKernel);
    }

    private String getPyClazz() {
        String pyClazz;
        String string = pyClazz = DKUApp.getParams().getBoolParam("dku.agents.visual.agenticLoopV2", true) ? PY_CLAZZ_V2 : PY_CLAZZ_V1;
        if (this.smiv.toolsUsingAgentSettings.mode == SavedModel.ToolsUsingAgentMode.BLOCKS_GRAPH) {
            pyClazz = PY_CLAZZ_BLOCK_GRAPH;
        }
        return pyClazz;
    }

    private JsonObject getConfig() throws IOException, DKUSecurityException {
        CustomBlocksGraphBlocksService customBlocksGraphBlocksService = (CustomBlocksGraphBlocksService)SpringUtils.getBean(CustomBlocksGraphBlocksService.class);
        SavedModel.ToolsUsingAgentSettings expandedSettings = (SavedModel.ToolsUsingAgentSettings)JSON.deepCopy((Object)this.smiv.toolsUsingAgentSettings);
        for (SavedModel.BlocksGraphBlock block : expandedSettings.blocks) {
            if (!(block instanceof SavedModel.CustomBlock)) continue;
            SavedModel.CustomBlock cblock = (SavedModel.CustomBlock)block;
            PluginSettingsResolver.ResolvedSettings expandedPluginSettings = customBlocksGraphBlocksService.getExpandedPluginSettings(cblock.componentId, this.authCtx, this.projectKey, cblock.config);
            cblock.config = expandedPluginSettings.config;
        }
        JsonObject config = JSON.toJsonObject((Object)expandedSettings, (String[])new String[0]);
        config.addProperty("agentId", this.savedModel.id);
        config.addProperty("agentName", this.savedModel.name);
        config.add("dkuRedactionConfig", JSON.toJsonElement((Object)LLMClient.inputRedactionConfig()));
        if (this.smiv.toolsUsingAgentSettings.mode == SavedModel.ToolsUsingAgentMode.BLOCKS_GRAPH) {
            JsonObject customBlockTypeToPythonClazz = new JsonObject();
            for (LoadedCustomBlocksGraphBlock loadedDesc : ((CustomBlocksGraphBlocksService)SpringUtils.getBean(CustomBlocksGraphBlocksService.class)).list()) {
                customBlockTypeToPythonClazz.addProperty(loadedDesc.getType(), loadedDesc.desc.pyClazzName);
            }
            config.add("customBlockClassNames", (JsonElement)customBlockTypeToPythonClazz);
            logger.info((Object)("Blocks graph agent custom block class names: " + JSON.log((Object)customBlockTypeToPythonClazz)));
        }
        return config;
    }

    public PythonLLMServerKernelPool.KernelDesc buildKernelDesc() throws Exception {
        CustomBlocksGraphBlocksService customBlocksGraphBlocksService = (CustomBlocksGraphBlocksService)SpringUtils.getBean(CustomBlocksGraphBlocksService.class);
        ArrayList<String> additionalPluginLibs = new ArrayList<String>();
        if (this.smiv.toolsUsingAgentSettings.mode == SavedModel.ToolsUsingAgentMode.BLOCKS_GRAPH) {
            for (SavedModel.BlocksGraphBlock block : this.smiv.toolsUsingAgentSettings.blocks) {
                if (!(block instanceof SavedModel.CustomBlock)) continue;
                SavedModel.CustomBlock cblock = (SavedModel.CustomBlock)block;
                String libFolder = customBlocksGraphBlocksService.getPythonLibFolder(cblock.componentId);
                logger.info((Object)("Adding plugin lib folder for block " + cblock.componentId + ": " + libFolder));
                additionalPluginLibs.add(libFolder);
            }
        }
        String envName = this.smiv.toolsUsingAgentSettings.mode == SavedModel.ToolsUsingAgentMode.BLOCKS_GRAPH ? new CodeEnvSelector().selectForAdvancedLLMAgent(this.savedModel.projectKey, this.smiv.toolsUsingAgentSettings.codeEnvSelection) : new CodeEnvSelector().selectForLLMAgent();
        String containerConfName = new ContainerExecConfigSelector().selectConfName_autoTXN(this.authCtx, this.savedModel.projectKey, this.smiv.toolsUsingAgentSettings.containerExecSelection);
        String clusterId = new ClusterSelector().selectForProject(this.authCtx, this.savedModel.projectKey).getClusterId();
        String pyClazz = this.getPyClazz();
        JsonObject config = this.getConfig();
        return PythonLLMServerKernelPool.buildKernelDesc(this.authCtx, this.savedModel.projectKey, this.savedModel.id, this.smiv, pyClazz, null, config, null, envName, containerConfName, null, null, false, clusterId, this.smiv.toolsUsingAgentSettings, this.devKernel, additionalPluginLibs);
    }

    @Override
    protected synchronized void initOnce() throws IOException {
        block7: {
            String pyClazz = this.getPyClazz();
            if (this.serverAPI == null) {
                this.validateParameters();
                try {
                    PythonLLMServerKernelPool.KernelDesc kernelDesc = this.buildKernelDesc();
                    PythonLLMServerKernelPool kernelPool = (PythonLLMServerKernelPool)SpringUtils.getBean(PythonLLMServerKernelPool.class);
                    if (this.isDevMode()) {
                        File logBaseDir = DKUApp.getFile((String[])new String[]{"saved_models", this.savedModel.projectKey, this.savedModel.id, "versions", this.smiv.versionId, "logs"});
                        PythonLLMServer server = new PythonLLMServer(this.authCtx, this.savedModel.projectKey, this.savedModel.id, this.smiv.versionId, pyClazz, null, kernelDesc.envName, kernelDesc.containerConfName, null, null, logBaseDir, kernelDesc.config, null, true, false, false, kernelDesc.additionalPythonLibFolders);
                        try {
                            server.start();
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Kernel failed to start, closing it", (Throwable)e);
                            IOUtils.closeQuietly((Closeable)server, null);
                            throw e;
                        }
                        this.serverAPI = server;
                        break block7;
                    }
                    this.serverAPI = kernelPool.getServerAPI(kernelDesc);
                }
                catch (CustomPythonKernelException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException("Failed to initialize Python LLM", e);
                }
            }
        }
    }

    @Override
    public boolean requiresCostLimiting() {
        return false;
    }

    @Override
    public boolean canBeBlockedByCostLimiting() {
        return false;
    }

    private void validateParameters() throws IllegalArgumentException {
        if (this.smiv.toolsUsingAgentSettings.mode == SavedModel.ToolsUsingAgentMode.BLOCKS_GRAPH) {
            return;
        }
        if (Strings.isNullOrEmpty((String)this.smiv.toolsUsingAgentSettings.llmId)) {
            throw new IllegalArgumentException("Missing llmId for visual agent, model " + this.savedModel.id + " version " + this.smiv.versionId);
        }
        if (this.smiv.toolsUsingAgentSettings.llmId.startsWith("agent:" + this.savedModel.id)) {
            throw new IllegalArgumentException("Illegal self-reference for visual agent, " + this.savedModel.id + " version " + this.smiv.versionId);
        }
    }

    @Override
    public String getProviderId() {
        return "tools-using-agent";
    }
}

