/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.vertex;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.VertexAILLMConnection;
import com.dataiku.dip.llm.online.ConfigurableOnlineLLMBackOff;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettings;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettingsValidator;
import com.dataiku.dip.llm.online.vertex.api.GeminiQuery;
import com.dataiku.dip.llm.online.vertex.api.GeminiQueryAdapter;
import com.dataiku.dip.llm.online.vertex.api.GeminiResponse;
import com.dataiku.dip.llm.online.vertex.api.GeminiResponseAdapter;
import com.dataiku.dip.llm.utils.AspectRatioMatcher;
import com.dataiku.dip.llm.utils.OnlineLLMUtils;
import com.dataiku.dip.streaming.endpoints.httpsse.SSEDecoder;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.GoogleCloudUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.AbstractHttpContent;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.GenericUrl;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpContent;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpHeaders;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpIOExceptionHandler;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpRequest;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpRequestFactory;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpRequestInitializer;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpResponse;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpTransport;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.javanet.NetHttpTransport;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.BackOff;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.ExponentialBackOff;
import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RawVertexClient {
    private static final String DEFAULT_REGIONAL_ENDPOINT_TEMPLATE = "https://__REGION__-aiplatform.googleapis.com/v1/projects/__PROJECT__/locations/__REGION__";
    private static final String DEFAULT_GLOBAL_ENDPOINT_TEMPLATE = "https://aiplatform.googleapis.com/v1/projects/__PROJECT__/locations/global";
    private HttpRequestFactory requestFactory;
    private String endpoint;
    private String userAgent;
    private final GoogleCredential credential;
    private final ProxySettings proxySettings;
    private final AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings;
    private static final CoreCompletionSettingsValidator geminiValidator = new CoreCompletionSettingsValidator("VertexAI Gemini").allowMaxTokens().allowTemperature().allowTopK().allowTopP().allowPresencePenalty().allowFrequencyPenalty().allowStopSequences().allowJsonMode().allowTools().allowJsonSchema();
    private static final AspectRatioMatcher aspectRatioMatcher = new AspectRatioMatcher("1:1", "16:9", "9:16", "4:3", "3:4");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.vertex.client");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpRequestFactory getRequestFactory() {
        if (this.requestFactory == null) {
            RawVertexClient rawVertexClient = this;
            synchronized (rawVertexClient) {
                HttpBackOffUnsuccessfulResponseHandler.BackOffRequired backOffRequired = response -> OnlineLLMUtils.retryRequired(response.getStatusCode());
                NetHttpTransport httpTransport = ProxyUtils.getNetHttpTransport((ProxySettings)this.proxySettings);
                GoogleCredential credentials = GoogleCloudUtils.setupCredentialsForProxy(this.credential, (HttpTransport)httpTransport);
                HttpRequestInitializer httpRequestInitializer = httpRequest -> {
                    credentials.initialize(httpRequest);
                    HttpBackOffUnsuccessfulResponseHandler responseHandler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ConfigurableOnlineLLMBackOff(this.networkSettings));
                    responseHandler.setBackOffRequired(backOffRequired);
                    httpRequest.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)responseHandler);
                };
                this.requestFactory = httpTransport.createRequestFactory(httpRequestInitializer);
            }
        }
        return this.requestFactory;
    }

    public RawVertexClient(GoogleCredential credential, String project, String region, ProxySettings proxySettings, AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings, boolean useGlobalEndpoint) {
        if (StringUtils.isBlank((String)project)) {
            throw new IllegalArgumentException("Google Cloud project is empty");
        }
        this.networkSettings = networkSettings;
        this.credential = credential.createScoped(Collections.singleton("https://www.googleapis.com/auth/cloud-platform"));
        this.proxySettings = proxySettings;
        if (useGlobalEndpoint) {
            this.endpoint = DEFAULT_GLOBAL_ENDPOINT_TEMPLATE.replaceAll("__PROJECT__", project) + "/publishers/google/models/";
        } else {
            if (StringUtils.isBlank((String)region)) {
                throw new IllegalArgumentException("Google Cloud region is empty");
            }
            this.endpoint = DEFAULT_REGIONAL_ENDPOINT_TEMPLATE.replaceAll("__PROJECT__", project).replaceAll("__REGION__", region) + "/publishers/google/models/";
        }
    }

    public void close() {
    }

    protected String buildEndpoint() {
        return this.endpoint;
    }

    private GenericUrl buildUrl(String query, Map<String, String> map) {
        String uri = this.buildEndpoint() + query;
        GenericUrl url = new GenericUrl(uri);
        if (map != null) {
            url.putAll(map);
        }
        return url;
    }

    private <T> T sendPost(String path, Map<String, String> map, Object body, Class<T> clazz) throws IOException {
        HttpRequest request = this.getRequestFactory().buildPostRequest(this.buildUrl(path, map), (HttpContent)new JsonHttpContent(body));
        return this.sendRequest(request, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T sendRequest(HttpRequest request, Class<T> clazz) throws IOException {
        logger.debug((Object)(request.getRequestMethod() + " " + String.valueOf(request.getUrl())));
        request.setThrowExceptionOnExecuteError(false);
        request.setNumberOfRetries(this.networkSettings.maxRetries);
        request.setReadTimeout(this.networkSettings.queryTimeoutMS);
        request.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler((BackOff)new ExponentialBackOff()));
        if (this.userAgent != null) {
            request.setHeaders(new HttpHeaders().setUserAgent(this.userAgent));
        }
        HttpResponse response = request.execute();
        if (clazz == HttpResponse.class) {
            return (T)response;
        }
        try {
            String responseBody = response.parseAsString();
            if (response.isSuccessStatusCode()) {
                Object object = clazz != null ? JSON.parse((String)responseBody, clazz) : null;
                return (T)object;
            }
            logger.info((Object)("response body: " + responseBody));
            RawVertexClient.parseAndThrowVertexResponseException(responseBody, response);
            T t = null;
            return t;
        }
        finally {
            response.disconnect();
        }
    }

    private static void parseAndThrowVertexResponseException(String responseBody, HttpResponse response) throws VertexResponseException {
        if (responseBody != null && responseBody.startsWith("{")) {
            try {
                GoogleCloudUtils.GoogleCloudErrorResponse errorResponse = (GoogleCloudUtils.GoogleCloudErrorResponse)JSON.parse((String)responseBody, GoogleCloudUtils.GoogleCloudErrorResponse.class);
                GoogleCloudUtils.GoogleCloudError error = errorResponse != null ? errorResponse.error : null;
                int errorCode = error == null ? 0 : errorResponse.error.code;
                throw new VertexResponseException(errorCode, GoogleCloudUtils.extractMessage(errorResponse));
            }
            catch (RuntimeException e) {
                logger.info((Object)"Failed to decode JSON error", (Throwable)e);
            }
        }
        throw new VertexResponseException(response.getStatusCode(), GoogleCloudUtils.extractErrorMessage(response, responseBody));
    }

    public LLMClient.SimpleCompletionResponse chatComplete(String modelId, List<LLMClient.ChatMessage> messages, CoreCompletionSettings ccs) throws IOException {
        geminiValidator.validate(ccs);
        GeminiQuery geminiQuery = GeminiQueryAdapter.adapt(modelId, messages, ccs);
        logger.trace(() -> String.format("Raw Gemini completion request: %s", JSON.prettyLog((Object)geminiQuery)));
        GeminiResponse.ChatResponses rcrs = this.sendPost(modelId + ":streamGenerateContent", null, geminiQuery, GeminiResponse.ChatResponses.class);
        logger.trace(() -> String.format("Raw Gemini completion response: %s", JSON.prettyLog((Object)rcrs)));
        if (rcrs.isEmpty()) {
            throw new IOException("Vertex did not respond with valid completion");
        }
        LLMClient.SimpleCompletionResponse ret = GeminiResponseAdapter.adapt(rcrs);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamChatComplete(LLMClient.StreamedCompletionResponseConsumer consumer, VertexAILLMConnection.VertexModel model, List<LLMClient.ChatMessage> messages, CoreCompletionSettings ccs) throws Exception {
        geminiValidator.validate(ccs);
        GeminiQuery geminiQuery = GeminiQueryAdapter.adapt(model.getId(), messages, ccs);
        logger.trace(() -> "Raw Gemini streaming query: " + JSON.prettyLog((Object)geminiQuery));
        GenericUrl url = this.buildUrl(model.getId() + ":streamGenerateContent", Collections.singletonMap("alt", "sse"));
        HttpRequest request = this.getRequestFactory().buildPostRequest(url, (HttpContent)new JsonHttpContent(geminiQuery));
        HttpResponse response = this.sendRequest(request, HttpResponse.class);
        LLMClient.StreamedCompletionResponseFooter footer = new LLMClient.StreamedCompletionResponseFooter();
        try {
            assert (response != null);
            if (!response.isSuccessStatusCode()) {
                String responseBody = response.parseAsString();
                logger.warn((Object)("error response body: " + responseBody));
                RawVertexClient.parseAndThrowVertexResponseException(responseBody, response);
            }
            SSEDecoder decoder = new SSEDecoder(response.getContent());
            consumer.onStreamStarted();
            while (true) {
                SSEDecoder.HTTPSSEEvent event = decoder.next();
                logger.trace(() -> "Received raw event from VertexAI: " + JSON.log((Object)event));
                if (event == null || event.data == null) {
                    logger.info((Object)"End of VertexAI stream");
                    break;
                }
                if (event.data.equals("[DONE]")) {
                    logger.info((Object)"Received explicit end marker from VertexAI stream");
                    break;
                }
                GeminiResponse.ChatResponse chunk = (GeminiResponse.ChatResponse)JSON.parse((String)event.data, GeminiResponse.ChatResponse.class);
                GeminiResponse.ChatResponses responses = new GeminiResponse.ChatResponses();
                responses.add(chunk);
                LLMClient.SimpleCompletionResponse ret = GeminiResponseAdapter.adapt(responses);
                LLMClient.StreamedCompletionResponseChunk genericChunk = new LLMClient.StreamedCompletionResponseChunk();
                genericChunk.text = ret.text;
                genericChunk.artifacts = ret.artifacts;
                genericChunk.logProbs = ret.logProbs;
                genericChunk.toolCalls = ret.toolCalls;
                genericChunk.memoryFragment = ret.memoryFragment;
                if (!genericChunk.isEmpty()) {
                    consumer.onStreamChunk(genericChunk);
                }
                if (chunk.usageMetadata != null) {
                    footer.promptTokens = ret.promptTokens;
                    footer.completionTokens = ret.completionTokens;
                    footer.totalTokens = ret.totalTokens;
                    footer.estimatedCost = model.getEstimatedCompletionCost(ret.promptTokens, ret.completionTokens);
                }
                if (ret.finishReason == null) continue;
                footer.finishReason = ret.finishReason;
            }
        }
        finally {
            if (response != null) {
                response.disconnect();
            }
        }
        consumer.onStreamComplete(footer);
    }

    public LLMClient.SimpleEmbeddingResponse embed(VertexAILLMConnection.VertexModel model, LLMClient.EmbeddingQuery query) throws IOException {
        VertexAIEmbeddingResponse resp;
        if (model.modelType.equals((Object)VertexAILLMConnection.VertexModelType.TEXT_IMAGE_EMBEDDING_EXTRACTION)) {
            MultimodalEmbeddingRequest r = new MultimodalEmbeddingRequest().fromQuery(query);
            resp = this.sendPost(model.getId() + ":predict", null, r, MultimodalEmbeddingResponse.class);
        } else {
            TextEmbeddingRequest r = new TextEmbeddingRequest().fromQuery(query);
            resp = this.sendPost(model.getId() + ":predict", null, r, TextEmbeddingResponse.class);
        }
        return resp.toSimpleEmbeddingResponses().get(0);
    }

    public LLMClient.ImageGenerationResponse imagenGenerateImage(String model, LLMClient.ImageGenerationQuery query) throws IOException {
        ImagenRequest ir = new ImagenRequest();
        ImagenInstance instance = new ImagenInstance();
        instance.prompt = query.getConcatenatedPrompts();
        ir.instances.add(instance);
        if (!query.negativePrompts.isEmpty()) {
            ir.parameters.negativePrompt = query.getConcatenatedNegativePrompts();
        }
        if (query.originalImage != null) {
            throw new IllegalArgumentException("Image edition is not supported on Vertex Imagen");
        }
        if (query.width != null && query.height != null) {
            ir.parameters.aspectRatio = aspectRatioMatcher.fuzzyMatch(query.width, query.height);
        }
        if (query.seed != null) {
            ir.parameters.seed = query.seed;
            ir.parameters.addWatermark = false;
        }
        if (query.originalImage == null) {
            logger.info((Object)("Raw Imagen request: " + JSON.log((Object)ir)));
        } else {
            logger.trace(() -> "Raw Imagen request: " + JSON.log((Object)ir));
        }
        if (query.nbImagesToGenerate != null) {
            ir.parameters.sampleCount = query.nbImagesToGenerate;
        }
        if (query.style != null) {
            logger.warn((Object)"style specified but ignored for Vertex provider");
        }
        if (query.quality != null) {
            logger.warn((Object)"quality specified but ignored for Vertex provider");
        }
        if (query.fidelity != null) {
            logger.warn((Object)"fidelity specified but ignored for Vertex provider");
        }
        if (query.maskMode != null) {
            logger.warn((Object)"maskMode specified but ignored for Vertex provider");
        }
        if (query.maskImage != null) {
            logger.warn((Object)"maskImage specified but ignored for Vertex provider");
        }
        JsonObject resp = this.sendPost(model + ":predict", null, ir, JsonObject.class);
        logger.trace(() -> "Raw Imagen generation response: " + JSON.prettyLog((Object)resp));
        if (!resp.has("predictions") || !resp.get("predictions").isJsonArray() || resp.get("predictions").getAsJsonArray().size() == 0) {
            throw new IOException("Vertex did not respond with valid completion");
        }
        LLMClient.ImageGenerationResponse imgResp = new LLMClient.ImageGenerationResponse();
        for (JsonElement elt : resp.get("predictions").getAsJsonArray()) {
            LLMClient.ImageGenerationImage img = new LLMClient.ImageGenerationImage(elt.getAsJsonObject().get("bytesBase64Encoded").getAsString());
            imgResp.images.add(img);
        }
        return imgResp;
    }

    private static class JsonHttpContent
    extends AbstractHttpContent {
        private final String data;

        public JsonHttpContent(Object data) {
            super("application/json; charset=UTF-8");
            this.data = data != null ? new Gson().toJson(data) : null;
        }

        public void writeTo(OutputStream out) throws IOException {
            if (this.data != null) {
                out.write(this.data.getBytes(Charsets.UTF_8));
            }
        }
    }

    public static class VertexResponseException
    extends IOException {
        public final int statusCode;

        public VertexResponseException(int statusCode, String message) {
            super("Code: " + statusCode + " msg= " + message);
            this.statusCode = statusCode;
        }
    }

    public class MultimodalEmbeddingRequest {
        public List<MultimodalEmbeddingInstance> instances = new ArrayList<MultimodalEmbeddingInstance>();

        public MultimodalEmbeddingRequest fromQuery(LLMClient.EmbeddingQuery query) {
            this.instances.add(new MultimodalEmbeddingInstance().fromQuery(query));
            return this;
        }
    }

    public class MultimodalEmbeddingResponse
    implements VertexAIEmbeddingResponse {
        public List<MultimodalEmbeddingPredictionResponse> predictions;

        @Override
        public List<LLMClient.SimpleEmbeddingResponse> toSimpleEmbeddingResponses() throws IOException {
            if (this.predictions == null || this.predictions.size() == 0) {
                throw new IOException("VertexAI did not respond with valid embedding response.");
            }
            ArrayList<LLMClient.SimpleEmbeddingResponse> resp = new ArrayList<LLMClient.SimpleEmbeddingResponse>();
            for (MultimodalEmbeddingPredictionResponse prediction : this.predictions) {
                resp.add(prediction.toSimpleEmbeddingResponse());
            }
            return resp;
        }
    }

    public static interface VertexAIEmbeddingResponse {
        public List<LLMClient.SimpleEmbeddingResponse> toSimpleEmbeddingResponses() throws IOException;
    }

    public class TextEmbeddingRequest {
        public List<TextEmbeddingInstance> instances = new ArrayList<TextEmbeddingInstance>();
        public TextEmbeddingParameters parameters = new TextEmbeddingParameters();

        public TextEmbeddingRequest fromQuery(LLMClient.EmbeddingQuery query) {
            this.instances.add(new TextEmbeddingInstance().fromQuery(query));
            return this;
        }
    }

    public class TextEmbeddingResponse
    implements VertexAIEmbeddingResponse {
        public List<TextEmbeddingPredictionResponse> predictions;

        @Override
        public List<LLMClient.SimpleEmbeddingResponse> toSimpleEmbeddingResponses() throws IOException {
            if (this.predictions == null || this.predictions.size() == 0) {
                throw new IOException("VertexAI did not respond with valid embedding response.");
            }
            ArrayList<LLMClient.SimpleEmbeddingResponse> resp = new ArrayList<LLMClient.SimpleEmbeddingResponse>();
            for (TextEmbeddingPredictionResponse prediction : this.predictions) {
                resp.add(prediction.toSimpleEmbeddingResponse());
            }
            return resp;
        }
    }

    private static class ImagenRequest {
        public List<ImagenInstance> instances = new ArrayList<ImagenInstance>();
        public ImagenParameters parameters = new ImagenParameters();

        private ImagenRequest() {
        }
    }

    private static class ImagenInstance {
        String prompt;
        ImagenImage image;
        ImagenMask mask;

        private ImagenInstance() {
        }
    }

    private static class ImagenParameters {
        Integer sampleCount;
        Integer seed;
        Boolean addWatermark;
        String negativePrompt;
        String mode;
        String aspectRatio;
        ImageEditConfig editConfig;
        JsonObject outputOptions = new JsonObject();

        private ImagenParameters() {
        }
    }

    private static class ImageEditConfig {
        String editMode;
        Object maskMode;
        Integer guidanceScale;

        private ImageEditConfig() {
        }
    }

    private static class ImagenMask {
        ImagenImage image;

        private ImagenMask() {
        }
    }

    private static class ImagenImage {
        String bytesBase64Encoded;

        private ImagenImage() {
        }
    }

    private static class MultimodalEmbeddingPredictionResponse
    implements VertexAIEmbeddingPrediction {
        double[] textEmbedding;
        double[] imageEmbedding;

        private MultimodalEmbeddingPredictionResponse() {
        }

        @Override
        public LLMClient.SimpleEmbeddingResponse toSimpleEmbeddingResponse() throws IOException {
            LLMClient.SimpleEmbeddingResponse r = new LLMClient.SimpleEmbeddingResponse();
            if (this.textEmbedding != null) {
                r.embedding = this.textEmbedding;
            } else if (this.imageEmbedding != null) {
                r.embedding = this.imageEmbedding;
            } else {
                throw new IOException("VertexAI did not respond with valid embedding response.");
            }
            return r;
        }
    }

    private static class TextEmbeddingPredictionResponse
    implements VertexAIEmbeddingPrediction {
        public TextEmbeddingEmbeddingsResponse embeddings;

        private TextEmbeddingPredictionResponse() {
        }

        @Override
        public LLMClient.SimpleEmbeddingResponse toSimpleEmbeddingResponse() throws IOException {
            LLMClient.SimpleEmbeddingResponse r = new LLMClient.SimpleEmbeddingResponse();
            if (this.embeddings == null || this.embeddings.values == null) {
                throw new IOException("VertexAI did not respond with valid embedding response.");
            }
            r.embedding = this.embeddings.values;
            r.promptTokens = this.embeddings.statistics != null ? this.embeddings.statistics.token_count : 0;
            return r;
        }
    }

    public static interface VertexAIEmbeddingPrediction {
        public LLMClient.SimpleEmbeddingResponse toSimpleEmbeddingResponse() throws IOException;
    }

    private static class TextEmbeddingEmbeddingsResponse {
        public double[] values;
        public TextEmbeddingStatisticsResponse statistics;

        private TextEmbeddingEmbeddingsResponse() {
        }
    }

    private static class TextEmbeddingStatisticsResponse {
        public boolean truncated;
        public int token_count;

        private TextEmbeddingStatisticsResponse() {
        }
    }

    private static class MultimodalEmbeddingInstance
    implements VertexAIEmbeddingInstance {
        public EmbeddingImage image;
        public String text;

        private MultimodalEmbeddingInstance() {
        }

        @Override
        public MultimodalEmbeddingInstance fromQuery(LLMClient.EmbeddingQuery query) {
            if (query.hasText()) {
                if (query.hasImage()) {
                    throw new IllegalArgumentException("Multimodal queries for VertexAI are not supported yet");
                }
                this.text = query.text;
            }
            if (query.hasImage()) {
                this.image = new EmbeddingImage();
                this.image.bytesBase64Encoded = query.inlineImage;
            }
            return this;
        }
    }

    private static class TextEmbeddingInstance
    implements VertexAIEmbeddingInstance {
        public String content;

        private TextEmbeddingInstance() {
        }

        @Override
        public TextEmbeddingInstance fromQuery(LLMClient.EmbeddingQuery query) {
            this.content = query.text;
            return this;
        }
    }

    public static interface VertexAIEmbeddingInstance {
        public VertexAIEmbeddingInstance fromQuery(LLMClient.EmbeddingQuery var1);
    }

    private static class TextEmbeddingParameters {
        public boolean autoTruncate = false;

        private TextEmbeddingParameters() {
        }
    }

    private static class EmbeddingImage {
        String bytesBase64Encoded;

        private EmbeddingImage() {
        }
    }

    private static class PalmRawVertexQuery {
        List<AbstractVertexInstance> instances = new ArrayList<AbstractVertexInstance>();
        PalmRawVertexParameters parameters = new PalmRawVertexParameters();

        private PalmRawVertexQuery() {
        }
    }

    private static class PalmRawVertexParameters {
        Double temperature;
        Integer maxOutputTokens;
        Integer maxDecodeSteps;
        Integer topK;
        Double topP;
        Double frequencyPenalty;
        Double presencePenalty;
        @SerializedName(value="logprobs")
        Integer logProbs;
        List<String> stopSequences;

        private PalmRawVertexParameters() {
        }
    }

    private static class PalmChatVertexInstance
    extends AbstractVertexInstance {
        String context;
        List<PalmChatVertexMessage> messages = new ArrayList<PalmChatVertexMessage>();

        private PalmChatVertexInstance() {
        }
    }

    private static class PalmChatVertexMessage {
        String author;
        String content;

        private PalmChatVertexMessage() {
        }
    }

    private static class PalmCompletionVertexInstance
    extends AbstractVertexInstance {
        String prompt;

        private PalmCompletionVertexInstance() {
        }
    }

    private static class AbstractVertexInstance {
        private AbstractVertexInstance() {
        }
    }
}

