/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.meanings.model;

import com.dataiku.dip.shaker.text.StringNormalizationMode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserDefinedMeaning
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String id;
    public String label;
    public String description;
    public List<Entry> entries;
    public List<Mapping> mappings;
    public String pattern;
    public StringNormalizationMode normalizationMode = StringNormalizationMode.EXACT;
    public boolean detectable;
    public Type type = Type.DECLARATIVE;

    public Map<String, String> getNormalizedValueMap() {
        if (this.type != Type.VALUES_MAPPING) {
            return null;
        }
        if (this.mappings == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>(this.mappings.size());
        for (Mapping mapping : this.mappings) {
            map.put(this.normalizationMode.apply(mapping.from), mapping.to.value);
        }
        return map;
    }

    public Set<String> getNormalizedValueSet() {
        if (this.type != Type.VALUES_LIST) {
            return null;
        }
        if (this.entries == null) {
            return new HashSet<String>();
        }
        HashSet<String> set = new HashSet<String>(this.entries.size());
        for (Entry entry : this.entries) {
            set.add(this.normalizationMode.apply(entry.value));
        }
        return set;
    }

    public Map<String, String> getColorMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        switch (this.type) {
            case VALUES_MAPPING: {
                if (this.mappings == null) {
                    return map;
                }
                for (Mapping mapping : this.mappings) {
                    map.put(this.normalizationMode.apply(mapping.from), mapping.to.color);
                }
                return map;
            }
            case VALUES_LIST: {
                if (this.entries == null) {
                    return map;
                }
                for (Entry entry : this.entries) {
                    map.put(this.normalizationMode.apply(entry.value), entry.color == null ? "" : entry.color);
                }
                return map;
            }
            case DECLARATIVE: 
            case PATTERN: {
                return null;
            }
        }
        return null;
    }

    public static enum Type {
        DECLARATIVE,
        VALUES_LIST,
        VALUES_MAPPING,
        PATTERN;

    }

    public static class Mapping
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String from;
        public Entry to;
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String value;
        public String color;
    }
}

