/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.partitioning;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public class StratifiedModelUtils {
    private static final String PARTITION_INFIX = "-part";
    public static final String BASE_SUFFIX = "-base";
    private static final String MODEL_NAME_SUFFIX = "Partitioned";

    public static String generatePartitionSuffix(String partitionName) {
        return "-part-" + PartitioningUtils.encode(partitionName);
    }

    public static String generatePartitionSuffix(String partitionName, String partitionVersion) {
        return StratifiedModelUtils.generatePartitionSuffix(partitionName) + "-" + partitionVersion;
    }

    public static String addSuffixIfAbsent(String modelName) {
        if (modelName.contains(MODEL_NAME_SUFFIX)) {
            return modelName;
        }
        return modelName + " - Partitioned";
    }

    public static Set<FullModelId> fetchPartitionFmis(FullModelId baseFmi) throws IOException {
        if (baseFmi.getType() == FullModelId.Type.ANALYSIS) {
            HashSet<FullModelId> partitionsFmis = new HashSet<FullModelId>();
            Matcher ppsMatcher = FullModelId.ANALYSIS_PPS_PATTERN.matcher("");
            Collection sessionSubfolders = DKUFileUtils.listSubfoldersOf((File)baseFmi.getSessionFolder());
            for (File subfolder : sessionSubfolders) {
                String name = subfolder.getName();
                if (!ppsMatcher.reset(name).find() || !StringUtils.isNotBlank((String)ppsMatcher.group("partitionName"))) continue;
                String partitionName = PartitioningUtils.decode(ppsMatcher.group("partitionName"));
                partitionsFmis.add(baseFmi.getModelPartition(partitionName));
            }
            return partitionsFmis;
        }
        return baseFmi.getSMPartitionsFmis();
    }

    public static void mergeSplitDesc(SplitDesc globalSplitDesc, SplitDesc partSplitDesc) {
        globalSplitDesc.fullRows += partSplitDesc.fullRows;
        globalSplitDesc.trainRows += partSplitDesc.trainRows;
        globalSplitDesc.testRows += partSplitDesc.testRows;
        if (globalSplitDesc.schema == null) {
            globalSplitDesc.schema = partSplitDesc.schema;
        }
    }
}

