/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.queries;

import com.dataiku.dip.sql.BigQuerySQLDialect;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLServerSQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.TeradataSQLDialect;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.utils.Pair;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SelectQueryBuilder {
    private List<Pair<String, String>> withs = new ArrayList<Pair<String, String>>();
    private List<SelectRef> select = new ArrayList<SelectRef>();
    private List<Expr> filters = new ArrayList<Expr>();
    private List<Expr> negatedFilters = new ArrayList<Expr>();
    private List<Expr> having = new ArrayList<Expr>();
    private List<OrderExpr> orders = new ArrayList<OrderExpr>();
    private List<Expr> groups = new ArrayList<Expr>();
    private List<JoinExpr> joins = new ArrayList<JoinExpr>();
    private NamedExpr table;
    private boolean strictTop;
    private Long maxNbRecords;
    private SQLDialect dialect;

    public SelectQueryBuilder(SQLDialect dialect) {
        this.dialect = dialect;
    }

    public void fromTable(String table) {
        this.fromTable(table, null);
    }

    public void fromTable(String table, String alias) {
        this.table = new NamedExpr();
        this.table.expr = this.dialect.quoteIdentifier(table);
        this.table.name = alias;
    }

    public void fromTable(SQLUtils.SQLTable table) {
        this.fromTable(table, null);
    }

    public void fromTable(SQLUtils.SQLTable table, String alias) {
        this.table = new NamedExpr();
        this.table.expr = this.dialect.getQuotedTableFullName(table);
        this.table.name = alias;
    }

    public SelectRef select(String expr, String as) {
        SelectRef ref = new SelectRef();
        ref.expr = expr;
        ref.name = as;
        this.select.add(ref);
        ref.index = this.select.size();
        return ref;
    }

    public void join(SelectQueryBuilder subquery, String alias, String on, JoinExpr.JoinType type) {
        this.join("(" + subquery.toSQL() + ")", alias, on, type);
    }

    public void join(String subquery, String alias, String on, JoinExpr.JoinType type) {
        JoinExpr expr = new JoinExpr();
        expr.expr = subquery;
        expr.name = alias;
        expr.type = type;
        expr.on = on;
        this.joins.add(expr);
    }

    public SelectRef select(String expr) {
        return this.select(expr, null);
    }

    public String getOrderedPartitionClause(List<String> partitionColumns, String orderColumn, String order) {
        Object ret = "PARTITION BY ";
        ret = (String)ret + StringUtils.join((Collection)FluentIterable.from(partitionColumns).transform((Function)new Function<String, String>(){

            public String apply(String in) {
                return SelectQueryBuilder.this.dialect.quoteIdentifier(in);
            }
        }).toList(), (String)",");
        ret = (String)ret + " ORDER BY " + this.dialect.quoteIdentifier(orderColumn) + " " + order;
        return ret;
    }

    public void where(String expr) {
        Expr where = new Expr();
        where.expr = expr;
        this.filters.add(where);
    }

    public void whereNot(String expr) {
        Expr whereNot = new Expr();
        whereNot.expr = expr;
        this.negatedFilters.add(whereNot);
    }

    public void limit(Long maxNbRecords) {
        this.maxNbRecords = maxNbRecords;
    }

    public SelectQueryBuilder withStrictTop() {
        this.strictTop = true;
        return this;
    }

    public void group(String expr) {
        Expr grp = new Expr();
        grp.expr = "(" + expr + ")";
        this.groups.add(grp);
    }

    public void group(SelectRef ref) {
        Expr grp = new Expr();
        grp.expr = this.dialect instanceof BigQuerySQLDialect || this.dialect instanceof ImpalaSQLDialect ? (StringUtils.isNotBlank((String)ref.name) ? this.dialect.quoteIdentifier(ref.name) : ref.expr) : ref.expr;
        this.groups.add(grp);
    }

    public void having(String expr) {
        Expr where = new Expr();
        where.expr = "(" + expr + ")";
        this.having.add(where);
    }

    public SQLDialect getDialect() {
        return this.dialect;
    }

    public void orderBy(String expr, boolean asc) {
        OrderExpr e = new OrderExpr();
        e.expr = "(" + expr + ")";
        e.asc = asc;
        this.orders.add(e);
    }

    public void orderBy(OrderExpr e) {
        this.orders.add(e);
    }

    public void orderBy(SelectRef ref, boolean asc) {
        OrderExpr e = new OrderExpr();
        e.expr = StringUtils.isNotBlank((String)ref.name) ? this.dialect.quoteIdentifier(ref.name) : ref.expr;
        e.asc = asc;
        this.orders.add(e);
    }

    public void with(Pair<String, String> withClause) {
        this.withs.add(withClause);
    }

    public String toSQL() {
        StringBuilder sb = new StringBuilder();
        if (!this.withs.isEmpty()) {
            if (!this.dialect.supportsCTEs()) {
                throw new QueryUtils.SQLGenerationException("SQL database does not support CTEs (WITH clause): " + this.dialect.getClass().getName());
            }
            sb.append("WITH ");
            boolean firstWith = true;
            for (Pair<String, String> pair : this.withs) {
                if (!firstWith) {
                    sb.append(",\n");
                }
                String alias = (String)pair.first;
                String subquery = (String)pair.second;
                sb.append(this.dialect.quoteIdentifier(alias)).append(" AS (").append(subquery).append(")");
                firstWith = false;
            }
            sb.append("\n");
        }
        sb.append("SELECT ");
        if (this.dialect instanceof TeradataSQLDialect && this.strictTop && this.maxNbRecords != null) {
            sb.append("TOP " + this.maxNbRecords + " ");
        }
        if (this.dialect instanceof SQLServerSQLDialect && this.maxNbRecords != null) {
            sb.append("TOP(" + this.maxNbRecords + ") ");
        }
        boolean first = true;
        for (NamedExpr namedExpr : this.select) {
            if (!first) {
                sb.append(",\n");
            }
            if ("*".equals(namedExpr.expr)) {
                sb.append("*");
            } else if (namedExpr.name != null) {
                sb.append("(" + namedExpr.expr + ") as " + this.dialect.quoteIdentifier(namedExpr.name));
            } else {
                sb.append("(" + namedExpr.expr + ")");
            }
            first = false;
        }
        if (this.select.size() == 0) {
            sb.append(" * ");
        }
        if (this.table.name == null) {
            sb.append(" \nFROM ").append(this.table.expr);
        } else {
            sb.append(" \nFROM ").append(this.table.expr).append(" ").append(this.dialect.quoteIdentifier(this.table.name));
        }
        for (JoinExpr joinExpr : this.joins) {
            switch (joinExpr.type) {
                case LEFT: {
                    sb.append(" \nLEFT JOIN");
                    break;
                }
                case RIGHT: {
                    sb.append(" \nRIGHT JOIN");
                    break;
                }
                case INNER: {
                    sb.append(" \nINNER JOIN");
                    break;
                }
                default: {
                    throw new RuntimeException("Unreachable");
                }
            }
            sb.append(" " + joinExpr.expr);
            if (joinExpr.name != null) {
                sb.append(" AS " + this.dialect.quoteIdentifier(joinExpr.name));
            }
            sb.append(" \nON (" + joinExpr.on + ")");
        }
        if (this.filters.size() > 0) {
            sb.append(" \nWHERE ");
            first = true;
            for (Expr expr : this.filters) {
                if (!first) {
                    sb.append(" \nAND");
                }
                if (this.filters.size() == 1) {
                    sb.append(expr.expr);
                } else {
                    sb.append(" (" + expr.expr + ")");
                }
                first = false;
            }
            sb.append("");
        }
        if (this.negatedFilters.size() > 0) {
            sb.append(" \nWHERE NOT ");
            first = true;
            for (Expr expr : this.negatedFilters) {
                if (!first) {
                    sb.append(" \nAND");
                }
                if (this.negatedFilters.size() == 1) {
                    sb.append(expr.expr);
                } else {
                    sb.append(" (" + expr.expr + ")");
                }
                first = false;
            }
            sb.append("");
        }
        if (this.groups.size() > 0) {
            sb.append(" \nGROUP BY");
            first = true;
            for (Expr expr : this.groups) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(" " + expr.expr);
                first = false;
            }
        }
        if (this.having.size() > 0) {
            sb.append(" \nHAVING (");
            first = true;
            for (Expr expr : this.having) {
                if (!first) {
                    sb.append(" \nAND");
                }
                sb.append(" (" + expr.expr + ")");
                first = false;
            }
            sb.append(")");
        }
        if (this.orders.size() > 0) {
            sb.append(" \nORDER BY");
            first = true;
            for (OrderExpr orderExpr : this.orders) {
                if (!first) {
                    sb.append(", ");
                }
                if (this.dialect instanceof OracleSQLDialect) {
                    sb.append(" (CASE WHEN TO_CHAR(" + orderExpr.expr + ") = '___dku_no_value___' THEN 0 ELSE 1 END) " + (orderExpr.asc ? "ASC," : "DESC,"));
                }
                sb.append(" " + orderExpr.expr + " " + (orderExpr.asc ? "ASC" : "DESC"));
                if (this.dialect.supportsNullsOrdering()) {
                    sb.append(" NULLS LAST");
                }
                first = false;
            }
        }
        if (this.maxNbRecords != null) {
            if (this.dialect instanceof OracleSQLDialect) {
                sb.insert(0, "SELECT * FROM (\n");
                sb.append("\n) WHERE ROWNUM <= " + this.maxNbRecords);
            } else if (!(this.dialect instanceof SQLServerSQLDialect)) {
                if (this.dialect instanceof TeradataSQLDialect) {
                    if (!this.strictTop) {
                        sb.append(" \nSAMPLE " + this.maxNbRecords);
                    }
                } else {
                    sb.append(" \nLIMIT " + this.maxNbRecords);
                }
            }
        } else if (this.dialect instanceof ImpalaSQLDialect && this.orders.size() > 0) {
            sb.append(" \nLIMIT " + ((ImpalaSQLDialect)this.dialect).getDefaultLimit());
        }
        return sb.toString();
    }

    public boolean hasFilters() {
        return this.filters.size() > 0 || this.negatedFilters.size() > 0;
    }

    private static class NamedExpr
    extends Expr {
        public String name;

        private NamedExpr() {
        }
    }

    public static class SelectRef
    extends NamedExpr {
        public int index;
        public boolean countOfPrevious = false;
    }

    public static class JoinExpr
    extends NamedExpr {
        public JoinType type;
        public String on;

        public static enum JoinType {
            LEFT,
            RIGHT,
            INNER;

        }
    }

    private static class Expr {
        public String expr;

        private Expr() {
        }
    }

    public static class OrderExpr
    extends Expr {
        public boolean asc = true;
    }
}

