/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel;

import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.frontend.color.DiscretePalette;
import com.dataiku.dip.pivot.frontend.color.PaletteFactory;
import com.dataiku.dip.pivot.frontend.excel.StdAggrDataSheet1DBuilder;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.axes.AxisFactory;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.AreaChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.BarChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.charts.BaseChart;
import com.dataiku.dip.pivot.frontend.excel.xssf.series.Series1D;
import com.dataiku.dip.pivot.frontend.excel.xssf.series.SeriesFactory;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.ChartType;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.AxisCrossBetween;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.AxisPosition;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.LegendPosition;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFChart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFSheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.chart.STBarGrouping;
import org.openxmlformats.schemas.drawingml.x2006.chart.STGrouping;

public class Stacked1DExporter {
    public static XSSFWorkbook export(ChartDef chartDef, PivotTableTensorResponse response, int animationFrameIdx) {
        SeriesFactory seriesFactory = new SeriesFactory();
        XSSFWorkbook workbook = new XSSFWorkbook();
        StdAggrDataSheet1DBuilder.DataSheet1DRef dataSheetRef = StdAggrDataSheet1DBuilder.buildSheet(workbook, chartDef, response, animationFrameIdx);
        DiscretePalette palette = PaletteFactory.buildIndexedPalette(chartDef.colorOptions.colorPalette);
        XSSFSheet chartSheet = workbook.createSheet("Chart");
        XSSFChart poiChart = ChartUtils.createChart(chartSheet);
        ChartUtils.setChartTitle(poiChart, dataSheetRef.getTitleSource());
        AxisFactory axisFactory = new AxisFactory(poiChart);
        XDDFValueAxis leftAxis = axisFactory.buildValueAxis(AxisPosition.LEFT);
        leftAxis.setCrossBetween(AxisCrossBetween.BETWEEN);
        if (chartDef.xAxisFormatting.isLogScale) {
            leftAxis.setLogBase(10.0);
        }
        XDDFCategoryAxis bottomAxis = axisFactory.buildCategoryAxis(AxisPosition.BOTTOM);
        ChartUtils.crossAxes((XDDFChartAxis)leftAxis, (XDDFChartAxis)bottomAxis);
        BaseChart chart = switch (chartDef.type) {
            case ChartType.stacked_columns -> {
                BarChart barChart1D = new BarChart();
                switch (chartDef.variant) {
                    case normal: {
                        barChart1D.setGrouping(STBarGrouping.STACKED);
                        break;
                    }
                    case stacked_100: {
                        barChart1D.setGrouping(STBarGrouping.PERCENT_STACKED);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperation("Excel chart export is not possible when the variant is " + String.valueOf((Object)chartDef.variant));
                    }
                }
                yield barChart1D;
            }
            case ChartType.stacked_area -> {
                AreaChart areaChart1D = new AreaChart();
                switch (chartDef.variant) {
                    case stacked_100: {
                        areaChart1D.setGrouping(STGrouping.PERCENT_STACKED);
                        break;
                    }
                    case normal: {
                        areaChart1D.setGrouping(STGrouping.STACKED);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperation("Excel chart export is not possible when the variant is " + String.valueOf((Object)chartDef.variant));
                    }
                }
                yield areaChart1D;
            }
            default -> throw new RuntimeException("Unreachable");
        };
        for (int i = 0; i < chartDef.genericMeasures.size(); ++i) {
            Series1D series = seriesFactory.build1D(dataSheetRef.getAggregationTitleSource(i), dataSheetRef.getAggregationSource(i), dataSheetRef.getAxisSource());
            series.setColor(palette.apply(i));
            series.setSmoothed(chartDef.smoothing);
            chart.addSeries(series);
        }
        XDDFChartLegend legend = poiChart.getOrAddLegend();
        legend.setPosition(LegendPosition.RIGHT);
        ChartUtils.setOverlay(legend, false);
        chart.plot((XDDFChart)poiChart, new XDDFChartAxis[]{bottomAxis, leftAxis});
        workbook.setSheetOrder("Chart", 0);
        workbook.setActiveSheet(0);
        return workbook;
    }
}

