/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginsLoadService;
import com.dataiku.dip.plugins.RegularPluginsRegistryService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.InstalledPluginState;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PluginRequirementService {
    private static Logger logger = Logger.getLogger((String)"dku.plugins.requirements");

    public RequirementsFile getRequirementsSpec(File folder, List<InstalledPluginDesc.ComponentLoadingFailure> loadingFailures) throws IOException {
        File requirementsFile = new File(folder, "requirements.json");
        if (requirementsFile.exists() && requirementsFile.isFile()) {
            try {
                return (RequirementsFile)JSON.parseFile((File)requirementsFile, RequirementsFile.class);
            }
            catch (JsonParseException e) {
                loadingFailures.add(new InstalledPluginDesc.ComponentLoadingFailure("requirements.json", "/", e.getMessage()));
            }
        }
        return null;
    }

    public CodeEnvModel.AbstractPluginEnvDesc getCodeEnvDesc(File folder, List<InstalledPluginDesc.ComponentLoadingFailure> loadingFailures) throws IOException {
        File codeEnvDir = new File(folder, "code-env");
        if (codeEnvDir.exists() && codeEnvDir.isDirectory()) {
            File descFile;
            File pythonEnvDir = new File(codeEnvDir, CodeEnvModel.EnvLang.PYTHON.getFolderName());
            File rEnvDir = new File(codeEnvDir, CodeEnvModel.EnvLang.R.getFolderName());
            if (pythonEnvDir.exists() && pythonEnvDir.isDirectory()) {
                File descFile2 = new File(pythonEnvDir, "desc.json");
                if (descFile2.exists() && descFile2.isFile()) {
                    try {
                        return (CodeEnvModel.AbstractPluginEnvDesc)JSON.parseFile((File)descFile2, CodeEnvModel.PythonPluginEnvDesc.class);
                    }
                    catch (JsonParseException e) {
                        loadingFailures.add(new InstalledPluginDesc.ComponentLoadingFailure("desc.json", "/code-env/python/", e.getMessage()));
                    }
                }
            } else if (rEnvDir.exists() && rEnvDir.isDirectory() && (descFile = new File(rEnvDir, "desc.json")).exists() && descFile.isFile()) {
                try {
                    return (CodeEnvModel.AbstractPluginEnvDesc)JSON.parseFile((File)descFile, CodeEnvModel.RPluginEnvDesc.class);
                }
                catch (JsonParseException e) {
                    loadingFailures.add(new InstalledPluginDesc.ComponentLoadingFailure("desc.json", "/code-env/r/", e.getMessage()));
                }
            }
        }
        return null;
    }

    public CodeEnvModel.EnvLang getCodeEnvLang(File folder) {
        File codeEnvDir = new File(folder, "code-env");
        if (codeEnvDir.exists() && codeEnvDir.isDirectory()) {
            File descFile;
            File pythonEnvDir = new File(codeEnvDir, CodeEnvModel.EnvLang.PYTHON.getFolderName());
            File rEnvDir = new File(codeEnvDir, CodeEnvModel.EnvLang.R.getFolderName());
            if (pythonEnvDir.exists() && pythonEnvDir.isDirectory()) {
                File descFile2 = new File(pythonEnvDir, "desc.json");
                if (descFile2.exists() && descFile2.isFile()) {
                    return CodeEnvModel.EnvLang.PYTHON;
                }
            } else if (rEnvDir.exists() && rEnvDir.isDirectory() && (descFile = new File(rEnvDir, "desc.json")).exists() && descFile.isFile()) {
                return CodeEnvModel.EnvLang.R;
            }
        }
        return null;
    }

    private List<String> buildPackagesSpecs(List<Dependency> dependencies, DependencySystem system, boolean forCommandLine) {
        ArrayList packageSpecs = Lists.newArrayList();
        for (Dependency dependency : dependencies) {
            if (dependency == null) {
                logger.warn((Object)("Invalid package in plugin requirements for dependency system : " + system.name()));
                continue;
            }
            String packageName = dependency.name;
            String versionSpec = dependency.version;
            if (system == DependencySystem.R) {
                packageSpecs.add(packageName);
                continue;
            }
            if (versionSpec == null || versionSpec.trim().length() == 0) {
                packageSpecs.add(packageName);
                continue;
            }
            if (forCommandLine) {
                packageSpecs.add("'" + packageName + versionSpec + "'");
                continue;
            }
            packageSpecs.add(packageName + versionSpec);
        }
        return packageSpecs;
    }

    private String buildPackagesInstallCommand(List<Dependency> dependencies, DependencySystem system) {
        List<String> packageSpecs = this.buildPackagesSpecs(dependencies, system, true);
        if (system == DependencySystem.PYTHON) {
            ArrayList args = Lists.newArrayList();
            args.addAll(this.getPipCmd());
            args.add("install");
            args.addAll(packageSpecs);
            return Joiner.on((String)" ").join((Iterable)args);
        }
        if (system == DependencySystem.R) {
            return "R\n> install.packages(c(\"" + Joiner.on((String)"\",\"").join(packageSpecs) + "\"))";
        }
        throw new Error();
    }

    private String getScriptCommand(String command, String script) {
        if (StringUtils.isNotBlank((String)command)) {
            return command;
        }
        if (script.endsWith(".py")) {
            return System.getenv("DIP_HOME") + "/bin/python";
        }
        return "sh";
    }

    public FrontendRequirements resolveRequirements(String pluginId, RequirementsFile requirementsSpec, CodeEnvModel.EnvLang codeEnvLang, InstalledPluginState pluginState, InstalledPluginDesc.PluginOrigin origin) throws Exception {
        FrontendRequirements requirements = new FrontendRequirements();
        if (requirementsSpec != null && StringUtils.isNotBlank((String)requirementsSpec.installScript)) {
            requirements.customPackages = requirementsSpec.custom != null ? requirementsSpec.custom : Lists.newArrayList();
            File pluginDir = RegularPluginsRegistryService.getPluginFolder(origin, pluginId);
            File script = new File(pluginDir, requirementsSpec.installScript);
            requirements.installScriptCommand = this.getScriptCommand(requirementsSpec.scriptCommand, requirementsSpec.installScript) + " " + script.getCanonicalPath();
            requirements.disclaimer = requirementsSpec.disclaimer;
        }
        if (codeEnvLang != null) {
            requirements.codeEnvLanguage = codeEnvLang;
            return requirements;
        }
        if (requirementsSpec == null) {
            return requirements;
        }
        if (requirementsSpec.python != null && requirementsSpec.python.size() > 0) {
            requirements.pythonPackages = requirementsSpec.python;
            requirements.pythonInstallCommand = this.buildPackagesInstallCommand(requirementsSpec.python, DependencySystem.PYTHON);
        }
        if (requirementsSpec.R != null && requirementsSpec.R.size() > 0) {
            requirements.rPackages = requirementsSpec.R;
            requirements.rInstallCommand = this.buildPackagesInstallCommand(requirementsSpec.R, DependencySystem.R);
        }
        requirements.manualProcedure = requirementsSpec.manualProcedure;
        for (InstalledPluginState.PluginActionRecord action : pluginState.actions) {
            if (action.action == InstalledPluginState.PluginActionType.INSTALLED_DEPS_PYTHON) {
                requirements.pythonInstalled = true;
            }
            if (action.action == InstalledPluginState.PluginActionType.INSTALLED_DEPS_R) {
                requirements.rInstalled = true;
            }
            if (action.action != InstalledPluginState.PluginActionType.INSTALLED_DEPS_CUSTOM) continue;
            requirements.customInstalled = true;
        }
        requirements.hasDependencies = requirements.pythonPackages.size() > 0 || requirements.rPackages.size() > 0 || requirements.installScriptCommand != null || requirements.manualProcedure != null;
        return requirements;
    }

    private List<String> getRCmd() {
        String rBin = System.getenv("DKURBIN");
        if (rBin == null) {
            throw new Error("environment variable DKURBIN not defined");
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(new File(rBin).getAbsolutePath());
        cmd.add("--no-save");
        return cmd;
    }

    private List<String> getPipCmd() {
        return Lists.newArrayList((Object[])new String[]{System.getenv("DIP_HOME") + "/bin/pip"});
    }

    public static FuturePayload buildFuturePayload(DependencySystem type, InstalledPluginDesc installedDesc) {
        FuturePayload fp = new FuturePayload();
        fp.action = "plugin_requirements";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(type.name(), installedDesc.desc.id, installedDesc.desc.meta.label, "PLUGIN").withPart("dependencies"));
        fp.displayName = "Install " + String.valueOf((Object)type) + " dependencies of " + installedDesc.desc.meta.label;
        return fp;
    }

    public FutureResponse<RequirementInstallationResult> installRequirements(InstalledPluginDesc installedDesc, DependencySystem type, AuthCtx authCtx) throws Exception {
        RequirementInstallationThread ft;
        if (type == DependencySystem.PYTHON) {
            ft = new RequirementInstallationThread((DSSAuthCtx)authCtx, installedDesc, type);
        } else if (type == DependencySystem.R) {
            ft = new RequirementInstallationThread((DSSAuthCtx)authCtx, installedDesc, type);
        } else if (type == DependencySystem.CUSTOM_SCRIPT) {
            ft = new RequirementInstallationThread((DSSAuthCtx)authCtx, installedDesc, type);
        } else {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_INVALID_DEFINITION, "The dependencies of type " + String.valueOf((Object)type) + " cannot be installed automatically");
        }
        FutureService futureService = (FutureService)((Object)SpringUtils.getBean(FutureService.class));
        return futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<RequirementInstallationResult>>(){});
    }

    public static class RequirementsFile {
        public List<Dependency> python = Lists.newArrayList();
        public List<Dependency> R = Lists.newArrayList();
        public List<Dependency> custom = Lists.newArrayList();
        public String installScript;
        public String scriptCommand;
        public String disclaimer;
        public String manualProcedure;
    }

    public static class Dependency {
        public String name;
        public String version;

        public Dependency() {
        }

        public Dependency(String name, String version) {
            this.name = name;
            this.version = version;
        }
    }

    public static enum DependencySystem {
        PYTHON,
        R,
        CUSTOM_SCRIPT;

    }

    public static class FrontendRequirements {
        public CodeEnvModel.EnvLang codeEnvLanguage;
        public boolean hasDependencies;
        public List<Dependency> rPackages = Lists.newArrayList();
        public String rInstallCommand;
        public boolean rInstalled;
        public List<Dependency> pythonPackages = Lists.newArrayList();
        public String pythonInstallCommand;
        public boolean pythonInstalled;
        public List<Dependency> customPackages = Lists.newArrayList();
        public String installScriptCommand;
        public String disclaimer;
        public boolean customInstalled;
        public String manualProcedure;
    }

    private class RequirementInstallationThread
    extends FutureThread<RequirementInstallationResult> {
        private final RequirementInstallationResult result;
        private final DependencySystem type;
        private final InstalledPluginDesc installedDesc;
        private final FuturePayload futurePayload;
        private final DKUtils.SmartLogTailBuilder logTailBuilder;

        public RequirementInstallationThread(DSSAuthCtx user, InstalledPluginDesc installedDesc, DependencySystem type) {
            super(user);
            this.result = new RequirementInstallationResult();
            this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            this.installedDesc = installedDesc;
            this.type = type;
            this.futurePayload = PluginRequirementService.buildFuturePayload(type, installedDesc);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public RequirementInstallationResult getResult() {
            return this.result;
        }

        public SmartLogTail getLog() {
            return this.logTailBuilder.get();
        }

        public void execute() throws Exception {
            try {
                File pluginDir = RegularPluginsRegistryService.getPluginFolder(this.installedDesc.origin, this.installedDesc.desc.id);
                InstalledPluginState.PluginActionRecord action = new InstalledPluginState.PluginActionRecord();
                action.user = this.getOwner().getIdentifier();
                if (this.type == DependencySystem.PYTHON) {
                    List<String> packageSpecs = PluginRequirementService.this.buildPackagesSpecs(this.installedDesc.requirementsSpec.python, DependencySystem.PYTHON, false);
                    ArrayList args = Lists.newArrayList();
                    args.addAll(PluginRequirementService.this.getPipCmd());
                    args.add("install");
                    args.addAll(packageSpecs);
                    this.runInstallCommand(null, pluginDir, args.toArray(new String[0]));
                    action.action = InstalledPluginState.PluginActionType.INSTALLED_DEPS_PYTHON;
                    this.installedDesc.frontendRequirements.pythonInstalled = this.result.success;
                } else if (this.type == DependencySystem.R) {
                    List<String> packageSpecs = PluginRequirementService.this.buildPackagesSpecs(this.installedDesc.requirementsSpec.R, DependencySystem.R, false);
                    String rScript = "install.packages(c(\"" + Joiner.on((String)"\",\"").join(packageSpecs) + "\"), repos=\"http://cran.us.r-project.org\")";
                    this.runInstallCommand(rScript, pluginDir, PluginRequirementService.this.getRCmd().toArray(new String[0]));
                    action.action = InstalledPluginState.PluginActionType.INSTALLED_DEPS_R;
                    this.installedDesc.frontendRequirements.rInstalled = this.result.success;
                } else if (this.type == DependencySystem.CUSTOM_SCRIPT) {
                    File script = new File(pluginDir, this.installedDesc.requirementsSpec.installScript);
                    String command = PluginRequirementService.this.getScriptCommand(this.installedDesc.requirementsSpec.scriptCommand, this.installedDesc.requirementsSpec.installScript);
                    this.runInstallCommand(null, pluginDir, command, script.getCanonicalPath());
                    action.action = InstalledPluginState.PluginActionType.INSTALLED_DEPS_CUSTOM;
                    this.installedDesc.frontendRequirements.customInstalled = this.result.success;
                }
                if (this.result.success) {
                    action.ts = DateTime.now().getMillis();
                    PluginsLoadService.addPluginAction(this.installedDesc, action);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to run the installation script", (Throwable)ex);
                this.result.exception = new SerializedError((Throwable)ex, true);
            }
        }

        private void runInstallCommand(String input, File pluginDir, String ... args) throws IOException, InterruptedException, Exception {
            DKUtils.ExecBuilder execBuilder = new DKUtils.ExecBuilder().withArgs(args).withCwd(pluginDir).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.logTailBuilder)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.logTailBuilder));
            final DKUtils.ExecKiller killer = execBuilder.makeNiceThenEvilKiller();
            try (FutureAborter.AutoCloseableAbortHook abort = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    killer.kill();
                }
            });){
                this.result.success = execBuilder.exec() == 0;
            }
        }
    }

    public static class RequirementInstallationResult {
        public boolean success;
        public SerializedError exception;
    }
}

