/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins;

import com.dataiku.dip.containers.exec.BaseImageBuilder;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.cde.CDEImageBuilderService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginConfigUtils;
import com.dataiku.dip.plugins.model.AppTemplateSettings;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.ParameterSetSettings;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.plugins.presets.LoadedParameterSet;
import com.dataiku.dip.plugins.presets.PluginParameterSetsService;
import com.dataiku.dip.plugins.presets.PluginPreset;
import com.dataiku.dip.projects.apps.CustomAppTemplatesService;
import com.dataiku.dip.projects.apps.LoadedCustomAppTemplate;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PluginSettingsAccessService {
    @Autowired
    private IPluginsRegistryService pluginsRegistryService;
    @Autowired
    private PluginParameterSetsService pluginParameterSetsService;
    @Autowired
    private CustomAppTemplatesService appTemplatesService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private CDEImageBuilderService cdeImageBuilderService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.plugins");

    static PluginSettingsAccessService forTests(IPluginsRegistryService pluginsRegistryService, PermissionsService permissionsService, PluginParameterSetsService pluginPresetsService) {
        PluginSettingsAccessService ret = new PluginSettingsAccessService();
        ret.permissionsService = permissionsService;
        ret.pluginsRegistryService = pluginsRegistryService;
        ret.pluginParameterSetsService = pluginPresetsService;
        return ret;
    }

    public PluginUISettings get(AuthCtx authCtx, String pluginId, String projectKey) throws IOException, DKUSecurityException {
        LoadedParameterSet parameterSetDesc;
        Object appTemplate;
        boolean found;
        boolean canAdminProject;
        boolean canAdminPlugin = this.permissionsService.hasPluginPrivilege(authCtx, pluginId, Privileges.PluginLevelPrivilegeType.ADMIN);
        boolean bl = canAdminProject = StringUtils.isNotBlank((String)projectKey) && this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        if (StringUtils.isNotBlank((String)projectKey)) {
            if (!canAdminProject) {
                throw new DKUSecurityException("Cannot retrieve project-level settings for plugin");
            }
        } else if (!canAdminPlugin) {
            throw new DKUSecurityException("Cannot retrieve settings for plugin");
        }
        InstalledPluginDesc pluginDesc = this.pluginsRegistryService.getInstalledDesc(pluginId);
        PluginSettings settings = StringUtils.isBlank((String)projectKey) ? this.pluginsRegistryService.getSettings(pluginId) : this.pluginsRegistryService.getProjectSettings(pluginId, projectKey);
        for (LoadedParameterSet parameterSetDesc2 : this.pluginParameterSetsService.listDescs(pluginId)) {
            found = false;
            for (ParameterSetSettings parameterSetSettings : settings.parameterSets) {
                if (!StringUtils.equals((String)parameterSetSettings.name, (String)parameterSetDesc2.id)) continue;
                found = true;
                break;
            }
            if (found) continue;
            ParameterSetSettings parameterSet = new ParameterSetSettings();
            parameterSet.name = parameterSetDesc2.id;
            parameterSet.defaultPermission = new ParameterSetSettings.PermissionItem();
            parameterSet.permissions = Lists.newArrayList();
            parameterSet.defaultPermission.definableInline = parameterSetDesc2.desc.defaultDefinableInline;
            parameterSet.defaultPermission.definableAtProjectLevel = parameterSetDesc2.desc.defaultDefinableAtProjectLevel;
            settings.parameterSets.add(parameterSet);
        }
        for (LoadedCustomAppTemplate appTemplateDesc : this.appTemplatesService.listDescs(pluginId)) {
            found = false;
            for (AppTemplateSettings appTemplateSettings : settings.appTemplates) {
                if (!StringUtils.equals((String)appTemplateSettings.name, (String)appTemplateDesc.id)) continue;
                found = true;
                break;
            }
            if (found) continue;
            appTemplate = new AppTemplateSettings();
            ((AppTemplateSettings)appTemplate).name = appTemplateDesc.id;
            settings.appTemplates.add((AppTemplateSettings)appTemplate);
        }
        PluginUISettings uiSettings = new PluginUISettings();
        if (canAdminPlugin && StringUtils.isBlank((String)projectKey)) {
            uiSettings.codeEnvName = settings.codeEnvName;
            uiSettings.excludedFromCDE = settings.excludedFromCDE;
            uiSettings.config = settings.config;
            uiSettings.defaultPermission = settings.defaultPermission;
            uiSettings.permissions = settings.permissions;
            for (ParameterSetSettings parameterSetSettings : settings.parameterSets) {
                parameterSetDesc = (LoadedParameterSet)this.pluginParameterSetsService.getOrNull(pluginId, parameterSetSettings.name);
                if (parameterSetDesc == null) {
                    logger.warn((Object)("Parameter set  of unregistered type " + parameterSetSettings.name));
                    continue;
                }
                ParameterSetUISettings uiParameterSet = new ParameterSetUISettings();
                uiParameterSet.name = parameterSetSettings.name;
                uiParameterSet.type = this.pluginParameterSetsService.makeType(pluginId, parameterSetSettings.name);
                uiParameterSet.defaultPermission = parameterSetSettings.defaultPermission;
                uiParameterSet.permissions = parameterSetSettings.permissions;
                uiSettings.parameterSets.add(uiParameterSet);
            }
            for (AppTemplateSettings appTemplateSettings : settings.appTemplates) {
                appTemplate = (LoadedCustomAppTemplate)this.appTemplatesService.getOrNull(pluginId, appTemplateSettings.name);
                if (appTemplate == null) {
                    logger.warn((Object)("App template  of unregistered type " + appTemplateSettings.name));
                    continue;
                }
                AppTemplateUISettings uiAppTemplate = new AppTemplateUISettings();
                uiAppTemplate.name = appTemplateSettings.name;
                uiAppTemplate.type = this.appTemplatesService.makeType(pluginId, appTemplateSettings.name);
                uiAppTemplate.remapping = appTemplateSettings.remapping;
                uiSettings.appTemplates.add(uiAppTemplate);
            }
        } else {
            uiSettings.detailsNotVisible = true;
        }
        for (PluginPreset preset : settings.presets) {
            parameterSetDesc = (LoadedParameterSet)this.pluginParameterSetsService.getOrNull(preset.type);
            if (parameterSetDesc == null) {
                logger.warn((Object)("Preset " + preset.name + " of unregistered type " + preset.type));
                continue;
            }
            PluginUIPreset uiPreset = new PluginUIPreset();
            uiPreset.name = preset.name;
            uiPreset.type = preset.type;
            uiPreset.owner = preset.owner;
            uiPreset.description = preset.description;
            uiPreset.defaultPermission = preset.defaultPermission;
            uiPreset.permissions = preset.permissions;
            uiPreset.pluginConfig = preset.pluginConfig;
            uiPreset.config = preset.config;
            uiSettings.presets.add(uiPreset);
        }
        for (LoadedParameterSet parameterSetDesc3 : pluginDesc.customParameterSets) {
            if (StringUtils.isNotBlank((String)projectKey)) {
                if (!this.permissionsService.hasPluginParameterSetPrivilege(authCtx, pluginId, parameterSetDesc3.id, Privileges.PluginParameterSetLevelPrivilegeType.OVERRIDE)) continue;
                uiSettings.accessibleParameterSetDescs.add(parameterSetDesc3);
                continue;
            }
            uiSettings.accessibleParameterSetDescs.add(parameterSetDesc3);
        }
        return uiSettings;
    }

    public PluginSettingsSaveResult save(AuthCtx authCtx, String pluginId, String projectKey, PluginUISettings data) throws IOException, DKUSecurityException, InterruptedException {
        LoadedParameterSet parameterSetDesc;
        boolean canAdminProject;
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        HashSet<PluginSettingsSavePostAction> postActions = new HashSet<PluginSettingsSavePostAction>();
        for (PluginUIPreset pluginUIPreset : data.presets) {
            for (LoadedParameterSet accessibleParameterSetDesc : data.accessibleParameterSetDescs) {
                if (!pluginUIPreset.type.equals(accessibleParameterSetDesc.getType()) || accessibleParameterSetDesc.desc == null) continue;
                pluginUIPreset.pluginConfig = PluginConfigUtils.encryptParameters(pluginUIPreset.pluginConfig, accessibleParameterSetDesc.desc.pluginParams);
                pluginUIPreset.config = PluginConfigUtils.encryptParameters(pluginUIPreset.config, accessibleParameterSetDesc.desc.params);
            }
        }
        logger.info((Object)("Save plugin settings for user " + authCtx.toString() + " in project " + projectKey + " : " + JSON.log((Object)data)));
        if (data.detailsNotVisible) {
            data.defaultPermission = null;
            data.permissions = null;
            data.config = null;
            data.parameterSets = null;
        }
        HashSet presetNames = Sets.newHashSet();
        for (PluginUIPreset preset : data.presets) {
            if (StringUtils.isBlank((String)preset.name)) {
                throw new IllegalArgumentException("Preset name not set");
            }
            if (presetNames.contains(preset.type + "." + preset.name)) {
                throw new IllegalArgumentException("Preset names are not unique");
            }
            presetNames.add(preset.type + "." + preset.name);
        }
        boolean bl = this.permissionsService.hasPluginPrivilege(authCtx, pluginId, Privileges.PluginLevelPrivilegeType.ADMIN);
        boolean bl2 = canAdminProject = StringUtils.isNotBlank((String)projectKey) && this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        if (StringUtils.isNotBlank((String)projectKey)) {
            if (!canAdminProject) {
                throw new DKUSecurityException("Cannot set project-level settings for plugin");
            }
        } else if (!bl) {
            throw new DKUSecurityException("Cannot set settings for plugin");
        }
        logger.info((Object)("User " + authCtx.toString() + " has rights canAdminPlugin=" + bl + " canAdminProject=" + canAdminProject));
        PluginSettings oldSettings = StringUtils.isBlank((String)projectKey) ? this.pluginsRegistryService.getSettings(pluginId) : this.pluginsRegistryService.getProjectSettings(pluginId, projectKey);
        PluginSettings newSettings = (PluginSettings)JSON.deepCopy((Object)oldSettings);
        if (bl && StringUtils.isBlank((String)projectKey)) {
            newSettings.config = data.config;
            newSettings.codeEnvName = data.codeEnvName;
            newSettings.excludedFromCDE = data.excludedFromCDE;
            if (!StringUtils.equals((String)oldSettings.codeEnvName, (String)data.codeEnvName) && this.cdeImageBuilderService.shouldRebuildCDEOnPluginCodeEnvChange(pluginId)) {
                postActions.add(PluginSettingsSavePostAction.REBUILD_CDE_IMAGE);
            }
            ArrayList pluginRights = Lists.newArrayList();
            pluginRights.add(new PermissionItemRightAccessor<PluginSettings.PermissionItem>(PluginSettings.PermissionItem.class, "admin", bl));
            pluginRights.add(new PermissionItemRightAccessor<PluginSettings.PermissionItem>(PluginSettings.PermissionItem.class, "canViewComponents", bl));
            PermissionItemUpdater<PluginSettings.PermissionItem> pluginPermissionsUpdater = new PermissionItemUpdater<PluginSettings.PermissionItem>((List)pluginRights){

                @Override
                public String getGroup(PluginSettings.PermissionItem perm) {
                    return perm.group;
                }

                @Override
                public boolean any(PluginSettings.PermissionItem perm) {
                    return perm.any();
                }
            };
            if (data.defaultPermission != null) {
                newSettings.defaultPermission = data.defaultPermission;
            }
            if (data.permissions != null) {
                newSettings.permissions = pluginPermissionsUpdater.update(data.permissions, oldSettings.permissions);
            }
            if (data.parameterSets != null) {
                newSettings.parameterSets = this.updateParameterSets(pluginId, messages, bl, oldSettings.parameterSets, data.parameterSets);
            }
            if (data.appTemplates != null) {
                newSettings.appTemplates = this.updateAppTemplates(pluginId, messages, bl, oldSettings.appTemplates, data.appTemplates);
            }
        } else {
            if (data.config != null && data.config.entrySet().size() > 0) {
                messages.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Modifying the plugin settings requires admin right on the plugin", new Object[0]);
            }
            if (StringUtils.isNotBlank((String)data.codeEnvName) && !StringUtils.equals((String)data.codeEnvName, (String)oldSettings.codeEnvName)) {
                messages.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Modifying the plugin's code env requires admin right on the plugin", new Object[0]);
            }
            if (data.defaultPermission != null && !JSON.jsonEquals((Object)data.defaultPermission, (Object)oldSettings.defaultPermission)) {
                messages.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Modifying the plugin's default permissions requires admin right on the plugin", new Object[0]);
            }
            if (data.permissions != null && !this.pluginPermissionsEquals(data.permissions, oldSettings.permissions)) {
                messages.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Modifying the plugin's permissions requires admin right on the plugin", new Object[0]);
            }
            if (data.parameterSets != null) {
                this.checkNoParameterSetChange(data.parameterSets, oldSettings.parameterSets, messages);
            }
            if (data.appTemplates != null) {
                this.checkNoAppTemplateChange(data.appTemplates, oldSettings.appTemplates, messages);
            }
        }
        CRUDSeparator<PluginUIPreset, PluginPreset> presetsCRUD = new CRUDSeparator<PluginUIPreset, PluginPreset>(data.presets, oldSettings.presets){

            @Override
            public String getNewItemKey(PluginUIPreset item) {
                return item.type + "." + item.name;
            }

            @Override
            public String getOldItemKey(PluginPreset item) {
                return item.type + "." + item.name;
            }
        };
        newSettings.presets = Lists.newArrayList();
        for (Pair updated : presetsCRUD.updated) {
            PluginPreset oldPreset = (PluginPreset)updated.first;
            PluginUIPreset newPreset = (PluginUIPreset)updated.second;
            if (!StringUtils.equals((String)oldPreset.type, (String)newPreset.type)) {
                messages.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Preset type of %s cannot be changed after creation (old=%s new=%s)", new Object[]{oldPreset.name, oldPreset.type, newPreset.type});
                continue;
            }
            LoadedParameterSet parameterSetDesc2 = (LoadedParameterSet)this.pluginParameterSetsService.getOrNull(oldPreset.type);
            if (parameterSetDesc2 == null) {
                messages.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Preset type of %s not registered : %s", new Object[]{oldPreset.name, oldPreset.type});
                continue;
            }
            boolean canAdminPreset = true;
            boolean isError = false;
            if (!bl && newPreset.pluginConfig != null && newPreset.pluginConfig.entrySet().size() > 0 && !JSON.jsonEquals((Object)newPreset.pluginConfig, (Object)oldPreset.pluginConfig)) {
                messages.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Modifying the plugin-level settings in preset %s requires admin right on the preset", new Object[]{oldPreset.name});
                isError = true;
            }
            if (isError) continue;
            PluginPreset preset = (PluginPreset)JSON.deepCopy((Object)oldPreset);
            if (bl) {
                preset.pluginConfig = newPreset.pluginConfig;
            }
            if (StringUtils.isNotBlank((String)newPreset.owner)) {
                preset.owner = newPreset.owner;
            }
            preset.description = newPreset.description;
            preset.config = newPreset.config;
            ArrayList presetRights = Lists.newArrayList();
            presetRights.add(new PermissionItemRightAccessor<PluginPreset.PermissionItem>(PluginPreset.PermissionItem.class, "use", canAdminPreset));
            PermissionItemUpdater<PluginPreset.PermissionItem> presetPermissionsUpdater = new PermissionItemUpdater<PluginPreset.PermissionItem>((List)presetRights){

                @Override
                public String getGroup(PluginPreset.PermissionItem perm) {
                    return perm.group;
                }

                @Override
                public boolean any(PluginPreset.PermissionItem perm) {
                    return perm.any();
                }
            };
            if (newPreset.defaultPermission != null) {
                preset.defaultPermission.use = newPreset.defaultPermission.use;
            }
            if (newPreset.permissions != null) {
                preset.permissions = presetPermissionsUpdater.update(newPreset.permissions, oldPreset.permissions);
            }
            newSettings.presets.add(preset);
        }
        for (PluginUIPreset created : presetsCRUD.created) {
            parameterSetDesc = (LoadedParameterSet)this.pluginParameterSetsService.getOrNull(created.type);
            if (parameterSetDesc == null) {
                messages.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Preset type of %s not registered : %s", new Object[]{created.name, created.type});
                continue;
            }
            if (StringUtils.isNotBlank((String)projectKey) && !this.permissionsService.hasPluginParameterSetPrivilege(authCtx, pluginId, parameterSetDesc.id, Privileges.PluginParameterSetLevelPrivilegeType.OVERRIDE)) {
                messages.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Preset type of %s cannot be defined at the project level : %s", new Object[]{created.type, created.name});
                continue;
            }
            if (!bl && created.pluginConfig != null && created.pluginConfig.entrySet().size() > 0) {
                messages.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Creating the plugin-level settings in preset %s requires admin right on the preset", new Object[]{created.name});
                continue;
            }
            PluginPreset preset = (PluginPreset)JSON.parse((String)JSON.json((Object)created), PluginPreset.class);
            preset.owner = StringUtils.isNotBlank((String)created.owner) ? created.owner : authCtx.getAssociatedDSSUser();
            newSettings.presets.add(preset);
        }
        for (PluginPreset deleted : presetsCRUD.deleted) {
            parameterSetDesc = (LoadedParameterSet)this.pluginParameterSetsService.getOrNull(deleted.type);
            if (parameterSetDesc != null) continue;
            logger.warnV("Unable to find parameter set %s for deleted preset %s, it was likely already deleted from the plugin, but not yet from settings.json", new Object[]{deleted.type, deleted.name});
        }
        Collections.sort(newSettings.presets, new Comparator<PluginPreset>(){

            @Override
            public int compare(PluginPreset a, PluginPreset b) {
                return a.name.compareTo(b.name);
            }
        });
        messages.summarize();
        if (messages.anyFatal()) {
            logger.info((Object)"Found errors wile preparing updated settings, not saving");
        } else if (StringUtils.isBlank((String)projectKey)) {
            this.pluginsRegistryService.setSettings(pluginId, newSettings);
        } else {
            this.pluginsRegistryService.setProjectSettings(pluginId, projectKey, newSettings);
        }
        return new PluginSettingsSaveResult(messages, postActions);
    }

    public InfoMessage.InfoMessages handleSavePostActions(PluginSettingsSaveResult result, DKUtils.SmartLogTailBuilder logTailBuilder) throws InterruptedException, IOException {
        InfoMessage.InfoMessages messages = result.getMessages();
        for (PluginSettingsSavePostAction po : result.getPostActions()) {
            if (Objects.requireNonNull(po) == PluginSettingsSavePostAction.REBUILD_CDE_IMAGE) {
                BaseImageBuilder builder = new BaseImageBuilder(ContainerExecUtils.BaseImageType.CDE_PLUGINS, new BaseImageBuilder.BaseImageBuildOptions(), logTailBuilder, true, true);
                builder.build(messages);
                continue;
            }
            throw new RuntimeException("Unsupported PostAction: " + String.valueOf((Object)po));
        }
        return messages;
    }

    public SimpleFutureThread<InfoMessage.InfoMessages> getSavePostActionFuture(AuthCtx authCtx, final String pluginId, final PluginSettingsSaveResult result) {
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        return new SimpleFutureThread<InfoMessage.InfoMessages>(authCtx){

            @Override
            protected InfoMessage.InfoMessages compute() throws Exception {
                return PluginSettingsAccessService.this.handleSavePostActions(result, logTailBuilder);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"plugin_post_save_settings", (String)("Post save settings actions for plugin: " + pluginId));
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        };
    }

    private void checkNoParameterSetChange(List<ParameterSetUISettings> newSettings, List<ParameterSetSettings> oldSettings, InfoMessage.InfoMessages ret) {
        CRUDSeparator<ParameterSetUISettings, ParameterSetSettings> parameterSetsSettingsCRUD = new CRUDSeparator<ParameterSetUISettings, ParameterSetSettings>(newSettings, oldSettings){

            @Override
            public String getNewItemKey(ParameterSetUISettings item) {
                return item.name;
            }

            @Override
            public String getOldItemKey(ParameterSetSettings item) {
                return item.name;
            }
        };
        for (Pair updated : parameterSetsSettingsCRUD.updated) {
            ParameterSetSettings oldParameterSet = (ParameterSetSettings)updated.first;
            ParameterSetUISettings newParameterSet = (ParameterSetUISettings)updated.second;
            if (newParameterSet.defaultPermission != null && !JSON.jsonEquals((Object)newParameterSet.defaultPermission, (Object)oldParameterSet.defaultPermission)) {
                ret.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Modifying the parameter set's default permissions requires admin right on the plugin", new Object[0]);
            }
            if (newParameterSet.permissions == null || this.parameterSetPermissionsEquals(newParameterSet.permissions, oldParameterSet.permissions)) continue;
            ret.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Modifying the parameter set's permissions requires admin right on the plugin", new Object[0]);
        }
        for (ParameterSetUISettings created : parameterSetsSettingsCRUD.created) {
            ret.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Adding a parameter set's settings for %s requires admin right on the plugin", new Object[]{created.name});
        }
        for (ParameterSetSettings deleted : parameterSetsSettingsCRUD.deleted) {
            ret.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Removing a parameter set's settings for %s requires admin right on the plugin", new Object[]{deleted.name});
        }
    }

    private void checkNoAppTemplateChange(List<AppTemplateUISettings> newSettings, List<AppTemplateSettings> oldSettings, InfoMessage.InfoMessages ret) {
        CRUDSeparator<AppTemplateUISettings, AppTemplateSettings> appTemplatesSettingsCRUD = new CRUDSeparator<AppTemplateUISettings, AppTemplateSettings>(newSettings, oldSettings){

            @Override
            public String getNewItemKey(AppTemplateUISettings item) {
                return item.name;
            }

            @Override
            public String getOldItemKey(AppTemplateSettings item) {
                return item.name;
            }
        };
        for (Pair updated : appTemplatesSettingsCRUD.updated) {
            AppTemplateSettings oldAppTemplate = (AppTemplateSettings)updated.first;
            AppTemplateUISettings newAppTemplate = (AppTemplateUISettings)updated.second;
            if (newAppTemplate.remapping == null || JSON.jsonEquals((Object)newAppTemplate.remapping, (Object)oldAppTemplate.remapping)) continue;
            ret.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Modifying the app template's remapping requires admin right on the plugin", new Object[0]);
        }
        for (AppTemplateUISettings created : appTemplatesSettingsCRUD.created) {
            ret.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Adding an app template's settings for %s requires admin right on the plugin", new Object[]{created.name});
        }
        for (AppTemplateSettings deleted : appTemplatesSettingsCRUD.deleted) {
            ret.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_ALLOWED, "Removing an app template's settings for %s requires admin right on the plugin", new Object[]{deleted.name});
        }
    }

    private List<ParameterSetSettings> updateParameterSets(String pluginId, InfoMessage.InfoMessages ret, boolean canAdminPlugin, List<ParameterSetSettings> oldSettings, List<ParameterSetUISettings> newSettings) {
        LoadedParameterSet parameterSetDesc;
        CRUDSeparator<ParameterSetUISettings, ParameterSetSettings> parameterSetsSettingsCRUD = new CRUDSeparator<ParameterSetUISettings, ParameterSetSettings>(newSettings, oldSettings){

            @Override
            public String getNewItemKey(ParameterSetUISettings item) {
                return item.name;
            }

            @Override
            public String getOldItemKey(ParameterSetSettings item) {
                return item.name;
            }
        };
        ArrayList parameterSets = Lists.newArrayList();
        for (Pair updated : parameterSetsSettingsCRUD.updated) {
            ParameterSetSettings oldParameterSet = (ParameterSetSettings)updated.first;
            ParameterSetUISettings newParameterSet = (ParameterSetUISettings)updated.second;
            LoadedParameterSet parameterSetDesc2 = (LoadedParameterSet)this.pluginParameterSetsService.getOrNull(pluginId, oldParameterSet.name);
            if (parameterSetDesc2 == null) {
                ret.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Preset type of %s not registered", new Object[]{oldParameterSet.name});
                continue;
            }
            ParameterSetSettings parameterSet = (ParameterSetSettings)JSON.deepCopy((Object)oldParameterSet);
            parameterSet.name = newParameterSet.name;
            ArrayList presetRights = Lists.newArrayList();
            presetRights.add(new PermissionItemRightAccessor<ParameterSetSettings.PermissionItem>(ParameterSetSettings.PermissionItem.class, "definableAtProjectLevel", canAdminPlugin));
            presetRights.add(new PermissionItemRightAccessor<ParameterSetSettings.PermissionItem>(ParameterSetSettings.PermissionItem.class, "definableInline", canAdminPlugin));
            PermissionItemUpdater<ParameterSetSettings.PermissionItem> presetPermissionsUpdater = new PermissionItemUpdater<ParameterSetSettings.PermissionItem>((List)presetRights){

                @Override
                public String getGroup(ParameterSetSettings.PermissionItem perm) {
                    return perm.group;
                }

                @Override
                public boolean any(ParameterSetSettings.PermissionItem perm) {
                    return perm.any();
                }
            };
            if (newParameterSet.defaultPermission != null) {
                parameterSet.defaultPermission.definableAtProjectLevel = newParameterSet.defaultPermission.definableAtProjectLevel;
                parameterSet.defaultPermission.definableInline = newParameterSet.defaultPermission.definableInline;
            }
            if (newParameterSet.permissions != null) {
                parameterSet.permissions = presetPermissionsUpdater.update(newParameterSet.permissions, oldParameterSet.permissions);
            }
            parameterSets.add(parameterSet);
        }
        for (ParameterSetUISettings created : parameterSetsSettingsCRUD.created) {
            parameterSetDesc = (LoadedParameterSet)this.pluginParameterSetsService.getOrNull(pluginId, created.name);
            if (parameterSetDesc == null) {
                ret.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Preset type of %s not registered", new Object[]{created.name});
                continue;
            }
            ParameterSetSettings preset = (ParameterSetSettings)JSON.parse((String)JSON.json((Object)created), ParameterSetSettings.class);
            parameterSets.add(preset);
        }
        for (ParameterSetSettings deleted : parameterSetsSettingsCRUD.deleted) {
            parameterSetDesc = (LoadedParameterSet)this.pluginParameterSetsService.getOrNull(pluginId, deleted.name);
            if (parameterSetDesc != null) continue;
            logger.warnV("Unable to find deleted parameter set %s, it was likely already deleted from the plugin, but not yet from settings.json", new Object[]{deleted.name});
        }
        Collections.sort(parameterSets, new Comparator<ParameterSetSettings>(){

            @Override
            public int compare(ParameterSetSettings a, ParameterSetSettings b) {
                return a.name.compareTo(b.name);
            }
        });
        return parameterSets;
    }

    private List<AppTemplateSettings> updateAppTemplates(String pluginId, InfoMessage.InfoMessages ret, boolean canAdminPlugin, List<AppTemplateSettings> oldSettings, List<AppTemplateUISettings> newSettings) {
        LoadedCustomAppTemplate appTemplateDesc;
        CRUDSeparator<AppTemplateUISettings, AppTemplateSettings> appTemplatesSettingsCRUD = new CRUDSeparator<AppTemplateUISettings, AppTemplateSettings>(newSettings, oldSettings){

            @Override
            public String getNewItemKey(AppTemplateUISettings item) {
                return item.name;
            }

            @Override
            public String getOldItemKey(AppTemplateSettings item) {
                return item.name;
            }
        };
        ArrayList appTemplates = Lists.newArrayList();
        for (Pair updated : appTemplatesSettingsCRUD.updated) {
            AppTemplateSettings oldAppTemplate = (AppTemplateSettings)updated.first;
            AppTemplateUISettings newAppTemplate = (AppTemplateUISettings)updated.second;
            LoadedCustomAppTemplate appTemplateDesc2 = (LoadedCustomAppTemplate)this.appTemplatesService.getOrNull(pluginId, oldAppTemplate.name);
            if (appTemplateDesc2 == null) {
                ret.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "App template type of %s not registered", new Object[]{oldAppTemplate.name});
                continue;
            }
            AppTemplateSettings appTemplate = (AppTemplateSettings)JSON.deepCopy((Object)oldAppTemplate);
            appTemplate.name = newAppTemplate.name;
            appTemplate.remapping = newAppTemplate.remapping;
            appTemplates.add(appTemplate);
        }
        for (AppTemplateUISettings created : appTemplatesSettingsCRUD.created) {
            appTemplateDesc = (LoadedCustomAppTemplate)this.appTemplatesService.getOrNull(pluginId, created.name);
            if (appTemplateDesc == null) {
                ret.withFatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "App template type of %s not registered", new Object[]{created.name});
                continue;
            }
            AppTemplateSettings preset = (AppTemplateSettings)JSON.parse((String)JSON.json((Object)created), AppTemplateSettings.class);
            appTemplates.add(preset);
        }
        for (AppTemplateSettings deleted : appTemplatesSettingsCRUD.deleted) {
            appTemplateDesc = (LoadedCustomAppTemplate)this.appTemplatesService.getOrNull(pluginId, deleted.name);
            if (appTemplateDesc != null) continue;
            logger.warnV("Unable to find deleted app template %s, it was likely already deleted from the plugin, but not yet from settings.json", new Object[]{deleted.name});
        }
        Collections.sort(appTemplates, new Comparator<AppTemplateSettings>(){

            @Override
            public int compare(AppTemplateSettings a, AppTemplateSettings b) {
                return a.name.compareTo(b.name);
            }
        });
        return appTemplates;
    }

    private boolean pluginPermissionsEquals(List<PluginSettings.PermissionItem> a, List<PluginSettings.PermissionItem> b) {
        ArrayList sortedA = Lists.newArrayList(a);
        ArrayList sortedB = Lists.newArrayList(b);
        Comparator<PluginSettings.PermissionItem> compareByGroup = new Comparator<PluginSettings.PermissionItem>(){

            @Override
            public int compare(PluginSettings.PermissionItem x, PluginSettings.PermissionItem y) {
                return x.group.compareTo(y.group);
            }
        };
        Collections.sort(sortedA, compareByGroup);
        Collections.sort(sortedB, compareByGroup);
        return JSON.jsonEquals((Object)sortedA, (Object)sortedB);
    }

    private boolean parameterSetPermissionsEquals(List<ParameterSetSettings.PermissionItem> a, List<ParameterSetSettings.PermissionItem> b) {
        ArrayList sortedA = Lists.newArrayList(a);
        ArrayList sortedB = Lists.newArrayList(b);
        Comparator<ParameterSetSettings.PermissionItem> compareByGroup = new Comparator<ParameterSetSettings.PermissionItem>(){

            @Override
            public int compare(ParameterSetSettings.PermissionItem x, ParameterSetSettings.PermissionItem y) {
                return x.group.compareTo(y.group);
            }
        };
        Collections.sort(sortedA, compareByGroup);
        Collections.sort(sortedB, compareByGroup);
        return JSON.jsonEquals((Object)sortedA, (Object)sortedB);
    }

    public static class PluginUISettings {
        public boolean detailsNotVisible;
        public List<LoadedParameterSet> accessibleParameterSetDescs = Lists.newArrayList();
        public PluginSettings.PermissionItem defaultPermission;
        public List<PluginSettings.PermissionItem> permissions;
        public JsonObject config;
        public String codeEnvName;
        public boolean excludedFromCDE;
        public List<PluginUIPreset> presets = Lists.newArrayList();
        public List<ParameterSetUISettings> parameterSets = Lists.newArrayList();
        public List<AppTemplateUISettings> appTemplates = Lists.newArrayList();
    }

    public static class ParameterSetUISettings {
        public String name;
        public String type;
        public ParameterSetSettings.PermissionItem defaultPermission;
        public List<ParameterSetSettings.PermissionItem> permissions;
    }

    public static class AppTemplateUISettings {
        public String name;
        public String type;
        public ProjectRemappingSettings remapping = new ProjectRemappingSettings();
    }

    public static class PluginUIPreset {
        public String type;
        public String name;
        public String description;
        public String owner;
        public PluginPreset.PermissionItem defaultPermission;
        public List<PluginPreset.PermissionItem> permissions;
        public JsonObject pluginConfig;
        public JsonObject config;
    }

    public static enum PluginSettingsSavePostAction {
        REBUILD_CDE_IMAGE;

    }

    private static class PermissionItemRightAccessor<T>
    implements IPermissionItemRightAccessor<T> {
        private final Field field;
        private final boolean canChange;

        public PermissionItemRightAccessor(Class<? extends T> clazz, String fieldName, boolean canChange) {
            this.canChange = canChange;
            try {
                this.field = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new Error("Failed to create right accessor, class probably changed", e);
            }
        }

        @Override
        public boolean get(T perm) {
            try {
                return (Boolean)this.field.get(perm);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new Error("Failed to use right accessor, class probably changed", e);
            }
        }

        @Override
        public void set(T perm, boolean to) {
            try {
                this.field.set(perm, to);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new Error("Failed to use right accessor, class probably changed", e);
            }
        }

        @Override
        public boolean canChange() {
            return this.canChange;
        }
    }

    private static abstract class PermissionItemUpdater<T> {
        private final List<PermissionItemRightAccessor<T>> rights;

        public PermissionItemUpdater(List<PermissionItemRightAccessor<T>> rights) {
            this.rights = rights;
        }

        public abstract String getGroup(T var1);

        public abstract boolean any(T var1);

        public List<T> update(List<T> newPerms, List<T> oldPerms) {
            CRUDSeparator permsCRUD = new CRUDSeparator<T, T>(newPerms, oldPerms){

                @Override
                public String getNewItemKey(T item) {
                    return this.getGroup(item);
                }

                @Override
                public String getOldItemKey(T item) {
                    return this.getGroup(item);
                }
            };
            ArrayList perms = Lists.newArrayList();
            for (Object TNew : permsCRUD.created) {
                for (PermissionItemRightAccessor permissionItemRightAccessor : this.rights) {
                    permissionItemRightAccessor.set(TNew, permissionItemRightAccessor.get(TNew) && permissionItemRightAccessor.canChange());
                }
                perms.add(TNew);
            }
            for (Object object : permsCRUD.deleted) {
                for (PermissionItemRightAccessor<Object> permissionItemRightAccessor : this.rights) {
                    if (!permissionItemRightAccessor.canChange()) continue;
                    permissionItemRightAccessor.set(object, false);
                }
                if (!this.any(object)) continue;
                perms.add(object);
            }
            for (Pair pair : permsCRUD.updated) {
                Object oldPerm = pair.first;
                Object object = pair.second;
                for (PermissionItemRightAccessor<Object> permissionItemRightAccessor : this.rights) {
                    if (!permissionItemRightAccessor.canChange()) continue;
                    permissionItemRightAccessor.set(oldPerm, permissionItemRightAccessor.get(object));
                }
                perms.add(oldPerm);
            }
            Collections.sort(perms, new Comparator<T>(){

                @Override
                public int compare(T a, T b) {
                    return this.getGroup(a).compareTo(this.getGroup(b));
                }
            });
            return perms;
        }
    }

    private static abstract class CRUDSeparator<TNew, TOld> {
        public List<TNew> created = Lists.newArrayList();
        public List<Pair<TOld, TNew>> updated = Lists.newArrayList();
        public List<TOld> deleted = Lists.newArrayList();

        public abstract String getNewItemKey(TNew var1);

        public abstract String getOldItemKey(TOld var1);

        public CRUDSeparator(List<TNew> newItems, List<TOld> oldItems) {
            HashMap newItemsByKey = Maps.newHashMap();
            HashMap oldItemsByKey = Maps.newHashMap();
            for (Object item : newItems) {
                newItemsByKey.put(this.getNewItemKey(item), item);
            }
            for (Object item : oldItems) {
                oldItemsByKey.put(this.getOldItemKey(item), item);
            }
            for (String key : Sets.difference(newItemsByKey.keySet(), oldItemsByKey.keySet())) {
                this.created.add(newItemsByKey.get(key));
            }
            for (String key : Sets.difference(oldItemsByKey.keySet(), newItemsByKey.keySet())) {
                this.deleted.add(oldItemsByKey.get(key));
            }
            for (String key : Sets.intersection(oldItemsByKey.keySet(), newItemsByKey.keySet())) {
                this.updated.add(new Pair(oldItemsByKey.get(key), newItemsByKey.get(key)));
            }
        }
    }

    public static class PluginSettingsSaveResult {
        private final InfoMessage.InfoMessages messages;
        private final Set<PluginSettingsSavePostAction> postActions;

        private PluginSettingsSaveResult(InfoMessage.InfoMessages messages, Set<PluginSettingsSavePostAction> postActions) {
            this.messages = messages;
            this.postActions = postActions;
        }

        public Set<PluginSettingsSavePostAction> getPostActions() {
            return this.postActions;
        }

        public InfoMessage.InfoMessages getMessages() {
            return this.messages;
        }
    }

    private static interface IPermissionItemRightAccessor<T> {
        public boolean get(T var1);

        public void set(T var1, boolean var2);

        public boolean canChange();
    }
}

