/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sql;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.recipes.code.CodeBasedRecipeStatus;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryRecipeTester;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeTester;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SQLQueryRecipeStatusComputer
extends RecipeStatusComputer {
    @Autowired
    private TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sql.validation");

    public SQLQueryRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) {
        SQLQueryRecipeStatusRequest request = (SQLQueryRecipeStatusRequest)JSON.parse((String)requestData, SQLQueryRecipeStatusRequest.class);
        SQLQueryRecipeStatus ret = null;
        try {
            try (Transaction t = this.transactionService.beginRead();){
                ret = this.fastStatusIgnorePartitions(authCtx);
            }
            if (request != null) {
                AbstractSQLQueryRecipeTester.SQLQueryValidationResult res = (AbstractSQLQueryRecipeTester.SQLQueryValidationResult)this.createTester().startValidate_NT(this.recipe, this.payload, request.run, request.targetPartitionSpec, authCtx).call();
                ret.schemaResult = res.schemaResult;
                ret.substitutionVariables = res.substitutionVariables;
                if (StringUtils.isNotBlank((String)res.substitutedQuery) && !res.substitutedQuery.equals(this.payload)) {
                    ret.substitutedCode = res.substitutedQuery;
                }
                ret.topLevelMessages.mergeFrom(res.messages);
                ret.runResult = res.runResult;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to validate SQL recipe", (Throwable)e);
            InfoMessage err = InfoMessage.fatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, (String)("Failed to validate SQL recipe: " + ExceptionUtils.getMessageWithCauses((Throwable)e)), (Object[])new Object[0]);
            ret.topLevelMessages.addMessage(err);
        }
        return ret;
    }

    @VisibleForTesting
    protected SQLQueryRecipeTester createTester() {
        return new SQLQueryRecipeTester();
    }

    @Override
    public SQLQueryRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws IOException, DKUSecurityException {
        SQLQueryRecipeStatus ret = new SQLQueryRecipeStatus();
        this.performBasicStructureChecks(ret, authCtx);
        ret.addSingleEngine("SQL", "SQL", "IN_DB", "In Database", "In-database (SQL)");
        return ret;
    }

    public static class SQLQueryRecipeStatusRequest
    extends CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest {
        public boolean run;
    }

    public static class SQLQueryRecipeStatus
    extends CodeBasedRecipeStatus {
        public RecipeSchemaService.RecipeSchemaAutoupdateResult schemaResult;
        public QueryRunResult runResult;
    }
}

