/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.common;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.common.GenericRecipeCreator;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.services.PDepsFixuper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.WithMessages;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public abstract class MultipleOutputDatasetsRecipeCreator
extends GenericRecipeCreator {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.multiple.outputs.creator");

    public MultipleOutputDatasetsRecipeCreator(AuthCtx authCtx, RecipeMeta meta, boolean allowPreFilledParams) {
        super(authCtx, meta, allowPreFilledParams);
    }

    @Override
    public RecipeCreator.CreationResult create_NT(SerializedRecipe sr, JsonObject creationData) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)sr.getProjectKey()), (Object)"The recipe project key must be set");
        Preconditions.checkArgument((boolean)this.meta.getType().equals(sr.getType()), (Object)String.format("The recipe type must be '%s', got '%s'", this.meta.getType(), sr.getType()));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)sr.name), (Object)"The recipe name must be set");
        logger.info((Object)"Create recipe params and payload");
        RecipeParams recipeParams = this.makeInitialParams(sr, creationData);
        RecipeCreator.CreationResult createResult = new RecipeCreator.CreationResult();
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            logger.infoV("Save %s recipe", new Object[]{sr.getType()});
            sr.name = this.recipeSaveService.transmogrifyName(sr.getProjectKey(), sr.name);
            sr.params = recipeParams;
            MultipleOutputRecipeCreationSettings settings = (MultipleOutputRecipeCreationSettings)JSON.parse((JsonElement)creationData, MultipleOutputRecipeCreationSettings.class);
            String payload = this.makeInitialPayload(sr, creationData);
            HashMap<String, List<Dataset>> outputSerializedDatasetsByRole = new HashMap<String, List<Dataset>>();
            for (Map.Entry<String, Map<String, ManagedDatasetsCreationService.ManagedDatasetCreationSettings>> entry : settings.outputDatasetsCreationSettingsByRole.entrySet()) {
                String role = entry.getKey();
                outputSerializedDatasetsByRole.put(role, new ArrayList());
                for (Map.Entry<String, ManagedDatasetsCreationService.ManagedDatasetCreationSettings> outputDatasetCreationSettingsEntry : entry.getValue().entrySet()) {
                    String outputDatasetName = outputDatasetCreationSettingsEntry.getKey();
                    ManagedDatasetsCreationService.ManagedDatasetCreationSettings outputDatasetCreationSettings = outputDatasetCreationSettingsEntry.getValue();
                    Dataset outputDataset = this.mdcService.prepare(this.authCtx, sr.projectKey, outputDatasetName, outputDatasetCreationSettings);
                    SerializedDataset sd = outputDataset.serialize();
                    this.flowZonesService.attachObjectToZone(outputDatasetCreationSettings.zone, sd.getProjectKey(), sd);
                    logger.info((Object)("Creating dataset " + JSON.prettyLog((Object)sd)));
                    DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildFromRecipe(sr);
                    WithMessages<SerializedDataset> createdDataset = this.datasetSaveService.create(sr.projectKey, sd, dsCtx, this.authCtx);
                    createResult.messages.mergeFrom(createdDataset.messages);
                    ((List)outputSerializedDatasetsByRole.get(role)).add(Dataset.fromSerialized((SerializedDataset)createdDataset.value));
                }
            }
            this.setOutputSchemas_T(sr, payload, outputSerializedDatasetsByRole);
            for (Dataset outputDataset : outputSerializedDatasetsByRole.values().stream().flatMap(Collection::stream).toList()) {
                SerializedDataset sds = outputDataset.serialize();
                WithMessages<SerializedDataset> savedDataset = this.datasetSaveService.saveWithoutEvents(sr.projectKey, outputDataset.getName(), sds, this.authCtx);
                createResult.messages.mergeFrom(savedDataset.messages);
            }
            if (creationData.has("zone")) {
                this.assignZone(sr, creationData.get("zone").getAsString());
            } else {
                this.assignZone(sr, null);
            }
            new PDepsFixuper().fixupInPlace(sr);
            this.checkOutputOwnership_T(sr);
            SerializedRecipe savedSr = this.recipeSaveService.save(sr.getProjectKey(), sr, payload);
            InfoMessage.InfoMessages msg = this.saveOutputDatasetsSchema(savedSr, payload);
            createResult.messages.mergeFrom(msg);
            rwt.commitV("Created %s recipe: %s", new Object[]{sr.getType(), sr.getFullId()});
            createResult.withId(savedSr.name);
        }
        return createResult;
    }

    @Override
    public void assignZone(SerializedRecipe sr, String recipeZone) throws IOException {
        if (StringUtils.isBlank((String)recipeZone)) {
            recipeZone = this.flowZonesService.retrieveInputZone(sr);
            this.flowZonesService.attachObjectToZone(recipeZone, sr.projectKey, sr);
            for (SerializedRecipe.RecipeOutput output : sr.getFlatOutputs()) {
                DatasetLocUtils.DatasetLoc dsLoc = DatasetLocUtils.resolveSmart(sr.getProjectKey(), output.ref);
                SerializedDataset outputSds = this.datasetAccessService.getMandatoryUnsafe(dsLoc).getModel();
                String outputZone = this.flowZonesService.retrieveZone(sr.getProjectKey(), outputSds);
                if (outputZone != null && (Objects.equals(outputZone, recipeZone) || !Objects.equals(outputZone, Zone.DEFAULT_ZONE.getId()))) continue;
                this.flowZonesService.attachObjectToZone(recipeZone, sr.getProjectKey(), outputSds);
            }
        } else {
            this.flowZonesService.attachObjectToZone(recipeZone, sr.projectKey, sr);
        }
    }

    @Override
    public RecipeCreator.CreationResult copy_NT(String projectKey, SerializedRecipe.SerializedRecipeAndPayload source, JsonObject copyData) throws Exception {
        Preconditions.checkArgument((boolean)this.meta.getRecipeDesc().copiable, (Object)String.format("Recipe '%s' cannot be copied", this.meta.getType()));
        RecipeCreator.CreationResult createResult = new RecipeCreator.CreationResult();
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            SerializedRecipe.SerializedRecipeAndPayload copy = this.copyCore(projectKey, source.recipe, source.payload, copyData);
            SerializedRecipe sr = copy.recipe;
            new PDepsFixuper().fixupInPlace(sr);
            this.checkOutputOwnership_T(sr);
            SerializedRecipe savedSr = this.recipeSaveService.create(projectKey, sr, copy.payload);
            InfoMessage.InfoMessages msg = this.saveOutputDatasetsSchema(savedSr, copy.payload);
            createResult.messages.mergeFrom(msg);
            t.commitV("Created %s recipe %s", new Object[]{savedSr.type, savedSr.name});
            createResult.withId(savedSr.name);
        }
        return createResult;
    }

    private InfoMessage.InfoMessages saveOutputDatasetsSchema(SerializedRecipe recipe, String payload) throws Exception {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        HashMap<String, List<Dataset>> outputDatasetsByRole = new HashMap<String, List<Dataset>>();
        for (String role : recipe.getOutputsUnsafe().keySet()) {
            outputDatasetsByRole.put(role, new ArrayList());
            for (SerializedRecipe.RecipeOutput output : recipe.getOutputsForRole(role)) {
                DatasetLocUtils.DatasetLoc dsLoc = DatasetLocUtils.resolveSmart(recipe.getProjectKey(), output.ref);
                Dataset outputDs = this.datasetAccessService.getMandatory(dsLoc);
                if (outputDs.getSchema().columns.isEmpty()) {
                    logger.infoV("Setting schema for output dataset '%s' with role '%s'", new Object[]{outputDs.getName(), role});
                    ((List)outputDatasetsByRole.get(role)).add(outputDs);
                    continue;
                }
                logger.infoV("Output dataset '%s' with role '%s' already has a schema", new Object[]{outputDs.getName(), role});
            }
        }
        this.setOutputSchemas_T(recipe, payload, outputDatasetsByRole);
        for (Dataset outputDataset : outputDatasetsByRole.values().stream().flatMap(Collection::stream).toList()) {
            WithMessages<SerializedDataset> saveResult = this.datasetSaveService.save(outputDataset.getDatasetLoc(), outputDataset.serialize(), this.authCtx);
            messages.mergeFrom(saveResult.messages);
        }
        return messages;
    }

    protected abstract void setOutputSchemas_T(SerializedRecipe var1, String var2, Map<String, List<Dataset>> var3) throws Exception;

    public static class MultipleOutputRecipeCreationSettings {
        public Map<String, Map<String, ManagedDatasetsCreationService.ManagedDatasetCreationSettings>> outputDatasetsCreationSettingsByRole = new HashMap<String, Map<String, ManagedDatasetsCreationService.ManagedDatasetCreationSettings>>();
    }
}

