/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.consistency;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;

public class BasicRecipeConsistencyChecker {
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private KernelsManagedFolderService managedFoldersService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    private final SerializedRecipe recipe;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.consistency");

    public BasicRecipeConsistencyChecker(SerializedRecipe recipe) {
        SpringUtils.getInstance().autowire((Object)this);
        this.recipe = recipe;
    }

    public void check(InfoMessage.InfoMessages messages) throws IOException {
        RecipeMeta meta = RecipeRegistry.getMeta(this.recipe.type);
        if (meta == null) {
            messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "Unknown recipe type: " + this.recipe.type, new Object[0]);
            return;
        }
        HashSet<String> inputs = new HashSet<String>();
        HashSet<String> outputs = new HashSet<String>();
        for (SerializedRecipe.InputRole irole : this.recipe.getInputsUnsafe().values()) {
            for (SerializedRecipe.RecipeInput i : irole.items) {
                if (inputs.contains(i.ref)) {
                    messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "Dataset %s appears several times in inputs", new Object[]{i.ref});
                }
                inputs.add(i.ref);
            }
        }
        for (SerializedRecipe.OutputRole orole : this.recipe.getOutputsUnsafe().values()) {
            for (SerializedRecipe.RecipeOutput o : orole.items) {
                if (outputs.contains(o.ref)) {
                    messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "Dataset %s appears several times in outputs", new Object[]{o.ref});
                }
                outputs.add(o.ref);
            }
        }
        for (SerializedRecipe.InputRole irole : this.recipe.getInputsUnsafe().values()) {
            for (SerializedRecipe.RecipeInput i : irole.items) {
                for (SerializedRecipe.SDep sdep : i.deps) {
                    if (sdep.idim == null) {
                        messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "A partition dependency is missing its input dimension", new Object[0]);
                        continue;
                    }
                    if (sdep.func == null) {
                        messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "A partition dependency is missing its function", new Object[0]);
                        continue;
                    }
                    SerializedRecipe.DimensionDependencyType type = null;
                    try {
                        type = SerializedRecipe.DimensionDependencyType.forType(sdep.func);
                    }
                    catch (IllegalArgumentException e) {
                        messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "Failed to verify dependency: %s", new Object[]{e.getMessage()});
                        continue;
                    }
                    DatasetLocUtils.DatasetLoc inputLoc = DatasetLocUtils.resolveSmart(this.recipe.projectKey, i.ref);
                    Partitionable input = this.resolvePartitionable(inputLoc.getProjectKey(), inputLoc.getId());
                    PartitioningScheme inputPartitioning = input.getPartitioningSchema();
                    Dimension inputDimension = null;
                    if (!inputPartitioning.isPartitioned()) {
                        messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "Input dataset '%s' is not partitioned", new Object[]{i.ref});
                        continue;
                    }
                    if (inputPartitioning.getDimension(sdep.idim) == null) {
                        messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "Input dataset '%s' does not contain partitioning dimension '%s'", new Object[]{i.ref, sdep.idim});
                        continue;
                    }
                    logger.infoV("Getting dimension %s on input %s", new Object[]{sdep.idim, inputLoc.getFullName()});
                    inputDimension = inputPartitioning.getDimension(sdep.idim);
                    boolean pdepNeedsOutput = true;
                    switch (sdep.func) {
                        case "values": 
                        case "latest_available": 
                        case "all_available": 
                        case "time_range": {
                            pdepNeedsOutput = false;
                            break;
                        }
                    }
                    Object outputDimension = null;
                    if (sdep.out != null && pdepNeedsOutput) {
                        Partitionable output = this.resolvePartitionable(this.recipe.projectKey, sdep.out);
                        PartitioningScheme outputPartitioning = output.getPartitioningSchema();
                        if (sdep.odim != null) {
                            if (!outputPartitioning.isPartitioned()) {
                                messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "Output dataset '%s' is not partitioned", new Object[]{i.ref});
                                continue;
                            }
                            if (outputPartitioning.getDimension(sdep.odim) == null) {
                                messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "Output dataset '%s' does not contain partitioning dimension '%s'", new Object[]{sdep.out, sdep.odim});
                                continue;
                            }
                            outputDimension = outputPartitioning.getDimension(sdep.odim);
                        }
                    }
                    switch (type) {
                        case ALL_AVAILABLE: 
                        case LATEST_AVAILABLE: {
                            break;
                        }
                        case CURRENT_MONTH: 
                        case CURRENT_WEEK: 
                        case SLIDING_DAYS: {
                            if (sdep.odim == null) {
                                messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "%s dependency needs an output dimension", new Object[]{type.getDescription()});
                                break;
                            }
                            if (!(inputDimension instanceof TimeDimension)) {
                                messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "Input dimension of a %s dependency must be a time dimension", new Object[]{type.getDescription()});
                                break;
                            }
                            if (!(outputDimension instanceof TimeDimension)) {
                                messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "Output dimension of a %s dependency must be a time dimension", new Object[]{type.getDescription()});
                                break;
                            }
                            if (!((TimeDimension)inputDimension).hasDay()) {
                                messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "Input dimension of a %s dependency must be DAY or HOUR level", new Object[]{type.getDescription()});
                                break;
                            }
                            if (((TimeDimension)outputDimension).mappedPeriod == TimeDimension.Period.DAY) break;
                            messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "Output dimension of a %s dependency must be DAY level", new Object[]{type.getDescription()});
                            break;
                        }
                        case WHOLE_MONTH: {
                            if (sdep.odim == null) {
                                messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "%s dependency needs an output dimension", new Object[]{type.getDescription()});
                                break;
                            }
                            if (!(inputDimension instanceof TimeDimension)) {
                                messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "Input dimension of a %s dependency must be a time dimension", new Object[]{type.getDescription()});
                                break;
                            }
                            if (!(outputDimension instanceof TimeDimension)) {
                                messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "Output dimension of a %s dependency must be a time dimension", new Object[]{type.getDescription()});
                                break;
                            }
                            if (!((TimeDimension)inputDimension).hasDay()) {
                                messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "Input dimension of a %s dependency must be DAY or HOUR level", new Object[]{type.getDescription()});
                                break;
                            }
                            if (((TimeDimension)outputDimension).mappedPeriod == TimeDimension.Period.MONTH) break;
                            messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "Output dimension of a %s dependency must be MONTH level", new Object[]{type.getDescription()});
                            break;
                        }
                        case EQUALS: {
                            if (outputDimension == null) {
                                messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "%s dependency needs an output dimension", new Object[]{type.getDescription()});
                                break;
                            }
                            if (inputDimension.getClass() != outputDimension.getClass()) {
                                messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "For a %s dependency, input and output must be of the same type (in:%s out:%s)", new Object[]{type.getDescription(), inputDimension.getClass(), outputDimension.getClass()});
                                break;
                            }
                            if (!(inputDimension instanceof TimeDimension) || ((TimeDimension)inputDimension).mappedPeriod == ((TimeDimension)outputDimension).mappedPeriod) break;
                            messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "For a %s dependency, time input and time output must be on the same period of time, but input is %s while output is %s", new Object[]{type.getDescription(), ((TimeDimension)inputDimension).mappedPeriod, ((TimeDimension)outputDimension).mappedPeriod});
                            break;
                        }
                        case TIME_RANGE: {
                            if (inputDimension instanceof TimeDimension) break;
                            messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "Input dimension of a %s dependency must be a time dimension", new Object[]{type.getDescription()});
                            break;
                        }
                        case VALUES: {
                            if (sdep.values != null) break;
                            messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "You selected a '%s' partition dependency, but did not provide any value", new Object[]{type.getDescription()});
                            break;
                        }
                    }
                }
            }
        }
    }

    private Partitionable resolvePartitionable(String projectKey, String elementId) throws IOException {
        Partitionable output = this.datasetAccessService.getOrNull(projectKey, elementId);
        if (output == null && (output = this.managedFoldersService.getOrNull(projectKey, elementId)) == null && (output = (Partitionable)this.savedModelsDAO.getOrNull(projectKey, elementId)) == null) {
            throw new NotFoundException("Output element not found: " + elementId);
        }
        return output;
    }
}

