/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.export;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.recipes.ParamsWithVariablesExpansionLoopConfig;
import com.dataiku.dip.recipes.RecipeParams;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class ExportRecipeParams
extends RecipeParams
implements ParamsWithContainerizable,
ParamsWithVariablesExpansionLoopConfig {
    public boolean clearOutputPartition = false;
    public ExportParams exportParams = new ExportParams();
    public FilterDesc filter = new FilterDesc();
    public String outputFilename;
    private final TimestampPrefixParams timestampPrefix;
    public VariablesExpansionLoopConfig variablesExpansionLoopConfig = new VariablesExpansionLoopConfig();
    public ContainerExecSelection containerSelection = new ContainerExecSelection();

    public ExportRecipeParams() {
        this(null);
    }

    @VisibleForTesting
    ExportRecipeParams(TimestampPrefixParams timestampPrefix) {
        this.timestampPrefix = timestampPrefix;
    }

    @Override
    public ContainerExecSelection getContainerSelection() {
        return this.containerSelection;
    }

    @Override
    public void setContainerSelection(ContainerExecSelection selection) {
        this.containerSelection = selection;
    }

    @Override
    public VariablesExpansionLoopConfig getVariablesExpansionLoopConfig() {
        return this.variablesExpansionLoopConfig;
    }

    @Override
    public void setVariablesExpansionLoopConfig(VariablesExpansionLoopConfig variablesExpansionLoopConfig) {
        this.variablesExpansionLoopConfig = variablesExpansionLoopConfig;
    }

    public Optional<String> getTimestampPrefix(Instant now) {
        if (this.timestampPrefix == null || !this.timestampPrefix.enabled) {
            return Optional.empty();
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.timestampPrefix.format), (Object)"Timestamp format cannot be blank if the timestamp prefix is enabled");
        return Optional.of(this.getTimeFormatter().format(now));
    }

    private DateTimeFormatter getTimeFormatter() {
        try {
            return DateTimeFormatter.ofPattern(this.timestampPrefix.format).withZone(ZoneId.of("UTC")).withLocale(Locale.US);
        }
        catch (IllegalArgumentException e) {
            String msg = "Invalid timestamp prefix: \"%s\"".formatted(this.timestampPrefix.format);
            throw new IllegalArgumentException(msg, e);
        }
    }

    static class TimestampPrefixParams {
        private final boolean enabled;
        private final String format;

        @VisibleForTesting
        TimestampPrefixParams(boolean enabled, String format) {
            this.enabled = enabled;
            this.format = format;
        }
    }
}

