/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.fromapp;

import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class FlowComputableForRoleMappingsBuilder<T> {
    final String type;
    final String action;
    final String applicationAsRecipeFullId;
    protected final FlowRecipe applicationAsRecipe;
    final RunnableSubgraph runnableSubgraph;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.app");

    protected FlowComputableForRoleMappingsBuilder(String type, String action, FlowRecipe applicationAsRecipe, RunnableSubgraph runnableSubgraph) {
        this.type = type;
        this.action = action;
        this.applicationAsRecipeFullId = applicationAsRecipe.getFullId();
        this.applicationAsRecipe = applicationAsRecipe;
        this.runnableSubgraph = runnableSubgraph;
    }

    protected abstract List<T> getObjectsForRoleFromRecipe(String var1);

    protected abstract String getObjectsName(T var1);

    protected abstract List<AppManifest.AppUseAsRecipeSettings.RoleMapping> getRoleMappings(AppManifest.AppUseAsRecipeSettings var1);

    protected abstract Map<String, FlowComputable> getFlowComputableMap();

    private AnyLoc resolveLoc(AppManifest.AppUseAsRecipeSettings.RoleMapping roleMapping) {
        List<T> recipeObjectsForRole = this.getObjectsForRoleFromRecipe(roleMapping.objectId);
        if (recipeObjectsForRole.isEmpty()) {
            logger.infoV("No object set on %s %s. Please configure one from the application-as-recipe settings %s", new Object[]{this.type, JSON.log((Object)roleMapping), this.applicationAsRecipeFullId});
        } else if (recipeObjectsForRole.size() > 1) {
            throw ErrorContext.iaef((String)"Too many objects associated to recipe %s %s for application-as-recipe %s. Expected 1, got %s", (Object)this.type, (Object[])new Object[]{JSON.log((Object)roleMapping), this.applicationAsRecipeFullId, recipeObjectsForRole.size()});
        }
        return DatasetLocUtils.resolveSmart(this.applicationAsRecipe.getProjectKey(), this.getObjectsName(recipeObjectsForRole.get(0)));
    }

    FlowComputable resolveFlowComputable(AppManifest.AppUseAsRecipeSettings.RoleMapping roleMapping) {
        AnyLoc objectLoc = this.resolveLoc(roleMapping);
        FlowComputable result = this.getFlowComputableMap().get(objectLoc.getFullName());
        if (result == null) {
            throw ErrorContext.iaef((String)"Unable to find object %s", (Object)objectLoc.getFullName(), (Object[])new Object[0]);
        }
        if (result.getType() != roleMapping.type) {
            throw ErrorContext.iaef((String)"Incorrect type for %s %s: expected %s but %s is %s ", (Object)this.type, (Object[])new Object[]{StringUtils.defaultIfBlank((String)roleMapping.roleLabel, (String)roleMapping.objectId), roleMapping.type, objectLoc.getFullName(), result.getType()});
        }
        return result;
    }

    Map<String, FlowComputable> build(AppManifest.AppUseAsRecipeSettings appUseAsRecipeSettings) {
        HashMap result = Maps.newHashMap();
        for (AppManifest.AppUseAsRecipeSettings.RoleMapping roleMapping : this.getRoleMappings(appUseAsRecipeSettings)) {
            result.put(roleMapping.objectId, this.resolveFlowComputable(roleMapping));
        }
        logger.infoV("Found %s objects to %s", new Object[]{result.size(), this.action});
        return result;
    }

    static class OutputFlowComputableForRoleMappingsBuilder
    extends FlowComputableForRoleMappingsBuilder<SerializedRecipe.RecipeOutput> {
        protected OutputFlowComputableForRoleMappingsBuilder(FlowRecipe applicationAsRecipe, RunnableSubgraph runnableSubgraph) {
            super("output", "copy", applicationAsRecipe, runnableSubgraph);
        }

        @Override
        protected List<SerializedRecipe.RecipeOutput> getObjectsForRoleFromRecipe(String objectId) {
            return this.applicationAsRecipe.getModel().getOutputsForRole(objectId);
        }

        @Override
        protected String getObjectsName(SerializedRecipe.RecipeOutput object) {
            return object.ref;
        }

        @Override
        protected List<AppManifest.AppUseAsRecipeSettings.RoleMapping> getRoleMappings(AppManifest.AppUseAsRecipeSettings appUseAsRecipeSettings) {
            return appUseAsRecipeSettings.outputRoles;
        }

        @Override
        protected Map<String, FlowComputable> getFlowComputableMap() {
            return this.runnableSubgraph.getTargetsMap();
        }
    }

    static class InputFlowComputableForRoleMappingsBuilder
    extends FlowComputableForRoleMappingsBuilder<SerializedRecipe.RecipeInput> {
        protected InputFlowComputableForRoleMappingsBuilder(FlowRecipe applicationAsRecipe, RunnableSubgraph runnableSubgraph) {
            super("input", "expose", applicationAsRecipe, runnableSubgraph);
        }

        @Override
        protected List<SerializedRecipe.RecipeInput> getObjectsForRoleFromRecipe(String objectId) {
            return this.applicationAsRecipe.getModel().getInputsForRole(objectId);
        }

        @Override
        protected String getObjectsName(SerializedRecipe.RecipeInput object) {
            return object.ref;
        }

        @Override
        protected List<AppManifest.AppUseAsRecipeSettings.RoleMapping> getRoleMappings(AppManifest.AppUseAsRecipeSettings appUseAsRecipeSettings) {
            return appUseAsRecipeSettings.inputRoles;
        }

        @Override
        protected Map<String, FlowComputable> getFlowComputableMap() {
            return this.runnableSubgraph.getSourcesMap();
        }
    }
}

