/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.embed_documents;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.CodeBasedRecipeDatasetInfoHelper;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.docextraction.ScreenshotterService;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.io.JavaBlockLink;
import com.dataiku.dip.io.LocalSimplePythonKernel;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMRefEnricherService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.recipes.nlp.common.EmbeddingRecipePayloadBaseParams;
import com.dataiku.dip.recipes.nlp.common.EmbeddingRecipeRunnerBase;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionIndexer;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRecipeRunner;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRecordManager;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRuleApplier;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.ExtractedDataWriter;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.IndexerComputationResult;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipeParams;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRuleApplier;
import com.dataiku.dip.recipes.nlp.embed_documents.ExtractedDataJsonLFileWriter;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class EmbedDocumentsRecipeRunner
extends EmbeddingRecipeRunnerBase
implements DocExtractionRecipeRunner {
    @Autowired
    protected ManagedFolderDAO managedFolderDAO;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected ScreenshotterService screenshotterService;
    @Autowired
    protected LLMRefEnricherService llmRefEnricherService;
    protected EmbedDocumentsRecipePayloadParams desc;
    protected final EmbedDocumentsRecipeParams recipeParams;
    public static final String CLEAR_KB_ON_VECTOR_STORE_TYPE_CHANGE = "dku.embeddocuments.clearKnowledgeBaseOnVectorStoreTypeChange";
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.nlp.embed_documents");

    public EmbedDocumentsRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        this.recipeParams = this.recipe.getModel().getParamsAs(EmbedDocumentsRecipeParams.class);
    }

    @Override
    public void setPayload(String payload) {
        this.desc = (EmbedDocumentsRecipePayloadParams)JSON.parse((String)payload, EmbedDocumentsRecipePayloadParams.class);
    }

    @Override
    public EmbeddingRecipePayloadBaseParams parseRecipePayload(String payload) {
        return (EmbeddingRecipePayloadBaseParams)JSON.parse((String)payload, EmbedDocumentsRecipePayloadParams.class);
    }

    @Override
    protected List<String> getIgnoredVersionFiles() {
        return Arrays.asList("kb.json", "recipe_settings.json", "version_info.json", "kb_status.json");
    }

    @Override
    protected boolean shouldClearKnowledgeBankAfterSettingsChange(RetrievableKnowledge currentRk, RetrievableKnowledge previousRk, EmbeddingRecipePayloadBaseParams currentDesc, EmbeddingRecipePayloadBaseParams previousDesc, File previousVersionFolder) {
        File previousRecordManagerFile = DKUApp.getFile((File)previousVersionFolder, (String[])new String[]{"dss_record_manager_cache.sqlite"});
        if (!previousRecordManagerFile.exists()) {
            logger.warn((Object)String.format("Previous KB folder exists & contains the settings files, but does not contain the record manager file: %s missing in %s", "dss_record_manager_cache.sqlite", previousVersionFolder.getAbsolutePath()));
            return this.shouldClearKnowledgeBankIfPreviousVersionNotComplete(currentDesc.getVectorStoreUpdateMethod());
        }
        if (currentDesc.getVectorStoreUpdateMethod().canDelete && !Objects.equals((Object)currentRk.vectorStoreType, (Object)previousRk.vectorStoreType)) {
            boolean allowedToClearKB = AbstractSQLConnection.CustomDatabaseProperty.toParams(this.recipe.getModel().dkuProperties).getBoolParam(CLEAR_KB_ON_VECTOR_STORE_TYPE_CHANGE, true);
            if (!allowedToClearKB && !this.desc.clearVectorStore) {
                logger.warn((Object)"Vector store type change detected but not clearing the Knowledge Bank because of recipe property: dku.embeddocuments.clearKnowledgeBaseOnVectorStoreTypeChange");
                return false;
            }
            logger.info((Object)"Clearing knowledge bank after settings change (vectorStoreType)");
            return true;
        }
        return false;
    }

    @Override
    public EmbeddingRecipePayloadBaseParams getRecipeBaseDesc() {
        return this.desc;
    }

    private void indexAndProcessDocumentsInBothDatasetAndFolder(Dataset dataset, final ManagedFolder folder, final DocExtractionRuleApplier ruleApplier, final IndexerComputationResult indexerResult, final DocExtractionIndexer indexer, final ExtractedDataWriter extractedDataWriter) throws Exception {
        if (this.desc.filePathMetadataColumn == null) {
            throw new IOException("Select a path column from the input dataset to use it as a metadata dataset");
        }
        StreamColumnFactory scf = new StreamColumnFactory();
        StreamRowFactory srf = new StreamRowFactory();
        final Column pathColumn = scf.column(this.desc.filePathMetadataColumn);
        final Column securityColumn = this.desc.securityTokensColumn != null ? scf.column(this.desc.securityTokensColumn) : null;
        final Set allDatasetColumns = dataset.getSchema().columns.stream().map(arg_0 -> EmbedDocumentsRecipeRunner.lambda$indexAndProcessDocumentsInBothDatasetAndFolder$0((ColumnFactory)scf, arg_0)).collect(Collectors.toSet());
        final Set metadataColumns = this.desc.userDefinedMetadataColumns != null ? this.desc.userDefinedMetadataColumns.stream().map(arg_0 -> EmbedDocumentsRecipeRunner.lambda$indexAndProcessDocumentsInBothDatasetAndFolder$1((ColumnFactory)scf, arg_0)).collect(Collectors.toSet()) : null;
        final HashSet filesInBothDatasetAndFolder = new HashSet();
        logger.info((Object)"Reading dataset & matching corresponding documents to recipe rules");
        try (final ManagedFolderHandler inputHandler = (ManagedFolderHandler)folder.buildHandler(this.authCtx);){
            UniversalSingleThreadPusher threadPush = new UniversalSingleThreadPusher(this.authCtx, dataset, new ProcessorOutput(){

                public void setMaxMemoryUsed(long size) {
                }

                public void lastRowEmitted() throws Exception {
                }

                public void emitRow(Row row) throws Exception {
                    FSPathOrDirectory fsPath;
                    String filePath = row.get(pathColumn);
                    if (filePath == null) {
                        logger.warn((Object)("Skipping dataset row. Path column `" + pathColumn.getName() + "` is empty in row: " + String.valueOf(row)));
                        return;
                    }
                    try {
                        fsPath = inputHandler.getFile(filePath);
                        if (fsPath == null) {
                            throw new IOException("Empty file handler");
                        }
                    }
                    catch (CodedException | DKUSecurityException | IOException e) {
                        ((EmbedDocumentsRecipeRunner)EmbedDocumentsRecipeRunner.this).activity.warnContext.addWarning(WarningsContext.WarningType.DOCUMENT_PROCESSING_FAILED, "Document " + filePath + " failed to be processed and was skipped", logger);
                        return;
                    }
                    String securityTokens = securityColumn != null ? row.get(securityColumn) : null;
                    HashMap<String, String> metadataValues = new HashMap<String, String>();
                    if (metadataColumns != null) {
                        for (Column col : metadataColumns) {
                            metadataValues.put(col.getName(), row.get(col));
                        }
                    }
                    HashMap<String, String> rowValues = new HashMap<String, String>();
                    for (Column col : allDatasetColumns) {
                        rowValues.put(col.getName(), row.get(col));
                    }
                    filesInBothDatasetAndFolder.add(filePath);
                    InputRefs.ManagedFolderDocumentRefWithMetadata document = new InputRefs.ManagedFolderDocumentRefWithMetadata(new InputRefs.ManagedFolderDocumentRef(folder.getSmartName(EmbedDocumentsRecipeRunner.this.recipe.getProjectKey()), (FSPath)fsPath), securityTokens, metadataValues);
                    ruleApplier.handleLoadedDocument(document, rowValues, indexer, indexerResult, extractedDataWriter);
                }

                public void cancel() throws Exception {
                }
            }, (ColumnFactory)scf, (RowFactory)srf, true);
            threadPush.push();
            ruleApplier.onExtractionEnd(indexer, indexerResult);
            logger.info((Object)("Done loading input files: ( " + threadPush.getProcessedRowCount() + " dataset rows, from which " + filesInBothDatasetAndFolder.size() + " correctly found in the input folder): " + String.valueOf(filesInBothDatasetAndFolder)));
        }
    }

    @Override
    public void run() throws Exception {
        SerializedRecipe.RecipeOutput ro2;
        logger.info((Object)"Embed documents recipe runner started");
        SerializedRecipe.RecipeOutput ro = (SerializedRecipe.RecipeOutput)this.recipe.getModel().getOutputsForRole("knowledge_bank").stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Knowledge bank output not found"));
        this.rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(ro.getLoc(this.recipe.getProjectKey()));
        this.checkKnowledgeBanksAllowed(this.rk);
        SerializedRecipe.RecipeInput ri = (SerializedRecipe.RecipeInput)this.recipe.getModel().getInputsForRole("main").stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Folder input not found"));
        ManagedFolder inputFolder = (ManagedFolder)this.managedFolderDAO.getMandatory(ri.getLoc(this.recipe.getProjectKey()));
        Dataset inputDataset = null;
        Optional optionalRecipeInputDataset = this.recipe.getModel().getInputsForRole("metadata_dataset").stream().findFirst();
        if (optionalRecipeInputDataset.isPresent()) {
            logger.info((Object)"Metadata Dataset is filled");
            SerializedRecipe.RecipeInput dataset_ri = (SerializedRecipe.RecipeInput)optionalRecipeInputDataset.orElseThrow(() -> new IllegalArgumentException("Input metadata dataset not found"));
            inputDataset = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatory(dataset_ri.getLoc(this.recipe.getProjectKey())));
        }
        this.desc.metadataColumns = new ArrayList();
        this.desc.metadataColumns.add(new EmbeddingRecipePayloadBaseParams.MetadataColumn("dku_file_path"));
        this.rk.metadataColumnsSchema = new ArrayList<SchemaColumn>();
        if (inputDataset != null && !this.desc.userDefinedMetadataColumns.isEmpty()) {
            Set userDefinedMetaColNames = this.desc.userDefinedMetadataColumns.stream().map(col -> col.column).collect(Collectors.toSet());
            this.desc.metadataColumns.addAll(this.desc.userDefinedMetadataColumns);
            this.rk.metadataColumnsSchema.addAll(inputDataset.getSchema().columns.stream().filter(sc -> userDefinedMetaColNames.contains(sc.getName())).toList());
        }
        this.rk.metadataColumnsSchema.add(new SchemaColumn("dku_file_path", Type.STRING));
        FlowComputable folderAsFlowComputable = this.recipe.getSourcesWithRoles().stream().filter((Predicate<FlowComputable.FlowComputableWithRole>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$run$7(com.dataiku.dip.dataflow.graph.FlowComputable$FlowComputableWithRole ), (Lcom/dataiku/dip/dataflow/graph/FlowComputable$FlowComputableWithRole;)Z)()).findFirst().orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$run$8(), ()Ljava/lang/IllegalArgumentException;)()).computable;
        if (folderAsFlowComputable.getType() != FlowComputable.FCType.MANAGED_FOLDER) {
            throw new IllegalStateException("Embed documents recipe expect a folder as input");
        }
        Optional imageFolderOptionalOutput = this.recipe.getModel().getOutputsForRole("images").stream().findFirst();
        ManagedFolder outfolder = null;
        boolean needFolderUpdate = false;
        if (imageFolderOptionalOutput.isPresent() && !(outfolder = (ManagedFolder)this.managedFolderDAO.getMandatory((ro2 = (SerializedRecipe.RecipeOutput)imageFolderOptionalOutput.get()).getLoc(this.recipe.getProjectKey()))).getFullId().equals(this.rk.managedFolderId)) {
            logger.warn((Object)("Output managed folder change detected from=" + this.rk.managedFolderId + ", to=" + outfolder.getFullId() + ", KB folder will be updated accordingly"));
            this.rk.managedFolderId = outfolder.getFullId();
            needFolderUpdate = true;
        }
        EnrichedLLMStructuredRef embeddingModelRef = this.llmRefEnricherService.getEnrichedLLMRef(this.rk.embeddingLLMId, this.authCtx, this.recipe.getProjectKey());
        EmbedDocumentsRuleApplier ruleApplier = new EmbedDocumentsRuleApplier(this.recipeParams, embeddingModelRef, outfolder, this.authCtx, this.recipe.getProjectKey(), this.ticketService, this.activity, this.screenshotterService);
        try (AutoDelete outputTmpDir = FlowJobUtils.getTmpFolder("embed-documents-recipe", "pyrun");){
            RetrievableKnowledge.RetrievableKnowledgeStatus kbStatus;
            IndexerComputationResult indexerResult;
            DocExtractionIndexer indexer;
            File baseFolder = DKUApp.getFile((String[])new String[]{"knowledge-banks", this.rk.projectKey, this.rk.id});
            MLPaths.createIfNeededFolderAndRestrictPermissions(baseFolder);
            this.desc.clearVectorStore = this.desc.clearVectorStore || this.shouldClearKnowledgeBank(this.rk);
            String version = "" + System.currentTimeMillis();
            File rkFolder = DKUApp.getFile((File)baseFolder, (String[])new String[]{"versions", version});
            Optional<CodeBasedRecipeDatasetInfoHelper.ConnectionLocationInfo> remoteVectorStoreConnectionInfo = this.getRemoteVectorStoreConnectionInfo(this.authCtx, this.rk.connection);
            String envName = new CodeEnvSelector().selectForPythonRecipe(this.recipe.getProjectKey(), this.rk.envSelection);
            logger.info((Object)("Run embed documents in code env " + StringUtils.defaultIfBlank((String)envName, (String)"built-in")));
            MLPaths.createIfNeededFolderAndRestrictPermissions(rkFolder);
            if (!this.desc.clearVectorStore) {
                this.copyPreviousVersionFolder(this.rk, rkFolder);
            }
            this.desc.knowledgeColumn = "DKU_GENERATED_EMBEDDING";
            this.desc.documentSplittingMode = EmbeddingRecipePayloadBaseParams.DocumentSplittingMode.NONE;
            ExtractedDataJsonLFileWriter extractedDataWriter = new ExtractedDataJsonLFileWriter(outputTmpDir);
            try (LocalSimplePythonKernel kernel = new LocalSimplePythonKernel(this.authCtx, this.recipe.getProjectKey(), GeneralSettingsDAO.CGrouppableProcessType.PYTHON_R_RECIPE, envName, "dataiku.llm.rag.embed_documents_recipe", false, false, null, false, "embed-documents");){
                HashMap<String, String> extraEnv = new HashMap<String, String>();
                remoteVectorStoreConnectionInfo.ifPresent(connectionLocationInfo -> extraEnv.put("DKU_KB_CONNECTION_INFO", JSON.json((Object)connectionLocationInfo)));
                kernel.withExtraEnv(extraEnv);
                kernel.start();
                JavaBlockLink link = kernel.getLink();
                this.sendStartCommand(link, rkFolder);
                if (this.desc.clearVectorStore) {
                    this.sendClearKBCommand(link);
                }
                DocExtractionRecordManager recordManager = new DocExtractionRecordManager(rkFolder, this.recipe.getProjectKey());
                indexer = new DocExtractionIndexer(this.desc.vectorStoreUpdateMethod, recordManager);
                this.sendCheckEmbeddingCommand(link);
                indexerResult = indexer.startIndexing();
                if (inputDataset != null) {
                    this.indexAndProcessDocumentsInBothDatasetAndFolder(inputDataset, inputFolder, ruleApplier, indexerResult, indexer, extractedDataWriter);
                } else {
                    DocExtractionRecipeRunner.indexAndProcessDocumentsInFolder(this.recipe.getProjectKey(), inputFolder, folderAsFlowComputable, ruleApplier, indexerResult, indexer, extractedDataWriter, this.authCtx, this.activity);
                }
                extractedDataWriter.handleOutdatedChunksUuids(indexer.getChunksIdsToDelete(indexerResult));
                kbStatus = this.sendEmbedCommand(link, extractedDataWriter);
                this.sendStopCommand(link);
            }
            catch (Exception e) {
                logger.error((Object)("Error when running recipe: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                throw new IOException("Error when running recipe:", e);
            }
            if (needFolderUpdate) {
                this.updateManagedFolderId();
            }
            String runID = JobContext.getCurrentJobContext().jobId;
            indexer.updateRecordManagerAndCleanOutdatedStoredAssets(indexerResult, extractedDataWriter.processedDocumentResourcesAccumulator, outfolder, this.authCtx, runID);
            JSON.prettyToFile((Object)this.rk, (File)new File(rkFolder, "kb.json"));
            this.updateMetadataColsSchema(this.rk);
            JSON.prettyToFile((Object)this.desc, (File)new File(rkFolder, "recipe_settings.json"));
            this.updateKBVersionOnDisk(this.rk, rkFolder, version);
            this.updateKBStatusOnDisk(rkFolder, kbStatus);
        }
    }

    private void updateManagedFolderId() throws IOException {
        String secret = this.ticketService.getSingleTicket().getSecret();
        try (TicketBasedIntercomAPIClient tClient = TicketBasedIntercomAPIClient.forLocalHost(secret);){
            logger.info((Object)("Setting new managed folder " + this.rk.managedFolderId + " on knowledge bank " + this.rk.getFullId()));
            tClient.postFormToJSON("/dip/api/tintercom/knowledge-bank/set-managed-folder", Void.class, new Object[]{"knowledgeBankFullId", this.rk.getFullId(), "managedFolderId", this.rk.managedFolderId});
            this.retrievableKnowledgeDAO.save(this.rk);
        }
    }

    private void updateKBStatusOnDisk(File rkFolder, RetrievableKnowledge.RetrievableKnowledgeStatus status) throws IOException {
        File statusFile = DKUApp.getFile((File)rkFolder, (String[])new String[]{"kb_status.json"});
        DocExtractionRecordManager recordManager = new DocExtractionRecordManager(rkFolder, this.recipe.getProjectKey());
        status.nbChunks = recordManager.getNumberOfChunks();
        status.nbDocuments = recordManager.getNumberOfDocuments();
        DKUFileUtils.writeFileUTF8((File)statusFile, (String)JSON.pretty((Object)status));
    }

    private void sendStartCommand(JavaBlockLink link, File rkFolder) throws IOException {
        DocumentEmbeddingResponse result;
        DocumentEmbeddingStartCommand command = new DocumentEmbeddingStartCommand();
        command.recipeSettings = JSON.pretty((Object)this.desc);
        command.knowledgeBankSettings = JSON.pretty((Object)this.rk);
        command.runFolder = rkFolder.getAbsolutePath();
        try {
            logger.info((Object)"Starting initialization of vector store");
            link.sendRequest((Object)command);
            result = (DocumentEmbeddingResponse)link.receiveJsonResponse(DocumentEmbeddingResponse.class);
        }
        catch (IOException e) {
            logger.error((Object)("Could not initialize vector store : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            throw new IOException("Could not initialize vector store", e);
        }
        if (ResponseType.ERROR.equals((Object)result.type)) {
            logger.error((Object)("Could not initialize vector store: " + result.message));
            throw new IOException("Could not initialize vector store:  " + result.message);
        }
    }

    private void sendCheckEmbeddingCommand(JavaBlockLink link) throws IOException {
        DocumentEmbeddingResponse result;
        DocumentEmbeddingCheckEmbeddingCommand command = new DocumentEmbeddingCheckEmbeddingCommand();
        try {
            logger.info((Object)"Starting knowledge bank configuration check");
            link.sendRequest((Object)command);
            result = (DocumentEmbeddingResponse)link.receiveJsonResponse(DocumentEmbeddingResponse.class);
        }
        catch (IOException e) {
            logger.error((Object)("Knowledge bank configuration check failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            throw new IOException("Knowledge bank configuration check failed", e);
        }
        if (ResponseType.ERROR.equals((Object)result.type)) {
            logger.error((Object)("Knowledge bank configuration check failed: " + result.message));
            throw new IOException("Knowledge bank configuration check failed: " + result.message);
        }
        logger.info((Object)"Knowledge bank configuration checked with success");
    }

    private void sendClearKBCommand(JavaBlockLink link) throws IOException {
        DocumentEmbeddingResponse result;
        DocumentEmbeddingClearKBCommand command = new DocumentEmbeddingClearKBCommand();
        try {
            logger.info((Object)"Starting knowledge bank clear");
            link.sendRequest((Object)command);
            result = (DocumentEmbeddingResponse)link.receiveJsonResponse(DocumentEmbeddingResponse.class);
        }
        catch (IOException e) {
            logger.error((Object)("Knowledge bank clear failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            throw new IOException("Knowledge bank clear failed", e);
        }
        if (ResponseType.ERROR.equals((Object)result.type)) {
            logger.error((Object)("Knowledge bank clear failed: " + result.message));
            throw new IOException("Knowledge bank clear failed: " + result.message);
        }
        logger.info((Object)"Knowledge bank cleared with success");
    }

    private RetrievableKnowledge.RetrievableKnowledgeStatus sendEmbedCommand(JavaBlockLink link, ExtractedDataJsonLFileWriter extractedDataWriter) throws IOException {
        UpdateKBResponse result;
        DocumentEmbeddingUpdateKBCommand command = new DocumentEmbeddingUpdateKBCommand();
        command.chunksToAdd = extractedDataWriter.toAddChunksContentFile.getAbsolutePath();
        command.chunksIdsToAdd = extractedDataWriter.toAddChunksUuidsFile.getAbsolutePath();
        command.chunksIdsToDelete = extractedDataWriter.toRemoveChunksUuidsFile.getAbsolutePath();
        try {
            logger.info((Object)"Starting Embedding");
            link.sendRequest((Object)command);
            result = (UpdateKBResponse)link.receiveJsonResponse(UpdateKBResponse.class);
        }
        catch (IOException e) {
            logger.error((Object)("Embedding of extracted content failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            throw new IOException("Embedding of extracted content failed", e);
        }
        if (ResponseType.ERROR.equals((Object)result.type)) {
            logger.error((Object)("Embedding of extracted content failed: " + result.message));
            throw new IOException("Embedding of extracted content failed: " + result.message);
        }
        logger.info((Object)("Embedding successful. New KB size: " + result.kbStatus.fileSizeMb));
        return result.kbStatus;
    }

    private void sendStopCommand(JavaBlockLink link) throws IOException {
        DocumentEmbeddingResponse result;
        DocumentEmbeddingStopCommand command = new DocumentEmbeddingStopCommand();
        logger.info((Object)"Stopping kernel");
        try {
            link.sendRequest((Object)command);
            result = (DocumentEmbeddingResponse)link.receiveJsonResponse(DocumentEmbeddingResponse.class);
        }
        catch (IOException e) {
            logger.error((Object)("Could not stop kernel: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            throw new IOException("Could not stop kernel", e);
        }
        if (ResponseType.ERROR.equals((Object)result.type)) {
            logger.error((Object)("Could not stop kernel: " + result.message));
        } else {
            logger.info((Object)"Kernel stopped.");
        }
    }

    private static /* synthetic */ IllegalArgumentException lambda$run$8() {
        return new IllegalArgumentException("Folder input not found from recipe sources");
    }

    private static /* synthetic */ boolean lambda$run$7(FlowComputable.FlowComputableWithRole source) {
        return source.role.equals("main");
    }

    private static /* synthetic */ Column lambda$indexAndProcessDocumentsInBothDatasetAndFolder$1(ColumnFactory scf, EmbeddingRecipePayloadBaseParams.MetadataColumn col) {
        return scf.column(col.column);
    }

    private static /* synthetic */ Column lambda$indexAndProcessDocumentsInBothDatasetAndFolder$0(ColumnFactory scf, SchemaColumn schemaColumn) {
        return scf.column(schemaColumn.getName());
    }

    private static class DocumentEmbeddingStartCommand
    extends DocumentEmbeddingCommand {
        public String recipeSettings;
        public String knowledgeBankSettings;
        public String runFolder;

        public DocumentEmbeddingStartCommand() {
            this.type = "START";
        }
    }

    private static class DocumentEmbeddingResponse {
        public ResponseType type;
        public String message;

        private DocumentEmbeddingResponse() {
        }
    }

    static enum ResponseType {
        SUCCESS,
        ERROR;

    }

    private static class DocumentEmbeddingCheckEmbeddingCommand
    extends DocumentEmbeddingCommand {
        public DocumentEmbeddingCheckEmbeddingCommand() {
            this.type = "CHECK_EMBEDDING";
        }
    }

    private static class DocumentEmbeddingClearKBCommand
    extends DocumentEmbeddingCommand {
        public DocumentEmbeddingClearKBCommand() {
            this.type = "CLEAR_KB";
        }
    }

    private static class DocumentEmbeddingUpdateKBCommand
    extends DocumentEmbeddingCommand {
        public String chunksToAdd;
        public String chunksIdsToAdd;
        public String chunksIdsToDelete;

        public DocumentEmbeddingUpdateKBCommand() {
            this.type = "UPDATE_KB";
        }
    }

    private static class UpdateKBResponse
    extends DocumentEmbeddingResponse {
        public RetrievableKnowledge.RetrievableKnowledgeStatus kbStatus;

        private UpdateKBResponse() {
        }
    }

    private static class DocumentEmbeddingStopCommand
    extends DocumentEmbeddingCommand {
        public DocumentEmbeddingStopCommand() {
            this.type = "STOP";
        }
    }

    private static class DocumentEmbeddingCommand {
        public String type;

        private DocumentEmbeddingCommand() {
        }
    }
}

