/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.prompt;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.nlp.prompt.PromptRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.prompt.RawQueryOutputMode;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class PromptRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private TransactionService transactionService;
    private PromptRecipePayloadParams desc;

    public PromptRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.desc = (PromptRecipePayloadParams)JSON.parse((String)payload, PromptRecipePayloadParams.class);
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
        Schema schema = new Schema();
        if (!this.recipe.getInputsUnsafe().get((Object)role).items.isEmpty()) {
            schema = this.getInputSchemaCopy();
        }
        for (PromptRecipeColumn column : List.of(PromptRecipeColumn.LLM_OUTPUT, PromptRecipeColumn.LLM_VALIDATION_STATUS, PromptRecipeColumn.LLM_RAW_OUTPUT, PromptRecipeColumn.LLM_ERROR_MSG)) {
            schema.withColumn(column.name, column.type);
        }
        if (!RawQueryOutputMode.NONE.equals((Object)this.desc.rawQueryOutputMode)) {
            schema.withColumn(PromptRecipeColumn.LLM_RAW_QUERY.name, PromptRecipeColumn.LLM_RAW_QUERY.type);
        }
        return Collections.singletonList(schema);
    }

    private Schema getInputSchemaCopy() throws Exception {
        Dataset inputDataset;
        try (Transaction t = this.transactionService.beginRead();){
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            AnyLoc inputDatasetLoc = this.recipe.getSingleInput("main").getLoc(this.recipe.getProjectKey());
            inputDataset = this.datasetAccessService.getMandatoryUnsafe(inputDatasetLoc);
        }
        return inputDataset.getSchema().getCopy();
    }

    public static enum PromptRecipeColumn {
        LLM_OUTPUT("llm_output", Type.STRING),
        LLM_VALIDATION_STATUS("llm_validation_status", Type.STRING),
        LLM_RAW_QUERY("llm_raw_query", Type.STRING),
        LLM_RAW_OUTPUT("llm_raw_response", Type.STRING),
        LLM_ERROR_MSG("llm_error_message", Type.STRING);

        public final String name;
        final Type type;

        private PromptRecipeColumn(String name, Type type) {
            this.name = name;
            this.type = type;
        }
    }
}

