/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.exec.JobExecutionResultHandler;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.dataflow.exec.SparkJobExecutionResultHandler;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.logging.SparkLoggingConfigurator;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.code.spark.SparkBasedActivityHelper;
import com.dataiku.dip.recipes.code.spark.SparkConfigEnricher;
import com.dataiku.dip.recipes.streaming.AbstractCodeBasedContinuousActivityRunner;
import com.dataiku.dip.spark.SparkErrorParser;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.submit.SparkSubmitHelper;
import com.dataiku.dip.spark.submit.SparkSubmitJob;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.LoggableCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSparkBasedContinuousRecipeRunner
extends AbstractCodeBasedContinuousActivityRunner {
    @Autowired
    protected RecipesDAO recipesDAO;
    private SparkExecutionEnginesHelper trHelper;
    private SparkJobHelper.SparkJobContext context;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.spark.base");

    public AbstractSparkBasedContinuousRecipeRunner(ContinuousActivity activity, SerializedRecipe sr) {
        super(activity, sr);
    }

    @Override
    protected JobExecutionResultHandler getExecutionResultHandler() {
        return new SparkJobExecutionResultHandler(this.context){

            @Override
            protected void enrichErrorFile(String languageInfo, SerializedError err) {
                logger.info((Object)("Trying to enrich " + languageInfo + " error"));
                SparkErrorParser.enrichError(languageInfo.toLowerCase(), err);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void runSpark(SparkJobHelper.RunMode runMode, String languageInfo, String envName, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine, SparkExecutionEnginesHelper.SparkRecipeJobBuilder jobBuilder, SparkJobHelper.SparkJobPostProcessor postProcessor, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws Exception {
        SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatory(this.activity.projectKey, this.activity.recipeId);
        ClusterSettings clusterSettings = new ClusterSelector().selectForProject(this.authCtxService.getAuthCtx(), recipe.getProjectKey());
        HadoopSettings hadoopSettings = clusterSettings.getHadoopSettings();
        SparkSettings sparkSettings = clusterSettings.getSparkSettings();
        List<SimpleKeyValue> conf = SparkJobHelper.composeConf(this.authCtxService.getAuthCtx(), recipe.getProjectKey(), sparkSettings, jobBuilder.getRecipeOverrideConf(), jobBuilder.getContextOverrideConf());
        AutoDelete tmpFolder = DSSTempUtils.getTempFolder((String)"xxx");
        SparkBasedActivityHelper helper = new SparkBasedActivityHelper(recipe.getProjectKey(), this.authCtxService.getAuthCtx(), (File)tmpFolder, null);
        helper.configure(recipe.getProjectKey(), this.activity, conf);
        new SparkConfigEnricher().setMetastoreConfKeysInKeys(conf);
        this.trHelper = new SparkExecutionEnginesHelper(this.projectKey);
        EnvironmentStash stash = this.prepareEnvStash(helper.getProcessRunDir(), helper.getProcessExtraEnv(), envName);
        try {
            switch (executionEngine) {
                case SPARK_SUBMIT: {
                    this.runUsingSparkSubmit(runMode, languageInfo, envName, jobBuilder, postProcessor, hadoopSettings, sparkSettings, conf, helper, cgrouppableProcessType, stash);
                    return;
                }
                default: {
                    throw new Error("Unsupported execution engine: " + String.valueOf((Object)executionEngine));
                }
            }
        }
        finally {
            helper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUsingSparkSubmit(SparkJobHelper.RunMode runMode, String languageInfo, String envName, SparkExecutionEnginesHelper.SparkRecipeJobBuilder jobBuilder, SparkJobHelper.SparkJobPostProcessor postProcessor, HadoopSettings hadoopSettings, SparkSettings sparkSettings, List<SimpleKeyValue> conf, SparkBasedActivityHelper helper, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, EnvironmentStash stash) throws Exception {
        SparkExecutionConfig usedExecutionConfig = sparkSettings.getByName(jobBuilder.getRecipeOverrideConf().inheritConf);
        SparkSubmitHelper sparkSubmitHelper = SparkSubmitHelper.build(this.projectKey, this.authCtxService.getAuthCtx(), sparkSettings, hadoopSettings, null, usedExecutionConfig);
        SparkSubmitJob job = jobBuilder.buildSparkJob(sparkSubmitHelper, helper.getProcessRunDir(), sparkSettings, conf);
        for (File file : SparkLoggingConfigurator.copyConfigurationFilesToRunDir(helper.getProcessRunDir())) {
            job.nonSecretGlobalFiles.add(file.getAbsolutePath());
        }
        CodeEnvModel.UsedCodeEnvRef codeEnvRef = this.trHelper.buildUsedCodeEnvRefForSparkSubmitJob(runMode, envName, stash, job);
        this.context = sparkSubmitHelper.runsInClusterMode(job) ? sparkSubmitHelper.setupRunUsingCluster(runMode, jobBuilder, helper.getProcessRunDir(), job, stash, helper.getJobExecEnv(), codeEnvRef) : sparkSubmitHelper.setupRunUsingClient(runMode, jobBuilder, helper.getProcessRunDir(), job, stash, helper.getJobExecEnv(), codeEnvRef);
        LoggableCommand cmd = sparkSubmitHelper.toCommand(job);
        try {
            ArrayList<String> codeRnvCmd = new ArrayList<String>();
            this.trHelper.enrichSparkSubmitCommandForCodeEnv(runMode, envName, codeRnvCmd);
            cmd.addToCommandLine(codeRnvCmd);
            logger.info((Object)("Execute spark-submit:\n" + cmd.getLogString()));
            File tmpDir = helper.getProcessRunDir();
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.directory(tmpDir);
            builder.environment().putAll(stash.getAsEnvVariables(true, true, false));
            builder.command(cmd.getCommands());
            this.executeLocal(builder, null, languageInfo, cgrouppableProcessType, this.context.impersonatesRemotely(), new File(tmpDir, "process-out.log"));
            if (postProcessor != null) {
                postProcessor.postProcess(this.context);
            }
        }
        finally {
            this.context.close();
        }
    }
}

