/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.remoterun;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.hf.ModelCacheDataProvider;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DSSInternalErrorException;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeUtils;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.remoterun.ProjectLibsBundler;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.utils.TarArchiveUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.filefilter.TrueFileFilter;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RemoteRunFileExchangeService {
    @Autowired
    IPluginsRegistryService pluginsRegistry;
    private final List<RemoteRunsRegistry.ExecutionType> executionTypesWithoutWriteAccess = Collections.singletonList(RemoteRunsRegistry.ExecutionType.SIMPLE_PYTHON);
    private static final FilenameFilter FILTER_NONE = TrueFileFilter.INSTANCE;
    private static final FilenameFilter FILTER_LOGS = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            if (name.toLowerCase().endsWith(".log")) {
                logger.debug((Object)("Skipping filtered " + name));
                return false;
            }
            return true;
        }
    };
    private static final FilenameFilter FILTER_OUTPUT_FOLDER = (dir, name) -> !dir.getName().equals("output");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.remoterun.fileexchange.service");

    public void downloadFile(RemoteRunsRegistry.Execution execution, FileKind fileKind, @Nullable String path, @Nullable String pluginId, @Nullable String codeEnvName, boolean compress, HttpServletResponse resp) throws Exception {
        File file;
        logger.trace((Object)("Download file execution=" + String.valueOf(execution) + " fK= " + String.valueOf((Object)fileKind) + " path=" + path));
        if (!fileKind.readable) {
            throw new SecurityException("Cannot read files of kind " + String.valueOf((Object)fileKind));
        }
        File relFile = null;
        if (fileKind == FileKind.FILTERED_PATHS) {
            file = this.getFilteredFile(path, execution.executionPath, execution.readablePaths);
        } else if (fileKind == FileKind.MODEL_CACHE) {
            file = this.getModelCacheFile(path);
        } else {
            relFile = this.getFile(execution, fileKind, pluginId, codeEnvName);
            file = relFile.getAbsoluteFile();
            if (!StringUtils.isEmpty((String)path)) {
                if (!(path = PathUtils.slashes((String)path, (Boolean)false, (Boolean)false, (boolean)true, (String)"")).isEmpty()) {
                    file = DKUFileUtils.getWithinFollowLink((File)file, (String[])new String[]{path});
                } else if (fileKind == FileKind.CODE_ENV_RESOURCE) {
                    throw new IllegalArgumentException("Path cannot be empty when fetching a code environment resource");
                }
            }
        }
        this.downloadFile(execution, fileKind, file, compress, resp);
    }

    private File getModelCacheFile(String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Cannot read model cache file without a path");
        }
        File file = new File(path);
        if (!ModelCacheDataProvider.isWithinModelCacheFollowLinks(file)) {
            throw new IllegalArgumentException("Path '" + path + "' is not in the model cache path");
        }
        return file;
    }

    public void downloadMLFile(RemoteRunsRegistry.Execution execution, FileKind fileKind, String path, MLTaskLoc taskLoc, HttpServletResponse resp) throws IOException {
        if (fileKind != FileKind.ML_FILES) {
            throw new IllegalArgumentException("Can only download ML files with type ML_FILES");
        }
        if (path == null) {
            throw new IllegalArgumentException("Cannot read a ML file without a path");
        }
        File file = new File(path);
        if (!DKUFileUtils.isWithinFollowLinks((File)taskLoc.getDataFolder(), (File)file)) {
            throw new IllegalArgumentException("Path '" + path + "' is not in the model available paths: " + String.valueOf(taskLoc.getDataFolder()));
        }
        logger.info((Object)("Download ML file, taskLoc=" + String.valueOf(taskLoc) + ", path=" + path));
        this.downloadFile(execution, fileKind, file, false, resp);
    }

    public void downloadKBFile(RemoteRunsRegistry.Execution execution, FileKind fileKind, String path, AnyLoc taskLoc, HttpServletResponse resp) throws IOException {
        if (fileKind != FileKind.KB_FILES) {
            throw new IllegalArgumentException("Can only download knowledge bank files with type KB_FILES");
        }
        if (path == null) {
            throw new IllegalArgumentException("Cannot read a knowledge bank without a path");
        }
        File file = new File(path);
        File baseKbFolder = RetrievableKnowledgeUtils.getDataFolder(taskLoc.getProjectKey(), taskLoc.getId());
        if (!DKUFileUtils.isWithinFollowLinks((File)baseKbFolder, (File)file)) {
            throw new IllegalArgumentException("Path '" + path + "' is not in the model available paths: " + String.valueOf(baseKbFolder));
        }
        logger.info((Object)("Download knowledge bank, loc=" + String.valueOf(taskLoc) + ", path=" + path));
        this.downloadFile(execution, fileKind, file, false, resp);
    }

    public void downloadMLFile(RemoteRunsRegistry.Execution execution, FileKind fileKind, String path, String savedModelProjectKey, String savedModelId, HttpServletResponse resp) throws IOException {
        File file = RemoteRunFileExchangeService.getMLFile(fileKind, path, savedModelProjectKey, savedModelId);
        logger.info((Object)("Download ML file, savedModel=" + savedModelId + ", path=" + path));
        this.downloadFile(execution, fileKind, file, false, resp);
    }

    private static File getMLFile(FileKind fileKind, String path, String savedModelProjectKey, String savedModelId) throws IOException {
        if (fileKind != FileKind.ML_FILES) {
            throw new IllegalArgumentException("Can only access ML files with type ML_FILES");
        }
        if (path == null) {
            throw new IllegalArgumentException("Cannot access a ML file without a path");
        }
        File file = new File(path);
        File baseSMPath = MLPaths.savedModelBaseFolder(savedModelProjectKey, savedModelId);
        if (!DKUFileUtils.isWithinFollowLinks((File)baseSMPath, (File)file)) {
            throw new IllegalArgumentException("Path '" + path + "' is not in the model available paths: " + String.valueOf(baseSMPath));
        }
        return file;
    }

    public void downloadHFFile(RemoteRunsRegistry.Execution execution, FileKind fileKind, String path, String savedModelProjectKey, String savedModelId, HttpServletResponse resp) throws IOException {
        File file = RemoteRunFileExchangeService.getHFFile(fileKind, path, savedModelProjectKey, savedModelId);
        logger.info((Object)("Download HF file, savedModel=" + savedModelId + ", path=" + path));
        this.downloadFile(execution, fileKind, file, false, resp);
    }

    private static File getHFFile(FileKind fileKind, String path, String savedModelProjectKey, String savedModelId) throws IOException {
        if (fileKind != FileKind.LOCAL_HF_FILE) {
            throw new IllegalArgumentException("Can only access HF files with type LOCAL_HF_FILE");
        }
        if (path == null) {
            throw new IllegalArgumentException("Cannot access a HF file without a path");
        }
        File file = new File(path);
        File baseSMPath = MLPaths.savedModelBaseFolder(savedModelProjectKey, savedModelId);
        if (!DKUFileUtils.isWithinFollowLinks((File)baseSMPath, (File)file)) {
            throw new IllegalArgumentException("Path '" + path + "' is not in the HF model available paths: " + String.valueOf(baseSMPath));
        }
        return file;
    }

    private void downloadFile(RemoteRunsRegistry.Execution execution, FileKind fileKind, File file, boolean compress, HttpServletResponse resp) throws IOException {
        logger.trace((Object)("Serving " + file.getAbsolutePath()));
        if (file.isFile()) {
            try (FileInputStream in = new FileInputStream(file);){
                resp.setStatus(200);
                resp.setContentType("application/octet-stream");
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
                resp.setHeader("Content-Length", "" + file.length());
                IOUtils.copy((InputStream)in, (OutputStream)resp.getOutputStream());
            }
            catch (IOException e) {
                logger.error((Object)"Failed to send file", (Throwable)e);
            }
        } else if (file.isDirectory()) {
            if (compress) {
                try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)resp.getOutputStream());){
                    FilenameFilter filter = this.getStaticFilter(execution, fileKind, true);
                    resp.setStatus(200);
                    resp.setContentType("application/gzip");
                    resp.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + ".tgz\"");
                    RemoteRunFileExchangeService.archiveDirectoryToOutputStream(file, filter, gzipOutputStream);
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to send files", (Throwable)e);
                }
            } else {
                try {
                    FilenameFilter filter = this.getStaticFilter(execution, fileKind, true);
                    resp.setStatus(200);
                    resp.setContentType("application/x-tar");
                    resp.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
                    RemoteRunFileExchangeService.archiveDirectoryToOutputStream(file, filter, (OutputStream)resp.getOutputStream());
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to send files", (Throwable)e);
                }
            }
        } else {
            resp.sendError(404, "File Not Found: " + String.valueOf((Object)fileKind) + ": " + file.getAbsolutePath());
        }
        if (fileKind.readAsBundle) {
            DKUFileUtils.forceDelete((File)file);
        }
    }

    public static void archiveDirectoryToOutputStream(File directoryToArchive, FilenameFilter filter, OutputStream outputStream) throws IOException {
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(outputStream);){
            tos.setLongFileMode(3);
            tos.setAddPaxHeadersForNonAsciiNames(true);
            tos.setBigNumberMode(2);
            if (!DKUFileUtils.isFileOrDirectory((File)directoryToArchive)) {
                throw new IllegalArgumentException("Cannot download: " + String.valueOf(directoryToArchive) + ", not supported");
            }
            RemoteRunFileExchangeService.addNoSymlinkDirectoryToTar(tos, directoryToArchive, filter, null);
            tos.flush();
        }
    }

    private static void addNoSymlinkDirectoryToTar(TarArchiveOutputStream tos, File directory, FilenameFilter filter, String prefix) throws IOException {
        assert (directory.isDirectory());
        assert (directory.canRead());
        for (File file : directory.listFiles(filter)) {
            String pathInTar = (String)(prefix == null ? "" : prefix + "/") + file.getName();
            BasicFileAttributes basicFileAttributes = DKUFileUtils.getAttributesNoFollowLinksOrNull((File)file);
            if (basicFileAttributes == null) continue;
            if (basicFileAttributes.isRegularFile()) {
                tos.putArchiveEntry(new TarArchiveEntry(file, pathInTar));
                try (FileInputStream in = new FileInputStream(file);){
                    IOUtils.copy((InputStream)in, (OutputStream)tos);
                }
                tos.closeArchiveEntry();
                continue;
            }
            if (basicFileAttributes.isDirectory()) {
                tos.putArchiveEntry(new TarArchiveEntry(file, pathInTar));
                tos.closeArchiveEntry();
                RemoteRunFileExchangeService.addNoSymlinkDirectoryToTar(tos, file, filter, pathInTar);
                continue;
            }
            logger.warn((Object)("TAR compression: skipping non-file non-directory " + file.getAbsolutePath()));
        }
    }

    private File getPreparedProjectLibsBundleForJob(RemoteRunsRegistry.Execution execution) throws IOException {
        AutoDelete tmpDir = FlowJobUtils.getTmpFolder("project-libs-remoterun", execution.id);
        ProjectLibsBundler.prepareProjectLibsBundleForJob(execution.projectKey, (File)tmpDir);
        return tmpDir;
    }

    private File getPreparedProjectLibsBundleForNonJob(RemoteRunsRegistry.Execution execution) throws IOException, DKUSecurityException {
        AutoDelete tmpDir = FlowJobUtils.getTmpFolder("project-libs-remoterun", execution.id);
        ProjectLibsBundler.prepareProjectLibsBundleForNonJob(execution.projectKey, execution.authCtx, (File)tmpDir);
        return tmpDir;
    }

    private File getFilteredFile(String path, String executionPath, Set<String> filteredPaths) throws IOException {
        logger.debug((Object)("File for yarn-cluster path=" + path + " runDir=" + executionPath + " filteredPaths= " + JSON.log(filteredPaths)));
        File runDir = new File(executionPath);
        File file = path.startsWith("/") ? new File(path) : new File(runDir, path);
        for (String readable : filteredPaths) {
            File readableFile = new File(readable);
            if (!DKUFileUtils.isFileOrDirectory((File)readableFile) || !DKUFileUtils.isWithinOrSameFollowLinks((File)readableFile, (File)file)) continue;
            return file;
        }
        if (DKUFileUtils.isFileOrDirectory((File)runDir) && DKUFileUtils.isWithinOrSameFollowLinks((File)runDir, (File)file)) {
            return file;
        }
        throw new IllegalArgumentException("Path '" + path + "' is not in any readable location : " + JSON.log(filteredPaths));
    }

    private File getFileToWrite(RemoteRunsRegistry.Execution execution, FileKind fileKind, String path) throws IOException, DKUSecurityException {
        File file;
        if (!fileKind.writable) {
            throw new SecurityException("Cannot write files of kind " + String.valueOf((Object)fileKind));
        }
        if (this.executionTypesWithoutWriteAccess.contains((Object)execution.type)) {
            throw new SecurityException("Cannot write files with execution type: " + execution.type.toString());
        }
        if (fileKind == FileKind.FILTERED_PATHS) {
            file = this.getFilteredFile(path, execution.executionPath, execution.writablePaths);
        } else {
            file = this.getFile(execution, fileKind, null, null);
            if (StringUtils.isEmpty((String)(path = PathUtils.slashes((String)path, (Boolean)false, (Boolean)false, (boolean)true, (String)"")))) {
                throw new IllegalArgumentException("No file path specified");
            }
            file = DKUFileUtils.getWithinFollowLink((File)file, (String[])new String[]{path});
        }
        return file;
    }

    public void processFileDelete(RemoteRunsRegistry.Execution execution, FileKind fileKind, String path) throws IOException, DKUSecurityException {
        File file = this.getFileToWrite(execution, fileKind, path);
        DKUFileUtils.forceDelete((File)file);
    }

    public void processMLFileDelete(RemoteRunsRegistry.Execution execution, FileKind fileKind, String path, String savedModelProjectKey, String savedModelId) throws IOException, DKUSecurityException {
        File file = RemoteRunFileExchangeService.getMLFile(fileKind, path, savedModelProjectKey, savedModelId);
        if (this.executionTypesWithoutWriteAccess.contains((Object)execution.type)) {
            throw new SecurityException("Cannot write files with execution type: " + execution.type.toString());
        }
        DKUFileUtils.forceDelete((File)file);
    }

    public void processMLFileUpload(RemoteRunsRegistry.Execution execution, FileKind fileKind, String path, String savedModelProjectKey, String savedModelId, InputStream in, boolean expand) throws IOException {
        File mlFile = RemoteRunFileExchangeService.getMLFile(fileKind, path, savedModelProjectKey, savedModelId);
        if (this.executionTypesWithoutWriteAccess.contains((Object)execution.type)) {
            throw new SecurityException("Cannot write files with execution type: " + execution.type.toString());
        }
        logger.info((Object)("Put ML file, savedModel=" + savedModelId + ", path=" + path));
        try (FileOutputStream fos = new FileOutputStream(mlFile);){
            IOUtils.copy((InputStream)in, (OutputStream)fos);
        }
        if (expand) {
            FilenameFilter filter = this.getStaticFilter(execution, fileKind, false);
            TarArchiveUtils.extractTarGzFile(mlFile, filter);
        }
        if (execution.uploadListener != null) {
            execution.uploadListener.notifyUpload(path);
        }
    }

    public void processFileUpload(RemoteRunsRegistry.Execution execution, FileKind fileKind, String path, MultipartFile src, boolean expand) throws Exception {
        File file = this.getFileToWrite(execution, fileKind, path);
        src.transferTo(file);
        if (expand) {
            FilenameFilter filter = this.getStaticFilter(execution, fileKind, false);
            TarArchiveUtils.extractTarGzFile(file, filter);
        }
        if (execution.uploadListener != null) {
            execution.uploadListener.notifyUpload(path);
        }
    }

    public void processFileUpload(RemoteRunsRegistry.Execution execution, FileKind fileKind, String path, InputStream in, boolean expand) throws IOException, DKUSecurityException {
        File file = this.getFileToWrite(execution, fileKind, path);
        try (FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.copy((InputStream)in, (OutputStream)fos);
        }
        if (expand) {
            FilenameFilter filter = this.getStaticFilter(execution, fileKind, false);
            TarArchiveUtils.extractTarGzFile(file, filter);
        }
        if (execution.uploadListener != null) {
            execution.uploadListener.notifyUpload(path);
        }
    }

    private File getFile(RemoteRunsRegistry.Execution execution, FileKind fileKind, @Nullable String pluginId, @Nullable String codeEnvName) throws IOException, DKUSecurityException {
        File file = null;
        block0 : switch (fileKind) {
            case DSS_LIB: {
                if ("1".equals(System.getenv("DSS_DEV"))) {
                    file = DKUApp.getInstallFile((String[])new String[]{"src", "main", "python"});
                    break;
                }
                file = DKUApp.getInstallFile((String[])new String[]{"python"});
                break;
            }
            case PROJECT_LIB: {
                switch (execution.type) {
                    case RECIPE_PYTHON: 
                    case RECIPE_PREDICTION_TRAIN_PYTHON: 
                    case RECIPE_CLUSTERING_TRAIN_PYTHON: 
                    case RECIPE_PREDICTION_TRAIN_DEEPHUB: 
                    case RECIPE_PREDICTION_TRAIN_TIMESERIES: 
                    case RECIPE_PREDICTION_TRAIN_CAUSAL: 
                    case RECIPE_PREDICTION_SCORE_PYTHON: 
                    case RECIPE_PREDICTION_SCORE_DEEPHUB: 
                    case RECIPE_PREDICTION_SCORE_KERAS: 
                    case RECIPE_PREDICTION_SCORE_MLFLOW: 
                    case RECIPE_PREDICTION_SCORE_TIMESERIES: 
                    case RECIPE_PREDICTION_SCORE_CAUSAL: 
                    case RECIPE_PREDICTION_EVAL_PYTHON: 
                    case RECIPE_PREDICTION_EVAL_KERAS: 
                    case RECIPE_PREDICTION_EVAL_MLFLOW: 
                    case RECIPE_PREDICTION_EVAL_TIMESERIES: 
                    case RECIPE_PREDICTION_EVAL_CAUSAL: 
                    case RECIPE_PREDICTION_STANDALONE_EVAL_PYTHON: 
                    case RECIPE_LLM_EVALUATION_PYTHON: 
                    case RECIPE_CLUSTERING_SCORE_PYTHON: 
                    case RECIPE_CLUSTERING_CLUSTER_PYTHON: 
                    case RECIPE_R: 
                    case RECIPE_FINE_TUNING_LLM: {
                        file = this.getPreparedProjectLibsBundleForJob(execution);
                        break;
                    }
                    case CODE_STUDIO: 
                    case RECIPE_CPYTHON: 
                    case NOTEBOOK_PYTHON: 
                    case DOCTOR_PYTHON: 
                    case NOTEBOOK_R: 
                    case WEBAPP_STD: 
                    case WEBAPP_SHINY: 
                    case WEBAPP_BOKEH: 
                    case WEBAPP_DASH: 
                    case WEBAPP_STREAMLIT: 
                    case ML_INTERACTIVE_SCORING: {
                        file = this.getPreparedProjectLibsBundleForNonJob(execution);
                        break;
                    }
                    case SIMPLE_PYTHON: {
                        file = ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.JEK ? this.getPreparedProjectLibsBundleForJob(execution) : this.getPreparedProjectLibsBundleForNonJob(execution);
                    }
                }
                break;
            }
            case INSTANCE_LIB: {
                switch (execution.type) {
                    case RECIPE_PYTHON: 
                    case RECIPE_PREDICTION_TRAIN_PYTHON: 
                    case RECIPE_CLUSTERING_TRAIN_PYTHON: 
                    case RECIPE_PREDICTION_TRAIN_DEEPHUB: 
                    case RECIPE_PREDICTION_TRAIN_TIMESERIES: 
                    case RECIPE_PREDICTION_TRAIN_CAUSAL: 
                    case RECIPE_PREDICTION_SCORE_PYTHON: 
                    case RECIPE_PREDICTION_SCORE_DEEPHUB: 
                    case RECIPE_PREDICTION_SCORE_KERAS: 
                    case RECIPE_PREDICTION_SCORE_MLFLOW: 
                    case RECIPE_PREDICTION_SCORE_TIMESERIES: 
                    case RECIPE_PREDICTION_SCORE_CAUSAL: 
                    case RECIPE_PREDICTION_EVAL_PYTHON: 
                    case RECIPE_PREDICTION_EVAL_KERAS: 
                    case RECIPE_PREDICTION_EVAL_MLFLOW: 
                    case RECIPE_PREDICTION_EVAL_TIMESERIES: 
                    case RECIPE_PREDICTION_EVAL_CAUSAL: 
                    case RECIPE_PREDICTION_STANDALONE_EVAL_PYTHON: 
                    case RECIPE_LLM_EVALUATION_PYTHON: 
                    case RECIPE_CLUSTERING_SCORE_PYTHON: 
                    case RECIPE_CLUSTERING_CLUSTER_PYTHON: 
                    case RECIPE_FINE_TUNING_LLM: 
                    case CODE_STUDIO: 
                    case RECIPE_CPYTHON: 
                    case NOTEBOOK_PYTHON: 
                    case DOCTOR_PYTHON: 
                    case WEBAPP_STD: 
                    case WEBAPP_BOKEH: 
                    case WEBAPP_DASH: 
                    case WEBAPP_STREAMLIT: 
                    case ML_INTERACTIVE_SCORING: 
                    case SIMPLE_PYTHON: {
                        file = ApplicationConfigurator.getFile((String)"lib/python");
                        break block0;
                    }
                    case RECIPE_R: 
                    case NOTEBOOK_R: 
                    case WEBAPP_SHINY: {
                        file = ApplicationConfigurator.getFile((String)"lib/R");
                        break block0;
                    }
                }
                break;
            }
            case CONTEXT_DIR: {
                switch (execution.type) {
                    case RECIPE_PYTHON: 
                    case RECIPE_PREDICTION_TRAIN_PYTHON: 
                    case RECIPE_CLUSTERING_TRAIN_PYTHON: 
                    case RECIPE_PREDICTION_TRAIN_DEEPHUB: 
                    case RECIPE_PREDICTION_TRAIN_TIMESERIES: 
                    case RECIPE_PREDICTION_TRAIN_CAUSAL: 
                    case RECIPE_PREDICTION_SCORE_PYTHON: 
                    case RECIPE_PREDICTION_SCORE_DEEPHUB: 
                    case RECIPE_PREDICTION_SCORE_KERAS: 
                    case RECIPE_PREDICTION_SCORE_MLFLOW: 
                    case RECIPE_PREDICTION_SCORE_TIMESERIES: 
                    case RECIPE_PREDICTION_SCORE_CAUSAL: 
                    case RECIPE_PREDICTION_EVAL_PYTHON: 
                    case RECIPE_PREDICTION_EVAL_KERAS: 
                    case RECIPE_PREDICTION_EVAL_MLFLOW: 
                    case RECIPE_PREDICTION_EVAL_TIMESERIES: 
                    case RECIPE_PREDICTION_EVAL_CAUSAL: 
                    case RECIPE_PREDICTION_STANDALONE_EVAL_PYTHON: 
                    case RECIPE_LLM_EVALUATION_PYTHON: 
                    case RECIPE_CLUSTERING_SCORE_PYTHON: 
                    case RECIPE_CLUSTERING_CLUSTER_PYTHON: 
                    case RECIPE_R: 
                    case RECIPE_FINE_TUNING_LLM: 
                    case CODE_STUDIO: 
                    case RECIPE_CPYTHON: 
                    case NOTEBOOK_PYTHON: 
                    case DOCTOR_PYTHON: 
                    case NOTEBOOK_R: 
                    case WEBAPP_STD: 
                    case WEBAPP_SHINY: 
                    case WEBAPP_BOKEH: 
                    case WEBAPP_DASH: 
                    case WEBAPP_STREAMLIT: 
                    case ML_INTERACTIVE_SCORING: 
                    case SIMPLE_PYTHON: 
                    case RECIPE_AGENT_EVALUATION_PYTHON: 
                    case CDE: {
                        file = new File(execution.contextPath);
                        break block0;
                    }
                }
                break;
            }
            case EXECUTION_DIR: {
                switch (execution.type) {
                    case RECIPE_PYTHON: 
                    case RECIPE_PREDICTION_TRAIN_PYTHON: 
                    case RECIPE_CLUSTERING_TRAIN_PYTHON: 
                    case RECIPE_PREDICTION_TRAIN_DEEPHUB: 
                    case RECIPE_PREDICTION_TRAIN_TIMESERIES: 
                    case RECIPE_PREDICTION_TRAIN_CAUSAL: 
                    case RECIPE_PREDICTION_SCORE_PYTHON: 
                    case RECIPE_PREDICTION_SCORE_DEEPHUB: 
                    case RECIPE_PREDICTION_SCORE_KERAS: 
                    case RECIPE_PREDICTION_SCORE_MLFLOW: 
                    case RECIPE_PREDICTION_SCORE_TIMESERIES: 
                    case RECIPE_PREDICTION_SCORE_CAUSAL: 
                    case RECIPE_PREDICTION_EVAL_PYTHON: 
                    case RECIPE_PREDICTION_EVAL_KERAS: 
                    case RECIPE_PREDICTION_EVAL_MLFLOW: 
                    case RECIPE_PREDICTION_EVAL_TIMESERIES: 
                    case RECIPE_PREDICTION_EVAL_CAUSAL: 
                    case RECIPE_PREDICTION_STANDALONE_EVAL_PYTHON: 
                    case RECIPE_LLM_EVALUATION_PYTHON: 
                    case RECIPE_CLUSTERING_SCORE_PYTHON: 
                    case RECIPE_CLUSTERING_CLUSTER_PYTHON: 
                    case RECIPE_R: 
                    case RECIPE_FINE_TUNING_LLM: 
                    case CODE_STUDIO: 
                    case RECIPE_CPYTHON: 
                    case NOTEBOOK_PYTHON: 
                    case DOCTOR_PYTHON: 
                    case NOTEBOOK_R: 
                    case WEBAPP_STD: 
                    case WEBAPP_SHINY: 
                    case WEBAPP_BOKEH: 
                    case WEBAPP_DASH: 
                    case WEBAPP_STREAMLIT: 
                    case ML_INTERACTIVE_SCORING: 
                    case SIMPLE_PYTHON: 
                    case RECIPE_AGENT_EVALUATION_PYTHON: 
                    case CDE: {
                        file = new File(execution.executionPath);
                        break block0;
                    }
                }
                break;
            }
            case CODE_ENV_RESOURCE: {
                switch (execution.type) {
                    case RECIPE_R: 
                    case NOTEBOOK_R: 
                    case WEBAPP_SHINY: 
                    case SPARK: {
                        break block0;
                    }
                }
                CodeEnvModel.EnvFullRef codeEnv = (CodeEnvModel.EnvFullRef)execution.codeEnvs.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("No code env from which to fetch"));
                if (StringUtils.isNotBlank((String)codeEnvName)) {
                    codeEnv = execution.codeEnvs.stream().filter(c2 -> StringUtils.equals((String)c2.name, (String)codeEnvName)).findFirst().orElseThrow(() -> new IllegalArgumentException("No code env named: " + codeEnvName));
                }
                switch (ApplicationConfigurator.getNodeType()) {
                    case AUTOMATION: {
                        file = new File(AutomationNodeCodeEnvsService.getResourcesPath(codeEnv.lang, codeEnv.name, codeEnv.version));
                        break block0;
                    }
                    case DESIGN: {
                        file = new File(DesignNodeCodeEnvsService.getResourcesPath(codeEnv.lang, codeEnv.name));
                        break block0;
                    }
                }
                throw new DSSInternalErrorException("Unreachable");
            }
            case PLUGIN: {
                switch (execution.type) {
                    case RECIPE_PYTHON: 
                    case RECIPE_R: 
                    case RECIPE_CPYTHON: 
                    case WEBAPP_STD: 
                    case WEBAPP_SHINY: 
                    case WEBAPP_BOKEH: 
                    case WEBAPP_DASH: 
                    case WEBAPP_STREAMLIT: 
                    case SIMPLE_PYTHON: {
                        file = this.pluginsRegistry.getActualPluginFolder(pluginId);
                    }
                }
                break;
            }
            case FILTERED_PATHS: {
                throw new DSSInternalErrorException("Unreachable");
            }
        }
        if (file == null) {
            throw new IllegalArgumentException("Unsupported file type " + String.valueOf((Object)fileKind) + " for " + String.valueOf((Object)execution.type) + " execution");
        }
        if (!DKUFileUtils.isFileOrDirectory(file)) {
            throw new IllegalStateException("File:" + String.valueOf(file) + " cannot be manipulated, it must be a directory or a file");
        }
        return file;
    }

    private FilenameFilter getStaticFilter(RemoteRunsRegistry.Execution execution, FileKind fileKind, boolean read) {
        List<RemoteRunsRegistry.ExecutionType> executionWithLogsToFilter = Arrays.asList(RemoteRunsRegistry.ExecutionType.DOCTOR_PYTHON, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_SCORE_PYTHON, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_SCORE_KERAS, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_SCORE_MLFLOW, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_SCORE_TIMESERIES, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_SCORE_CAUSAL, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_EVAL_PYTHON, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_STANDALONE_EVAL_PYTHON, RemoteRunsRegistry.ExecutionType.RECIPE_LLM_EVALUATION_PYTHON, RemoteRunsRegistry.ExecutionType.RECIPE_AGENT_EVALUATION_PYTHON, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_EVAL_KERAS, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_EVAL_MLFLOW, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_EVAL_TIMESERIES, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_EVAL_CAUSAL, RemoteRunsRegistry.ExecutionType.RECIPE_CLUSTERING_SCORE_PYTHON, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_SCORE_DEEPHUB);
        if (read && executionWithLogsToFilter.contains((Object)execution.type) && (fileKind == FileKind.CONTEXT_DIR || fileKind == FileKind.EXECUTION_DIR)) {
            return FILTER_LOGS;
        }
        if (fileKind == FileKind.LOCAL_HF_FILE) {
            return FILTER_OUTPUT_FOLDER;
        }
        return FILTER_NONE;
    }

    public static enum FileKind {
        DSS_LIB(true, false, false),
        PROJECT_LIB(true, false, true),
        INSTANCE_LIB(true, false, false),
        PLUGIN(true, false, false),
        CONTEXT_DIR(true, true, false),
        EXECUTION_DIR(true, true, false),
        FILTERED_PATHS(true, true, false),
        ML_FILES(true, true, false),
        LOCAL_HF_FILE(true, false, false),
        MODEL_CACHE(true, false, false),
        CODE_ENV_RESOURCE(true, false, false),
        KB_FILES(true, false, false);

        private final boolean readable;
        private final boolean writable;
        private final boolean readAsBundle;

        private FileKind(boolean readable, boolean writable, boolean readAsBundle) {
            this.readable = readable;
            this.writable = writable;
            this.readAsBundle = readAsBundle;
        }
    }
}

