/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.reports;

import com.dataiku.dip.enterpriseassetlibrary.EnterpriseAssetCollection;
import com.dataiku.dip.reports.ReportsManagementService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterpriseAssetLibraryService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class EnterpriseAssetLibraryReportBuilder {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private EnterpriseAssetLibraryService enterpriseAssetLibraryService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.usage.enterpriseassetlibrary");

    public EnterpriseAssetLibraryReportBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public ReportsManagementService.ReadyReport buildReport() {
        EnterpriseAssetLibraryReport o = this.build();
        return new ReportsManagementService.ReadyReport("enterprise-asset-library-usage-summary", JSON.toJsonObject((Object)o, (String[])new String[0]));
    }

    @NotNull
    private EnterpriseAssetLibraryReport build() {
        int projectsCount = 0;
        int promptsCount = 0;
        int collectionsCount = 0;
        try (Transaction tr = this.transactionService.beginRead();){
            List<EnterpriseAssetCollection> collections = this.enterpriseAssetLibraryService.listCollections();
            for (EnterpriseAssetCollection collection : collections) {
                if (collection.getId().equals("DATAIKU")) continue;
                ++collectionsCount;
                try {
                    projectsCount += this.enterpriseAssetLibraryService.getProjects(collection.getId()).size();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to get projects on collection " + collection.getId()));
                }
                try {
                    promptsCount += this.enterpriseAssetLibraryService.getPrompts(collection.getId()).size();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to get prompts on collection " + collection.getId()));
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"Failed to build enterprise asset library report", (Throwable)e);
        }
        return new EnterpriseAssetLibraryReport(projectsCount, promptsCount, collectionsCount);
    }

    private static class EnterpriseAssetLibraryReport {
        public int projectsCount;
        public int promptsCount;
        public int collectionsCount;

        public EnterpriseAssetLibraryReport(int projectsCount, int promptsCount, int collectionsCount) {
            this.projectsCount = projectsCount;
            this.promptsCount = promptsCount;
            this.collectionsCount = collectionsCount;
        }
    }
}

