/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.MetricsLaunchService;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.scheduler.ScenarioThread;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepParamsWithComputables;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public class ComputeMetricsStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return ComputeMetricsStepParams.class;
        }

        @Override
        public String getType() {
            return "compute_metrics";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new ComputeMetricsStepRunner(scenario, step, step.getParamsAs(ComputeMetricsStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            ComputeMetricsStepParams params = step.getParamsAs(ComputeMetricsStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("compute metrics of");
            if (params != null) {
                for (FlowComputableSpecification built : params.getComputes()) {
                    sb.append(" ");
                    sb.append(built.getItemName());
                }
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            ComputeMetricsStepParams params = step.getParamsAs(ComputeMetricsStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("comp_metrics");
            if (params != null) {
                for (FlowComputableSpecification built : params.getComputes()) {
                    sb.append("_");
                    sb.append(built.getPartitionInvariantId());
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario scenario, Step step, PluginUsagesInspector pluginUsagesInspector) {
            ComputeMetricsStepParams stepParams = (ComputeMetricsStepParams)step.params;
            if (null != stepParams && null != stepParams.computes) {
                return StepMeta.UnavailableStepInfo.checkFlowComputableSpecs(scenario, step, pluginUsagesInspector, stepParams.computes, logger);
            }
            return null;
        }
    };
    private final ComputeMetricsStepParams params;
    private final Scenario scenario;
    private final Step step;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private MetricsLaunchService metricsLaunchService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.computemetrics");

    ComputeMetricsStepRunner(Scenario scenario, Step step, ComputeMetricsStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        VariablesContext variablesContext = this.variablesService.getForProject(this.scenario.getProjectKey());
        StrSubstitutor substitutor = new StrSubstitutor(variablesContext.getAllVariables());
        String scenarioProjectKey = this.scenario.getProjectKey();
        HashMap reportsByPartition = Maps.newHashMap();
        MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
        environment.startedFromBuild = false;
        try (Transaction t = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
            environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
            environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
        }
        Iterator<FlowComputableSpecification> iterator = this.params.computes.iterator();
        block23: while (true) {
            Object object;
            if (!iterator.hasNext()) {
                logger.info((Object)("Done step " + this.step.name));
                stepRun.payload = reportsByPartition;
                stepRun.getScenarioRun().withStepRunOutput(stepRun, reportsByPartition);
                stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
                return;
            }
            FlowComputableSpecification compute = iterator.next();
            try (Transaction t = this.transactionService.beginRead();){
                object = compute.resolveTarget(scenarioProjectKey, this.datasetsDAO, this.managedFolderDAO, this.savedModelsDAO, this.modelEvaluationStoresDAO, this.retrievableKnowledgeDAO);
            }
            List<Partition> toCompute = compute.resolvePartitions_NT(object, substitutor, null, null, this.modelEvaluationStoresCRUDService);
            logger.info((Object)("Computing metrics of " + toCompute.size() + " partitions of " + compute.getItemName()));
            Iterator<Partition> iterator2 = toCompute.iterator();
            while (true) {
                String string;
                AnyLoc anyLoc;
                ReportItem.ComputedMetrics reportItem;
                block32: {
                    block31: {
                        if (!iterator2.hasNext()) continue block23;
                        Partition partition = iterator2.next();
                        ScenarioThread.checkInterrupted();
                        ReportTargetItem datasetItem = compute.getTargetItem(this.scenario.getProjectKey(), partition != null ? partition.id() : null);
                        reportItem = (ReportItem.ComputedMetrics)new ReportItem.ComputedMetrics(datasetItem).withStart(DateTime.now().getMillis());
                        try {
                            FutureResponse<MetricsComputationService.MetricsComputationReport> metricsFuture = null;
                            DSSAuthCtx runAsUser = stepRun.getScenarioRun().getRunAsUser();
                            switch (compute.type) {
                                case DATASET: {
                                    metricsFuture = this.metricsLaunchService.launchComputeMetrics((AuthCtx)runAsUser, (Dataset)object, partition, new MetricsEngineDesc.MetricsEngineContext(runAsUser), environment);
                                    break;
                                }
                                case MANAGED_FOLDER: {
                                    metricsFuture = this.metricsLaunchService.launchComputeMetrics((AuthCtx)runAsUser, (ManagedFolder)object, partition, new MetricsEngineDesc.MetricsEngineContext(runAsUser), environment);
                                    break;
                                }
                                case SAVED_MODEL: {
                                    metricsFuture = this.metricsLaunchService.launchComputeMetrics(runAsUser, (SavedModel)object, new MetricsEngineDesc.MetricsEngineContext(runAsUser), environment);
                                    break;
                                }
                                case STREAMING_ENDPOINT: {
                                    throw new IllegalStateException("Streaming endpoints are not built");
                                }
                                case MODEL_EVALUATION_STORE: {
                                    throw new IllegalStateException("Model evaluation stores do not have metrics");
                                }
                                case RETRIEVABLE_KNOWLEDGE: {
                                    throw new IllegalStateException("Knowledge banks do not have metrics");
                                }
                            }
                            if (metricsFuture == null) {
                                throw ErrorContext.iae((String)("Invalid compute type: " + String.valueOf((Object)compute.type)));
                            }
                            metricsFuture = this.futureService.waitForFinalResponse(metricsFuture);
                            MetricsComputationService.MetricsComputationReport results = (MetricsComputationService.MetricsComputationReport)metricsFuture.result;
                            results.target = datasetItem;
                            reportItem = reportItem.withMetricCount(results == null ? 0 : results.computed.size());
                            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
                            reportsByPartition.put(String.valueOf(compute.getLoc(scenarioProjectKey)) + "_" + (partition != null ? partition.id() : ""), results);
                            anyLoc = compute.getLoc(scenarioProjectKey);
                            if (partition == null) break block31;
                        }
                        catch (InterruptedException iex) {
                            try {
                                throw iex;
                                catch (Throwable ex) {
                                    reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED).withThrown(ex);
                                    throw ex;
                                }
                            }
                            catch (Throwable throwable) {
                                this.jobsDatabaseService.tryRegisterFlowObjectEvent(compute.getLoc(scenarioProjectKey), partition != null ? partition.id() : null, null, stepRun.getScenarioRun(), stepRun, reportItem);
                                throw throwable;
                            }
                        }
                        string = partition.id();
                        break block32;
                    }
                    string = null;
                }
                this.jobsDatabaseService.tryRegisterFlowObjectEvent(anyLoc, string, null, stepRun.getScenarioRun(), stepRun, reportItem);
            }
            break;
        }
    }

    public static class ComputeMetricsStepParams
    extends NonFatalStepParams
    implements StepParams,
    StepParamsWithComputables {
        public List<FlowComputableSpecification> computes = Lists.newArrayList();

        public List<FlowComputableSpecification> getComputes() {
            return Lists.newArrayList(this.computes);
        }

        public ComputeMetricsStepParams withComputes(List<FlowComputableSpecification> computes) {
            this.computes = Lists.newArrayList(computes);
            return this;
        }

        public ComputeMetricsStepParams withComputes(FlowComputableSpecification ... computes) {
            this.computes = Lists.newArrayList((Object[])computes);
            return this;
        }

        @Override
        public Collection<FlowComputableSpecification> getComputablesSpec() {
            return this.getComputes();
        }
    }
}

