/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClustersService;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.scheduler.ScenarioThread;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.scheduler.steps.TearDownClusterStepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class FinallyStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return FinallyStepParams.class;
        }

        @Override
        public String getType() {
            return "finally";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new FinallyStepRunner(step.getParamsAs(FinallyStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "Cleanup";
        }

        @Override
        public String buildId(Step step) {
            return "finally";
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    @Autowired
    private ClustersService clustersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    private final FinallyStepParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.finally");

    public FinallyStepRunner(FinallyStepParams params) {
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        DSSAuthCtx authCtx = stepRun.getScenarioRun().getRunAsUser();
        for (String clusterId : this.params.clusterIds) {
            Cluster cluster;
            ScenarioThread.checkInterrupted();
            try (Transaction t = this.transactionService.beginRead();){
                cluster = this.clustersService.getMandatoryUnsafe(clusterId);
            }
            logger.info((Object)"Stop the cluster");
            ReportTargetItem.ClusterItem clusterItem = new ReportTargetItem.ClusterItem(cluster.id);
            AnyLoc clusterLoc = new AnyLoc("__DKU_INSTANCE_CLUSTERS__", cluster.id);
            ReportItem.ToreDownCluster reportItem = (ReportItem.ToreDownCluster)new ReportItem.ToreDownCluster(clusterItem).withStart(DateTime.now().getMillis());
            try {
                if (cluster.state == Cluster.ClusterState.RUNNING) {
                    Object fr;
                    try (Transaction t = this.transactionService.beginRead();){
                        fr = this.clustersService.stop(authCtx, stepRun.getScenarioRun().getScenario().getProjectKey(), cluster, true, false);
                    }
                    if (!fr.hasResult) {
                        fr = this.futureService.waitForCompletion(fr.jobId);
                    }
                } else {
                    try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
                        this.clustersService.delete(clusterId);
                        t.commit("Deleted non-running cluster " + clusterId);
                    }
                }
                reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
            }
            catch (InterruptedException iex) {
                throw iex;
            }
            catch (Throwable ex) {
                reportItem.withThrown(ex).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
                logger.error((Object)"Failure while stopping the cluster", ex);
            }
            finally {
                this.jobsDatabaseService.tryRegisterFlowObjectEvent(clusterLoc, null, null, stepRun.getScenarioRun(), stepRun, reportItem);
            }
            TearDownClusterStepRunner.detachOneClusterFromScenarioRun(stepRun.getScenarioRun(), cluster.id);
        }
        stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
    }

    public static class FinallyStepParams
    implements StepParams {
        public List<String> clusterIds = Lists.newArrayList();
    }
}

