/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dashboards.insights.chart.ChartInsightParams;
import com.dataiku.dip.dashboards.insights.eda.EdaInsightParams;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.DashboardPage;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.Tile;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.eda.compute.sampling.Sample;
import com.dataiku.dip.eda.compute.sampling.SamplesService;
import com.dataiku.dip.eda.worksheets.CardComputeService;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.PivotTablesService;
import com.dataiku.dip.pivot.backend.dss.LinoCacheBuilderService;
import com.dataiku.dip.pivot.backend.dss.LinoPivotTablesService;
import com.dataiku.dip.scheduler.ScenarioThread;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.ChartsOnDatasetDataSpec;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.model.ShakerSamplingUtils;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NamedRWLock;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RefreshChartCacheStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public String getType() {
            return "refresh_chart_cache";
        }

        @Override
        public Class<? extends StepParams> paramsClass() {
            return RefreshChartCacheStepParams.class;
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new RefreshChartCacheStepRunner(step, step.getParamsAs(RefreshChartCacheStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            RefreshChartCacheStepParams rlcParams = step.getParamsAs(RefreshChartCacheStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("Refresh chart cache from dashboards");
            if (rlcParams != null) {
                for (RefreshItem d : rlcParams.dashboards) {
                    sb.append(" ");
                    sb.append(d.name);
                }
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            RefreshChartCacheStepParams rlcParams = step.getParamsAs(RefreshChartCacheStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("refresh_chart_cache");
            if (rlcParams != null) {
                for (RefreshItem d : rlcParams.dashboards) {
                    sb.append("_");
                    sb.append(d.smartName);
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DataService shakerDataService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private CardComputeService cardComputeService;
    @Autowired
    private SamplesService samplesService;
    private final RefreshChartCacheStepParams params;
    private final Step step;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenario.refreshchartchache");

    public RefreshChartCacheStepRunner(Step step, RefreshChartCacheStepParams params) {
        this.step = step;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        this.processCharts(stepRun);
        this.processEda(stepRun);
        stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
        logger.info((Object)("Done refresh chart cache step " + this.step.name));
        assert (stepReportItem.getOutcome() != null);
    }

    public void processCharts(StepRun stepRun) throws Exception {
        String contextProjectKey = stepRun.getScenarioRun().getScenario().getProjectKey();
        logger.info((Object)"Building the list of datasets to refresh");
        HashMap<String, DatasetWithSamplingInfos> datasets = new HashMap<String, DatasetWithSamplingInfos>();
        try (Transaction t = this.transactionService.beginRead();){
            this.addDatasetsFromDashboard(contextProjectKey, this.params.dashboards, datasets);
            this.addDatasetsFromCharts(contextProjectKey, this.params.datasets, datasets);
        }
        logger.info((Object)("Found datasets: " + StringUtils.join(datasets.keySet(), (String)", ")));
        DSSAuthCtx authCtx = stepRun.getScenarioRun().getRunAsUser();
        if (!datasets.isEmpty()) {
            ExecutorService executorService = Executors.newFixedThreadPool(Math.min(datasets.size(), 4));
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            for (DatasetWithSamplingInfos datasetWithSamplingInfos : datasets.values()) {
                ScenarioThread.checkInterrupted();
                Dataset dataset = datasetWithSamplingInfos.dataset;
                for (Map.Entry<String, SerializedShakerScript.RefreshableStreamableSelection> selectionEntry : datasetWithSamplingInfos.sampleSettings.entrySet()) {
                    SerializedShakerScript.RefreshableStreamableSelection sampleSettings = selectionEntry.getValue();
                    SerializedShakerScript script = datasetWithSamplingInfos.scripts.get(selectionEntry.getKey());
                    String datasetPath = dataset.getProjectKey() + "_" + dataset.getName();
                    if (dataset.getPartitioningSchema() != null && !dataset.getPartitioningSchema().isPartitioned() && sampleSettings.selection != null) {
                        sampleSettings.selection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.ALL;
                    }
                    script.contextProjectKey = dataset.getProjectKey();
                    script.origin = SerializedShakerScript.ShakerOrigin.DATASET_EXPLORE;
                    MemTable mt = this.shakerDataService.get_NOTRANSACTION((Dataset)dataset, (SerializedShakerScript)script, null, null, (boolean)true, (AuthCtx)authCtx).table;
                    String sampleId = ShakerSamplingUtils.computeSampleId(authCtx, dataset, sampleSettings, script.steps, mt);
                    File cacheFolder = LinoPivotTablesService.getLinoCacheFolder(datasetPath, sampleId, sampleSettings._refreshTrigger);
                    String lockName = "dku.pivot.lino.cacheBuild." + datasetPath + "." + sampleId;
                    Future<Void> future = executorService.submit(() -> {
                        block17: {
                            try (LinoReader cacheReader = this.params.force ? null : LinoPivotTablesService.getCachedReader(cacheFolder, null);
                                 AutoCloseableLock lock = NamedRWLock.acquireWrite((String)lockName);){
                                if (cacheReader == null) {
                                    logger.info((Object)("Rebuild cache: " + String.valueOf(cacheFolder)));
                                    try (FutureProgress.AutocloseableFutureProgressState buildState = FutureProgress.pushAutoCloseableState((String)"Building cache");){
                                        LinoCacheBuilderService.BuildLinoCacheFutureThread ft = new LinoCacheBuilderService.BuildLinoCacheFutureThread(null, dataset, script, sampleSettings, script.steps, authCtx, this.shakerDataService);
                                        this.futureService.runAndWait(ft, (TypeToken)new TypeToken<FutureResponse<LinoCacheBuilderService.BuildLinoCacheFutureResponse>>(){});
                                        break block17;
                                    }
                                }
                                logger.info((Object)("Not rebuilding because already cached: " + String.valueOf(cacheFolder)));
                            }
                        }
                        return null;
                    });
                    futures.add(future);
                }
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException iex) {
                    throw iex;
                }
                catch (Exception e) {
                    logger.error((Object)"Error processing cache rebuild task", (Throwable)e);
                }
            }
            executorService.shutdown();
        }
    }

    private void addDatasetsFromCharts(String contextProjectKey, List<RefreshItem> datasets, Map<String, DatasetWithSamplingInfos> data) throws IOException {
        for (RefreshItem datasetItem : datasets) {
            AnyLoc datasetFullName = DatasetLocUtils.DatasetLoc.resolveSmart(contextProjectKey, datasetItem.smartName);
            DatasetExploreSettings datasetExploreSettings = this.exploresService.get(datasetFullName.getProjectKey(), datasetFullName.getId());
            for (DatasetExploreSettings.DatasetChart chart : datasetExploreSettings.charts) {
                if (chart.engineType != SerializedShakerScript.ChartsEngine.LINO) continue;
                ChartsOnDatasetDataSpec spec = new ChartsOnDatasetDataSpec();
                spec.datasetProjectKey = datasetFullName.getProjectKey();
                spec.datasetName = datasetFullName.getId();
                spec.copySelectionFromScript = chart.copySelectionFromScript;
                spec.engineType = chart.engineType;
                spec.script = datasetExploreSettings.script;
                spec.sampleSettings = chart.refreshableSelection;
                PivotTablesService.expandSampleSettingsFromScriptIfNeeded(spec);
                this.addDataset(data, datasetFullName, spec.sampleSettings);
            }
        }
    }

    private void addDatasetsFromDashboard(String contextProjectKey, List<RefreshItem> dashboardItems, Map<String, DatasetWithSamplingInfos> data) throws IOException {
        for (RefreshItem d : dashboardItems) {
            AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveSmart(contextProjectKey, d.smartName);
            Dashboard dashboard = this.dashboardsService.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
            for (DashboardPage page : dashboard.pages) {
                for (Tile tile : page.getFlattenedTileList()) {
                    if (!"chart".equals(tile.insightType)) continue;
                    Insight insight = this.insightsService.getMandatoryUnsafe(dashboard.projectKey, tile.insightId);
                    ChartInsightParams chartParams = insight.getParamsAs(ChartInsightParams.class);
                    if (chartParams.engineType != SerializedShakerScript.ChartsEngine.LINO) continue;
                    AnyLoc datasetFullName = DatasetLocUtils.DatasetLoc.resolveSmart(contextProjectKey, chartParams.datasetSmartName);
                    this.addDataset(data, datasetFullName, chartParams.refreshableSelection);
                }
                if (page.filtersParams == null || !StringUtils.isNotBlank((String)page.filtersParams.datasetSmartName)) continue;
                this.addDataset(data, DatasetLocUtils.DatasetLoc.resolveSmart(contextProjectKey, page.filtersParams.datasetSmartName), page.filtersParams.refreshableSelection);
            }
        }
    }

    private void addDataset(Map<String, DatasetWithSamplingInfos> data, AnyLoc datasetFullName, SerializedShakerScript.RefreshableStreamableSelection refreshableSelection) {
        DatasetWithSamplingInfos datasetWithSamplingInfos = data.computeIfAbsent(datasetFullName.toString(), k -> {
            try {
                return new DatasetWithSamplingInfos(Dataset.fromSerializedUnsafe((SerializedDataset)this.datasetsDAO.getMandatory(datasetFullName)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        datasetWithSamplingInfos.add(refreshableSelection, () -> {
            try {
                return this.exploresService.get((String)datasetFullName.getProjectKey(), (String)datasetFullName.getId()).script;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void processEda(StepRun stepRun) throws Exception {
        String contextProjectKey = stepRun.getScenarioRun().getScenario().getProjectKey();
        DSSAuthCtx authCtx = stepRun.getScenarioRun().getRunAsUser();
        for (RefreshItem d : this.params.dashboards) {
            Dashboard dashboard;
            AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveSmart(contextProjectKey, d.smartName);
            try (Transaction t = this.transactionService.beginRead();){
                dashboard = this.dashboardsService.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
            }
            for (DashboardPage page : dashboard.pages) {
                for (Tile tile : page.getFlattenedTileList()) {
                    EdaInsightParams edaParams;
                    Insight insight;
                    if (!"eda".equals(tile.insightType)) continue;
                    try (Transaction t = this.transactionService.beginRead();){
                        insight = this.insightsService.getMandatoryUnsafe(dashboard.projectKey, tile.insightId);
                        edaParams = insight.getParamsAs(EdaInsightParams.class);
                    }
                    logger.info((Object)("Recomputing eda insight: " + insight.id));
                    Sample sample = this.samplesService.getOrRebuildCurrentSample_NT(authCtx, insight.getRef(), edaParams.dataSpec);
                    CardResult result = this.cardComputeService.computeResults_NT(authCtx, edaParams.card, false, sample);
                    RWTransaction t = this.transactionService.beginWriteAsDSS();
                    try {
                        this.insightsService.savePayload(insight, JSON.json((Object)((Object)result)));
                    }
                    finally {
                        if (t == null) continue;
                        t.close();
                    }
                }
            }
        }
    }

    public static class RefreshChartCacheStepParams
    extends NonFatalStepParams
    implements StepParams {
        public boolean force = false;
        public List<RefreshItem> dashboards = new ArrayList<RefreshItem>();
        public List<RefreshItem> datasets = new ArrayList<RefreshItem>();
    }

    static class DatasetWithSamplingInfos {
        Dataset dataset;
        Map<String, SerializedShakerScript.RefreshableStreamableSelection> sampleSettings;
        Map<String, SerializedShakerScript> scripts;

        DatasetWithSamplingInfos(Dataset dataset) {
            this.dataset = dataset;
            this.sampleSettings = new HashMap<String, SerializedShakerScript.RefreshableStreamableSelection>();
            this.scripts = new HashMap<String, SerializedShakerScript>();
        }

        public void add(SerializedShakerScript.RefreshableStreamableSelection setting, Supplier<SerializedShakerScript> getScript) {
            Object identifier = setting.selection.getIdentifier();
            if (setting.selection != null && setting.selection.filter != null && setting.selection.filter.enabled) {
                identifier = (String)identifier + ", filter=" + FilterDescUtils.getFilterRepr(setting.selection.filter);
            }
            this.sampleSettings.putIfAbsent((String)identifier, setting);
            this.scripts.computeIfAbsent((String)identifier, k -> (SerializedShakerScript)getScript.get());
        }
    }

    public static class RefreshItem {
        public String smartName;
        public String name;
    }
}

