/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.businessapps.BusinessAppsService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import java.io.IOException;
import java.sql.SQLException;
import javax.annotation.Nullable;

public interface IPermissionsService {
    public boolean hasDatasetPrivilege(AuthCtx var1, DatasetLocUtils.DatasetLoc var2, Privileges.DatasetLevelPrivilegeType var3) throws DKUSecurityException;

    public void checkDatasetPrivileges(AuthCtx var1, DatasetLocUtils.DatasetLoc var2, Privileges.DatasetLevelPrivilegeType ... var3) throws DKUSecurityException;

    public boolean hasAnyProjectAccess(AuthCtx var1, String var2) throws DKUSecurityException;

    public boolean hasAnyProjectAccess(AuthCtx var1, SerializedProject var2) throws DKUSecurityException;

    public boolean hasCustomProjectAccess(AuthCtx var1, String var2, Privileges.ProjectLevelPrivilegeType var3) throws DKUSecurityException;

    public boolean hasProjectPrivilege(AuthCtx var1, String var2, Privileges.ProjectLevelPrivilegeType var3) throws DKUSecurityException;

    public boolean hasProjectPrivilege(AuthCtx var1, SerializedProject var2, Privileges.ProjectLevelPrivilegeType var3) throws DKUSecurityException;

    public boolean hasAnyCodeEnvAccess(AuthCtx var1, CodeEnvModel.EnvLang var2, String var3) throws DKUSecurityException;

    public boolean hasCodeEnvPrivilege(AuthCtx var1, CodeEnvModel.EnvLang var2, String var3, Privileges.CodeEnvLevelPrivilegeType var4) throws DKUSecurityException;

    public boolean hasAnyClusterAccess(AuthCtx var1, String var2) throws DKUSecurityException;

    public boolean hasClusterPrivilege(AuthCtx var1, String var2, Privileges.ClusterLevelPrivilegeType var3) throws DKUSecurityException;

    public boolean hasAnyCodeStudioTemplateAccess(AuthCtx var1, String var2) throws DKUSecurityException;

    public boolean hasCodeStudioTemplatePrivilege(AuthCtx var1, String var2, Privileges.CodeStudioTemplatePrivilegeType var3) throws DKUSecurityException;

    public boolean hasCodeStudioTemplatePrivilege(AuthCtx var1, CodeStudioTemplate var2, Privileges.CodeStudioTemplatePrivilegeType var3) throws DKUSecurityException;

    public boolean hasProjectFolderPrivilege(AuthCtx var1, String var2, Privileges.ProjectFolderLevelPrivilegeType var3) throws DKUSecurityException;

    public boolean hasLabelingTaskPrivilege(AuthCtx var1, LabelingTask var2, Privileges.LabelingLevelPrivilegeType var3) throws DKUSecurityException;

    public boolean hasLabelingTaskPrivilege(AuthCtx var1, String var2, String var3, Privileges.LabelingLevelPrivilegeType var4) throws DKUSecurityException;

    public void checkAnyProjectAccess(AuthCtx var1, String var2) throws DKUSecurityException;

    public void checkProjectPrivileges(AuthCtx var1, String var2, Privileges.ProjectLevelPrivilegeType ... var3) throws DKUSecurityException;

    public void checkProjectPrivileges(AuthCtx var1, String var2, boolean var3, Privileges.ProjectLevelPrivilegeType ... var4) throws DKUSecurityException;

    public void checkCodeEnvPrivileges(AuthCtx var1, CodeEnvModel.EnvLang var2, String var3, Privileges.CodeEnvLevelPrivilegeType ... var4) throws DKUSecurityException;

    public void checkClusterPrivileges(AuthCtx var1, String var2, Privileges.ClusterLevelPrivilegeType ... var3) throws DKUSecurityException;

    public boolean hasBusinessAppPrivileges(AuthCtx var1, String var2, BusinessAppsService.BusinessAppPrivilegeType ... var3) throws Exception;

    public void checkProjectFolderPrivilege(AuthCtx var1, String var2, Privileges.ProjectFolderLevelPrivilegeType ... var3) throws DKUSecurityException;

    public boolean hasAnyPluginPresetAccess(AuthCtx var1, String var2, String var3, String var4, String var5) throws DKUSecurityException;

    public boolean hasPluginPresetPrivilege(AuthCtx var1, String var2, String var3, String var4, String var5, Privileges.PluginPresetLevelPrivilegeType var6) throws DKUSecurityException;

    public boolean hasPluginPrivilege(AuthCtx var1, String var2, Privileges.PluginLevelPrivilegeType var3) throws DKUSecurityException;

    public void checkPluginPrivileges(AuthCtx var1, String var2, Privileges.PluginLevelPrivilegeType ... var3) throws DKUSecurityException;

    public boolean hasPluginParameterSetPrivilege(AuthCtx var1, String var2, String var3, Privileges.PluginParameterSetLevelPrivilegeType var4) throws DKUSecurityException;

    public void checkPluginParameterSetPrivileges(AuthCtx var1, String var2, String var3, Privileges.PluginParameterSetLevelPrivilegeType ... var4) throws DKUSecurityException;

    public boolean isAdmin(AuthCtx var1);

    public void checkAdmin(AuthCtx var1) throws UnauthorizedException;

    public void checkAdmin(AuthCtx var1, String var2) throws UnauthorizedException;

    public boolean hasAdditionalCloudDataikerAdminPermission(AuthCtx var1);

    public void checkAdditionalCloudDataikerAdminPermission(AuthCtx var1) throws UnauthorizedException;

    public boolean isCloudDataikerAdmin(AuthCtx var1);

    public void checkSQLikePrivilege(AuthCtx var1, DSSConnection var2) throws DKUSecurityException;

    public void checkCreateCodeEnvPrivilege(AuthCtx var1) throws UnauthorizedException;

    public void checkCreateClusterPrivilege(AuthCtx var1) throws UnauthorizedException;

    public void checkCreateCodeStudioTemplatePrivilege(AuthCtx var1) throws UnauthorizedException;

    public void checkDevelopPluginPrivilege(AuthCtx var1) throws UnauthorizedException;

    public void checkEditLibFoldersPrivilege(AuthCtx var1) throws UnauthorizedException;

    public void checkCanCreateActiveWebContent(AuthCtx var1) throws UnauthorizedException;

    public boolean canCreateActiveWebContent(AuthCtx var1);

    public boolean canObtainAPITicketFromBrowserHeaders(AuthCtx var1, AuthCtx var2) throws DKUSecurityException;

    public void checkCanCreateProjectFromMacro(AuthCtx var1) throws UnauthorizedException;

    public void checkReadDashboardPermission(AuthCtx var1, String var2, @Nullable ITaggingService.TaggableType var3, @Nullable String var4) throws DKUSecurityException;

    public boolean hasReadDashboardPermission(AuthCtx var1, String var2, @Nullable ITaggingService.TaggableType var3, @Nullable String var4) throws DKUSecurityException;

    public void checkManageFeatureStorePrivilege(AuthCtx var1) throws UnauthorizedException;

    public void checkCanExportAndManageBundles(AuthCtx var1, String var2) throws DKUSecurityException;

    public void checkUserDefinedCustomSqlFilters(AuthCtx var1, Dataset var2, DatasetSelection var3) throws IOException, DKUSecurityException, SQLException;

    public void checkUnsafeCodePermission(AuthCtx var1, Transaction var2, GitModel.MultiCommitDiff var3) throws DKUSecurityException, IOException;
}

