/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.model;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class OAuth2ConfigDiscovery {
    private static final int HTTP_CONNECT_TIMEOUT = 15000;
    private static final int HTTP_READ_TIMEOUT = 15000;
    private static final Pattern RESOURCE_METADATA_URI_PATTERN = Pattern.compile("resource(?:_metadata)?(?:_uri)?=\"([^\"]+)\"");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.security.oauth.discovery");

    private static OAuthServerMetadata getOAuthServerMetadata(URI serverURI, String path) throws URISyntaxException {
        block8: {
            OAuthServerMetadata oAuthServerMetadata;
            URI candidateURI = new URI(serverURI.getScheme(), null, serverURI.getHost(), serverURI.getPort(), path, null, null);
            InputStreamReader reader = new InputStreamReader(candidateURI.toURL().openStream());
            try {
                oAuthServerMetadata = (OAuthServerMetadata)new Gson().fromJson((Reader)reader, OAuthServerMetadata.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException e) {
                    logger.warn((Object)("Failed to parse OAuth server metadata from " + String.valueOf(candidateURI) + ". Content was not valid JSON."), (Throwable)e);
                    break block8;
                }
                catch (Exception e) {
                    logger.trace(() -> "Failed to read OAuth server metadata from " + String.valueOf(candidateURI), (Throwable)e);
                }
            }
            ((Reader)reader).close();
            return oAuthServerMetadata;
        }
        return null;
    }

    private static OAuthProtectedResourceMetadata getOauthProtectedResourceMetadata(URI uri) {
        block8: {
            OAuthProtectedResourceMetadata oAuthProtectedResourceMetadata;
            InputStreamReader reader = new InputStreamReader(uri.toURL().openStream());
            try {
                JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                Gson gson = new Gson();
                oAuthProtectedResourceMetadata = (OAuthProtectedResourceMetadata)gson.fromJson((JsonElement)jsonObject, OAuthProtectedResourceMetadata.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException e) {
                    logger.warn((Object)("Failed to parse OAuth server metadata from " + String.valueOf(uri) + ". Content was not valid JSON."), (Throwable)e);
                    break block8;
                }
                catch (Exception e) {
                    logger.trace(() -> "Failed to read OAuth protected resource metadata from " + String.valueOf(uri), (Throwable)e);
                }
            }
            ((Reader)reader).close();
            return oAuthProtectedResourceMetadata;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URI getOAuthProtectedResourceLocation(URI serverURI) {
        HttpURLConnection conn = null;
        try {
            Matcher matcher;
            String authHeader;
            conn = (HttpURLConnection)serverURI.toURL().openConnection();
            conn.setRequestMethod("HEAD");
            conn.setConnectTimeout(DKUApp.getParams().getIntParam("dku.connection.oauth.timeoutMs", Integer.valueOf(15000)));
            conn.setReadTimeout(DKUApp.getParams().getIntParam("dku.connection.oauth.timeoutMs", Integer.valueOf(15000)));
            if (conn.getResponseCode() == 401 && (authHeader = conn.getHeaderField("WWW-Authenticate")) != null && (matcher = RESOURCE_METADATA_URI_PATTERN.matcher(authHeader)).find()) {
                URI uRI = new URI(matcher.group(1));
                return uRI;
            }
        }
        catch (IOException e) {
            logger.trace(() -> "Failed to check for authentication requirement for OAuth at " + String.valueOf(serverURI), (Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.warn((Object)"Invalid URL found in resource_metadata", (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    private static String getURIWithPath(String serverURL, String path) {
        try {
            URI baseURI = new URI(serverURL);
            return new URI(baseURI.getScheme(), null, baseURI.getHost(), baseURI.getPort(), baseURI.getPath() + path, null, null).toString();
        }
        catch (URISyntaxException e) {
            logger.warn((Object)"Invalid URI", (Throwable)e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkHTTPResourceExists(String serverURL, String path) {
        HttpURLConnection conn = null;
        try {
            URI uri = new URI(serverURL);
            URI resourceURI = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), path, null, null);
            conn = (HttpURLConnection)resourceURI.toURL().openConnection();
            conn.setRequestMethod("HEAD");
            conn.setConnectTimeout(DKUApp.getParams().getIntParam("dku.connection.oauth.timeoutMs", Integer.valueOf(15000)));
            conn.setReadTimeout(DKUApp.getParams().getIntParam("dku.connection.oauth.timeoutMs", Integer.valueOf(15000)));
            boolean bl = conn.getResponseCode() != 404;
            return bl;
        }
        catch (IOException | URISyntaxException e) {
            logger.trace(() -> "Failed to check if HTTP resource exists", (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return false;
    }

    private static OAuthServerMetadata getOAuthServerMetadataFrom401(URI serverURI, OAuthServerMetadata config) {
        OAuthProtectedResourceMetadata metadata;
        URI protectedResourceLocation = OAuth2ConfigDiscovery.getOAuthProtectedResourceLocation(serverURI);
        if (protectedResourceLocation != null && (metadata = OAuth2ConfigDiscovery.getOauthProtectedResourceMetadata(protectedResourceLocation)) != null && !metadata.authorization_servers.isEmpty()) {
            String baseURL = metadata.authorization_servers.get(0);
            try {
                URI baseURI = new URI(baseURL);
                config = OAuth2ConfigDiscovery.getOAuthServerMetadata(baseURI, "/.well-known/oauth-authorization-server");
                if (config != null) {
                    return config;
                }
            }
            catch (URISyntaxException e) {
                logger.warn((Object)("Invalid authorization server URL:" + baseURL), (Throwable)e);
            }
            baseURL = StringUtils.removeEnd((String)baseURL, (String)"/");
            String oauthBasePath = null;
            for (String candidateBasePath : List.of("", "/api/oauth", "/v2/oauth", "/v1/oauth")) {
                if (!OAuth2ConfigDiscovery.checkHTTPResourceExists(baseURL, candidateBasePath + "/authorize")) continue;
                oauthBasePath = candidateBasePath;
                break;
            }
            if (oauthBasePath != null) {
                config = new OAuthServerMetadata();
                config.wasGuessed = true;
                config.issuer = baseURL;
                config.authorizationEndpoint = OAuth2ConfigDiscovery.getURIWithPath(baseURL, oauthBasePath + "/authorize");
                config.tokenEndpoint = OAuth2ConfigDiscovery.getURIWithPath(baseURL, oauthBasePath + "/token");
                config.registrationEndpoint = OAuth2ConfigDiscovery.getURIWithPath(baseURL, oauthBasePath + "/register");
                if (StringUtils.equals((String)config.tokenEndpoint, (String)"https://github.com/login/oauth/token")) {
                    config.tokenEndpoint = "https://github.com/login/oauth/access_token";
                }
            }
        }
        return config;
    }

    public static DSSOAuthServerMetadata discoverConfig(String serverURL) throws IllegalArgumentException, URISyntaxException {
        URI serverURI;
        if (StringUtils.isBlank((String)serverURL)) {
            throw new IllegalArgumentException("Server URL can't be empty");
        }
        try {
            serverURI = new URI(serverURL);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Server URL is invalid, got: " + serverURL, e);
        }
        if (!serverURI.isAbsolute()) {
            throw new IllegalArgumentException("Server URL should be absolute, got: " + String.valueOf(serverURI));
        }
        String basePath = serverURI.getPath();
        OAuthServerMetadata config = OAuth2ConfigDiscovery.getOAuthServerMetadata(serverURI, basePath);
        if (config == null) {
            config = OAuth2ConfigDiscovery.getOAuthServerMetadataFrom401(serverURI, config);
        }
        if (config == null) {
            config = OAuth2ConfigDiscovery.getOAuthServerMetadata(serverURI, "/.well-known/oauth-authorization-server");
        }
        if (config == null) {
            config = OAuth2ConfigDiscovery.getOAuthServerMetadata(serverURI, "/.well-known/oauth-authorization-server" + basePath);
        }
        if (config == null) {
            config = OAuth2ConfigDiscovery.getOAuthServerMetadata(serverURI, basePath + "/.well-known/oauth-authorization-server");
        }
        if (config == null) {
            config = OAuth2ConfigDiscovery.getOAuthServerMetadata(serverURI, "/.well-known/oauth-protected-resource" + basePath);
        }
        if (config == null) {
            config = OAuth2ConfigDiscovery.getOAuthServerMetadata(serverURI, basePath + "/.well-known/oauth-protected-resource");
        }
        if (config == null) {
            config = OAuth2ConfigDiscovery.getOAuthServerMetadata(serverURI, "/.well-known/openid-configuration");
        }
        if (config == null) {
            config = OAuth2ConfigDiscovery.getOAuthServerMetadata(serverURI, basePath + "/.well-known/openid-configuration");
        }
        if (config == null) {
            config = OAuth2ConfigDiscovery.getOAuthServerMetadata(serverURI, "/.well-known/openid-configuration" + basePath);
        }
        if (config == null) {
            throw new UnsupportedOperationException("OAuth config not found. Make sure this server supports OAuth and set it up manually.");
        }
        return new DSSOAuthServerMetadata(config);
    }

    public static class OAuthServerMetadata {
        private static final String SERVER_METADATA_WELL_KNOWN_PATH = "/.well-known/oauth-authorization-server";
        private static final String RESOURCE_METADATA_WELL_KNOWN_PATH = "/.well-known/oauth-protected-resource";
        private static final String OPENID_CONFIGURATION_WELL_KNOWN_PATH = "/.well-known/openid-configuration";
        private static final String DEFAULT_AUTHORIZE_PATH = "/authorize";
        private static final String DEFAULT_TOKEN_PATH = "/token";
        private static final String DEFAULT_REGISTER_PATH = "/register";
        public String issuer;
        @Nullable
        public Boolean wasGuessed;
        @Nullable
        @SerializedName(value="jwks_uri")
        public String jwksUri;
        @Nullable
        @SerializedName(value="authorization_endpoint")
        public String authorizationEndpoint;
        @Nullable
        @SerializedName(value="token_endpoint")
        public String tokenEndpoint;
        @Nullable
        @SerializedName(value="registration_endpoint")
        public String registrationEndpoint;
        @Nullable
        @SerializedName(value="scopes_supported")
        public List<String> scopesSupported;
        @Nullable
        @SerializedName(value="grant_types_supported")
        public List<String> grantTypesSupported;
        @Nullable
        @SerializedName(value="token_endpoint_auth_methods_supported")
        public List<String> tokenEndpointAuthMethodsSupported;
    }

    private static class OAuthProtectedResourceMetadata {
        private static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
        public List<String> authorization_servers;

        private OAuthProtectedResourceMetadata() {
        }
    }

    public static class DSSOAuthServerMetadata {
        public String issuer;
        public Boolean wasGuessed;
        public String jwksUri;
        public String authorizationEndpoint;
        public String tokenEndpoint;
        public String registrationEndpoint;
        public List<String> scopesSupported;
        public List<String> grantTypesSupported;
        public List<String> tokenEndpointAuthMethodsSupported;

        public DSSOAuthServerMetadata() {
        }

        DSSOAuthServerMetadata(OAuthServerMetadata metadata) {
            this.issuer = metadata.issuer;
            this.wasGuessed = metadata.wasGuessed;
            this.jwksUri = metadata.jwksUri;
            this.authorizationEndpoint = metadata.authorizationEndpoint;
            this.tokenEndpoint = metadata.tokenEndpoint;
            this.registrationEndpoint = metadata.registrationEndpoint;
            this.scopesSupported = metadata.scopesSupported;
            this.grantTypesSupported = metadata.grantTypesSupported;
            this.tokenEndpointAuthMethodsSupported = metadata.tokenEndpointAuthMethodsSupported;
        }
    }
}

