/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.semanticmodels.values;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SinkProcessorOutput;
import com.dataiku.dip.datalayer.streamimpl.StreamColumn;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.queries.SQLQueryRuntime;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.facet.CountMap;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DistinctValuesComputer {
    private static final String NO_VALUE = "__dku_no_value__";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.semanticmodels.distinct-values");
    private final AuthCtx authCtx;
    private final Dataset dataset;
    private final VariablesService variablesService;

    public DistinctValuesComputer(AuthCtx authCtx, Dataset dataset) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
    }

    public ComputedDistinctValues computeDistinctValues(List<String> columns, long maxKeptDistinctValuesPerColumn, long maxScannedRows) {
        ComputedDistinctValues out = new ComputedDistinctValues();
        if (columns == null || columns.isEmpty()) {
            return out;
        }
        columns.forEach(column -> out.columns.put((String)column, new ColumnComputedDistinctValues((String)column)));
        assert (maxKeptDistinctValuesPerColumn > 0L);
        if (DatasetInspector.isSQLOrHive(this.dataset)) {
            this.computeDistinctValuesSQL(out, columns, maxKeptDistinctValuesPerColumn, maxScannedRows);
        } else {
            this.computeDistinctValuesNonSQL(out, columns, maxKeptDistinctValuesPerColumn, maxScannedRows);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeDistinctValuesSQL(ComputedDistinctValues out, List<String> columns, long maxKeptDistinctValuesPerColumn, long maxScannedRows) {
        try (DatasetHandler dh = DatasetHandlerFactory.build(this.authCtx, this.dataset);){
            SelectQueryBuilder baseQuery;
            assert (dh instanceof AbstractSQLDatasetHandler);
            AbstractSQLDatasetHandler sqlHandler = (AbstractSQLDatasetHandler)dh;
            SQLDialect dialect = sqlHandler.getDialect();
            QueryBunch baseQueryBunch = new QueryBunch();
            SelectQueryBuilder scanQuery = baseQuery = this.buildDatasetQuery(dialect, baseQueryBunch);
            if (maxScannedRows >= 0L) {
                SelectQueryBuilder limited = new SelectQueryBuilder();
                limited.from(baseQuery, "dku_limited");
                limited.limit(maxScannedRows);
                scanQuery = limited;
            }
            for (String column : columns) {
                ColumnComputedDistinctValues colOut = out.columns.get(column);
                if (colOut == null) continue;
                SelectQueryBuilder columnQuery = new SelectQueryBuilder();
                columnQuery.from(scanQuery, "dku_source");
                ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                ExpressionBuilder colExpr = ebf.col(column);
                ExpressionBuilder countExpr = ebf.col("*").count();
                columnQuery.select(colExpr, "dku_value");
                columnQuery.select(countExpr, "dku_count");
                columnQuery.group(colExpr);
                columnQuery.order(countExpr, QueryAst.OrderType.DESC);
                if (maxKeptDistinctValuesPerColumn > 0L) {
                    columnQuery.limit(maxKeptDistinctValuesPerColumn);
                }
                String sql = columnQuery.toSQL(dialect);
                sql = this.variablesService.getForProject(this.dataset.getProjectKey()).expand(sql);
                QueryBunch queryBunch = baseQueryBunch.clone();
                queryBunch.query = sql;
                int rowsToReturn = Integer.MAX_VALUE;
                if (maxKeptDistinctValuesPerColumn > 0L && maxKeptDistinctValuesPerColumn < Integer.MAX_VALUE) {
                    rowsToReturn = (int)maxKeptDistinctValuesPerColumn;
                }
                SQLQueryRuntime sqr = new SQLQueryRuntime(queryBunch, sqlHandler.getConnectionData(), this.authCtx, this.dataset.getProjectKey());
                try {
                    FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook(() -> {
                        try {
                            sqr.cancel();
                        }
                        catch (SQLException e) {
                            logger.error((Object)"Failed to cancel a query", (Throwable)e);
                        }
                    });
                    try {
                        sqr.init(0);
                        QueryRunResult res = sqr.getPage(0, rowsToReturn, null);
                        if (!res.success) {
                            throw new RuntimeException(res.errorMessage);
                        }
                        for (String[] row : res.rows) {
                            if (row.length == 0) continue;
                            String value = row[0];
                            if (StringUtils.isBlank((String)value)) {
                                value = NO_VALUE;
                            }
                            long count = 0L;
                            if (row.length > 1 && StringUtils.isNotBlank((String)row[1])) {
                                try {
                                    count = Long.parseLong(row[1]);
                                }
                                catch (NumberFormatException e) {
                                    logger.warn((Object)("Unable to parse count for column " + column + ": " + row[1]));
                                }
                            }
                            colOut.distinctValuesCounts.put(value, count);
                        }
                    }
                    finally {
                        if (aborter == null) continue;
                        aborter.close();
                    }
                }
                finally {
                    sqr.close(false, false);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compute distinct values on SQL dataset", e);
        }
    }

    private SelectQueryBuilder buildDatasetQuery(SQLDialect dialect, QueryBunch queryBunch) throws Exception {
        SelectQueryBuilder queryBuilder = new SelectQueryBuilder();
        AbstractSQLDatasetHandler.AbstractSQLConfig config = this.dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(this.dataset.getProjectKey());
        if ("query".equals(config.mode)) {
            if (StringUtils.isBlank((String)config.query)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Dataset " + this.dataset.getFullName() + " is configured with mode 'SQL query' but the query is missing");
            }
            Splitter splitter = new Splitter(dialect.getSemicolonExclusionPortionFinders());
            String[] statements = splitter.split(config.query);
            int selectStatementIndex = SQLUtils.findLastSelectStatement(statements, splitter);
            selectStatementIndex = selectStatementIndex < 0 ? statements.length - 1 : selectStatementIndex;
            for (int i = 0; i < selectStatementIndex; ++i) {
                queryBunch.preQueries.add(statements[i]);
            }
            String query = statements[selectStatementIndex];
            for (int i = selectStatementIndex + 1; i < statements.length; ++i) {
                queryBunch.postQueries.add(statements[i]);
            }
            ArrayList columnNames = null;
            if (this.dataset.getSchema() != null && this.dataset.getSchema().getColumns() != null) {
                columnNames = Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.dataset.getSchema().getColumns(), SchemaColumn::getName));
            }
            QueryAst.TableLike table = columnNames == null ? queryBuilder.withInlineQuery(query, "dku_subquery") : queryBuilder.withInlineQuery(query, columnNames, "dku_subquery");
            queryBuilder.from(table);
        } else if ("table".equals(config.mode)) {
            if (StringUtils.isBlank((String)config.table)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table defined on SQL dataset " + this.dataset.getFullName());
            }
            queryBuilder.from(new SQLUtils.SQLTable(config.catalog, config.schema, config.table, true), "dku_datasource");
        }
        return queryBuilder;
    }

    private void computeDistinctValuesNonSQL(ComputedDistinctValues out, final List<String> columns, final long maxKeptDistinctValuesPerColumn, long maxScannedRows) {
        final ArrayList countsByIndex = new ArrayList(columns.size());
        final ArrayList<StreamColumn> columnRefs = new ArrayList<StreamColumn>(columns.size());
        StreamColumnFactory scf = new StreamColumnFactory();
        StreamRowFactory srf = new StreamRowFactory();
        for (String column : columns) {
            countsByIndex.add(new CountMap());
            columnRefs.add(scf.column(column));
        }
        StreamableDatasetSelection selection = StreamableDatasetSelection.full();
        if (maxScannedRows >= 0L) {
            selection.samplingMethod = SamplingParam.SamplingMethod.HEAD_SEQUENTIAL;
            selection.maxRecords = maxScannedRows;
        }
        SinkProcessorOutput output = new SinkProcessorOutput(){

            public void emitRow(Row row) throws Exception {
                for (int i = 0; i < columns.size(); ++i) {
                    CountMap map = (CountMap)countsByIndex.get(i);
                    Column cd = (Column)columnRefs.get(i);
                    String value = row.get(cd);
                    if (StringUtils.isBlank((String)value)) {
                        value = DistinctValuesComputer.NO_VALUE;
                    }
                    if (maxKeptDistinctValuesPerColumn > 0L && !map.containsKey(value) && (long)map.size() >= maxKeptDistinctValuesPerColumn) continue;
                    map.inc(value);
                }
            }
        };
        try {
            UniversalSingleThreadPusher.push(this.authCtx, this.dataset, selection, (ProcessorOutput)output, (ColumnFactory)scf, (RowFactory)srf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compute distinct values on non-SQL dataset", e);
        }
        for (int i = 0; i < columns.size(); ++i) {
            String column = columns.get(i);
            ColumnComputedDistinctValues colOut = out.columns.get(column);
            CountMap countMap = (CountMap)countsByIndex.get(i);
            assert (colOut != null);
            for (Map.Entry entry : countMap) {
                colOut.distinctValuesCounts.put((String)entry.getKey(), (long)entry.getValue().toInteger());
            }
        }
    }

    public static class ComputedDistinctValues {
        Map<String, ColumnComputedDistinctValues> columns = new HashMap<String, ColumnComputedDistinctValues>();
    }

    public static class ColumnComputedDistinctValues {
        String columnName;
        Map<String, Long> distinctValuesCounts = new LinkedHashMap<String, Long>();

        public ColumnComputedDistinctValues() {
        }

        public ColumnComputedDistinctValues(String columnName) {
            this.columnName = columnName;
        }
    }
}

