/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.semanticmodels.values;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.semanticmodels.SemanticModel;
import com.dataiku.dip.semanticmodels.SemanticModelLoc;
import com.dataiku.dip.semanticmodels.SemanticModelsDAO;
import com.dataiku.dip.semanticmodels.model.Attribute;
import com.dataiku.dip.semanticmodels.model.EntityClass;
import com.dataiku.dip.semanticmodels.model.SemanticModelVersion;
import com.dataiku.dip.semanticmodels.values.DistinctValuesComputer;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistinctValuesService {
    @Autowired
    private SemanticModelsDAO dao;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.semanticmodels.values");

    private static File getSemanticModelFolder(SemanticModelLoc loc) {
        return DKUApp.getFile((String[])new String[]{"semantic-models", loc.projectKey, loc.semanticModelId, loc.versionId});
    }

    private static File getEntityDistinctValuesFile(SemanticModelLoc loc, String entityName) {
        File smFolder = DistinctValuesService.getSemanticModelFolder(loc);
        return DKUFileUtils.getWithin((File)smFolder, (String[])new String[]{"distinct-values", entityName + ".json"});
    }

    public BasicDistinctValuesResult getBasicForAttribute_NT(SemanticModelLoc loc, String entityName, String attributeName, long maxValues) throws Exception {
        BasicDistinctValuesResult ret = new BasicDistinctValuesResult();
        File entityDVFile = DistinctValuesService.getEntityDistinctValuesFile(loc, entityName);
        if (!entityDVFile.isFile()) {
            return ret;
        }
        DistinctValuesComputer.ComputedDistinctValues cdv = (DistinctValuesComputer.ComputedDistinctValues)JSON.parseFile((File)entityDVFile, DistinctValuesComputer.ComputedDistinctValues.class);
        DistinctValuesComputer.ColumnComputedDistinctValues ccdv = cdv.columns.get(attributeName);
        if (ccdv == null) {
            return ret;
        }
        ret.values = ccdv.distinctValuesCounts.entrySet().stream().limit(maxValues).map(Map.Entry::getKey).toList();
        return ret;
    }

    public BasicDistinctValuesForSemanticModelResult getBasicForSemanticModel_NT(SemanticModelLoc loc, long maxValues) throws Exception {
        BasicDistinctValuesForSemanticModelResult ret = new BasicDistinctValuesForSemanticModelResult();
        SemanticModel sm = null;
        try (Transaction t = this.transactionService.beginRead();){
            sm = (SemanticModel)this.dao.getMandatory(loc.projectKey, loc.semanticModelId);
        }
        SemanticModelVersion version = sm.getVersionByIdMand(loc.versionId);
        for (EntityClass entityClass : version.entities) {
            BasicDistinctValuesForEntityResult entityResult = new BasicDistinctValuesForEntityResult();
            entityResult.entityName = entityClass.name;
            DistinctValuesComputer.ComputedDistinctValues cdv = null;
            File entityDVFile = DistinctValuesService.getEntityDistinctValuesFile(loc, entityClass.name);
            if (entityDVFile.isFile()) {
                try {
                    cdv = (DistinctValuesComputer.ComputedDistinctValues)JSON.parseFile((File)entityDVFile, DistinctValuesComputer.ComputedDistinctValues.class);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to read distinct values file for entity " + entityClass.name), (Throwable)e);
                }
            }
            for (Attribute attribute : entityClass.attributes) {
                DistinctValuesComputer.ColumnComputedDistinctValues ccdv;
                if (!attribute.indexDistinctValues) continue;
                BasicDistinctValuesResult attrResult = new BasicDistinctValuesResult();
                if (cdv != null && (ccdv = cdv.columns.get(attribute.name)) != null) {
                    attrResult.values = ccdv.distinctValuesCounts.entrySet().stream().limit(maxValues).map(Map.Entry::getKey).toList();
                }
                entityResult.attributes.put(attribute.name, attrResult);
            }
            ret.entities.add(entityResult);
        }
        return ret;
    }

    public FutureResponse<Void> startRefreshDistinctValues_NT(AuthCtx authCtx, SemanticModelLoc loc) throws Exception {
        DistinctValuesRefresherThread fvThread = new DistinctValuesRefresherThread(authCtx, loc);
        return this.futureService.runFuture(fvThread, 0L, new TypeToken<FutureResponse<Void>>(){});
    }

    public static class BasicDistinctValuesResult {
        public List<String> values = new ArrayList<String>();
    }

    public static class BasicDistinctValuesForSemanticModelResult {
        public List<BasicDistinctValuesForEntityResult> entities = new ArrayList<BasicDistinctValuesForEntityResult>();
    }

    public static class BasicDistinctValuesForEntityResult {
        public String entityName;
        public Map<String, BasicDistinctValuesResult> attributes = new LinkedHashMap<String, BasicDistinctValuesResult>();
    }

    static class DistinctValuesRefresherThread
    extends SimpleFutureThread<Void> {
        private final SemanticModelLoc loc;
        @Autowired
        private SemanticModelsDAO dao;
        @Autowired
        private DatasetsDAO datasetsDAO;
        @Autowired
        private TransactionService transactionService;

        public DistinctValuesRefresherThread(AuthCtx owner, SemanticModelLoc loc) {
            super(owner);
            SpringUtils.getInstance().autowire((Object)this);
            this.loc = loc;
        }

        private DistinctValuesComputer.ComputedDistinctValues computeDistinctValuesForEntity(SemanticModelVersion version, EntityClass entityClass) throws Exception {
            logger.info((Object)("Computing distinct values for entity: " + entityClass.name));
            List<Attribute> indexedAttributes = entityClass.attributes.stream().filter(attr -> attr.indexDistinctValues).filter(attr -> attr.type == Attribute.Type.COLUMN).toList();
            List<String> columns = indexedAttributes.stream().map(attr -> attr.column).filter(StringUtils::isNotBlank).toList();
            if (columns.isEmpty()) {
                return new DistinctValuesComputer.ComputedDistinctValues();
            }
            Dataset dataset = null;
            try (Transaction t = this.transactionService.beginRead();){
                if (StringUtils.isBlank((String)entityClass.datasetRef)) {
                    throw new IllegalArgumentException("Missing datasetRef for entity " + entityClass.name);
                }
                SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(AnyLoc.resolveSmart(this.loc.projectKey, entityClass.datasetRef));
                dataset = Dataset.fromSerializedUnsafe(sd);
            }
            long maxScannedRows = DatasetInspector.isSQLOrHive(dataset) ? version.indexingSettings.maxScannedRowsForSQLDatasets : version.indexingSettings.maxScannedRowsForNonSQLDatasets;
            DistinctValuesComputer dvc = new DistinctValuesComputer(this.getOwner(), dataset);
            DistinctValuesComputer.ComputedDistinctValues computed = dvc.computeDistinctValues(columns, version.indexingSettings.maxDistinctValuesPerAttribute, maxScannedRows);
            DistinctValuesComputer.ComputedDistinctValues remapped = new DistinctValuesComputer.ComputedDistinctValues();
            for (Attribute attribute : indexedAttributes) {
                String column = attribute.column;
                if (StringUtils.isBlank((String)column)) continue;
                DistinctValuesComputer.ColumnComputedDistinctValues colValues = computed.columns.get(column);
                DistinctValuesComputer.ColumnComputedDistinctValues remappedValues = new DistinctValuesComputer.ColumnComputedDistinctValues(attribute.name);
                if (colValues != null && colValues.distinctValuesCounts != null) {
                    remappedValues.distinctValuesCounts = new LinkedHashMap<String, Long>(colValues.distinctValuesCounts);
                }
                remapped.columns.put(attribute.name, remappedValues);
            }
            return remapped;
        }

        @Override
        public Void compute() throws Exception {
            logger.info((Object)("Starting distinct values refresh for semantic model " + String.valueOf(this.loc)));
            SemanticModel sm = null;
            try (Transaction t = this.transactionService.beginRead();){
                sm = (SemanticModel)this.dao.getMandatory(this.loc.projectKey, this.loc.semanticModelId);
            }
            SemanticModelVersion version = sm.getVersionByIdMand(this.loc.versionId);
            for (EntityClass entityClass : version.entities) {
                logger.info((Object)("Refreshing distinct values for entity " + entityClass.name));
                DistinctValuesComputer.ComputedDistinctValues cdv = this.computeDistinctValuesForEntity(version, entityClass);
                File outputFile = DistinctValuesService.getEntityDistinctValuesFile(this.loc, entityClass.name);
                DKUFileUtils.mkdirsParent((File)outputFile);
                JSON.prettyToFile((Object)cdv, (File)outputFile);
            }
            logger.info((Object)("Completed distinct values refresh for semantic model " + String.valueOf(this.loc)));
            return null;
        }

        @Override
        public double getDangerosity() {
            return 1.0;
        }

        public FuturePayload getPayload() {
            return null;
        }

        static {
            JSON.registerAdapter(DistinctValuesRefresherThread.class, (Object)new JSON.Adapter<DistinctValuesRefresherThread>(){

                public DistinctValuesRefresherThread deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) throws JsonParseException {
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    DSSAuthCtx owner = (DSSAuthCtx)((Object)ctx.deserialize(jsonObj.get("owner"), DSSAuthCtx.class));
                    SemanticModelLoc loc = (SemanticModelLoc)ctx.deserialize(jsonObj.get("loc"), SemanticModelLoc.class);
                    return new DistinctValuesRefresherThread((AuthCtx)owner, loc);
                }

                public JsonElement serialize(DistinctValuesRefresherThread ft, Type type, JsonSerializationContext ctx) {
                    JsonObject ret = new JsonObject();
                    ret.add("owner", ctx.serialize((Object)ft.owner));
                    ret.add("loc", ctx.serialize((Object)ft.loc));
                    return ret;
                }
            });
        }
    }
}

