/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.semanticsearch;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.aigenerations.AISemanticSearchQueryAugmentationService;
import com.dataiku.dip.aigenerations.AISemanticSearchResultRerankingService;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.impl.ExternalCatalogInternalDB;
import com.dataiku.dip.datacatalog.UIDataCatalog;
import com.dataiku.dip.datacollections.DataCollectionsByItem;
import com.dataiku.dip.datacollections.DataCollectionsService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.semanticsearch.ItemFacets;
import com.dataiku.dip.semanticsearch.ItemMetadata;
import com.dataiku.dip.semanticsearch.SemanticSearchFacets;
import com.dataiku.dip.semanticsearch.SemanticSearchMessage;
import com.dataiku.dip.semanticsearch.SemanticSearchResults;
import com.dataiku.dip.server.datasets.DataStewardService;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.catalog.LuceneIndexException;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.server.services.catalog.internal.IInternalDataCatalogService;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BoostQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchAllDocsQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchNoDocsQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SemanticSearchService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ExternalCatalogInternalDB externalTableDAO;
    @Autowired
    private DataCollectionsService dataCollectionsService;
    @Autowired
    private AISemanticSearchQueryAugmentationService queryAugmentationService;
    @Autowired
    private AISemanticSearchResultRerankingService rerankingService;
    @Autowired
    private IInternalDataCatalogService internalDataCatalogService;
    @Autowired
    private UsersService usersService;
    private static final DKULogger logger = DKULogger.getLogger(SemanticSearchService.class);

    public static void checkAllowedToUse(LicenseStatusService.LicensingStatus licensingStatus) {
        if (licensingStatus == null || licensingStatus.community) {
            throw new IllegalArgumentException("AI services are not available with Dataiku Free Edition");
        }
        GeneralSettingsDAO.AIDrivenAnalyticsSettings aiDrivenAnalyticsSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().aiDrivenAnalyticsSettings;
        if (!aiDrivenAnalyticsSettings.isAssistantEnabled(GeneralSettingsDAO.AiAssistant.SEMANTIC_SEARCH_ASSISTANT)) {
            throw new IllegalStateException("AI Search is disabled");
        }
    }

    public FutureResponse<AISemanticSearchQueryAugmentationService.AugmentQueryResponse> augmentQuery(AuthCtx authCtx, String query, List<SemanticSearchMessage> previousMessages, String conversationId) throws Exception {
        logger.infoV("Received request to augment query. ConversationId: [%s], Query: [%s], Previous messages count: [%d]", new Object[]{conversationId, query, previousMessages.size()});
        SemanticSearchFacets allAvailableFacets = this.getAllAvailableFacets(authCtx);
        SemanticSearchFacets availableFacets = new SemanticSearchFacets();
        availableFacets.datasetType = allAvailableFacets.datasetType;
        availableFacets.catalog = allAvailableFacets.catalog;
        availableFacets.connection = allAvailableFacets.connection;
        availableFacets.connectionType = allAvailableFacets.connectionType;
        availableFacets.schema = allAvailableFacets.schema;
        return this.queryAugmentationService.augmentQuery(authCtx, query, availableFacets, previousMessages, conversationId);
    }

    public FutureResponse<SemanticSearchResults> search(AuthCtx authCtx, String query, String conversationId, AISemanticSearchQueryAugmentationService.KeywordExtractionResponse extractedKeywords) throws Exception {
        logger.infoV("Received request to search. ConversationId: [%s], Query: [%s]", new Object[]{conversationId, query});
        SemanticSearchService.checkAllowedToUse(this.licenseStatusService.getLicensingStatus());
        return this.futureService.runFuture(new SearchFutureThread(authCtx, query, conversationId, extractedKeywords), 0L, new TypeToken<FutureResponse<SemanticSearchResults>>(){});
    }

    public LuceneResponseWrapper queryLucene(AuthCtx authCtx, AISemanticSearchQueryAugmentationService.KeywordExtractionResponse extractedKeywords) throws IOException, DKUSecurityException, LuceneIndexException {
        return this.internalDataCatalogService.searchNoHighlight(this.buildLuceneQuery(extractedKeywords), authCtx, new IInternalDataCatalogService.Options(IInternalDataCatalogService.MAX_RESULTS, true, false, false));
    }

    private SemanticSearchFacets getAllAvailableFacets(AuthCtx authCtx) throws Exception {
        Map<String, List<String>> datasetAndExternalTableFacets = this.internalDataCatalogService.getDatasetAndExternalTableFacets(authCtx);
        return SemanticSearchFacets.fromLucene(datasetAndExternalTableFacets);
    }

    protected Query buildLuceneQuery(AISemanticSearchQueryAugmentationService.KeywordExtractionResponse extractedKeywords) {
        boolean hasAtLeastOneInclusion = this.hasAtLeastOneInclusion(extractedKeywords);
        boolean hasAtLeastOneExclusion = this.hasAtLeastOneExclusion(extractedKeywords);
        logger.debugV("Building Lucene query. Inclusions found: %b, Exclusions found: %b", new Object[]{hasAtLeastOneInclusion, hasAtLeastOneExclusion});
        if (!hasAtLeastOneInclusion && !hasAtLeastOneExclusion) {
            logger.info((Object)"No keywords extracted; returning MatchNoDocsQuery");
            return new MatchNoDocsQuery();
        }
        Object inclusionsQuery = hasAtLeastOneInclusion ? this.buildInclusionsQuery(extractedKeywords) : new MatchAllDocsQuery();
        if (!hasAtLeastOneExclusion) {
            BooleanQuery.Builder finalQuery = new BooleanQuery.Builder();
            finalQuery.add(this.buildTypeQuery(), BooleanClause.Occur.MUST);
            finalQuery.add(inclusionsQuery, BooleanClause.Occur.MUST);
            logger.infoV("Built inclusion-only Lucene query: %s", new Object[]{finalQuery.build().toString()});
            return finalQuery.build();
        }
        Query exclusionQuery = this.buildExclusionsQuery(extractedKeywords);
        BooleanQuery.Builder finalQuery = new BooleanQuery.Builder();
        BooleanQuery.Builder matchWithoutExcluded = new BooleanQuery.Builder();
        matchWithoutExcluded.add(inclusionsQuery, BooleanClause.Occur.MUST);
        matchWithoutExcluded.add(exclusionQuery, BooleanClause.Occur.MUST_NOT);
        BooleanQuery.Builder matchWithExcluded = new BooleanQuery.Builder();
        matchWithExcluded.add(inclusionsQuery, BooleanClause.Occur.MUST);
        matchWithExcluded.add(exclusionQuery, BooleanClause.Occur.MUST);
        finalQuery.add(this.buildTypeQuery(), BooleanClause.Occur.MUST);
        finalQuery.add((Query)matchWithoutExcluded.build(), BooleanClause.Occur.SHOULD);
        finalQuery.add((Query)new BoostQuery((Query)matchWithExcluded.build(), 0.01f), BooleanClause.Occur.SHOULD);
        logger.infoV("Built Lucene query (with exclusions/boosts): %s", new Object[]{finalQuery.build().toString()});
        return finalQuery.build();
    }

    private boolean hasAtLeastOneInclusion(AISemanticSearchQueryAugmentationService.KeywordExtractionResponse extractedKeywords) {
        return !extractedKeywords.catalogNames.isEmpty() || !extractedKeywords.connectionNames.isEmpty() || !extractedKeywords.connectionTypes.isEmpty() || !extractedKeywords.schemaNames.isEmpty() || !extractedKeywords.datasetNames.isEmpty() || !extractedKeywords.datasetTypes.isEmpty() || !extractedKeywords.columnNames.isEmpty() || !extractedKeywords.tags.isEmpty() || !extractedKeywords.projectKeys.isEmpty() || !extractedKeywords.dataStewards.isEmpty() || !extractedKeywords.descriptionKeywords.isEmpty() || extractedKeywords.type != null && !extractedKeywords.type.isEmpty() || extractedKeywords.isInDataCollection != null || extractedKeywords.isPartitioned != null;
    }

    private boolean hasAtLeastOneExclusion(AISemanticSearchQueryAugmentationService.KeywordExtractionResponse extractedKeywords) {
        return !extractedKeywords.excludedCatalogNames.isEmpty() || !extractedKeywords.excludedConnectionNames.isEmpty() || !extractedKeywords.excludedConnectionTypes.isEmpty() || !extractedKeywords.excludedSchemaNames.isEmpty() || !extractedKeywords.excludedDatasetNames.isEmpty() || !extractedKeywords.excludedDatasetTypes.isEmpty() || !extractedKeywords.excludedTags.isEmpty() || !extractedKeywords.excludedProjectKeys.isEmpty() || !extractedKeywords.excludedDataStewards.isEmpty();
    }

    private Query buildInclusionsQuery(AISemanticSearchQueryAugmentationService.KeywordExtractionResponse extractedKeywords) {
        BooleanQuery.Builder inclusionsQueryBuilder = new BooleanQuery.Builder();
        if (!extractedKeywords.catalogNames.isEmpty()) {
            inclusionsQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.catalogNames, "catalog.raw", 1.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.connectionNames.isEmpty()) {
            inclusionsQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.connectionNames, "connection.raw", 1.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.connectionTypes.isEmpty()) {
            inclusionsQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.connectionTypes, "connectionType", 1.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.schemaNames.isEmpty()) {
            inclusionsQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.schemaNames, "schema.raw", 1.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.datasetNames.isEmpty()) {
            inclusionsQueryBuilder.add(this.buildQueryFromLuceneKeywords(extractedKeywords.datasetNames, "name", 5.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.datasetTypes.isEmpty()) {
            inclusionsQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.datasetTypes, "type_raw", 1.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.columnNames.isEmpty()) {
            inclusionsQueryBuilder.add(this.buildQueryFromLuceneKeywords(extractedKeywords.columnNames, "columns.name", 1.5f), BooleanClause.Occur.SHOULD);
            inclusionsQueryBuilder.add(this.buildQueryFromLuceneKeywords(extractedKeywords.columnNames, "columns.name.raw", 1.5f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.tags.isEmpty()) {
            inclusionsQueryBuilder.add(this.buildQueryFromLuceneKeywords(extractedKeywords.tags, "tag", 2.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.projectKeys.isEmpty()) {
            inclusionsQueryBuilder.add(this.buildQueryFromLuceneKeywords(extractedKeywords.projectKeys, "projectKey", 1.5f), BooleanClause.Occur.SHOULD);
            inclusionsQueryBuilder.add(this.buildQueryFromLuceneKeywords(extractedKeywords.projectKeys, "projectName", 1.5f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.dataStewards.isEmpty()) {
            inclusionsQueryBuilder.add(this.buildQueryFromLuceneKeywords(extractedKeywords.dataStewards, "dataSteward", 2.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.descriptionKeywords.isEmpty()) {
            inclusionsQueryBuilder.add(this.buildQueryFromLuceneKeywords(extractedKeywords.descriptionKeywords, "description", 0.6666667f), BooleanClause.Occur.SHOULD);
            inclusionsQueryBuilder.add(this.buildQueryFromLuceneKeywords(extractedKeywords.descriptionKeywords, "shortDesc", 0.6666667f), BooleanClause.Occur.SHOULD);
            inclusionsQueryBuilder.add(this.buildQueryFromLuceneKeywords(extractedKeywords.descriptionKeywords, "description.plaintext", 0.6666667f), BooleanClause.Occur.SHOULD);
        }
        if (extractedKeywords.type != null && !extractedKeywords.type.isEmpty() && Set.of("dataset", "table").containsAll(extractedKeywords.type)) {
            extractedKeywords.type.forEach(type -> inclusionsQueryBuilder.add((Query)new TermQuery(new Term("_type", type)), BooleanClause.Occur.SHOULD));
        }
        if (extractedKeywords.isInDataCollection != null) {
            inclusionsQueryBuilder.add((Query)new TermQuery(new Term("isInDataCollection", extractedKeywords.isInDataCollection != false ? "true" : "false")), BooleanClause.Occur.SHOULD);
        }
        if (extractedKeywords.isPartitioned != null) {
            inclusionsQueryBuilder.add((Query)new TermQuery(new Term("partitioned", extractedKeywords.isPartitioned != false ? "true" : "false")), BooleanClause.Occur.SHOULD);
        }
        return inclusionsQueryBuilder.build();
    }

    private Query buildExclusionsQuery(AISemanticSearchQueryAugmentationService.KeywordExtractionResponse extractedKeywords) {
        BooleanQuery.Builder exclusionQueryBuilder = new BooleanQuery.Builder();
        if (!extractedKeywords.excludedCatalogNames.isEmpty()) {
            exclusionQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.excludedCatalogNames, "catalog.raw", 1.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.excludedConnectionNames.isEmpty()) {
            exclusionQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.excludedConnectionNames, "connection.raw", 1.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.excludedConnectionTypes.isEmpty()) {
            exclusionQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.excludedConnectionTypes, "connectionType", 1.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.excludedSchemaNames.isEmpty()) {
            exclusionQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.excludedSchemaNames, "schema.raw", 1.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.excludedDatasetNames.isEmpty()) {
            exclusionQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.excludedDatasetNames, "name", 1.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.excludedDatasetTypes.isEmpty()) {
            exclusionQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.excludedDatasetTypes, "type_raw", 1.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.excludedTags.isEmpty()) {
            exclusionQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.excludedTags, "tag", 1.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.excludedProjectKeys.isEmpty()) {
            exclusionQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.excludedProjectKeys, "projectKey", 1.0f), BooleanClause.Occur.SHOULD);
            exclusionQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.excludedProjectKeys, "projectName", 1.0f), BooleanClause.Occur.SHOULD);
        }
        if (!extractedKeywords.excludedDataStewards.isEmpty()) {
            exclusionQueryBuilder.add(this.buildQueryFromStrings(extractedKeywords.excludedDataStewards, "dataSteward", 1.0f), BooleanClause.Occur.SHOULD);
        }
        return exclusionQueryBuilder.build();
    }

    private Query buildQueryFromLuceneKeywords(List<AISemanticSearchQueryAugmentationService.LuceneKeyword> luceneKeywords, String field, float categoricalBoost) {
        BooleanQuery.Builder res = new BooleanQuery.Builder();
        for (AISemanticSearchQueryAugmentationService.LuceneKeyword luceneKeyword : luceneKeywords) {
            try {
                Query itemQuery = this.internalDataCatalogService.buildQuery(field, luceneKeyword.value, categoricalBoost * luceneKeyword.boost);
                res.add(itemQuery, BooleanClause.Occur.SHOULD);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to add " + field + " from extractedKeywords " + luceneKeyword.value), (Throwable)e);
            }
        }
        return res.build();
    }

    private Query buildQueryFromStrings(List<String> items, String field, float boost) {
        BooleanQuery.Builder res = new BooleanQuery.Builder();
        for (String item : items) {
            try {
                Query itemQuery = this.internalDataCatalogService.buildQuery(field, item, boost);
                res.add(itemQuery, BooleanClause.Occur.SHOULD);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to add " + field + " from extractedKeywords " + item), (Throwable)e);
            }
        }
        return res.build();
    }

    private Query buildTypeQuery() {
        BooleanQuery.Builder res = new BooleanQuery.Builder();
        res.add((Query)new TermQuery(new Term("_type", IndexableType.DATASET.index())), BooleanClause.Occur.SHOULD);
        res.add((Query)new TermQuery(new Term("_type", IndexableType.TABLE.index())), BooleanClause.Occur.SHOULD);
        return res.build();
    }

    protected class SearchFutureThread
    extends SimpleFutureThread<SemanticSearchResults> {
        protected final AuthCtx authCtx;
        private final String query;
        private final String conversationId;
        private final AISemanticSearchQueryAugmentationService.KeywordExtractionResponse extractedKeywords;

        public SearchFutureThread(AuthCtx authCtx, String query, String conversationId, AISemanticSearchQueryAugmentationService.KeywordExtractionResponse extractedKeywords) {
            super(authCtx);
            this.authCtx = authCtx;
            this.query = query;
            this.conversationId = conversationId;
            this.extractedKeywords = extractedKeywords;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"semantic_search", (String)"AI Search");
        }

        @Override
        protected SemanticSearchResults compute() throws Exception {
            DataCollectionsByItem dataCollectionsByItem;
            logger.infoV("Starting compute for ConvId: [%s]. Querying Lucene...", new Object[]{this.conversationId});
            LuceneResponseWrapper luceneResults = SemanticSearchService.this.queryLucene(this.authCtx, this.extractedKeywords);
            logger.infoV("Lucene returned [%d] hits for ConvId: [%s]", new Object[]{luceneResults.hits.size(), this.conversationId});
            ArrayList<SerializedDataset> datasets = new ArrayList<SerializedDataset>();
            HashMap<String, String> dataStewardByDataset = new HashMap<String, String>();
            try (Transaction ignored = SemanticSearchService.this.transactionService.retrieveOrBeginRead();){
                dataCollectionsByItem = SemanticSearchService.this.dataCollectionsService.listByItemNoThrowsUnsafe();
                luceneResults.hits.stream().filter(h -> IndexableType.DATASET.index().equals(h._type)).map(h -> new DatasetLocUtils.DatasetLoc((String)h._source.get("projectKey"), (String)h._source.get("name"))).forEach(dl -> {
                    try {
                        SerializedDataset serializedDataset = (SerializedDataset)SemanticSearchService.this.datasetsDAO.getMandatoryUnsafe((AnyLoc)dl);
                        datasets.add(serializedDataset);
                        String dataStewardLogin = DataStewardService.getDataStewardLoginOrDefault(serializedDataset);
                        PublicUser dataStewardUser = dataStewardLogin == null ? null : SemanticSearchService.this.usersService.getPublicUser(dataStewardLogin);
                        String dataStewardDisplayName = dataStewardUser == null ? null : (String)StringUtils.defaultIfBlank((CharSequence)dataStewardUser.displayName, (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)dataStewardUser.login, (CharSequence)dataStewardUser.email)));
                        dataStewardByDataset.put(serializedDataset.getFullName(), (String)StringUtils.defaultIfBlank(dataStewardDisplayName, (CharSequence)""));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to read dataset " + dl.getFullName()), (Throwable)e);
                    }
                });
            }
            Map<String, ItemFacets> datasetFacets = SearchFutureThread.buildDatasetFacetsMap(luceneResults, datasets, dataCollectionsByItem);
            List<ItemMetadata.DatasetMetadata> datasetsMetadata = ItemMetadata.DatasetMetadata.from(datasets, dataCollectionsByItem, dataStewardByDataset);
            List<LuceneResponseWrapper.Hit> indexedTables = luceneResults.hits.stream().filter(h -> IndexableType.TABLE.index().equals(h._type)).toList();
            List<ItemMetadata.IndexedTableMetadata> indexedTableMetadata = ItemMetadata.IndexedTableMetadata.from(indexedTables);
            if (datasetsMetadata.isEmpty() && indexedTableMetadata.isEmpty()) {
                logger.infoV("Empty dataset and indexed table metadata list for ConvId: [%s]. Returning empty.", new Object[]{this.conversationId});
                return SemanticSearchResults.getEmpty();
            }
            logger.infoV("Requesting rerank for [%d] datasets and [%d] tables for ConvId: [%s]", new Object[]{datasetsMetadata.size(), indexedTableMetadata.size(), this.conversationId});
            AISemanticSearchResultRerankingService.RerankResultsResponse rerankResultsResponse = SemanticSearchService.this.rerankingService.rerankResults(this.authCtx, this.query, datasetsMetadata, indexedTableMetadata, this.conversationId);
            if (!rerankResultsResponse.ok) {
                logger.errorV("Reranking failed for ConvId: [%s]. Error: %s", new Object[]{this.conversationId, rerankResultsResponse.error});
                return new SemanticSearchResults(luceneResults, rerankResultsResponse, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap());
            }
            logger.debugV("Reranking successful. Relevant results count: [%d]", new Object[]{rerankResultsResponse.results.stream().filter(r -> r.isRelevant).toList().size()});
            Map<String, LuceneResponseWrapper.Hit> tablesHitMap = indexedTables.stream().collect(Collectors.toMap(t -> t._id, t -> t));
            SearchFutureThread.enrichRerankResultsWithFacets(rerankResultsResponse.results, datasetFacets, tablesHitMap);
            Map<String, UIDataCatalog.DatasetDetails> datasetEnrichments = this.enrichDatasets(this.authCtx, rerankResultsResponse.results);
            Map<String, List<String>> tableEnrichments = this.enrichTables(rerankResultsResponse.results);
            ArrayList<SerializedProject> projects = new ArrayList<SerializedProject>();
            try (Transaction ignored = SemanticSearchService.this.transactionService.beginRead();){
                rerankResultsResponse.results.stream().filter(r -> r instanceof AISemanticSearchResultRerankingService.RerankedDatasetResult).map(r -> (AISemanticSearchResultRerankingService.RerankedDatasetResult)r).map(r -> r.projectKey).collect(Collectors.toSet()).forEach(p -> {
                    try {
                        projects.add(SemanticSearchService.this.projectsDAO.getMandatoryUnsafe((String)p));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to read project " + p), (Throwable)e);
                    }
                });
            }
            logger.infoV("Compute complete for ConvId: [%s]. Final Result: [%d] items.", new Object[]{this.conversationId, rerankResultsResponse.results.size()});
            return new SemanticSearchResults(luceneResults, rerankResultsResponse, projects, datasetEnrichments, tableEnrichments);
        }

        private static Map<String, ItemFacets> buildDatasetFacetsMap(LuceneResponseWrapper luceneResponseWrapper, List<SerializedDataset> datasets, DataCollectionsByItem dataCollectionsByItem) {
            Map<String, SerializedDataset> datasetsMap = datasets.stream().collect(Collectors.toMap(SerializedDataset::getFullName, d -> d));
            HashMap<String, ItemFacets> datasetFacetsMap = new HashMap<String, ItemFacets>();
            for (LuceneResponseWrapper.Hit hit : luceneResponseWrapper.hits) {
                String datasetFullName;
                if (!"dataset".equals(hit._type) || hit._source.get("projectKey") == null || hit._source.get("name") == null || datasetFacetsMap.containsKey(datasetFullName = String.valueOf(hit._source.get("projectKey")) + "." + String.valueOf(hit._source.get("name"))) || !datasetsMap.containsKey(datasetFullName)) continue;
                SerializedDataset sd = datasetsMap.get(datasetFullName);
                ItemFacets itemFacets = new ItemFacets(dataCollectionsByItem.isDatasetInAnyDataCollection(sd.getProjectKey(), sd.getId()), sd.isPartitioned(), DataStewardService.getDataStewardLoginOrDefault(sd), sd.getProjectKey(), sd.tags, sd.getSubtype());
                datasetFacetsMap.put(datasetFullName, itemFacets);
            }
            return datasetFacetsMap;
        }

        private static void enrichRerankResultsWithFacets(List<AISemanticSearchResultRerankingService.RerankedResult> results, Map<String, ItemFacets> datasetFacetsMap, Map<String, LuceneResponseWrapper.Hit> tableMap) {
            for (AISemanticSearchResultRerankingService.RerankedResult result : results) {
                if (result instanceof AISemanticSearchResultRerankingService.RerankedDatasetResult) {
                    AISemanticSearchResultRerankingService.RerankedDatasetResult res = (AISemanticSearchResultRerankingService.RerankedDatasetResult)result;
                    res.itemFacets = datasetFacetsMap.getOrDefault(res.projectKey + "." + res.datasetName, new ItemFacets());
                    continue;
                }
                if (!(result instanceof AISemanticSearchResultRerankingService.RerankedTableResult)) continue;
                AISemanticSearchResultRerankingService.RerankedTableResult res = (AISemanticSearchResultRerankingService.RerankedTableResult)result;
                res.hit = tableMap.get(res.tableId);
            }
        }

        private Map<String, UIDataCatalog.DatasetDetails> enrichDatasets(AuthCtx authCtx, List<AISemanticSearchResultRerankingService.RerankedResult> results) {
            HashMap<String, UIDataCatalog.DatasetDetails> enrichments = new HashMap<String, UIDataCatalog.DatasetDetails>();
            for (AISemanticSearchResultRerankingService.RerankedResult result : results) {
                if (!(result instanceof AISemanticSearchResultRerankingService.RerankedDatasetResult)) continue;
                AISemanticSearchResultRerankingService.RerankedDatasetResult res = (AISemanticSearchResultRerankingService.RerankedDatasetResult)result;
                String datasetKey = res.projectKey + "." + res.datasetName;
                try {
                    UIDataCatalog.AbstractDatasetDetails details = SemanticSearchService.this.internalDataCatalogService.getReadableDatasetItemDetails_NT(authCtx, res.projectKey, res.datasetName);
                    if (!(details instanceof UIDataCatalog.DatasetDetails)) continue;
                    UIDataCatalog.DatasetDetails datasetDetails = (UIDataCatalog.DatasetDetails)details;
                    enrichments.put(datasetKey, datasetDetails);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to fetch enriched details for dataset " + datasetKey), (Throwable)e);
                }
            }
            return enrichments;
        }

        private Map<String, List<String>> enrichTables(List<AISemanticSearchResultRerankingService.RerankedResult> results) {
            HashMap<String, List<String>> enrichments = new HashMap<String, List<String>>();
            for (AISemanticSearchResultRerankingService.RerankedResult result : results) {
                if (!(result instanceof AISemanticSearchResultRerankingService.RerankedTableResult)) continue;
                AISemanticSearchResultRerankingService.RerankedTableResult res = (AISemanticSearchResultRerankingService.RerankedTableResult)result;
                try {
                    ExternalCatalogInternalDB.ExternalTableDSSMetadata metadata;
                    DatabaseObjectKey tableKey = SearchFutureThread.extractTableKey(res);
                    if (tableKey == null || (metadata = SemanticSearchService.this.externalTableDAO.getDSSMetadata(tableKey)) == null || metadata.tags == null) continue;
                    enrichments.put(res.tableId, metadata.tags);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to fetch tags for table " + res.tableId), (Throwable)e);
                }
            }
            return enrichments;
        }

        private static DatabaseObjectKey extractTableKey(AISemanticSearchResultRerankingService.RerankedTableResult res) {
            if (res.hit == null || res.hit._source == null) {
                return null;
            }
            String connection = (String)res.hit._source.get("connection");
            String catalog = (String)res.hit._source.get("catalog");
            String schema = (String)res.hit._source.get("schema");
            String name = (String)res.hit._source.get("name");
            if (connection == null || schema == null || name == null) {
                return null;
            }
            return new DatabaseObjectKey(connection, catalog, schema, name);
        }
    }
}

