/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.datasets.sample.LoadedSampleDataset;
import com.dataiku.dip.datasets.sample.SampleDatasetInfo;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.plugins.PluginStoreService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class SampleDatasetsController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PluginStoreService pluginStoreService;
    @Autowired
    private PermissionsService permissionsService;

    @AuditedCall(value={"msgType", "samples"})
    @RequestMapping(value={"/api/samples/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        DSSAuthCtx liu;
        try (Transaction ignored = this.transactionService.beginRead();){
            liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
        }
        List<PluginStoreService.PluginStateInfo> plugins = this.pluginStoreService.getStateList((DSSAuthCtx)liu).plugins;
        SampleDatasetsController.writeJSON((HttpServletResponse)resp, plugins.stream().filter(plugin -> plugin.installed).filter(plugin -> !plugin.installedDesc.customSampleDatasets.isEmpty()).filter(plugin -> {
            try {
                return this.permissionsService.hasPluginPrivilege(liu, plugin.id, Privileges.PluginLevelPrivilegeType.COMPONENTS_VIEWER);
            }
            catch (DKUSecurityException e) {
                logger.warn((Object)"DKUSecurityException caught during plugin privilege verification", (Throwable)e);
                return false;
            }
        }).flatMap(plugin -> plugin.installedDesc.customSampleDatasets.stream()).filter(LoadedSampleDataset::doesActiveDatasetExist).sorted(Comparator.comparing(LoadedSampleDataset::getDisplayOrderRank).reversed().thenComparing(plugin -> plugin.desc.meta.label)).map(SampleDatasetInfo::new).collect(Collectors.toList()));
    }
}

