/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.analysis;

import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.AnalysisDataService;
import com.dataiku.dip.analysis.coreservices.ClusteringService;
import com.dataiku.dip.analysis.coreservices.PredictionService;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.MLSparkParams;
import com.dataiku.dip.analysis.ml.clustering.guess.ClusteringGuessPolicy;
import com.dataiku.dip.analysis.ml.prediction.guess.PredictionGuessPolicy;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.input.ExportShaker;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AnalysisCRUDController
extends DIPInternalControllerBase {
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private PredictionService predictionService;
    @Autowired
    private ClusteringService clusteringService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private SavedModelsCRUDService savedModelsCRUDService;
    @Autowired
    private AnalysisDataService dataService;
    static Logger logger = Logger.getLogger((String)"dku.analysis");

    @AuditInline
    @RequestMapping(value={"/api/analysis/create"})
    public void createAnalysis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String inputDatasetSmartName, @RequestParam String name) throws Exception {
        this.checkNotEmpty(new String[]{inputDatasetSmartName});
        String id = null;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            id = this.analysisCRUDService.create(projectKey, inputDatasetSmartName, name);
            AnalysisCRUDController.writeJSON((HttpServletResponse)resp, (Object)new Id(id));
            String message = "Created analysis for " + inputDatasetSmartName;
            t.commit(message);
        }
        AuditTrailService.EmittableAuditObj auditObj = this.auditTrailService.generic("analysis-create").with("projectKey", projectKey).with("datasetRef", inputDatasetSmartName).with("analysisId", id);
        auditObj.emit();
    }

    private AnalysisCreationData createAnalysisTemplate(HttpServletRequest req, String projectKey, String inputDatasetSmartName, String analysisName, MLTask.BackendType mlBackendType, String mlBackendName, Boolean useGlobalMetastore) throws Exception {
        MLSparkParams sparkParams;
        AnalysisCoreParams acp;
        AuthCtx u;
        String analysisId;
        this.checkNotEmpty(new String[]{inputDatasetSmartName});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (mlBackendType == MLTask.BackendType.KERAS) {
                AuthCtx user = this.authService.getMandatoryUser(req);
                user.failIfNoSafeCode("use a custom Keras architecture");
            }
            analysisId = this.analysisCRUDService.create(projectKey, inputDatasetSmartName, analysisName);
            t.commit("Created analysis for " + inputDatasetSmartName);
        }
        this.auditTrailService.generic("analysis-create").with("projectKey", projectKey).with("datasetRef", inputDatasetSmartName).with("analysisId", analysisId).emit();
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            if (mlBackendType == null) {
                throw ErrorContext.iae((String)"Invalid ML Backend type");
            }
            if (mlBackendType.isSparkBased()) {
                mlBackendName = this.checkBackendName(u, mlBackendType, mlBackendName, projectKey);
                SparkSettings sparkSettings = new ClusterSelector().selectForProject(u, projectKey).getSparkSettings();
                if (StringUtils.isBlank((String)mlBackendName)) {
                    mlBackendName = sparkSettings.getDefault().name;
                }
                sparkSettings.getByName(mlBackendName);
                sparkParams = RecipeCreationUtils.setupMLSparkParams(u, projectKey, mlBackendName, useGlobalMetastore);
            } else {
                sparkParams = null;
            }
        }
        return new AnalysisCreationData(u, acp, sparkParams);
    }

    private String checkBackendName(AuthCtx authCtx, MLTask.BackendType mlBackendType, String mlBackendName, String projectKey) throws IOException, DKUSecurityException {
        if (mlBackendType == null) {
            throw ErrorContext.iae((String)"Invalid ML Backend type");
        }
        if (mlBackendType.isSparkBased()) {
            SparkSettings sparkSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getSparkSettings();
            if (StringUtils.isBlank((String)mlBackendName)) {
                mlBackendName = sparkSettings.getDefault().name;
            }
            sparkSettings.getByName(mlBackendName);
            return mlBackendName;
        }
        return mlBackendName;
    }

    @AuditInline
    @RequestMapping(value={"/api/analysis/create-prediction-template"})
    public void createPredictionTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String inputDatasetSmartName, @RequestParam String analysisName, @RequestParam MLTask.BackendType mlBackendType, @RequestParam String mlBackendName, @RequestParam(required=false) Boolean useGlobalMetastore, @RequestParam String targetVariable, @RequestParam PredictionGuessPolicy guessPolicy, @RequestParam(required=false) String managedFolderSmartId, @RequestParam(required=false) PredictionMLTask.PredictionType predictionType, @RequestParam(required=false) String timeVariable, @RequestParam(required=false) List<String> timeseriesIdentifiers, @RequestParam(required=false) String treatmentVariable) throws Exception {
        AnalysisCreationData dat = this.createAnalysisTemplate(req, projectKey, inputDatasetSmartName, analysisName, mlBackendType, mlBackendName, useGlobalMetastore);
        String mlTaskId = this.predictionService.createAndGuess_NT(dat.u, dat.acp, targetVariable, managedFolderSmartId, mlBackendType, dat.sparkParams, guessPolicy, predictionType, timeVariable, timeseriesIdentifiers, treatmentVariable);
        AnalysisCRUDController.writeJSON((HttpServletResponse)resp, (Object)new TemplateCreationData(dat.acp.id, mlTaskId));
    }

    @AuditInline
    @RequestMapping(value={"/api/analysis/create-clustering-template"})
    public void createClusteringTemplate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String inputDatasetSmartName, @RequestParam String analysisName, @RequestParam MLTask.BackendType mlBackendType, @RequestParam String mlBackendName, @RequestParam(required=false) Boolean useGlobalMetastore, @RequestParam ClusteringGuessPolicy guessPolicy) throws Exception {
        AnalysisCreationData dat = this.createAnalysisTemplate(req, projectKey, inputDatasetSmartName, analysisName, mlBackendType, mlBackendName, useGlobalMetastore);
        String mlTaskId = this.clusteringService.createAndGuess_NT(dat.u, dat.acp, mlBackendType, dat.sparkParams, guessPolicy);
        AnalysisCRUDController.writeJSON((HttpServletResponse)resp, (Object)new TemplateCreationData(dat.acp.id, mlTaskId));
    }

    @AuditedCall(value={"msgType", "analysis-get", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam(required=false, defaultValue="false") boolean withMLTasksAndSavedModels) throws Exception {
        AuthCtx authCtx;
        AnalysisSummary summ = new AnalysisSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            summ.object = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            if (withMLTasksAndSavedModels) {
                summ.mlTasks = this.analysisCRUDService.listMLTasks(projectKey, analysisId, true);
                summ.savedModels = this.savedModelsCRUDService.listWithVersionsFromAnalysis(projectKey, analysisId);
            }
        }
        ITaggingService.TaggableType type = summ.object.getTaggableType();
        summ.timeline = this.timelinesService.getObjectTimeline_NT(type, projectKey, analysisId, summ.object.creationTag, summ.object.versionTag, 0, 100);
        summ.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, type, projectKey, analysisId);
        AnalysisCRUDController.writeJSON((HttpServletResponse)resp, (Object)summ);
    }

    @AuditedCall(value={"msgType", "analysis-get", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/get-core"})
    public void getCore(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            AnalysisCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.analysisCRUDService.getCoreMandatory(projectKey, analysisId));
        }
    }

    @AuditedCall(value={"msgType", "analysis-get-post-script-schema", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/get-post-script-schema"})
    public void getPostScriptSchema(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId) throws Exception {
        AnalysisCoreParams acp;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
        }
        AnalysisCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.dataService.getInferredSchemaForML_NT(acp, user));
    }

    @AuditedCall(value={"msgType", "analysis-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/analysis/list-on-dataset"})
    public void createAnalysis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetSmartName, @RequestParam(required=false, defaultValue="false") boolean withMLTasks) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ArrayList<AnalysisCoreParams.AnalysisListItem> heads = new ArrayList<AnalysisCoreParams.AnalysisListItem>();
            for (AnalysisCoreParams acp : this.analysisCRUDService.listCoreUnsafe(projectKey, datasetSmartName)) {
                AnalysisCoreParams.AnalysisListItem head = this.analysisCRUDService.makeHead(acp, withMLTasks);
                this.taggableObjectsService.setEditionInfoFromTags(acp, head);
                heads.add(head);
            }
            AnalysisCRUDController.writeJSON((HttpServletResponse)resp, heads);
        }
    }

    @AuditedCall(value={"msgType", "analysis-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/analysis/list-heads"})
    public void listHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false, defaultValue="false") boolean withMLTasks) throws Exception {
        AuthCtx authCtx;
        ArrayList heads = Lists.newArrayList();
        Map<Object, Object> analysisWithSavedModel = new HashMap();
        try (Transaction t = this.transactionService.beginRead();){
            if (withMLTasks) {
                analysisWithSavedModel = this.savedModelsCRUDService.listAnalysesWithVersions(projectKey);
            }
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            authCtx = this.authService.getMandatoryUser(req);
            for (AnalysisCoreParams acp : this.analysisCRUDService.listCoreUnsafe(projectKey, null)) {
                AnalysisCoreParams.AnalysisListItem head = this.analysisCRUDService.makeHead(acp, withMLTasks);
                this.taggableObjectsService.setEditionInfoFromTags(acp, head);
                heads.add(head);
                if (!withMLTasks) continue;
                head.hasSavedModel = analysisWithSavedModel.containsKey(head.id);
                head.hasActiveModel = head.hasSavedModel && (Boolean)analysisWithSavedModel.get(head.id) != false;
            }
        }
        this.interestsService.enrichListItems(authCtx.getAssociatedDSSUser(), projectKey, heads);
        AnalysisCRUDController.writeJSON((HttpServletResponse)resp, (Object)heads);
    }

    @AuditInline
    @RequestMapping(value={"/api/analysis/duplicate"})
    public void duplicate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId) throws Exception {
        Id id = null;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            id = this.analysisCRUDService.duplicate(projectKey, analysisId);
            AnalysisCRUDController.writeJSON((HttpServletResponse)resp, (Object)id);
            t.commit("Duplicated analysis " + projectKey + "." + analysisId);
        }
        this.auditTrailService.generic("analysis-duplicate").with("projectKey", projectKey).with("sourceId", analysisId).with("analysisId", id.id).emit();
    }

    @AuditInline
    @RequestMapping(value={"/api/analysis/save-core"})
    public void saveCore(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam(required=false) String saveInfo) throws Exception {
        TaggableObjectsService.TaggableObjectSaveInfo si = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        AnalysisCoreParams acp = (AnalysisCoreParams)JSON.parse((String)data, AnalysisCoreParams.class);
        this.checkNotNull(acp, "Analysis core params are null", new Object[0]);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, acp.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.analysisCRUDService.saveCore(acp, si.summaryOnly);
            if (StringUtils.isBlank((String)si.commitMessage)) {
                t.commit("Saved analysis " + acp.projectKey + "." + acp.name + " (id: " + acp.id + ")", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            } else if (si.summaryOnly) {
                t.commit("Updated summary for analysis " + acp.projectKey + "." + acp.name + " (id: " + acp.id + "): " + si.commitMessage, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            } else {
                t.commit("Saved analysis " + acp.projectKey + "." + acp.name + " (id: " + acp.id + "): " + si.commitMessage, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            }
        }
        this.auditTrailService.generic("analysis-save").with("projectKey", acp.projectKey).with("analysisId", acp.id).emit();
    }

    @AuditedCall(value={"msgType", "analysis-get-mltasks", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/list-mltasks"})
    public void listMLTasks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            AnalysisCRUDController.writeJSON((HttpServletResponse)resp, this.analysisCRUDService.listMLTasks(projectKey, analysisId, true));
        }
    }

    @AuditedCall(value={"msgType", "analysis-export-data", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/export-processed-data"})
    public void createExport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String params) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF, Privileges.ProjectLevelPrivilegeType.EXPORT_DATASETS_DATA);
            AnalysisCoreParams acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveSmart(projectKey, acp.inputDatasetSmartName);
            SerializedShakerScript ss = acp.script;
            ss.contextProjectKey = projectKey;
            ExportParams exportParams = (ExportParams)JSON.parse((String)params, ExportParams.class);
            exportParams.contextProjectKey = projectKey;
            exportParams.filenameBase = "analysis_output_" + acp.inputDatasetSmartName + "_" + analysisId;
            ExportShaker input = new ExportShaker(((DatasetAccessService)SpringUtils.getBean(DatasetAccessService.class)).getMandatory(datasetLoc), ss, exportParams.filenameBase, user);
            ExportStatus ret = ((ExportService)SpringUtils.getBean(ExportService.class)).handleExportRequest(user, input, exportParams);
            AnalysisCRUDController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    private static class AnalysisCreationData {
        AuthCtx u;
        AnalysisCoreParams acp;
        MLSparkParams sparkParams;

        public AnalysisCreationData(AuthCtx u, AnalysisCoreParams acp, MLSparkParams sparkParams) {
            this.u = u;
            this.acp = acp;
            this.sparkParams = sparkParams;
        }
    }

    static class TemplateCreationData {
        String analysisId;
        String mlTaskId;

        public TemplateCreationData(String analysisId, String mlTaskId) {
            this.analysisId = analysisId;
            this.mlTaskId = mlTaskId;
        }
    }

    public static class AnalysisSummary
    extends TaggableObjectsService.TaggableObjectSummary {
        List<AnalysisCRUDService.MLTaskHead> mlTasks;
        List<SavedModelsCRUDService.SavedModelWithVersions> savedModels;
    }
}

