/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.analysis;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.ClusteringService;
import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.coreservices.PredictionService;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.docgen.helpers.MDGFileUtil;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.SMStatus;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesMeta;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesService;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringSMMgmtService;
import com.dataiku.dip.analysis.ml.llm.LLMSMMgmtService;
import com.dataiku.dip.analysis.ml.llm.LLMSavedModelVersionDeploymentWithStatus;
import com.dataiku.dip.analysis.ml.prediction.PredictedDataService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesMeta;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelSnippetData;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.llm.LLMModelSnippetData;
import com.dataiku.dip.analysis.model.prediction.MLflowOrigin;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelSnippetData;
import com.dataiku.dip.analysis.model.prediction.overrides.MLOverridesParams;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.exceptions.DSSIllegalArgumentException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.externalml.mlflow.MLflowModelDeployResult;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.gh.GovernIntegrationService;
import com.dataiku.dip.llm.savedmodels.SavedModelVersionDeploymentCRUDService;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.savedmodels.SavedModelsService;
import com.dataiku.dip.savedmodels.proxymodels.ProxyModelConfiguration;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.analysis.AnalysisPredictedDataController;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.ShakerUtils;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.server.SerializedMemTableV2;
import com.dataiku.dip.shaker.server.SerializedTableChunk;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.wizard.MonitoringWizardCreatedSummary;
import com.dataiku.dip.unifiedmonitoring.wizard.MonitoringWizardService;
import com.dataiku.dip.unifiedmonitoring.wizard.MonitoringWizardSettings;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatusList;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifierList;
import com.dataiku.dss_gh.api.models.identifiers.DSSSavedModelVersionIdentifier;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.NDC;
import org.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class SavedModelsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private SavedModelsCRUDService service;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private PredictionRecipesService predictionRecipesService;
    @Autowired
    private PredictionSMMgmtService psmmService;
    @Autowired
    private ClusteringRecipesService clusteringRecipesService;
    @Autowired
    private ClusteringSMMgmtService csmmService;
    @Autowired
    private LLMSMMgmtService llmsmService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private MLBaseService mlBaseService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private PredictionService predictionService;
    @Autowired
    private ClusteringService clusteringService;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private GovernIntegrationService governIntegrationService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private SavedModelsService savedModelsService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private MonitoringWizardService monitoringWizardService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private PredictedDataService predictedDataService;
    @Autowired
    private SavedModelVersionDeploymentCRUDService smvDeploymentCrudService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.savedmodels.controller");

    @AuditedCall(value={"msgType", "savedmodel-get", "projectKey", "${projectKey}", "modelId", "${smartId}"})
    @RequestMapping(value={"/api/savedmodels/get"})
    public void getSavedModel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smartId) throws Exception {
        SavedModel sm;
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.SAVED_MODEL, smartId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
            sm = this.service.getMandatoryUnsafe(ref.getProjectKey(projectKey), ref.objectId);
        }
        SavedModelsController.writeJSON((HttpServletResponse)resp, (Object)sm);
    }

    @AuditedCall(value={"msgType", "savedmodel-get", "projectKey", "${projectKey}", "modelId", "${id}"})
    @RequestMapping(value={"/api/savedmodels/get-full-info"})
    @ResponseBody
    public NavigatorService.SavedModelFullInfo getFullInfo(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        NavigatorService.SavedModelFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, id);
            this.projectsService.failIfNoSavedModelReadUseAccess(u, loc, projectKey);
            info = this.navigatorService.getSavedModelFullInfo(loc, projectKey, u);
        }
        this.navigatorService.addSavedModelStatus_NT(info);
        this.navigatorService.addInfo_NT(info, u);
        return info;
    }

    @AuditedCall(value={"msgType", "savedmodels-governance-status-get", "projectKey", "${projectKey}", "modelId", "${id}", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/api/savedmodels/get-governance-status"})
    public void getGovernanceStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, id);
            this.projectsService.failIfNoSavedModelReadUseAccess(u, loc, projectKey);
        }
        DSSSavedModelVersionIdentifier dssSavedModelVersionIdentifier = this.governIntegrationService.buildDSSSavedModelVersionIdentifier(fmi);
        DSSItemIdentifierList dssItemIdentifierList = new DSSItemIdentifierList();
        dssItemIdentifierList.dssItemItentifiers.add(dssSavedModelVersionIdentifier);
        DSSItemGovernanceStatusList dssItemGovernanceStatusList = this.governIntegrationService.getDSSItemsGovernanceStatus(dssItemIdentifierList);
        if (dssItemGovernanceStatusList.dssItemGovernanceStatuses.isEmpty()) {
            throw new IllegalStateException("Unexpected error: cannot retrieve governance status for model version:" + fmi.toString());
        }
        SavedModelsController.writeJSON((HttpServletResponse)resp, dssItemGovernanceStatusList.dssItemGovernanceStatuses.get(0));
    }

    @AuditedCall(value={"msgType", "savedmodels-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/savedmodels/list"})
    public void listSavedModels(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        List<SavedModel> list;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            list = this.service.list(projectKey);
        }
        SavedModelsController.writeJSON((HttpServletResponse)resp, list);
    }

    @AuditedCall(value={"msgType", "savedmodels-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/savedmodels/list-with-accessible"})
    public void listSavedModelsWithAccessible(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        List<SavedModel> list;
        try (Transaction t = this.transactionService.beginRead();){
            list = this.service.list(projectKey);
            for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedSavedModels(projectKey)) {
                SavedModel model = this.service.getOrNull(datasetLoc.getProjectKey(), datasetLoc.getId());
                if (model == null) continue;
                SmartObjectRef ref = SmartObjectRef.fromResolved(ITaggingService.TaggableType.SAVED_MODEL, datasetLoc.getProjectKey(), datasetLoc.getId(), datasetLoc.getProjectKey());
                this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
                list.add(model);
            }
        }
        SavedModelsController.writeJSON((HttpServletResponse)resp, list);
    }

    @AuditedCall(value={"msgType", "savedmodels-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/savedmodels/list-heads"})
    @ResponseBody
    public List<SavedModel.SavedModelListItem> listSavedModelsHeads(HttpServletRequest req, @RequestParam String projectKey, @RequestParam(required=false, defaultValue="false") boolean withForeign) throws Exception {
        List<SavedModel> smList;
        AuthCtx authCtx;
        ArrayList<SavedModel.SavedModelListItem> heads = new ArrayList<SavedModel.SavedModelListItem>();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            smList = this.service.list(projectKey);
            if (withForeign) {
                this.exposedObjectsService.getAllObjectsSharedToProjectStream(projectKey).filter(ref -> ref.type == ITaggingService.TaggableType.SAVED_MODEL).map(ref -> (SavedModel)this.savedModelsDAO.getOrNullUnsafeNoFail(ref.getLoc())).filter(Objects::nonNull).forEach(smList::add);
            }
            for (SavedModel sm : smList) {
                SavedModel.SavedModelListItem item = new SavedModel.SavedModelListItem(sm);
                this.taggableObjectsService.setEditionInfoFromTags(sm, item);
                heads.add(item);
            }
        }
        for (int i = 0; i < heads.size(); ++i) {
            SavedModel sm = smList.get(i);
            SavedModel.SavedModelListItem item = (SavedModel.SavedModelListItem)heads.get(i);
            SMStatus smStatus = switch (sm.getType()) {
                case MLTask.MLTaskType.PREDICTION -> this.psmmService.getStatus_NT(sm);
                case MLTask.MLTaskType.CLUSTERING -> this.csmmService.getStatus_NT(sm);
                case MLTask.MLTaskType.LLM_GENERIC_RAW, MLTask.MLTaskType.LLM_GENERIC_PROMPTABLE_COMPLETION, MLTask.MLTaskType.LLM_CLASSIFICATION -> LLMSMMgmtService.getStatus_NT(sm);
                default -> throw new IllegalArgumentException(String.format("Unknown type %s", new Object[]{sm.getType()}));
            };
            item.versionsCount = smStatus.versions.size();
        }
        this.interestsService.enrichListItems(authCtx.getAssociatedDSSUser(), projectKey, heads);
        return heads;
    }

    @AuditInline
    @RequestMapping(value={"/api/savedmodels/save"})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam(required=false) String saveInfo) throws Exception {
        SavedModel old;
        SavedModel sm = (SavedModel)JSON.parse((String)data, SavedModel.class);
        TaggableObjectsService.TaggableObjectSaveInfo si = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, sm.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            old = this.service.getMandatory(sm.projectKey, sm.id);
            this.service.save(sm, false, si.summaryOnly);
            if (si.summaryOnly) {
                t.commit("Updated summary for saved model " + sm.projectKey + "." + sm.name + " (id: " + sm.id + ")", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            } else {
                t.commit("Saved saved model " + sm.projectKey + "." + sm.name + " (id: " + sm.id + ")");
            }
            this.auditTrailService.generic("savedmodel-save").with("projectKey", sm.projectKey).with("modelId", sm.id).emit();
        }
        t = this.transactionService.beginRead();
        try {
            boolean hasOutputChange = false;
            if (old.conditionalOutputs.size() != sm.conditionalOutputs.size()) {
                hasOutputChange = true;
            } else if (old.conditionalOutputs.size() > 0) {
                boolean bl = hasOutputChange = !old.conditionalOutputs.containsAll(sm.conditionalOutputs);
            }
            if (!hasOutputChange) {
                SavedModelsController.writeJSONString((HttpServletResponse)resp, (String)"{}");
            } else {
                int hiddenRecipes = 0;
                StringBuilder sbr = new StringBuilder("[");
                JSONArray payloads = new JSONArray();
                for (SerializedRecipe sr : this.graphService.getSuccessorRecipesAccrossProjectsUnsafe(new AnyLoc(sm.projectKey, sm.id))) {
                    if (!PredictionRecipesMeta.SCORING_META.getType().equals(sr.type) && !PredictionRecipesMeta.EVALUATION_META.getType().equals(sr.type)) continue;
                    logger.info((Object)("Warn of modification for successor recipe: " + sr.name + " - " + sr.projectKey));
                    if (!sm.projectKey.equals(sr.projectKey)) {
                        ++hiddenRecipes;
                        continue;
                    }
                    payloads.put((Object)this.recipesDAO.getPayloadOrNull(sr.projectKey, sr.name));
                    if (sbr.length() > 1) {
                        sbr.append(',');
                    }
                    sbr.append(JSON.json((Object)sr));
                }
                sbr.append(']');
                SavedModelsController.writeJSONString((HttpServletResponse)resp, (String)("{\"hiddenRecipes\":" + hiddenRecipes + ",\"recipes\":" + sbr.toString() + ",\"payloads\":" + payloads.toString() + "}"));
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-rename", "projectKey", "${projectKey}", "savedModelId", "${savedModelId}", "newName", "${newName}"})
    @RequestMapping(value={"/api/savedmodels/rename"}, method={RequestMethod.POST})
    public void rename(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String savedModelId, @RequestParam String newName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.service.rename(projectKey, savedModelId, newName);
            t.commit("Renamed saved model to " + newName + " (id: " + savedModelId + ")");
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-set-active", "projectKey", "${projectKey}", "modelId", "${savedModelId}", "version", "${newActiveVersion}"})
    @RequestMapping(value={"/api/savedmodels/prediction/set-active"})
    public void savedModelSetActive(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String savedModelId, @RequestParam String newActiveVersion) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SavedModel sm = this.service.getMandatory(projectKey, savedModelId);
            boolean schemaChanged = this.psmmService.setActive(sm, newActiveVersion) && this.predictionRecipesService.hasDownstreamRecipe(sm);
            SavedModelsController.writeJSONString((HttpServletResponse)resp, (String)("{\"schemaChanged\":" + schemaChanged + "}"));
            t.commit("Set active version of " + projectKey + "." + savedModelId + " to " + newActiveVersion);
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-new-model-version-with-different-overrides", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/api/savedmodels/prediction/create-model-version-with-different-overrides"})
    public void createModelVersionWithDifferentOverrides(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String newModelName, @RequestParam MLOverridesParams overridesParams) throws Exception {
        AuthCtx user;
        FullModelId originFmi = FullModelId.parse(fullModelId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, originFmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = this.authService.getMandatoryUser(req);
        }
        SavedModelsController.writeJSON((HttpServletResponse)resp, this.predictionService.createSavedModelVersionWithDifferentOverrides_NT(user, originFmi, newModelName, overridesParams));
    }

    @AuditedCall(value={"msgType", "savedmodel-delete-versions", "projectKey", "${projectKey}", "modelId", "${savedModelId}", "versions", "${versions}"})
    @RequestMapping(value={"/api/savedmodels/prediction/delete-versions"})
    public void savedModelDeleteVersion(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String savedModelId, @RequestParam String versions) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            sm = this.service.getMandatory(projectKey, savedModelId);
        }
        ArrayList versionsList = (ArrayList)JSON.parse((String)versions, (TypeToken)new TypeToken<ArrayList<String>>(){});
        for (String version : versionsList) {
            this.psmmService.deleteVersion_NT(sm, version, true);
        }
        this.psmmService.cleanUnreferencedPartitionedModelsNoFail(sm);
    }

    @AuditedCall(value={"msgType", "savedmodel-get-status", "projectKey", "${projectKey}", "modelId", "${savedModelId}"})
    @RequestMapping(value={"/api/savedmodels/prediction/get-status"})
    @ResponseBody
    public PredictionSMMgmtService.PredictionSMStatus getStatus(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String savedModelSmartId, @RequestParam(defaultValue="true") boolean onlyFinalVersions) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.SAVED_MODEL, savedModelSmartId);
            this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
            sm = this.service.getMandatory(ref.getProjectKey(projectKey), ref.objectId);
        }
        return this.psmmService.getStatus_NT(sm, onlyFinalVersions);
    }

    @ResponseBody
    @AuditInline
    @RequestMapping(value={"/api/savedmodels/prediction/create-external"}, method={RequestMethod.POST})
    public SavedModel createExternal(HttpServletRequest req, @RequestParam String projectKey, @RequestParam SavedModel.SavedModelType savedModelType, @RequestParam(required=false) PredictionMLTask.PredictionType predictionType, @RequestParam String name, @RequestParam(required=false) ProxyModelConfiguration proxyModelConfiguration) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            }
            SavedModel sm = this.savedModelsService.createExternalSavedModel(authCtx, projectKey, savedModelType, predictionType, name, proxyModelConfiguration);
            this.auditTrailService.generic("savedmodel-create").with("projectKey", projectKey).with("modelId", sm.id).with("type", sm.savedModelType.toString()).emit();
            return sm;
        }
        catch (Exception e) {
            this.auditTrailService.failure("savedmodel-create", (Throwable)e).with("projectKey", projectKey).with("name", name).with("type", savedModelType.toString()).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-set-active", "projectKey", "${projectKey}", "modelId", "${savedModelId}", "version", "${newActiveVersion}"})
    @RequestMapping(value={"/api/savedmodels/llm-generic/set-active"})
    public void llmGenericSetActive(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String savedModelId, @RequestParam boolean deployNewActiveModel, @RequestParam boolean deleteInactiveDeployments, @RequestParam String newActiveVersion) throws Exception {
        AuthCtx authCtx;
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            sm = this.service.getMandatory(projectKey, savedModelId);
            authCtx = this.authService.getMandatoryUser(req);
        }
        if (deployNewActiveModel) {
            this.smvDeploymentCrudService.deployFineTunedModel(authCtx, sm, new FullModelId(sm.projectKey, sm.getId(), newActiveVersion));
        }
        if (deleteInactiveDeployments) {
            HashSet<LLMSMMgmtService.LLMSMVersionHeader> versionsToDelete = new HashSet<LLMSMMgmtService.LLMSMVersionHeader>();
            LLMSMMgmtService.LLMSMStatus status = LLMSMMgmtService.getStatus_NT(sm);
            for (LLMSMMgmtService.LLMSMVersionHeader versionHeader : status.versions) {
                if (versionHeader.versionId.equals(newActiveVersion) || ((LLMModelSnippetData)versionHeader.snippet).deployment == null) continue;
                versionsToDelete.add(versionHeader);
            }
            this.smvDeploymentCrudService.deleteVersionsDeployments(authCtx, sm, versionsToDelete);
        }
        t = this.transactionService.beginWriteForUI(req);
        try {
            this.llmsmService.setLLMGenericVersionActive(sm, newActiveVersion);
            t.commit("Set active version of " + projectKey + "." + savedModelId + " to " + newActiveVersion);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-delete-versions", "projectKey", "${projectKey}", "modelId", "${savedModelId}", "versions", "${versions}"})
    @RequestMapping(value={"/api/savedmodels/llm-generic/delete-versions"})
    public void llmGenericDeleteVersions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String savedModelId, @RequestParam String versions) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SavedModel sm = this.service.getMandatory(projectKey, savedModelId);
            ArrayList versionsList = (ArrayList)JSON.parse((String)versions, (TypeToken)new TypeToken<ArrayList<String>>(){});
            for (String version : versionsList) {
                this.llmsmService.deleteLLMGenericModelVersion(authCtx, sm, version, false);
            }
            t.commit("Deleted " + versionsList.size() + " versions from " + projectKey + "." + savedModelId);
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-get-status", "projectKey", "${projectKey}", "modelId", "${savedModelSmartId}"})
    @RequestMapping(value={"/api/savedmodels/llm/get-status"})
    @ResponseBody
    public LLMSMMgmtService.LLMSMStatus getLLMStatus(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String savedModelSmartId) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, savedModelSmartId).resolved();
            this.projectsService.failIfNoSavedModelReadUseAccess(authCtx, loc, projectKey);
            sm = this.service.getMandatory(loc.getProjectKey(), loc.getId());
        }
        return LLMSMMgmtService.getStatus_NT(sm);
    }

    @AuditedCall(value={"msgType", "savedmodel-list-deployments", "projectKey", "${projectKey}", "savedModelId", "${savedModelId}"})
    @RequestMapping(value={"api/savedmodels/llm-generic/deployments/list"})
    @ResponseBody
    public List<LLMSavedModelVersionDeploymentWithStatus> listDeployments(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String savedModelId) throws Exception {
        SavedModel sm;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            authCtx = this.authService.getMandatoryUser(req);
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, savedModelId);
        }
        return this.smvDeploymentCrudService.listDeployments(authCtx, projectKey, sm);
    }

    @AuditedCall(value={"msgType", "savedmodel-get-deployment", "projectKey", "${projectKey}", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"api/savedmodels/llm-generic/deployments/get"})
    @ResponseBody
    public LLMSavedModelVersionDeploymentWithStatus getDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String fullModelId) throws Exception {
        SavedModel sm;
        FullModelId fmi;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            authCtx = this.authService.getMandatoryUser(req);
            fmi = FullModelId.parse(fullModelId);
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, fmi.getSavedModelID());
        }
        Optional<LLMSavedModelVersionDeploymentWithStatus> deploymentOpt = this.smvDeploymentCrudService.getDeployment(authCtx, projectKey, sm, fmi.getSavedModelVersionID());
        if (deploymentOpt.isEmpty()) {
            SavedModelsController.send404((String)("No deployment for version " + fmi.getSavedModelVersionID()), (HttpServletResponse)resp);
        }
        return deploymentOpt.get();
    }

    @AuditedCall(value={"msgTpe", "savedmodel-detach-deployment", "projectKey", "${projectKey}", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/api/savedmodels/llm-generic/deployments/detach"}, method={RequestMethod.DELETE})
    public void detachDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String fullModelId) throws Exception {
        SavedModel sm;
        FullModelId fmi;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            fmi = FullModelId.parse(fullModelId);
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, fmi.getSavedModelID());
        }
        this.smvDeploymentCrudService.detachDeployment(sm, fmi);
    }

    @AuditedCall(value={"msgTpe", "savedmodel-attach-deployment", "projectKey", "${projectKey}", "fullModelId", "${fullModelId}", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/savedmodels/llm-generic/deployments/attach"}, method={RequestMethod.PUT})
    @ResponseBody
    public LLMSavedModelVersionDeploymentWithStatus attachDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String fullModelId, @RequestParam String deploymentId) throws Exception {
        SavedModel sm;
        FullModelId fmi;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            fmi = FullModelId.parse(fullModelId);
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, fmi.getSavedModelID());
        }
        return this.smvDeploymentCrudService.attachDeployment(authCtx, projectKey, sm, fmi, deploymentId);
    }

    @AuditedCall(value={"msgTpe", "savedmodel-delete-deployment", "projectKey", "${projectKey}", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/api/savedmodels/llm-generic/deployments/delete"}, method={RequestMethod.DELETE})
    public void deleteDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String fullModelId) throws Exception {
        SavedModel sm;
        FullModelId fmi;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            fmi = FullModelId.parse(fullModelId);
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, fmi.getSavedModelID());
        }
        this.smvDeploymentCrudService.deleteDeployment(authCtx, projectKey, sm, fmi);
    }

    @AuditedCall(value={"msgTpe", "savedmodel-create-deployment", "projectKey", "${projectKey}", "fullModelId", "${fullModelId}", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/savedmodels/llm-generic/deployments/create"}, method={RequestMethod.POST})
    @ResponseBody
    public LLMSavedModelVersionDeploymentWithStatus createDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String fullModelId, @RequestParam String deploymentId) throws Exception {
        SavedModel sm;
        FullModelId fmi;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            fmi = FullModelId.parse(fullModelId);
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, fmi.getSavedModelID());
        }
        return this.smvDeploymentCrudService.createDeployment(authCtx, projectKey, sm, fmi, deploymentId);
    }

    @AuditedCall(value={"msgType", "savedmodel-get", "projectKey", "${projectKey}", "id", "${id}"})
    @RequestMapping(value={"/api/savedmodels/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        AuthCtx authCtx;
        TaggableObjectsService.TaggableObjectSummary summ = new TaggableObjectsService.TaggableObjectSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            summ.object = this.service.getMandatoryUnsafe(projectKey, id);
        }
        summ.timeline = this.timelinesService.getObjectTimeline_NT(summ.object.getTaggableType(), projectKey, id, summ.object.creationTag, summ.object.versionTag, 0, 100);
        summ.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summ.object.getTaggableType(), projectKey, id);
        SavedModelsController.writeJSON((HttpServletResponse)resp, (Object)summ);
    }

    @AuditInline
    @RequestMapping(value={"/api/savedmodels/prediction/deploy-scoring"})
    public void deployScoring(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String options) throws Exception {
        PredictionRecipesService.ScoringRecipeCreationOptions optionsObj = (PredictionRecipesService.ScoringRecipeCreationOptions)JSON.parse((String)options, PredictionRecipesService.ScoringRecipeCreationOptions.class);
        AuthCtx u = null;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (!optionsObj.createOutput) {
                this.checkNotBlank(optionsObj.outputDatasetSmartName, "No output dataset name", new Object[0]);
                DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, optionsObj.outputDatasetSmartName);
                this.datasetAccessService.getMandatory(loc);
            }
        }
        RecipeCreator.CreationResult result = this.predictionRecipesService.createScoringRecipe_NT(u, projectKey, optionsObj);
        SavedModelsController.writeJSON((HttpServletResponse)resp, (Object)new Id(result.id));
        this.auditTrailService.generic("recipe-create").with("projectKey", projectKey).with("recipeType", "prediction-scoring").with("recipeName", result.id).emit();
    }

    @AuditInline
    @RequestMapping(value={"/api/savedmodels/prediction/deploy-evaluation"})
    public void deployEvaluation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String options) throws Exception {
        PredictionRecipesService.EvaluationRecipeCreationOptions optionsObj = (PredictionRecipesService.EvaluationRecipeCreationOptions)JSON.parse((String)options, PredictionRecipesService.EvaluationRecipeCreationOptions.class);
        AuthCtx u = null;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (StringUtils.isBlank((String)optionsObj.scoredDatasetSmartName) && StringUtils.isBlank((String)optionsObj.metricsDatasetSmartName) && StringUtils.isBlank((String)optionsObj.evaluationStoreSmartName)) {
                throw new DSSIllegalArgumentException("No evaluation dataset nor metrics dataset nor evaluation store defined");
            }
            if (StringUtils.isNotBlank((String)optionsObj.scoredDatasetSmartName)) {
                DatasetLocUtils.DatasetLoc scoredLoc = DatasetLocUtils.resolveSmart(projectKey, optionsObj.scoredDatasetSmartName);
                this.datasetAccessService.getMandatory(scoredLoc);
            }
            if (StringUtils.isNotBlank((String)optionsObj.metricsDatasetSmartName)) {
                DatasetLocUtils.DatasetLoc metricsLoc = DatasetLocUtils.resolveSmart(projectKey, optionsObj.metricsDatasetSmartName);
                this.datasetAccessService.getMandatory(metricsLoc);
            }
            if (StringUtils.isNotBlank((String)optionsObj.evaluationStoreSmartName)) {
                DatasetLocUtils.DatasetLoc storeLoc = DatasetLocUtils.resolveSmart(projectKey, optionsObj.evaluationStoreSmartName);
                this.modelEvaluationStoresDAO.getMandatory(storeLoc);
            }
            if (StringUtils.isNotBlank((String)optionsObj.managedFolderSmartId)) {
                AnyLoc managedFolderLoc = AnyLoc.resolveSmart(projectKey, optionsObj.managedFolderSmartId);
                this.managedFoldersService.getMandatory(managedFolderLoc.getProjectKey(), managedFolderLoc.getId());
            }
        }
        String recipeName = this.predictionRecipesService.createEvaluationRecipe_NT(u, projectKey, optionsObj);
        SavedModelsController.writeJSON((HttpServletResponse)resp, (Object)new Id(recipeName));
        this.auditTrailService.generic("recipe-create").with("projectKey", projectKey).with("recipeType", "prediction-evaluation").with("recipeName", recipeName).emit();
    }

    @AuditInline
    @RequestMapping(value={"/api/savedmodels/prediction/deploy-standalone-evaluation"})
    public void deployStandaloneEvaluation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String options) throws Exception {
        PredictionRecipesService.StandaloneEvaluationRecipeCreationOptions optionsObj = (PredictionRecipesService.StandaloneEvaluationRecipeCreationOptions)JSON.parse((String)options, PredictionRecipesService.StandaloneEvaluationRecipeCreationOptions.class);
        AuthCtx u = null;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.checkNotBlank(optionsObj.evaluationStoreSmartName, "No model evaluation store", new Object[0]);
            DatasetLocUtils.DatasetLoc storeLoc = DatasetLocUtils.resolveSmart(projectKey, optionsObj.evaluationStoreSmartName);
            this.modelEvaluationStoresDAO.getMandatory(storeLoc);
            if (StringUtils.isNotBlank((String)optionsObj.managedFolderSmartId)) {
                AnyLoc managedFolderLoc = AnyLoc.resolveSmart(projectKey, optionsObj.managedFolderSmartId);
                this.managedFoldersService.getMandatory(managedFolderLoc.getProjectKey(), managedFolderLoc.getId());
            }
            if (StringUtils.isNotBlank((String)optionsObj.referenceManagedFolderSmartId)) {
                AnyLoc referenceManagedFolderLoc = AnyLoc.resolveSmart(projectKey, optionsObj.referenceManagedFolderSmartId);
                this.managedFoldersService.getMandatory(referenceManagedFolderLoc.getProjectKey(), referenceManagedFolderLoc.getId());
            }
        }
        String recipeName = this.predictionRecipesService.createStandaloneEvaluationRecipe_NT(u, projectKey, optionsObj);
        SavedModelsController.writeJSON((HttpServletResponse)resp, (Object)new Id(recipeName));
        this.auditTrailService.generic("recipe-create").with("projectKey", projectKey).with("recipeType", "prediction-standalone-evaluation").with("recipeName", recipeName).emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditedCall(value={"msgType", "model-documentation-export", "exportId", "${exportId}"})
    @RequestMapping(value={"/api/savedmodels/model-documentation-export"}, method={RequestMethod.GET})
    public void downloadPreparedExport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String exportId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUserNoXSRF(req);
        }
        File parentFolder = DKUApp.getFile((String[])new String[]{"tmp", "docgen/" + exportId});
        File outputFile = MDGFileUtil.getRenderedTemplateFile(parentFolder);
        try {
            if (outputFile != null) {
                MDGFileUtil.sendDocxDownload(outputFile, resp);
            } else {
                SavedModelsController.send404((String)"Generated file not found", (HttpServletResponse)resp);
            }
        }
        finally {
            if (outputFile != null) {
                DKUFileUtils.forceDelete((File)outputFile);
            }
            DKUFileUtils.forceDelete((File)parentFolder);
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-set-active", "projectKey", "${projectKey}", "modelId", "${savedModelId}", "version", "${newActiveVersion}"})
    @RequestMapping(value={"/api/savedmodels/clustering/set-active"})
    public void clusteringSetActive(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String savedModelId, @RequestParam String newActiveVersion) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SavedModel sm = this.service.getMandatory(projectKey, savedModelId);
            boolean schemaChanged = this.csmmService.setActive(sm, newActiveVersion) && this.clusteringRecipesService.hasDownstreamRecipe(sm);
            SavedModelsController.writeJSONString((HttpServletResponse)resp, (String)("{\"schemaChanged\":" + schemaChanged + "}"));
            t.commit("Set active version of " + projectKey + "." + savedModelId + " to " + newActiveVersion);
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-delete-versions", "projectKey", "${projectKey}", "modelId", "${savedModelId}", "versions", "${versions}"})
    @RequestMapping(value={"/api/savedmodels/clustering/delete-versions"})
    public void clusteringDeleteVersion(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String savedModelId, @RequestParam String versions) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SavedModel sm = this.service.getMandatory(projectKey, savedModelId);
            ArrayList versionsList = (ArrayList)JSON.parse((String)versions, (TypeToken)new TypeToken<ArrayList<String>>(){});
            for (String version : versionsList) {
                this.csmmService.deleteVersion(sm, version);
            }
            t.commit("Deleted " + versionsList.size() + " versions from " + projectKey + "." + savedModelId);
        }
    }

    @AuditedCall(value={"msgType", "savedmodel-get-status", "projectKey", "${projectKey}", "modelId", "${savedModelId}"})
    @RequestMapping(value={"/api/savedmodels/clustering/get-status"})
    @ResponseBody
    public ClusteringSMMgmtService.ClusteringSMStatus getClusteringStatus(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String savedModelSmartId) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();){
            SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.SAVED_MODEL, savedModelSmartId);
            this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
            sm = this.service.getMandatory(ref.getProjectKey(projectKey), ref.objectId);
        }
        return this.csmmService.getStatus_NT(sm);
    }

    @AuditInline
    @RequestMapping(value={"/api/savedmodels/clustering/deploy-scoring"})
    public void deployClusteringScoring(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String savedModelSmartName, @RequestParam String inputDatasetSmartName, @RequestParam boolean createOutput, @RequestParam String outputDatasetSmartName, @RequestParam(value="outputDatasetSettings") ManagedDatasetsCreationService.ManagedDatasetCreationSettings ods) throws Exception {
        AuthCtx u = null;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (!createOutput) {
                this.checkNotBlank(outputDatasetSmartName, "No output dataset name", new Object[0]);
                DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, outputDatasetSmartName);
                this.datasetAccessService.getMandatory(loc);
            }
        }
        RecipeCreator.CreationResult result = this.clusteringRecipesService.createScoringRecipe_NT(u, projectKey, savedModelSmartName, inputDatasetSmartName, createOutput, outputDatasetSmartName, ods);
        this.auditTrailService.generic("recipe-create").with("projectKey", projectKey).with("recipeType", "clustering-scoring").with("recipeName", result.id).emit();
        SavedModelsController.writeJSON((HttpServletResponse)resp, (Object)new Id(result.id));
    }

    @AuditedCall(value={"msgType", "savedmodel-guess-train-deploy", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/savedmodels/guess-train-deploy"})
    public void guessTrainDeploy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String modelId) throws Exception {
        MLTask mlTask;
        AnalysisCoreParams acp;
        MLTaskLoc mlTaskLoc;
        SavedModel sm;
        AuthCtx authCtx;
        SerializedRecipe recipe = null;
        HashSet trainingRecipeTypes = Sets.newHashSet((Object[])new String[]{PredictionRecipesMeta.TRAINING_META.getType(), ClusteringRecipesMeta.TRAINING_META.getType()});
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            sm = this.service.getMandatory(projectKey, modelId);
            FullModelId mlTaskFmi = FullModelId.parse(sm.lastExportedFrom);
            if (mlTaskFmi.type != FullModelId.Type.ANALYSIS) {
                throw new IllegalArgumentException("This model doesn't originate from an analysis");
            }
            for (SerializedRecipe sr : this.recipesDAO.listUnsafe(projectKey)) {
                if (!trainingRecipeTypes.contains(sr.getType()) || !modelId.equals(sr.getSingleOutput((String)"main").ref)) continue;
                recipe = sr;
                break;
            }
            if (recipe == null) {
                throw new IllegalArgumentException("Saved model is not built by a recipe of this project");
            }
            mlTaskLoc = mlTaskFmi.getTaskLoc();
            mlTaskLoc.analysisProjectKey = projectKey;
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, mlTaskLoc.analysisId);
            mlTask = this.analysisCRUDService.getMLTask(mlTaskLoc);
        }
        GuessTrainDeployThread ft = new GuessTrainDeployThread(authCtx, sm, recipe, mlTaskLoc, mlTask, acp);
        SavedModelsController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<String>>(){}));
    }

    @AuditedCall(value={"msgType", "savedmodel-deploy-mlflow", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @ResponseBody
    @RequestMapping(value={"/api/savedmodels/deploy-mlflow-model"})
    public FutureResponse<MLflowModelDeployResult> deployMLflowModel(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String folderRef, @RequestParam String path, @RequestParam String versionId, @RequestParam MLFlowModelVersionInfo modelVersionInfo, @RequestParam(required=false) MLflowOrigin origin, @RequestParam(required=false) SamplingParam samplingParam, @RequestParam(defaultValue="true") boolean activate, @RequestParam(defaultValue="0.5") double binaryClassificationThreshold, @RequestParam(defaultValue="true") boolean useOptimalThreshold, @RequestParam(defaultValue="false") boolean skipExpensiveReports) throws Exception {
        AuthCtx authCtx;
        if (StringUtils.isNotEmpty((String)modelVersionInfo.gatherFeaturesFromDataset) && (modelVersionInfo.predictionType == PredictionMLTask.PredictionType.MULTICLASS || modelVersionInfo.predictionType == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION)) {
            this.checkArgument(CollectionUtils.isNotEmpty(modelVersionInfo.classLabels), "Class labels must be specified for a prediction model", new Object[0]);
        }
        this.checkArgument(modelVersionInfo.proxyModelVersionConfiguration == null, "You cannot specify a proxyModelVersionConfiguration for a MLflow model. Please deploys this model as a \"proxy\" model instead.", new Object[0]);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (modelVersionInfo.pythonCodeEnvName != null) {
                this.permissionsService.checkCodeEnvPrivileges(authCtx, CodeEnvModel.EnvLang.PYTHON, modelVersionInfo.pythonCodeEnvName, Privileges.CodeEnvLevelPrivilegeType.USE);
            }
        }
        if (StringUtils.isNotBlank((String)modelVersionInfo.gatherFeaturesFromDataset)) {
            modelVersionInfo.evaluationDatasetSmartName = modelVersionInfo.gatherFeaturesFromDataset;
            modelVersionInfo.evaluationSamplingParam = samplingParam;
        }
        StreamableDatasetSelection selection = samplingParam == null ? StreamableDatasetSelection.head10K() : StreamableDatasetSelection.fromSamplingParam(samplingParam);
        return this.savedModelsService.deployMLflowModelInFuture(authCtx, projectKey, smId, folderRef, path, versionId, modelVersionInfo, origin, selection, activate, binaryClassificationThreshold, useOptimalThreshold, skipExpensiveReports);
    }

    @AuditedCall(value={"msgType", "savedmodel-deploy-proxy", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @ResponseBody
    @RequestMapping(value={"/api/savedmodels/deploy-proxy-model"})
    public FutureResponse<MLflowModelDeployResult> deployProxyModel(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String versionId, @RequestParam MLFlowModelVersionInfo modelVersionInfo, @RequestParam ContainerExecSelection containerExecSelection, @RequestParam(required=false) SamplingParam samplingParam, @RequestParam(defaultValue="true") boolean activate, @RequestParam(defaultValue="0.5") double binaryClassificationThreshold, @RequestParam(defaultValue="true") boolean useOptimalThreshold, @RequestParam(defaultValue="false") boolean skipExpensiveReports) throws Exception {
        AuthCtx authCtx;
        if (StringUtils.isNotEmpty((String)modelVersionInfo.gatherFeaturesFromDataset) && (modelVersionInfo.predictionType == PredictionMLTask.PredictionType.MULTICLASS || modelVersionInfo.predictionType == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION)) {
            this.checkArgument(CollectionUtils.isNotEmpty(modelVersionInfo.classLabels), "Class labels must be specified for a prediction model", new Object[0]);
        }
        this.checkArgument(modelVersionInfo.proxyModelVersionConfiguration.proxyModelConfiguration != null, "proxyModelConfiguration must be specified for a proxy model", new Object[0]);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (modelVersionInfo.pythonCodeEnvName != null) {
                this.permissionsService.checkCodeEnvPrivileges(authCtx, CodeEnvModel.EnvLang.PYTHON, modelVersionInfo.pythonCodeEnvName, Privileges.CodeEnvLevelPrivilegeType.USE);
            }
        }
        StreamableDatasetSelection selection = samplingParam == null ? StreamableDatasetSelection.head10K() : StreamableDatasetSelection.fromSamplingParam(samplingParam);
        return this.savedModelsService.deployProxyModelInFuture(authCtx, projectKey, smId, versionId, modelVersionInfo, selection, containerExecSelection, activate, binaryClassificationThreshold, useOptimalThreshold, skipExpensiveReports);
    }

    @AuditedCall(value={"msgType", "savedmodel-import-from-databricks", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @ResponseBody
    @RequestMapping(value={"/api/savedmodels/import-from-databricks"})
    public FutureResponse<MLflowModelDeployResult> importFromDatabricks(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String connectionName, @RequestParam(defaultValue="false") boolean useUnityCatalog, @RequestParam String modelName, @RequestParam String modelVersion, @RequestParam String versionId, @RequestParam MLFlowModelVersionInfo modelVersionInfo, @RequestParam(required=false) SamplingParam samplingParam, @RequestParam(defaultValue="true") boolean activate, @RequestParam(defaultValue="0.5") double binaryClassificationThreshold, @RequestParam(defaultValue="true") boolean useOptimalThreshold, @RequestParam(defaultValue="false") boolean skipExpensiveReports) throws Exception {
        DSSAuthCtx authCtx;
        if (StringUtils.isNotEmpty((String)modelVersionInfo.gatherFeaturesFromDataset) && (modelVersionInfo.predictionType == PredictionMLTask.PredictionType.MULTICLASS || modelVersionInfo.predictionType == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION)) {
            this.checkArgument(CollectionUtils.isNotEmpty(modelVersionInfo.classLabels), "Class labels must be specified for a prediction model", new Object[0]);
        }
        this.checkArgument(modelVersionInfo.proxyModelVersionConfiguration == null, "You cannot specify a proxyModelVersionConfiguration for a MLflow Databricks model. Please deploys this model as a \"proxy\" model instead.", new Object[0]);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (modelVersionInfo.pythonCodeEnvName != null) {
                this.permissionsService.checkCodeEnvPrivileges(authCtx, CodeEnvModel.EnvLang.PYTHON, modelVersionInfo.pythonCodeEnvName, Privileges.CodeEnvLevelPrivilegeType.USE);
            }
        }
        DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnectionAndCheckDetailsReadable(authCtx, connectionName);
        AutoDelete modelFolder = DSSTempUtils.getTempFolder((String)"dbx-model-download");
        FilesystemACLUtils.grantFSFullACLs((AuthCtx)authCtx, projectKey, new File[]{modelFolder});
        File file = this.savedModelsService.downloadModelFromDatabricks(authCtx, connection, useUnityCatalog, modelName, modelVersion, (File)modelFolder);
        assert (null != file && file.equals(modelFolder));
        if (StringUtils.isNotBlank((String)modelVersionInfo.gatherFeaturesFromDataset)) {
            modelVersionInfo.evaluationDatasetSmartName = modelVersionInfo.gatherFeaturesFromDataset;
            modelVersionInfo.evaluationSamplingParam = samplingParam;
        }
        MLflowOrigin mlflowDBXOrigin = new MLflowOrigin(modelName, modelVersion, connection.name, useUnityCatalog);
        StreamableDatasetSelection selection = samplingParam == null ? StreamableDatasetSelection.head10K() : StreamableDatasetSelection.fromSamplingParam(samplingParam);
        return this.savedModelsService.deployMLflowModelInFuture(authCtx, projectKey, smId, null, modelFolder.getAbsolutePath(), versionId, modelVersionInfo, mlflowDBXOrigin, selection, activate, binaryClassificationThreshold, useOptimalThreshold, skipExpensiveReports);
    }

    @AuditedCall(value={"msgType", "savedmodel-check-proxy-model-endpoint", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @ResponseBody
    @RequestMapping(value={"/api/savedmodels/check-proxy-model-endpoint"}, method={RequestMethod.POST})
    public FutureResponse<InfoMessage.InfoMessages> checkProxyModelEndpoint(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String versionId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        FullModelId fmi = this.checkAndParseProxyFmi(projectKey, smId, versionId);
        return this.savedModelsService.checkProxyModelEndpoint(authCtx, fmi);
    }

    @AuditedCall(value={"msgType", "savedmodel-setup-proxy-model-monitoring", "projectKey", "${projectKey}", "fullModelId", "${fullModelId}", "connection", "${connection}"})
    @ResponseBody
    @RequestMapping(value={"/api/savedmodels/setup-proxy-model-monitoring"}, method={RequestMethod.POST})
    public MonitoringWizardCreatedSummary setupExternalModelMonitoring(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String versionId, @RequestParam String connection, @RequestParam MonitoringWizardSettings params) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        FullModelId fmi = this.checkAndParseProxyFmi(projectKey, smId, versionId);
        return this.monitoringWizardService.setupExternalModelMonitoring(authCtx, projectKey, fmi, connection, params);
    }

    private FullModelId checkAndParseProxyFmi(String projectKey, String smId, String versionId) throws Exception {
        FullModelId fmi = new FullModelId(projectKey, smId, versionId);
        fmi.checkIdsValidity(null);
        if (!fmi.isExternalMLflowModelVersion() || !fmi.getMLflowImportedModelMetadata().isProxyModel()) {
            throw new IllegalArgumentException(String.format("Model version %s is not an external (proxy) model", fmi));
        }
        return fmi;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/savedmodels/predicted/get-prediction-display-script"})
    @ResponseBody
    public SerializedShakerScript getPredictionDisplayScript(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws IOException {
        FullModelId fmi = FullModelId.parse(fullModelId);
        return fmi.getHeadMLTask().predictionDisplayScript;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/savedmodels/predicted/refresh-table"})
    public void refreshTable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String displayScript, @RequestParam(value="allowCache", required=false, defaultValue="false") boolean allowCache, @RequestParam(value="filters", required=false, defaultValue="") String filters) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)displayScript, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            RefreshTableFutureThread ft = new RefreshTableFutureThread((DSSAuthCtx)user, allowCache, fmi, sss, (FilterRequest)JSON.parse((String)filters, FilterRequest.class));
            SavedModelsController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ft, 2000L, new TypeToken<FutureResponse<SerializedMemTableV2>>(){}));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/savedmodels/predicted/get-table-chunk"})
    public void getTableChunk(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String displayScript, @RequestParam int firstRow, @RequestParam int nbRows, @RequestParam int firstCol, @RequestParam int nbCols, @RequestParam String filters) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)displayScript, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        MemScriptRunner.TableWithReport twr = this.predictedDataService.getUncachedFiltered_NT(fmi, sss, (FilterRequest)JSON.parse((String)filters, FilterRequest.class));
        SerializedTableChunk stc = new SerializedTableChunk(firstRow, nbRows, firstCol, nbCols);
        stc.fill(twr.table, twr.filters, sss.coloring, sss.columnsSelection);
        SavedModelsController.writeJSON((HttpServletResponse)resp, (Object)stc);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/savedmodels/predicted/detailed-column-analysis"})
    public void detailedColumnAnalysis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String displayScript, @RequestParam String column, @RequestParam int alphanumMaxResults) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)displayScript, SerializedShakerScript.class);
        ss.contextProjectKey = fmi.getProjectKey();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            ShakerUtils.checkScriptCodePermission(user, ss);
        }
        SavedModelsController.writeJSON((HttpServletResponse)resp, (Object)this.predictedDataService.getDetailedColumnAnalysis(fmi, ss, column, alphanumMaxResults));
    }

    @AuditedCall(value={"msgType", "deploy-model-archive", "projectKey", "${projectKey}", "modelId", "${smId}", "versionId", "${versionId}"})
    @ResponseBody
    @RequestMapping(value={"/api/savedmodels/deploy-model-archive"})
    public FutureResponse<MLflowModelDeployResult> deployModelFromArchive(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String smId, @RequestParam String tmpPathKey, @RequestParam String versionId, @RequestParam MLFlowModelVersionInfo modelVersionInfo, @RequestParam(required=false) MLflowOrigin origin, @RequestParam(required=false) SamplingParam samplingParam, @RequestParam(defaultValue="true") boolean activate, @RequestParam(defaultValue="0.5") double binaryClassificationThreshold, @RequestParam(defaultValue="true") boolean useOptimalThreshold, @RequestParam(defaultValue="false") boolean skipExpensiveReports) throws Exception {
        File tmpDir;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        try {
            File archive = DSSTempUtils.getTempFileWithSpecificName((String)"saved_model", (String)tmpPathKey, (String)"zip");
            tmpDir = DSSTempUtils.getTempFolderWithSpecificName((String)"saved_model", (String)("extract_" + tmpPathKey));
            ZipUnzipDir.extractFolder(archive, tmpDir, false);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to extract model archive", (Throwable)e);
            throw e;
        }
        if (tmpDir != null && tmpDir.exists()) {
            return this.deployMLflowModel(req, projectKey, smId, null, tmpDir.getPath(), versionId, modelVersionInfo, origin, samplingParam, activate, binaryClassificationThreshold, useOptimalThreshold, skipExpensiveReports);
        }
        throw new IOException("Failed to extract model archive");
    }

    @AuditedCall(value={"msgType", "savedmodel-import-archive", "projectKey", "${projectKey}", "filePath", "${filePath}"})
    @RequestMapping(value={"/api/savedmodels/import-archive"}, method={RequestMethod.POST})
    public void importModelFromArchive(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="projectKey") String projectKey, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        SavedModelsController.writeJSON((HttpServletResponse)resp, (Object)this.savedModelsService.importModelFromArchive(filePart));
    }

    public class GuessTrainDeployThread
    extends SimpleFutureThread<String> {
        private final SavedModel sm;
        private final MLTaskLoc mlTaskLoc;
        private MLTask mlTask;
        private AnalysisCoreParams acp;
        private final SerializedRecipe recipe;

        public GuessTrainDeployThread(AuthCtx owner, SavedModel sm, SerializedRecipe recipe, MLTaskLoc mlTaskLoc, MLTask mlTask, AnalysisCoreParams acp) {
            super(owner);
            this.sm = sm;
            this.recipe = recipe;
            this.mlTaskLoc = mlTaskLoc;
            this.mlTask = mlTask;
            this.acp = acp;
        }

        @Override
        protected String compute() throws Exception {
            try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Re-guessing task params");){
                if (SavedModelsController.this.mlBaseService.isGuessing(this.mlTaskLoc)) {
                    throw new IllegalArgumentException("ML Task is already in guessing state. Wait for guessing to finish");
                }
                if (SavedModelsController.this.mlBaseService.isTraining(this.mlTaskLoc)) {
                    throw new IllegalArgumentException("ML Task is already in training state. Wait for training to finish");
                }
                if (this.mlTask.taskType.equals((Object)MLTask.MLTaskType.PREDICTION)) {
                    PredictionMLTask predictionMLTask = (PredictionMLTask)this.mlTask;
                    if (!predictionMLTask.predictionType.supportsGuessTrainDeploy()) {
                        throw new IllegalArgumentException("Unsupported Guess-Train-Deploy: " + String.valueOf((Object)((PredictionMLTask)this.mlTask).predictionType));
                    }
                    SavedModelsController.this.predictionService.reguess_NT(this.owner, this.acp, this.mlTaskLoc, predictionMLTask);
                } else if (this.mlTask.taskType.equals((Object)MLTask.MLTaskType.CLUSTERING)) {
                    SavedModelsController.this.clusteringService.reguess_NT(this.owner, this.acp, this.mlTaskLoc, (ClusteringMLTask)this.mlTask);
                } else {
                    throw new IllegalArgumentException("Unknown ML task type: " + String.valueOf((Object)this.mlTask.taskType));
                }
                try (Transaction t = SavedModelsController.this.transactionService.beginRead();){
                    this.acp = SavedModelsController.this.analysisCRUDService.getCoreMandatory(this.mlTaskLoc.analysisProjectKey, this.mlTaskLoc.analysisId);
                    this.mlTask = SavedModelsController.this.analysisCRUDService.getMLTask(this.mlTaskLoc);
                }
            }
            try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Re-training task models");){
                String sessionId;
                if (this.mlTask.taskType == MLTask.MLTaskType.PREDICTION) {
                    sessionId = SavedModelsController.this.predictionService.trainStart_NT(this.owner, this.acp, this.mlTaskLoc, (PredictionMLTask)this.mlTask, "Automatic retrain", "", false);
                } else if (this.mlTask.taskType == MLTask.MLTaskType.CLUSTERING) {
                    sessionId = SavedModelsController.this.clusteringService.trainStart_NT(this.owner, this.acp, this.mlTaskLoc, (ClusteringMLTask)this.mlTask, "Automatic retrain", "", false);
                } else {
                    throw new Error("unreachable");
                }
                logger.info((Object)("Started session " + sessionId));
                while (SavedModelsController.this.mlBaseService.isTraining(this.mlTaskLoc)) {
                    Thread.sleep(10000L);
                }
            }
            state = FutureProgress.pushAutoCloseableState((String)"Redeploying best model");
            try {
                List<FullModelId> fmis = SavedModelsController.this.mlBaseService.listCompletedModelIds(this.mlTaskLoc);
                if (this.mlTask.taskType == MLTask.MLTaskType.PREDICTION) {
                    PredictionMLTask predictionMLTask = (PredictionMLTask)this.mlTask;
                    Map<String, PredictionModelSnippetData> models = SavedModelsController.this.predictionService.getSnippets_NT((PredictionMLTask)this.mlTask, fmis);
                    double bestScore = Double.NEGATIVE_INFINITY;
                    String bestFmi = null;
                    for (Map.Entry<String, PredictionModelSnippetData> model : models.entrySet()) {
                        PredictionModelSnippetData snippet = model.getValue();
                        if (snippet.trainInfo == null || snippet.trainInfo.state != ModelTrainInfo.ModelTrainState.DONE) continue;
                        double score = Double.NEGATIVE_INFINITY;
                        switch (predictionMLTask.predictionType) {
                            case REGRESSION: {
                                score = snippet.r2;
                                break;
                            }
                            case BINARY_CLASSIFICATION: 
                            case MULTICLASS: 
                            case DEEP_HUB_IMAGE_CLASSIFICATION: {
                                score = snippet.auc;
                                break;
                            }
                            case DEEP_HUB_IMAGE_OBJECT_DETECTION: {
                                score = snippet.averagePrecisionIOU50;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Cannot handle prediction type: " + String.valueOf((Object)predictionMLTask.predictionType));
                            }
                        }
                        if (!(score > bestScore)) continue;
                        bestScore = score;
                        bestFmi = model.getKey();
                    }
                    if (bestFmi == null) {
                        throw new Exception("No model trained successfully, can't deploy");
                    }
                    SavedModelsController.this.predictionRecipesService.updateTrainingRecipePrep_NT(this.owner, FullModelId.parse(bestFmi), this.recipe, true, new PredictionRecipesService.TrainingRecipeCreationOptions());
                    Iterator<Map.Entry<String, PredictionModelSnippetData>> iterator = bestFmi;
                    return iterator;
                }
                if (this.mlTask.taskType == MLTask.MLTaskType.CLUSTERING) {
                    Map<String, ClusteringModelSnippetData> models = SavedModelsController.this.clusteringService.getSnippets_NT(fmis);
                    double bestScore = Double.NEGATIVE_INFINITY;
                    String bestFmi = null;
                    for (Map.Entry<String, ClusteringModelSnippetData> model : models.entrySet()) {
                        double score;
                        ClusteringModelSnippetData snippet = model.getValue();
                        if (snippet.trainInfo == null || snippet.trainInfo.state != ModelTrainInfo.ModelTrainState.DONE || !((score = snippet.silhouette) > bestScore)) continue;
                        bestScore = score;
                        bestFmi = model.getKey();
                    }
                    if (bestFmi == null) {
                        throw new Exception("No model trained successfully, can't deploy");
                    }
                    SavedModelsController.this.clusteringRecipesService.updateTrainingRecipePrep_NT(this.owner, FullModelId.parse(bestFmi), this.recipe, true);
                    Iterator<Map.Entry<String, ClusteringModelSnippetData>> iterator = bestFmi;
                    return iterator;
                }
                throw new Error("unreachable");
            }
            finally {
                if (state != null) {
                    state.close();
                }
            }
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "guess-train-deploy";
            fp.displayName = "Regenerate model " + this.sm.id + " in project " + this.sm.getProjectKey();
            return fp;
        }
    }

    class RefreshTableFutureThread
    extends FutureThread<SerializedMemTableV2> {
        final FullModelId fmi;
        final SerializedShakerScript displayScript;
        final FilterRequest frequest;
        final boolean allowCache;
        final FuturePayload futurePayload;
        SerializedMemTableV2 result;

        public RefreshTableFutureThread(DSSAuthCtx user, boolean allowCache, FullModelId fmi, SerializedShakerScript sss, FilterRequest filterRequest) {
            super(user);
            this.result = new SerializedMemTableV2();
            this.allowCache = allowCache;
            this.fmi = fmi;
            this.displayScript = sss;
            this.frequest = filterRequest;
            this.futurePayload = AnalysisPredictedDataController.buildFuturePayload(fmi);
        }

        public SerializedMemTableV2 getResult() {
            return this.result;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() throws Exception {
            NDC.push((String)("refresh-pml-table: " + String.valueOf(this.fmi)));
            try {
                MemScriptRunner.TableWithReport twr = SavedModelsController.this.predictedDataService.getUncachedFiltered_NT(this.fmi, this.displayScript, this.frequest);
                this.result.fill(twr, this.displayScript, 64, 32);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to get table data", (Throwable)e);
                throw e;
            }
            finally {
                NDC.pop();
            }
        }
    }

    public static class ReplaceableSavedModel {
        String recipeName;
        String inputDatasetName;
        SavedModel savedModel;
        String outputDatasetName;
    }
}

