/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.IntegrationChannelsRegistry;
import com.dataiku.dip.integrations.IntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationHooksRegistry;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.scheduler.IntegrationChannelsDAO;
import com.dataiku.dip.scheduler.reports.MessageLookupBuilder;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ScenarioReportEvent;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunKey;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepRegistry;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.ScenarioRunsService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ScenarioIntercomController
extends DIPInternalControllerBase {
    @Autowired
    TransactionService transactionService;
    @Autowired
    ScenariosService scenariosService;
    @Autowired
    ScenarioRunContext scenarioRunContext;
    @Autowired
    ScenarioRunsService scenarioRunsService;
    @Autowired
    ScenariosTriggerService scenariosTriggerService;
    @Autowired
    FutureService futureService;
    @Autowired
    APITicketService apiTicketService;
    @Autowired
    TicketAuthService authService;
    @Autowired
    IntegrationChannelsDAO integrationChannelsDAO;
    @Autowired
    GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    VariablesService variablesService;
    @Autowired
    ReadWriteJobsInternalDB jobsDBService;
    @Autowired
    AuditTrailService auditTrailService;
    @Autowired
    ProjectsService projectsService;
    private static Logger logger = Logger.getLogger((String)"dip.controllers.scenarios");

    @AuditedCall(value={"msgType", "integration-channel-get", "id", "${id}"})
    @RequestMapping(value={"/api/tintercom/integration-channels/get"})
    public void lookup(HttpServletRequest req, HttpServletResponse resp, String id) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            IntegrationChannel channel = this.integrationChannelsDAO.getMandatory(id);
            channel = channel.withConfiguration(null);
            ScenarioIntercomController.writeJSON((HttpServletResponse)resp, (Object)channel);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/tintercom/scenarios/fire-trigger"})
    public void fireTrigger(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String triggerState, @RequestParam(required=false) String triggerFireParams) throws Exception {
        TriggerFire triggerFire = null;
        try (Transaction t = this.transactionService.beginRead();
             APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            APITicketService.Ticket ticket = tu.getTicket();
            if (!(ticket.getPayload() instanceof TriggerFire)) {
                throw new IllegalArgumentException("The API ticket used is not associated with a scenario trigger");
            }
            triggerFire = (TriggerFire)ticket.getPayload();
            if (triggerState != null) {
                triggerFire = triggerFire.withTriggerState(triggerState);
            }
            if (triggerFireParams != null) {
                triggerFire = triggerFire.withParams((JsonObject)JSON.parse((String)triggerFireParams, JsonObject.class));
            }
            triggerFire.executedFromExternal = true;
            this.auditTrailService.generic("scenario-fire-trigger").with("projectKey", triggerFire.getProjectKey()).with("scenarioId", triggerFire.getScenarioId()).with("triggerId", triggerFire.getTrigger().getId()).emit();
        }
        catch (Exception e) {
            if (triggerFire != null) {
                this.auditTrailService.failure("scenario-fire-trigger", (Throwable)e).with("projectKey", triggerFire.getProjectKey()).with("scenarioId", triggerFire.getScenarioId()).with("triggerId", triggerFire.getTrigger().getId()).emit();
            } else {
                this.auditTrailService.failure("scenario-fire-trigger", (Throwable)e).emit();
            }
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/tintercom/scenarios/run-step"})
    public void runStep(HttpServletRequest req, HttpServletResponse resp, @RequestParam String stepData) throws Exception {
        Step step = (Step)JSON.parse((String)stepData, Step.class);
        ScenarioRunKey scenarioRun = null;
        try (Transaction t = this.transactionService.beginRead();){
            if (StringUtils.isBlank((String)step.getId())) {
                step = step.withId(StepRegistry.getMeta(step).buildId(step));
            }
            if (StringUtils.isBlank((String)step.getName())) {
                step = step.withName(StepRegistry.getMeta(step).buildName(step));
            }
            try (APITicketService.TicketUsage ticketUsage = this.authService.getAndUseMandTicket(req);){
                APITicketService.Ticket ticket = ticketUsage.getTicket();
                scenarioRun = this.getScenarioRunFromTicket(ticket);
                RunStepFutureThread ft = new RunStepFutureThread(scenarioRun.getScenario(), (ScenarioRun)scenarioRun, step, ((ScenarioRun)scenarioRun).getRunAsUser(), ticket);
                FutureResponse<StepRun> fr = this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<StepRun>>(){});
                ScenarioIntercomController.writeJSON((HttpServletResponse)resp, fr);
            }
            this.auditTrailService.generic("scenario-run-step").with("projectKey", scenarioRun.getScenario().getProjectKey()).with("scenarioId", scenarioRun.getScenario().getId()).with("scenarioRunId", scenarioRun.getRunId()).with("stepId", step.getId()).emit();
        }
        catch (Exception e) {
            if (scenarioRun != null) {
                this.auditTrailService.failure("scenario-run-step", (Throwable)e).with("projectKey", scenarioRun.getScenario().getProjectKey()).with("scenarioId", scenarioRun.getScenario().getId()).with("scenarioRunId", scenarioRun.getRunId()).with("stepId", step.getId()).emit();
            } else {
                this.auditTrailService.failure("scenario-run-step", (Throwable)e).emit();
            }
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/tintercom/scenarios/add-step-report-item"})
    public void addStepReportItem(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String objectRef, @RequestParam(required=false) String partition, @RequestParam(value="reportItem") String reportItemData) throws Exception {
        StepRun stepRun = null;
        ReportItem reportItem = (ReportItem)JSON.parse((String)reportItemData, ReportItem.class);
        try (Transaction t = this.transactionService.beginRead();){
            try (APITicketService.TicketUsage ticketUsage = this.authService.getAndUseMandTicket(req);){
                APITicketService.Ticket ticket = ticketUsage.getTicket();
                stepRun = this.getStepRunFromTicket(ticket);
                String contextProjectKey = stepRun.getScenarioRun().getScenario().getProjectKey();
                AnyLoc loc = StringUtils.isNotBlank((String)objectRef) ? AnyLoc.resolveSmart(contextProjectKey, objectRef) : new AnyLoc(contextProjectKey, "");
                this.jobsDBService.tryRegisterFlowObjectEvent(loc, partition, null, stepRun.getScenarioRun(), stepRun, reportItem);
            }
            this.auditTrailService.generic("scenario-add-step-report-item").with("projectKey", stepRun.getScenarioRun().getScenario().getProjectKey()).with("scenarioId", stepRun.getScenarioRun().getScenario().getId()).with("scenarioRunId", stepRun.getScenarioRun().getRunId()).with("stepId", stepRun.getStep().getId()).with("itemType", reportItem.getType().name()).emit();
        }
        catch (Exception e) {
            if (stepRun != null) {
                this.auditTrailService.failure("scenario-add-step-report-item", (Throwable)e).with("projectKey", stepRun.getScenarioRun().getScenario().getProjectKey()).with("scenarioId", stepRun.getScenarioRun().getScenario().getId()).with("scenarioRunId", stepRun.getScenarioRun().getRunId()).with("stepId", stepRun.getStep().getId()).emit();
            } else {
                this.auditTrailService.failure("scenario-add-step-report-item", (Throwable)e).emit();
            }
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/tintercom/scenarios/set-variables"})
    public void addVariable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String variables) throws Exception {
        ScenarioRunKey scenarioRun = null;
        try (Transaction t = this.transactionService.beginRead();){
            try (APITicketService.TicketUsage ticketUsage = this.authService.getAndUseMandTicket(req);){
                APITicketService.Ticket ticket = ticketUsage.getTicket();
                scenarioRun = this.getScenarioRunFromTicket(ticket);
                JsonObject variablesObj = (JsonObject)JSON.parse((String)variables, JsonObject.class);
                for (Map.Entry elt : variablesObj.entrySet()) {
                    ((ScenarioRun)scenarioRun).getVariables().add((String)elt.getKey(), (JsonElement)elt.getValue());
                }
                ScenarioIntercomController.writeJSON((HttpServletResponse)resp, (Object)scenarioRun);
            }
            this.auditTrailService.generic("scenario-variables-set").with("projectKey", scenarioRun.getScenario().getProjectKey()).with("scenarioId", scenarioRun.getScenario().getId()).with("scenarioRunId", scenarioRun.getRunId()).emit();
        }
        catch (Exception e) {
            if (scenarioRun != null) {
                this.auditTrailService.failure("scenario-variables-set", (Throwable)e).with("projectKey", scenarioRun.getScenario().getProjectKey()).with("scenarioId", scenarioRun.getScenario().getId()).with("scenarioRunId", scenarioRun.getRunId()).emit();
            } else {
                this.auditTrailService.failure("scenario-variables-set", (Throwable)e).emit();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/tintercom/scenarios/get-all-variables"})
    public void getAllVariables(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        ScenarioRunKey scenarioRun = null;
        try (Transaction t = this.transactionService.beginRead();){
            try (APITicketService.TicketUsage ticketUsage = this.authService.getAndUseMandTicket(req);){
                APITicketService.Ticket ticket = ticketUsage.getTicket();
                scenarioRun = this.getScenarioRunFromTicket(ticket);
                this.scenarioRunContext.setScenarioRun((ScenarioRun)scenarioRun);
                try {
                    MessageLookupBuilder lookupBuilder = new MessageLookupBuilder();
                    VariableLookup lookup = lookupBuilder.buildForVariablesStep((ScenarioRun)scenarioRun);
                    ScenarioIntercomController.writeJSON((HttpServletResponse)resp, (Object)lookup.getAllVariablesTyped());
                }
                finally {
                    this.scenarioRunContext.clearScenarioRun();
                }
            }
            this.auditTrailService.generic("scenario-variables-get").with("projectKey", scenarioRun.getScenario().getProjectKey()).with("scenarioId", scenarioRun.getScenario().getId()).with("scenarioRunId", scenarioRun.getRunId()).emit();
        }
        catch (Exception e) {
            if (scenarioRun != null) {
                this.auditTrailService.failure("scenario-variables-get", (Throwable)e).with("projectKey", scenarioRun.getScenario().getProjectKey()).with("scenarioId", scenarioRun.getScenario().getId()).with("scenarioRunId", scenarioRun.getRunId()).emit();
            } else {
                this.auditTrailService.failure("scenario-variables-get", (Throwable)e).emit();
            }
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/tintercom/scenarios/get-step-outputs"})
    public void getStepResults(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        ScenarioRunKey scenarioRun = null;
        try (Transaction t = this.transactionService.beginRead();){
            try (APITicketService.TicketUsage ticketUsage = this.authService.getAndUseMandTicket(req);){
                APITicketService.Ticket ticket = ticketUsage.getTicket();
                scenarioRun = this.getScenarioRunFromTicket(ticket);
                ArrayList stepRunResults = Lists.newArrayList();
                Map<String, Object> stepRunOutputs = ((ScenarioRun)scenarioRun).getStepRunOutputs();
                for (StepRun stepRun : this.scenariosService.getStepRunsOfRun(scenarioRun)) {
                    if (!StringUtils.isNotBlank((String)stepRun.getStep().getName()) || !stepRunOutputs.containsKey(stepRun.getRunId())) continue;
                    stepRunResults.add(new StepRunResult(stepRun.getStep().getName(), stepRunOutputs.get(stepRun.getRunId())));
                }
                ScenarioIntercomController.writeJSON((HttpServletResponse)resp, (Object)stepRunResults);
            }
            this.auditTrailService.generic("scenario-step-outputs-get").with("projectKey", scenarioRun.getScenario().getProjectKey()).with("scenarioId", scenarioRun.getScenario().getId()).with("scenarioRunId", scenarioRun.getRunId()).emit();
        }
        catch (Exception e) {
            if (scenarioRun != null) {
                this.auditTrailService.failure("scenario-step-outputs-get", (Throwable)e).with("projectKey", scenarioRun.getScenario().getProjectKey()).with("scenarioId", scenarioRun.getScenario().getId()).with("scenarioRunId", scenarioRun.getRunId()).emit();
            } else {
                this.auditTrailService.failure("scenario-step-outputs-get", (Throwable)e).emit();
            }
            throw e;
        }
    }

    private ScenarioRun getScenarioRunFromTicket(APITicketService.Ticket ticket) {
        return this.getScenarioRunFromTicket(ticket, true);
    }

    private ScenarioRun getScenarioRunFromTicket(APITicketService.Ticket ticket, boolean mandatory) {
        ScenarioRun scenarioRun = null;
        if (ticket.getPayload() instanceof ScenarioRun) {
            scenarioRun = (ScenarioRun)ticket.getPayload();
        } else if (ticket.getPayload() instanceof StepRun) {
            scenarioRun = ((StepRun)ticket.getPayload()).getScenarioRun();
        } else if (mandatory) {
            throw new IllegalArgumentException("The API ticket used is not associated with a scenario run");
        }
        return scenarioRun;
    }

    private StepRun getStepRunFromTicket(APITicketService.Ticket ticket) {
        if (!(ticket.getPayload() instanceof StepRun)) {
            throw new IllegalArgumentException("The API ticket used is not associated with a step run");
        }
        StepRun stepRun = (StepRun)ticket.getPayload();
        return stepRun;
    }

    public static FuturePayload buildFuturePayload(Scenario scenario, Step step, ScenarioRun scenarioRun) {
        FuturePayload fp = new FuturePayload();
        fp.action = "run_step";
        fp.targets.add(DSSFuturePayloadUtils.forTaggableObject(scenario).withPart(step.getName()));
        fp.displayName = "Run step " + step.getType() + " in scenario " + scenario.getName();
        return fp;
    }

    @AuditInline
    @RequestMapping(value={"/api/tintercom/scenarios/send-message"})
    public void sendMessage(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="variables") String variablesJson, @RequestParam(value="messaging") String messagingJson, @RequestParam(required=false) String projectKey) throws Exception {
        ScenarioRun scenarioRun = null;
        IntegrationHook messaging = null;
        try (APITicketService.TicketUsage ticketUsage = this.authService.getAndUseMandTicket(req);){
            VariableLookup lookup;
            scenarioRun = this.getScenarioRunFromTicket(ticketUsage.getTicket(), false);
            if (projectKey == null && scenarioRun != null) {
                projectKey = scenarioRun.scenario.projectKey;
            }
            if (projectKey == null) {
                throw ErrorContext.iae((String)"contextual project key required");
            }
            JsonObject messagingElt = (JsonObject)JSON.parse((String)messagingJson, JsonObject.class);
            if (!messagingElt.has("type") || messagingElt.get("type").isJsonNull()) {
                if (!messagingElt.has("configuration") || messagingElt.get("configuration").isJsonNull()) {
                    throw new IllegalArgumentException("No configuration on the messaging, cannot infer type");
                }
                JsonObject configurationElt = messagingElt.get("configuration").getAsJsonObject();
                if (!configurationElt.has("channelId") || configurationElt.get("channelId").isJsonNull()) {
                    throw new IllegalArgumentException("No channelId on the messaging, cannot infer type");
                }
                String channelId = configurationElt.get("channelId").getAsString();
                try (Transaction t = this.transactionService.beginRead();){
                    IntegrationChannel channel = this.integrationChannelsDAO.getMandatory(channelId);
                    messagingElt.addProperty("type", IntegrationChannelsRegistry.getMeta((String)channel.getType()).getAssociatedIntegrationType());
                }
                messaging = (IntegrationHook)JSON.parse((JsonElement)messagingElt, IntegrationHook.class);
            } else {
                messaging = (IntegrationHook)JSON.parse((String)messagingJson, IntegrationHook.class);
            }
            Map variables = (Map)JSON.parse((String)variablesJson, (TypeToken)new TypeToken<Map<String, String>>(){});
            MessageLookupBuilder lookupBuilder = new MessageLookupBuilder();
            if (scenarioRun != null) {
                lookup = lookupBuilder.build(projectKey, null, scenarioRun.scenario, scenarioRun);
            } else {
                lookup = new VariableLookup();
                try (Transaction t = this.transactionService.beginRead();){
                    lookup.setVariablesContext(this.variablesService.getForProject(projectKey));
                }
            }
            lookup.addVariables(variables);
            logger.info((Object)("Send message with configuration " + JSON.prettyLog((Object)messaging)));
            logger.info((Object)("Send message with variables " + lookup.dump()));
            IntegrationEventHandler sender = IntegrationHooksRegistry.buildSender(ticketUsage.getAuthCtx(), messaging, new IntegrationMeta.PermissionCheckContext(true));
            ScenarioReportEvent sre = new ScenarioReportEvent();
            sre.lookup = lookup;
            sre.projectKey = projectKey;
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            sender.handleEvent(sre, messages);
            logger.info((Object)"Done sending message");
            ScenarioIntercomController.writeJSON((HttpServletResponse)resp, (Object)messages);
            if (scenarioRun != null) {
                this.auditTrailService.generic("scenario-send-message").with("projectKey", scenarioRun.getScenario().getProjectKey()).with("scenarioId", scenarioRun.getScenario().getId()).with("scenarioRunId", scenarioRun.getRunId()).with("integrationType", messaging.type).emit();
            } else {
                this.auditTrailService.generic("scenario-send-message").with("projectKey", projectKey).with("integrationType", messaging.type).emit();
            }
        }
        catch (Exception e) {
            if (scenarioRun != null && messaging != null) {
                this.auditTrailService.failure("scenario-send-message", (Throwable)e).with("projectKey", scenarioRun.getScenario().getProjectKey()).with("scenarioId", scenarioRun.getScenario().getId()).with("scenarioRunId", scenarioRun.getRunId()).with("integrationType", messaging.type).emit();
            } else {
                this.auditTrailService.failure("scenario-send-message", (Throwable)e).emit();
            }
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "scenario-object-get-last-build", "projectKey", "${projectKey}", "objectId", "${objectId}"})
    @RequestMapping(value={"/api/tintercom/scenarios/get-object-last-build"})
    public void getLastBuild(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String objectId) throws Exception {
        try (APITicketService.TicketUsage ticketUsage = this.authService.getAndUseMandTicket(req);){
            ScenarioRun scenarioRun = this.getScenarioRunFromTicket(ticketUsage.getTicket());
            if (projectKey == null && scenarioRun != null) {
                projectKey = scenarioRun.scenario.projectKey;
            }
            if (projectKey == null) {
                throw ErrorContext.iae((String)"contextual project key required");
            }
            TaggableObjectsService.TaggableObjectRef did = new TaggableObjectsService.TaggableObjectRef(projectKey, null, objectId);
            ScenarioIntercomController.writeJSON((HttpServletResponse)resp, (Object)this.jobsDBService.getLatestBuildForObject(did));
        }
    }

    @AuditedCall(value={"msgType", "scenario-get-history", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/api/tintercom/scenarios/download-run-diagnosis"})
    public void downloadLogDiagnosis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam(required=false) String runId) throws Exception {
        ScenariosService.ScenarioRunDetails scenarioRunDetails;
        AuthCtx authCtx;
        try (APITicketService.TicketUsage ticketUsage = this.authService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            authCtx = ticketUsage.getAuthCtx();
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!ScenarioIntercomController.canAccessLogs(authCtx)) {
                throw new UnauthorizedException("Access denied", "Logs visibility is restricted. Contact your administrator if you need to access these logs");
            }
            if (StringUtils.isBlank((String)runId)) {
                for (ScenarioRun run : this.scenariosService.getLastRuns(projectKey, scenarioId, 1, true)) {
                    runId = run.getRunId();
                }
                if (StringUtils.isBlank((String)runId)) {
                    throw new Exception("Unable to find last run id");
                }
            }
            scenarioRunDetails = this.scenariosService.getScenarioRunDetails(projectKey, scenarioId, runId, true);
        }
        this.scenariosService.sendScenarioDiagnostic(authCtx, resp, scenarioRunDetails);
    }

    private static boolean canAccessLogs(AuthCtx authCtx) {
        return !ApplicationConfigurator.hideLogs() || authCtx.isAdmin();
    }

    private class RunStepFutureThread
    extends FutureThread<StepRun> {
        private final Scenario scenario;
        private final ScenarioRun scenarioRun;
        private final Step step;
        private final APITicketService.Ticket ticket;
        private StepRun stepRun;
        private final FuturePayload futurePayload;

        RunStepFutureThread(Scenario scenario, ScenarioRun scenarioRun, Step step, DSSAuthCtx user, APITicketService.Ticket ticket) {
            super(user);
            this.scenario = scenario;
            this.scenarioRun = scenarioRun;
            this.step = step;
            this.ticket = ticket;
            this.futurePayload = ScenarioIntercomController.buildFuturePayload(scenario, step, scenarioRun);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public StepRun getResult() {
            return this.stepRun;
        }

        public void execute() throws Exception {
            if (this.ticket != null) {
                logger.info((Object)"Linking the execution of a step to an API ticket");
                ScenarioIntercomController.this.apiTicketService.registerFutureUsingTicket(this.ticket, (FutureThreadBase)this);
            }
            try {
                this.stepRun = ScenarioIntercomController.this.scenariosService.runStep(this.scenario, this.scenarioRun, this.step);
            }
            finally {
                if (this.ticket != null) {
                    logger.info((Object)"Unlinking the execution of a step from an API ticket");
                    ScenarioIntercomController.this.apiTicketService.deregisterFutureUsingTicket(this.ticket, (FutureThreadBase)this);
                }
            }
            ScenarioIntercomController.this.jobsDBService.fetchStepRunAdditionalReportItems(this.stepRun);
        }
    }

    public static class StepRunResult {
        String stepName;
        Object result;

        StepRunResult(String stepName, Object result) {
            this.stepName = stepName;
            this.result = result;
        }
    }
}

