/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.ComputedColumnUtils;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TopNRecipeService {
    public static final String ROLE_REJECTS = "rejects";
    private static final String DUP_COUNT_INNER_QUERY_ALIAS = "__dup_count";
    private static final String DUP_COUNT_INNER_COLUMN_NAME = "__dup_cnt";
    public static final String ROW_NUMBER_FINAL_COLUMN_NAME = "_row_number";
    public static final String RANK_FINAL_COLUMN_NAME = "_rank";
    public static final String DENSE_RANK_FINAL_COLUMN_NAME = "_dense_rank";
    public static final String DUP_COUNT_FINAL_COLUMN_NAME = "_duplicate_count";
    private static final String TOP_N_BTM_M_QUERY_ALIAS = "__topn_btmm";
    private static final String ORIGINAL_TABLE_ALIAS = "__origin_table";
    private static final ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
    @Autowired
    private VariablesService variablesService;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.topn");

    private void expandParams(TopNRecipePayloadParams params, String projectKey) {
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        FilterDescUtils.expand(params.preFilter, vc);
        FilterDescUtils.expand(params.computedColumns, vc);
    }

    public TopNRecipePayloadParams loadParams(String payload, SerializedRecipe sr) {
        TopNRecipePayloadParams params = (TopNRecipePayloadParams)JSON.parse((String)payload, TopNRecipePayloadParams.class);
        Preconditions.checkNotNull((Object)params, (Object)"Empty parameters");
        this.expandParams(params, sr.projectKey);
        return params;
    }

    public boolean hasRejectsOutput(SerializedRecipe recipe) {
        Map<String, SerializedRecipe.OutputRole> outputsUnsafe = recipe.getOutputsUnsafe();
        return outputsUnsafe.containsKey(ROLE_REJECTS) && outputsUnsafe.get((Object)ROLE_REJECTS).items != null && !outputsUnsafe.get((Object)ROLE_REJECTS).items.isEmpty();
    }

    public Dataset getDatasetFromRole(SerializedRecipe recipe, String role) throws IOException {
        return Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatory(recipe.getSingleOutput(role).getLoc(recipe.getProjectKey())));
    }

    private PartitioningScheme getTargetPartitionScheme(JobActivity activity, Dataset outputDataset) {
        Partition part;
        PartitioningScheme targetPartitionScheme = null;
        if (DatasetInspector.arePartitioningColumnsMandatoryInSchema(outputDataset) && (part = activity.getSubgraph().getTargetPartition(activity.getSubgraph().getTargetDataset(outputDataset.getFullName()))) != null && !part.isNP() && !part.isAll() && outputDataset.getPartitioningSchema().isPartitioned()) {
            targetPartitionScheme = outputDataset.getPartitioningSchema();
        }
        return targetPartitionScheme;
    }

    public String generateSQL(JobActivity activity, FlowRecipe recipe, SQLDialect dialect, Dataset inputDS, TopNRecipePayloadParams params, String role, boolean forceOutputColumnNameOverride) throws IOException {
        List<Partition> sourcePartitions = null;
        PartitioningScheme sourcePartitionScheme = null;
        if (MultiEngineRecipeRunner.shouldSpecifySourcePartitionInWhereClause(dialect, params.engineParams)) {
            boolean isValidPartition;
            List<Partition> parts = activity.getSubgraph().getSourcePartitions(activity.getSubgraph().getSingleSourceDataset());
            boolean hasPartition = parts != null && !parts.isEmpty();
            boolean bl = isValidPartition = hasPartition && !parts.get(0).isAll() && !parts.get(0).isNP() && inputDS.getPartitioningSchema().isPartitioned();
            if (isValidPartition) {
                sourcePartitions = parts;
                sourcePartitionScheme = inputDS.getPartitioningSchema();
            }
        }
        Dataset outputDS = this.getDatasetFromRole(recipe.getModel(), role);
        PartitioningScheme targetPartitionScheme = this.getTargetPartitionScheme(activity, outputDS);
        return this.generateSQL(dialect, inputDS, params, role, sourcePartitionScheme, sourcePartitions, targetPartitionScheme, outputDS, forceOutputColumnNameOverride);
    }

    public String generateSQLIgnoreParitions(JobActivity activity, FlowRecipe recipe, SQLDialect dialect, Dataset inputDS, TopNRecipePayloadParams params, String role, boolean forceOutputColumnNameOverride) throws IOException {
        return this.generateSQL(activity, recipe, dialect, inputDS, params, role, forceOutputColumnNameOverride);
    }

    private SelectQueryBuilder getDuplicateCountQuery(SQLDialect dialect, TopNRecipePayloadParams params, SQLUtils.SQLTable table, Dataset inputDS, PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions) {
        ExpressionBuilder col;
        SelectQueryBuilder dupCntQuerySub = new SelectQueryBuilder();
        dupCntQuerySub.from(table, ORIGINAL_TABLE_ALIAS);
        dupCntQuerySub.select(ef.expr("*"));
        if (sourcePartitionScheme != null && table.isTrueTable()) {
            ExpressionBuilder partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(sourcePartitionScheme, inputDS, sourcePartitions, dialect);
            dupCntQuerySub.where(partitionFilterExpression);
        }
        QueryGenerationUtils.preFilter(dupCntQuerySub, params.preFilter, dialect, inputDS, false);
        dupCntQuerySub = QueryGenerationUtils.computedColumns(dupCntQuerySub, params.computedColumns, dialect, inputDS.getSchema());
        SelectQueryBuilder dupCntQuery = new SelectQueryBuilder();
        dupCntQuery.from(dupCntQuerySub, ORIGINAL_TABLE_ALIAS);
        for (String key : params.keys) {
            col = ExpressionUtils.getAdjustedColumn(ef.col(ORIGINAL_TABLE_ALIAS, key), key, inputDS, dialect);
            dupCntQuery.select(col, key);
        }
        dupCntQuery.select(ef.count("*"), DUP_COUNT_INNER_COLUMN_NAME);
        for (String key : params.keys) {
            col = ExpressionUtils.getAdjustedColumn(ef.col(ORIGINAL_TABLE_ALIAS, key), key, inputDS, dialect);
            dupCntQuery.group(col);
        }
        return dupCntQuery;
    }

    private SelectQueryBuilder getRowNumberQuery(SQLDialect dialect, TopNRecipePayloadParams params, SQLUtils.SQLTable table, Dataset inputDS, PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, boolean simpleSql) {
        ArrayList<ExpressionBuilder> keyColumns = new ArrayList<ExpressionBuilder>();
        for (String key : params.keys) {
            ExpressionBuilder col = ExpressionUtils.getAdjustedColumn(ef.col(ORIGINAL_TABLE_ALIAS, key), key, inputDS, dialect);
            keyColumns.add(col);
        }
        ArrayList<ExpressionBuilder> orderExpressions = new ArrayList<ExpressionBuilder>();
        ArrayList<QueryAst.OrderType> orderTypes = new ArrayList<QueryAst.OrderType>();
        for (TopNRecipePayloadParams.Order order : params.orders) {
            ExpressionBuilder col = ExpressionUtils.getAdjustedColumn(ef.col(ORIGINAL_TABLE_ALIAS, order.column), order.column, inputDS, dialect);
            orderExpressions.add(col);
            orderTypes.add(order.desc ? QueryAst.OrderType.DESC : QueryAst.OrderType.ASC);
        }
        QueryAst.Window window = SelectQueryBuilder.window(keyColumns, orderExpressions, orderTypes);
        SelectQueryBuilder originalTableQuery = new SelectQueryBuilder();
        originalTableQuery.from(table, ORIGINAL_TABLE_ALIAS);
        if (sourcePartitionScheme != null && table.isTrueTable()) {
            ExpressionBuilder partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(sourcePartitionScheme, inputDS, sourcePartitions, dialect);
            originalTableQuery.where(partitionFilterExpression);
        }
        QueryGenerationUtils.preFilter(originalTableQuery, params.preFilter, dialect, inputDS, false);
        originalTableQuery = QueryGenerationUtils.computedColumns(originalTableQuery, params.computedColumns, dialect, inputDS.getSchema());
        SelectQueryBuilder rowNbQuery = new SelectQueryBuilder();
        rowNbQuery.from(originalTableQuery, ORIGINAL_TABLE_ALIAS);
        for (SchemaColumn sc : inputDS.getSchema().columns) {
            ExpressionBuilder col = ExpressionUtils.getAdjustedColumn(ef.col(ORIGINAL_TABLE_ALIAS, sc.getName()), sc.getName(), inputDS, dialect);
            rowNbQuery.select(col, sc.getName());
        }
        for (ComputedColumn cc : params.computedColumns) {
            rowNbQuery.select(ef.col(ORIGINAL_TABLE_ALIAS, cc.name), cc.name);
        }
        rowNbQuery.select(ef.rowNumber().over(window), ROW_NUMBER_FINAL_COLUMN_NAME);
        if (params.rank) {
            rowNbQuery.select(ef.rank().over(window), RANK_FINAL_COLUMN_NAME);
        }
        if (params.denseRank) {
            rowNbQuery.select(ef.denseRank().over(window), DENSE_RANK_FINAL_COLUMN_NAME);
        }
        if (!simpleSql) {
            SelectQueryBuilder dupCntQuery = this.getDuplicateCountQuery(dialect, params, table, inputDS, sourcePartitionScheme, sourcePartitions);
            rowNbQuery.select(ef.col(DUP_COUNT_INNER_QUERY_ALIAS, DUP_COUNT_INNER_COLUMN_NAME), DUP_COUNT_FINAL_COLUMN_NAME);
            SelectQueryBuilder.JoinClauseBuilder join = rowNbQuery.join(dupCntQuery, QueryAst.JoinType.INNER, DUP_COUNT_INNER_QUERY_ALIAS);
            if (params.keys.isEmpty()) {
                join.on(ef.expr("1").nullUnsafeEq(ef.expr("1")));
            }
            for (String key : params.keys) {
                join.on(ef.col(DUP_COUNT_INNER_QUERY_ALIAS, key).nullUnsafeEq(ef.col(ORIGINAL_TABLE_ALIAS, key)));
            }
        }
        return rowNbQuery;
    }

    public String generateSQL(SQLDialect dialect, Dataset inputDS, TopNRecipePayloadParams params, String role, PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, PartitioningScheme targetPartitionScheme, Dataset outputDataset, boolean forceOutputColumnNameOverride) throws IOException {
        boolean simpleSql = params.lastRows == 0 && !params.duplicateCount;
        SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(inputDS, dialect, params.engineParams);
        HashSet partitionColumnNames = Sets.newHashSet();
        if (targetPartitionScheme != null) {
            for (String col : targetPartitionScheme.getDimensionNames()) {
                partitionColumnNames.add(col);
            }
        }
        SelectQueryBuilder rowNbQuery = this.getRowNumberQuery(dialect, params, table, inputDS, sourcePartitionScheme, sourcePartitions, simpleSql);
        SelectQueryBuilder filterQuery = this.getFilterQuery(dialect, rowNbQuery, inputDS, params, role, simpleSql, params.retrievedColumnsSelectionMode == TopNRecipePayloadParams.RetrievedColumnsSelectionMode.ALL, targetPartitionScheme, partitionColumnNames, outputDataset.getSchema(), forceOutputColumnNameOverride);
        filterQuery = QueryGenerationUtils.applyInsertIntoCasts(filterQuery, dialect, outputDataset);
        return filterQuery.toSQL(dialect);
    }

    private SelectQueryBuilder getFilterQuery(SQLDialect dialect, SelectQueryBuilder rowNbQuery, Dataset inputDS, TopNRecipePayloadParams params, String role, boolean simpleSql, boolean retrieveAllColumns, PartitioningScheme targetPartitionScheme, Set<String> partitionColumnNames, Schema outputSchema, boolean forceOutputColumnNameOverride) {
        SchemaColumn scOutput;
        SelectQueryBuilder filterQuery = new SelectQueryBuilder();
        filterQuery.from(rowNbQuery, TOP_N_BTM_M_QUERY_ALIAS);
        for (SchemaColumn sc : inputDS.getSchema().columns) {
            if (!retrieveAllColumns && !params.retrievedColumns.contains(sc.getName())) continue;
            if (partitionColumnNames.contains(sc.getName())) {
                scOutput = outputSchema.getColumnOrDefault(sc.getName(), Type.STRING);
                filterQuery.select(ef.dstPartitionId(scOutput, targetPartitionScheme.getDimension(sc.getName())), sc.getName());
                partitionColumnNames.remove(sc.getName());
                continue;
            }
            ExpressionBuilder col = ef.col(TOP_N_BTM_M_QUERY_ALIAS, sc.getName());
            filterQuery.select(col, sc.getName());
        }
        for (ComputedColumn cc : params.computedColumns) {
            if (!retrieveAllColumns && !params.retrievedColumns.contains(cc.name) || filterQuery.getSelectedItemsAliases().contains(cc.name)) continue;
            if (partitionColumnNames.contains(cc.name)) {
                scOutput = outputSchema.getColumnOrDefault(cc.name, Type.STRING);
                filterQuery.select(ef.dstPartitionId(scOutput, targetPartitionScheme.getDimension(cc.name)), cc.name);
                partitionColumnNames.remove(cc.name);
                continue;
            }
            filterQuery.select(ef.col(TOP_N_BTM_M_QUERY_ALIAS, cc.name), cc.name);
        }
        if (params.duplicateCount) {
            filterQuery.select(ef.col(TOP_N_BTM_M_QUERY_ALIAS, DUP_COUNT_FINAL_COLUMN_NAME), DUP_COUNT_FINAL_COLUMN_NAME);
        }
        if (params.rowNumber) {
            filterQuery.select(ef.col(TOP_N_BTM_M_QUERY_ALIAS, ROW_NUMBER_FINAL_COLUMN_NAME), ROW_NUMBER_FINAL_COLUMN_NAME);
        }
        if (params.rank) {
            filterQuery.select(ef.col(TOP_N_BTM_M_QUERY_ALIAS, RANK_FINAL_COLUMN_NAME), RANK_FINAL_COLUMN_NAME);
        }
        if (params.denseRank) {
            filterQuery.select(ef.col(TOP_N_BTM_M_QUERY_ALIAS, DENSE_RANK_FINAL_COLUMN_NAME), DENSE_RANK_FINAL_COLUMN_NAME);
        }
        if (targetPartitionScheme != null) {
            for (String col : targetPartitionScheme.getDimensionNames()) {
                if (!partitionColumnNames.contains(col)) continue;
                scOutput = outputSchema.getColumnOrDefault(col, Type.STRING);
                filterQuery.select(ef.dstPartitionId(scOutput, targetPartitionScheme.getDimension(col)), col);
            }
        }
        ExpressionBuilder whereClause = this.getTopNWhereClause(params, simpleSql, role);
        filterQuery.where(whereClause);
        filterQuery = QueryGenerationUtils.applyOverrides(filterQuery, params.outputColumnNameOverrides, dialect, forceOutputColumnNameOverride);
        return filterQuery;
    }

    private ExpressionBuilder getTopNWhereClause(TopNRecipePayloadParams params, boolean simpleSql, String role) {
        ExpressionBuilder rejectsExpr;
        ExpressionBuilder mainExpr;
        ExpressionBuilder topN = ef.expr(Integer.toString(params.firstRows));
        ExpressionBuilder rnCol = ef.col(ROW_NUMBER_FINAL_COLUMN_NAME);
        if (simpleSql) {
            mainExpr = rnCol.lte(topN);
            rejectsExpr = rnCol.gt(topN);
        } else {
            ExpressionBuilder bottomM = ef.expr(Integer.toString(params.lastRows));
            ExpressionBuilder dcCol = ef.col(DUP_COUNT_FINAL_COLUMN_NAME);
            ExpressionBuilder bottomRank = dcCol.minus(bottomM);
            mainExpr = rnCol.lte(topN).or(rnCol.gt(bottomRank));
            rejectsExpr = rnCol.gt(topN).and(rnCol.lte(bottomRank));
        }
        return role == "main" ? mainExpr : rejectsExpr;
    }

    public Schema getOutputSchemaAfterOverride(Dataset inputDataset, TopNRecipePayloadParams params, boolean lowerCaseColumnsNames) {
        Schema schema = this.getOutputSchemaBeforeOverride(inputDataset, params, lowerCaseColumnsNames);
        if (params.outputColumnNameOverrides != null) {
            for (SchemaColumn sc : schema.columns) {
                String override = params.outputColumnNameOverrides.get(sc.getName());
                if (!StringUtils.isNotBlank((String)override)) continue;
                sc.setName(override);
            }
        }
        if (lowerCaseColumnsNames) {
            SchemaUtils.lowerCase(schema);
        }
        return schema;
    }

    public Schema getOutputSchemaBeforeOverride(Dataset inputDataset, TopNRecipePayloadParams params, boolean lowerCaseColumnsNames) {
        Schema schema = this.getBaseOutputSchema(inputDataset, params);
        if (lowerCaseColumnsNames) {
            SchemaUtils.lowerCase(schema);
        }
        return schema;
    }

    private Schema getBaseOutputSchema(Dataset inputDataset, TopNRecipePayloadParams params) {
        Schema outputSchema = new Schema();
        logger.info((Object)("getBaseOutputSchema, mode= " + String.valueOf((Object)params.retrievedColumnsSelectionMode) + " cols=" + JSON.log(params.retrievedColumns) + " computedColumns=" + JSON.log(params.computedColumns)));
        for (SchemaColumn sc : inputDataset.getSchema().columns) {
            if (params.retrievedColumnsSelectionMode != TopNRecipePayloadParams.RetrievedColumnsSelectionMode.ALL && !params.retrievedColumns.contains(sc.getName())) continue;
            outputSchema.addColumn(sc);
        }
        for (ComputedColumn cc : params.computedColumns) {
            if (params.retrievedColumnsSelectionMode != TopNRecipePayloadParams.RetrievedColumnsSelectionMode.ALL && !params.retrievedColumns.contains(cc.name)) continue;
            ComputedColumnUtils.addToSchema(outputSchema, cc);
        }
        if (params.duplicateCount) {
            outputSchema.addColumn(outputSchema.transmogrify(DUP_COUNT_FINAL_COLUMN_NAME), Type.BIGINT);
        }
        if (params.rowNumber) {
            outputSchema.addColumn(outputSchema.transmogrify(ROW_NUMBER_FINAL_COLUMN_NAME), Type.BIGINT);
        }
        if (params.rank) {
            outputSchema.addColumn(outputSchema.transmogrify(RANK_FINAL_COLUMN_NAME), Type.BIGINT);
        }
        if (params.denseRank) {
            outputSchema.addColumn(outputSchema.transmogrify(DENSE_RANK_FINAL_COLUMN_NAME), Type.BIGINT);
        }
        return outputSchema;
    }
}

