/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.dataquality;

import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataquality.DataQualityDailyStatus;
import com.dataiku.dip.dataquality.DataQualityOutcome;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.DataQualityRuleSet;
import com.dataiku.dip.dataquality.DataQualityRunOrigin;
import com.dataiku.dip.dataquality.UIRuleHistory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.datasets.DataStewardService;
import com.dataiku.dip.server.recipes.ExtractFailedRowsSchemaGenerator;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import com.google.common.collect.Sets;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataQualitySummaryService {
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ReadOnlyJobsInternalDB readOnlyJobsInternalDB;
    @Autowired
    private UsersService usersService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.dataquality.summary");

    public long computeDay(long computeTime) {
        return new DateTime(computeTime).withZone(DateTimeZone.UTC).withTimeAtStartOfDay().getMillis();
    }

    public UIDatasetDataQuality getDatasetDataQualityRules_NT(SerializedDataset dataset, String partitionId, boolean allowDisabled) throws Exception {
        ArrayList<UIDataQualityRule> rules = new ArrayList<UIDataQualityRule>();
        Map<String, ReadOnlyJobsInternalDB.CheckDataPoint> checkDataPoints = this.readOnlyJobsInternalDB.getLastDatasetRulesStatus(dataset.projectKey, dataset.name, partitionId);
        List<DataQualityRule> orderedRules = Stream.concat(dataset.getDataQualityRuleSet().getRules().stream().filter(r -> r.enabled), allowDisabled ? dataset.getDataQualityRuleSet().getRules().stream().filter(r -> !r.enabled) : Stream.empty()).toList();
        Set ruleIdsSupportedForExtraction = ExtractFailedRowsSchemaGenerator.getSupportedRules(orderedRules).stream().map(DataQualityRule::getId).collect(Collectors.toSet());
        for (DataQualityRule rule : orderedRules) {
            ReadOnlyJobsInternalDB.CheckDataPoint checkDataPoint = checkDataPoints.get(rule.getId());
            rules.add(UIDataQualityRule.currentStatusPoint(rule, checkDataPoint, ruleIdsSupportedForExtraction.contains(rule.getId())));
        }
        return new UIDatasetDataQuality(rules);
    }

    public UIDatasetDataQuality getDatasetDataQualityRulesForDay_NT(SerializedDataset dataset, String partitionId, long startOfDayTimestamp) throws Exception {
        ArrayList<UIDataQualityRule> rules = new ArrayList<UIDataQualityRule>();
        List<ReadOnlyJobsInternalDB.ComputedRule> partitionSummary = this.readOnlyJobsInternalDB.getMostRecentDataQualityComputedRules(dataset.projectKey, dataset.name, partitionId, startOfDayTimestamp);
        if (!partitionSummary.isEmpty()) {
            Map<ReadOnlyJobsInternalDB.ComputedRule, ReadOnlyJobsInternalDB.CheckDataPoint> checkDataPoints = this.readOnlyJobsInternalDB.getHistoryChecks(dataset.getProjectKey(), dataset.name, partitionId, partitionSummary);
            Set ruleIdsSupportedForExtraction = ExtractFailedRowsSchemaGenerator.getSupportedRules(dataset.getDataQualityRuleSet().getRules()).stream().map(DataQualityRule::getId).collect(Collectors.toSet());
            for (ReadOnlyJobsInternalDB.ComputedRule rule : partitionSummary) {
                ReadOnlyJobsInternalDB.CheckDataPoint checkDataPoint = checkDataPoints.get(rule);
                if (checkDataPoint == null || startOfDayTimestamp > checkDataPoint.time && !rule.enabled) continue;
                checkDataPoint.check.updateDisplayName();
                AbstractCheckContext.CheckOutcome worstDailyOutcome = startOfDayTimestamp <= checkDataPoint.time ? rule.worstDailyOutcome : null;
                rules.add(UIDataQualityRule.historyPoint(checkDataPoint.check, checkDataPoint, worstDailyOutcome, rule.enabled, rule.deleted, ruleIdsSupportedForExtraction.contains(rule.id)));
            }
        }
        return new UIDatasetDataQuality(rules);
    }

    public List<UIDProjectDatasetDataQuality> getProjectSummaryStatusForDay_NT(String projectKey, List<SerializedDataset> sds, long startOfDayTimestamp) throws SQLException, IOException {
        Map<String, SerializedDataset> serializedDatasetMap = this.filterDatasetsWithValidRuleset(sds);
        Map<String, PublicUser> loginToPublicUserMap = this.getLoginToPublicUserMapForSd(serializedDatasetMap.values());
        List<ReadOnlyJobsInternalDB.ObjectHistoryRef> objectHistoryRefs = this.readOnlyJobsInternalDB.getMostRecentDataQualityObjectHistoryRefs(projectKey, startOfDayTimestamp);
        Map<String, ReadOnlyJobsInternalDB.DataQualityHistoryObjectPoint> objectDataPoints = this.readOnlyJobsInternalDB.getExactDataQualityObjectStatusesForHistoryRefList(projectKey, objectHistoryRefs);
        ArrayList<AnyLoc> deletedDatasetsLocs = new ArrayList<AnyLoc>();
        Map datasetStatuses = objectHistoryRefs.stream().map(s -> s.objectId).collect(Collectors.toMap(Function.identity(), objectId -> {
            ReadOnlyJobsInternalDB.DataQualityHistoryObjectPoint point = (ReadOnlyJobsInternalDB.DataQualityHistoryObjectPoint)objectDataPoints.get(objectId);
            SerializedDataset sd = (SerializedDataset)serializedDatasetMap.get(objectId);
            if (point == null) {
                point = new ReadOnlyJobsInternalDB.DataQualityHistoryObjectPoint(projectKey, (String)objectId, -1L, -1L, DataQualityOutcome.NONE, DataQualityOutcome.NONE, sd != null && sd.getDataQualityRuleSet().monitor, sd == null);
            } else if (point.timestamp != startOfDayTimestamp) {
                point = new ReadOnlyJobsInternalDB.DataQualityHistoryObjectPoint(projectKey, (String)objectId, point.timestamp, point.lastRunRuleComputeTime, point.last, DataQualityOutcome.NONE, point.monitored, point.deleted);
            }
            UIDProjectDatasetDataQuality projectDatasetDataQuality = new UIDProjectDatasetDataQuality();
            if (sd != null) {
                projectDatasetDataQuality.id = sd.getDisplayName();
                projectDatasetDataQuality.tags = sd.tags;
                projectDatasetDataQuality.datasetType = sd.type;
                projectDatasetDataQuality.dataSteward = loginToPublicUserMap.getOrDefault(sd.dataSteward, null);
                String defaultDataStewardLogin = DataStewardService.getDefaultDataStewardLogin(sd);
                projectDatasetDataQuality.defaultDataSteward = loginToPublicUserMap.getOrDefault(defaultDataStewardLogin, null);
                projectDatasetDataQuality.numberEnabledRules = sd.getDataQualityRuleSet().getEnabledRules().size();
                projectDatasetDataQuality.isPartitioned = sd.isPartitioned();
                projectDatasetDataQuality.partitioning = sd.partitioning;
            } else {
                deletedDatasetsLocs.add(new AnyLoc(projectKey, (String)objectId));
                projectDatasetDataQuality.datasetType = "Dataset";
                projectDatasetDataQuality.isNowDeleted = true;
            }
            projectDatasetDataQuality.monitored = point.monitored;
            projectDatasetDataQuality.deleted = point.deleted;
            projectDatasetDataQuality.datasetQuality = new DataQualityDailyStatus(point);
            projectDatasetDataQuality.lastRunRuleComputeTime = point.lastRunRuleComputeTime;
            return projectDatasetDataQuality;
        }));
        this.jobsDatabaseService.getLastDataQualityObjectStatusesForList(deletedDatasetsLocs).forEach((loc, dp) -> {
            ((UIDProjectDatasetDataQuality)datasetStatuses.get((Object)loc.getId())).id = dp.displayName;
        });
        return datasetStatuses.values().stream().filter(status -> StringUtils.isNotBlank((CharSequence)status.id) && (!status.deleted || status.datasetQuality.worstOutcome != null)).toList();
    }

    private Map<String, PublicUser> getLoginToPublicUserMapForSd(Collection<SerializedDataset> sds) throws IOException {
        HashMap<String, PublicUser> loginToPublicUserMap = new HashMap<String, PublicUser>();
        try (Transaction t = this.transactionService.beginRead();){
            for (SerializedDataset sd : sds) {
                String defaultDataStewardLogin;
                String dataStewardLogin = sd.getDataSteward();
                if (dataStewardLogin != null && !loginToPublicUserMap.containsKey(dataStewardLogin)) {
                    PublicUser pu = this.usersService.getPublicUser(dataStewardLogin);
                    loginToPublicUserMap.put(dataStewardLogin, pu);
                }
                if ((defaultDataStewardLogin = DataStewardService.getDefaultDataStewardLogin(sd)) == null || loginToPublicUserMap.containsKey(defaultDataStewardLogin)) continue;
                PublicUser pu = this.usersService.getPublicUser(defaultDataStewardLogin);
                loginToPublicUserMap.put(defaultDataStewardLogin, pu);
            }
        }
        return loginToPublicUserMap;
    }

    private Map<String, PublicUser> getLoginToPublicUserMap(List<String> logins) throws IOException {
        HashMap<String, PublicUser> loginToPublicUserMap = new HashMap<String, PublicUser>();
        try (Transaction t = this.transactionService.beginRead();){
            for (String login : logins) {
                if (login == null || loginToPublicUserMap.containsKey(login)) continue;
                PublicUser pu = this.usersService.getPublicUser(login);
                loginToPublicUserMap.put(login, pu);
            }
        }
        return loginToPublicUserMap;
    }

    public void updatePartitionStatus_NT(String projectKey, String datasetName, String partitionId, long computeTime) throws Exception {
        SerializedDataset dataset;
        long computeDay = this.computeDay(computeTime);
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        DataQualityRuleSet ruleset = dataset.getDataQualityRuleSet();
        LinkedHashSet<String> enabledRuleIds = new LinkedHashSet<String>(ruleset.getEnabledRuleIds());
        Set<String> existingRuleIds = ruleset.getRules().stream().map(DataQualityRule::getId).collect(Collectors.toSet());
        Map<String, ReadOnlyJobsInternalDB.CheckDataPoint> dataPoints = this.readOnlyJobsInternalDB.getLastChecks(projectKey, datasetName, partitionId).stream().collect(Collectors.toMap(c2 -> c2.name, Function.identity()));
        long lastRunRuleComputeTime = enabledRuleIds.stream().filter(dataPoints::containsKey).map(ruleId -> ((ReadOnlyJobsInternalDB.CheckDataPoint)dataPoints.get((Object)ruleId)).time).reduce(-1L, Math::max);
        DataQualityOutcome partitionLastOutcome = new DataQualityOutcome(enabledRuleIds.stream().map(dataPoints::get).map(dp -> dp == null ? null : dp.outcome));
        Map previousWorstWhileEnabled = this.readOnlyJobsInternalDB.getExactDayDataQualityComputedRules(projectKey, datasetName, partitionId, computeDay).stream().filter(r -> r.worstDailyOutcomeWhileEnabled != null).collect(Collectors.toMap(r -> r.id, r -> r.worstDailyOutcomeWhileEnabled, (x, y) -> y, LinkedHashMap::new));
        Map<String, AbstractCheckContext.CheckOutcome> worstOutcomes = this.readOnlyJobsInternalDB.getExactDayDataQualityRuleWorstOutcomeForPartition(projectKey, datasetName, partitionId, computeDay);
        List<ReadOnlyJobsInternalDB.ComputedRule> computedRules = DataQualitySummaryService.generateComputedRules(dataPoints, worstOutcomes, previousWorstWhileEnabled, existingRuleIds, enabledRuleIds);
        DataQualityOutcome partitionWorstOutcome = new DataQualityOutcome(computedRules.stream().map(r -> r.worstDailyOutcomeWhileEnabled));
        ReadOnlyJobsInternalDB.DataQualityPartitionPoint toSave = new ReadOnlyJobsInternalDB.DataQualityPartitionPoint(projectKey, datasetName, partitionId, computeTime, lastRunRuleComputeTime, partitionLastOutcome, partitionWorstOutcome);
        this.jobsDatabaseService.updateDataQualityPartitionStatus(toSave, computedRules);
    }

    public static List<ReadOnlyJobsInternalDB.ComputedRule> generateComputedRules(Map<String, ReadOnlyJobsInternalDB.CheckDataPoint> dataPoints, Map<String, AbstractCheckContext.CheckOutcome> worstOutcomes, Map<String, AbstractCheckContext.CheckOutcome> previousWorstWhileEnabled, Collection<String> existingRuleIds, Collection<String> enabledRuleIds) {
        return Stream.concat(enabledRuleIds.stream(), previousWorstWhileEnabled.keySet().stream()).distinct().map(dataPoints::get).filter(Objects::nonNull).map(p -> {
            String ruleId = p.check.getId();
            boolean isEnabled = enabledRuleIds.contains(ruleId);
            boolean isDeleted = !existingRuleIds.contains(ruleId);
            AbstractCheckContext.CheckOutcome worst = (AbstractCheckContext.CheckOutcome)((Object)((Object)worstOutcomes.get(ruleId)));
            AbstractCheckContext.CheckOutcome worstWhileEnabled = isEnabled ? worst : (AbstractCheckContext.CheckOutcome)((Object)((Object)previousWorstWhileEnabled.get(ruleId)));
            return new ReadOnlyJobsInternalDB.ComputedRule(ruleId, p.sessionIndex, worst, worstWhileEnabled, isDeleted, isEnabled);
        }).toList();
    }

    public void updateDataQualityObjectStatus_NT(String projectKey, String objectId, long computeTime, String displayName, boolean monitored, boolean deleted) throws SQLException {
        long computeDay = this.computeDay(computeTime);
        Collection<ReadOnlyJobsInternalDB.DataQualityPartitionPoint> lastPartitionRuns = this.readOnlyJobsInternalDB.getLastDataQualityPartitionStatusesForObject(projectKey, objectId).values();
        long lastRunRuleComputeTime = lastPartitionRuns.stream().map(pt -> pt.lastRunRuleComputeTime).reduce(-1L, Math::max);
        ReadOnlyJobsInternalDB.DataQualityLastObjectPoint lastDataPoint = this.readOnlyJobsInternalDB.getLastDataQualityObjectStatus(projectKey, objectId);
        long mostRecentDayWithRuns = lastRunRuleComputeTime == -1L ? -1L : this.computeDay(lastRunRuleComputeTime);
        Supplier<Stream> relevantPartitionRuns = () -> lastPartitionRuns.stream().filter(pt -> pt.lastRunRuleComputeTime >= mostRecentDayWithRuns);
        monitored = monitored && !deleted;
        DataQualityOutcome last = new DataQualityOutcome(relevantPartitionRuns.get().map(pt -> pt.last.getOutcome()));
        DataQualityOutcome worst = mostRecentDayWithRuns == computeDay ? new DataQualityOutcome(relevantPartitionRuns.get().map(pt -> pt.worst.getOutcome())) : DataQualityOutcome.NONE;
        AbstractCheckContext.CheckOutcome previousWorstMonitored = lastDataPoint == null || lastDataPoint.timestamp < computeDay ? null : lastDataPoint.worstMonitoredOutcome;
        AbstractCheckContext.CheckOutcome updatedWorstMonitored = monitored ? worst.getOutcome() : previousWorstMonitored;
        ReadOnlyJobsInternalDB.DataQualityLastObjectPoint toSave = new ReadOnlyJobsInternalDB.DataQualityLastObjectPoint(projectKey, objectId, computeTime, lastRunRuleComputeTime, last, worst, displayName, updatedWorstMonitored, deleted);
        this.jobsDatabaseService.updateDataQualityObjectStatus(toSave, monitored);
    }

    public Map<String, SerializedDataset> filterDatasetsWithValidRuleset(List<SerializedDataset> sds) {
        HashMap<String, SerializedDataset> nonBrokenDatasets = new HashMap<String, SerializedDataset>(sds.size());
        for (SerializedDataset sd : sds) {
            try {
                sd.getDataQualityRuleSet();
                nonBrokenDatasets.put(sd.name, sd);
            }
            catch (JsonParseException e) {
                logger.warn((Object)("Cannot deserialize the rules of " + sd.getFullName()), (Throwable)e);
            }
        }
        return nonBrokenDatasets;
    }

    public void updateDataQualityProjectStatus_NT(String projectKey, long computeTime) throws IOException, SQLException {
        List<SerializedDataset> sds;
        long computeDay = this.computeDay(computeTime);
        try (Transaction t = this.transactionService.beginRead();){
            sds = this.datasetsDAO.listUnsafe(projectKey);
        }
        Map<String, SerializedDataset> allDatasets = this.filterDatasetsWithValidRuleset(sds);
        Map todayObjectRefs = this.readOnlyJobsInternalDB.getExactDayDataQualityObjectHistoryRefs(projectKey, computeDay).stream().collect(Collectors.toMap(md -> md.objectId, Function.identity()));
        List<AnyLoc> relevantDatasetsLocs = Sets.union(allDatasets.keySet(), todayObjectRefs.keySet()).stream().map(id -> new AnyLoc(projectKey, (String)id)).toList();
        Map<AnyLoc, ReadOnlyJobsInternalDB.DataQualityLastObjectPoint> dataPoints = this.readOnlyJobsInternalDB.getLastDataQualityObjectStatusesForList(relevantDatasetsLocs);
        List<ReadOnlyJobsInternalDB.ObjectHistoryRef> newObjectHistoryRefs = relevantDatasetsLocs.stream().map(loc -> {
            if (dataPoints.containsKey(loc)) {
                ReadOnlyJobsInternalDB.DataQualityLastObjectPoint dataPoint = (ReadOnlyJobsInternalDB.DataQualityLastObjectPoint)dataPoints.get(loc);
                if (dataPoint.deleted && dataPoint.worst.getOutcome() == null) {
                    return null;
                }
                long dataPointComputeDay = this.computeDay(dataPoint.timestamp);
                return new ReadOnlyJobsInternalDB.ObjectHistoryRef(loc.getId(), dataPointComputeDay);
            }
            return new ReadOnlyJobsInternalDB.ObjectHistoryRef(loc.getId(), -1L);
        }).filter(Objects::nonNull).toList();
        DataQualityOutcome worstOutcome = new DataQualityOutcome(dataPoints.values().stream().filter(dp -> dp.timestamp >= computeDay).map(dp -> dp.worstMonitoredOutcome));
        DataQualityOutcome lastOutcome = new DataQualityOutcome(dataPoints.values().stream().filter(pt -> !pt.deleted).filter(pt -> allDatasets.containsKey(pt.objectId) && ((SerializedDataset)allDatasets.get((Object)pt.objectId)).getDataQualityRuleSet().monitor).map(pt -> pt.last.getOutcome()));
        long lastRunRuleComputeTime = dataPoints.values().stream().filter(pt -> !pt.deleted && allDatasets.containsKey(pt.objectId) && ((SerializedDataset)allDatasets.get((Object)pt.objectId)).getDataQualityRuleSet().monitor).map(pt -> pt.lastRunRuleComputeTime).reduce(-1L, Math::max);
        ReadOnlyJobsInternalDB.DataQualityProjectPoint toSave = new ReadOnlyJobsInternalDB.DataQualityProjectPoint(projectKey, computeTime, lastRunRuleComputeTime, lastOutcome, worstOutcome);
        this.jobsDatabaseService.updateDataQualityProjectStatus(toSave, newObjectHistoryRefs);
    }

    public void updateProjectStatusOnBundleActivation(String projectKey, long computeTime) throws SQLException, IOException {
        long computeDay = this.computeDay(computeTime);
        TransactionContext.assertNoAttachedTransaction();
        Map<String, ReadOnlyJobsInternalDB.DataQualityLastObjectPoint> datasetsInDb = this.readOnlyJobsInternalDB.getLastDataQualityObjectStatusesForProject(projectKey);
        HashMap<String, Pair> toUpdate = new HashMap<String, Pair>();
        try (Transaction t = this.transactionService.beginRead();){
            for (Map.Entry<String, ReadOnlyJobsInternalDB.DataQualityLastObjectPoint> e : datasetsInDb.entrySet()) {
                ReadOnlyJobsInternalDB.DataQualityLastObjectPoint updated;
                boolean isDataPointFromToday;
                String objectId = e.getKey();
                ReadOnlyJobsInternalDB.DataQualityLastObjectPoint dataPoint = e.getValue();
                boolean bl = isDataPointFromToday = dataPoint.timestamp >= computeDay;
                if (!dataPoint.deleted && !this.datasetsDAO.exists(projectKey, objectId)) {
                    updated = new ReadOnlyJobsInternalDB.DataQualityLastObjectPoint(projectKey, objectId, computeTime, dataPoint.lastRunRuleComputeTime, dataPoint.last, isDataPointFromToday ? dataPoint.worst : DataQualityOutcome.NONE, objectId, isDataPointFromToday ? dataPoint.worstMonitoredOutcome : null, true);
                    toUpdate.put(objectId, new Pair((Object)updated, (Object)false));
                }
                if (!dataPoint.deleted || !this.datasetsDAO.exists(projectKey, objectId)) continue;
                updated = new ReadOnlyJobsInternalDB.DataQualityLastObjectPoint(projectKey, objectId, computeTime, dataPoint.lastRunRuleComputeTime, dataPoint.last, isDataPointFromToday ? dataPoint.worst : DataQualityOutcome.NONE, objectId, isDataPointFromToday ? dataPoint.worstMonitoredOutcome : null, false);
                boolean isMonitored = false;
                try {
                    SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(projectKey, objectId);
                    isMonitored = sd != null && sd.getDataQualityRuleSet().monitor;
                }
                catch (JsonParseException ex) {
                    logger.warn((Object)("Cannot deserialize the rules of " + projectKey + "." + objectId), (Throwable)ex);
                }
                toUpdate.put(objectId, new Pair((Object)updated, (Object)isMonitored));
            }
        }
        for (Pair p : toUpdate.values()) {
            this.jobsDatabaseService.updateDataQualityObjectStatus((ReadOnlyJobsInternalDB.DataQualityLastObjectPoint)p.first, (Boolean)p.second);
        }
        this.updateDataQualityProjectStatus_NT(projectKey, computeTime);
    }

    public void enrichAndRedactUIDatasetDataQuality(AuthCtx user, String projectKey, UIDatasetDataQuality uiDq) throws IOException, DKUSecurityException {
        boolean canReadSourceProjectConf = this.permissionsService.hasProjectPrivilege(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        for (UIDataQualityRule ruleState : uiDq.rules) {
            RunOriginAndScenarioName runOriginAndScenarioName = this.enrichAndRedactRunOrigin(user, ruleState.runOrigin, canReadSourceProjectConf);
            ruleState.runOrigin = runOriginAndScenarioName.runOrigin;
            ruleState.scenarioName = runOriginAndScenarioName.scenarioName;
        }
    }

    public void enrichUIRuleHistory(AuthCtx user, String projectKey, UIRuleHistory.RuleFetchResult ruleFetchResult) throws DKUSecurityException, IOException {
        boolean canReadSourceProjectConf = this.permissionsService.hasProjectPrivilege(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        for (UIRuleHistory.RuleHistoryPoint point : ruleFetchResult.ruleHistory) {
            RunOriginAndScenarioName runOriginAndScenarioName = this.enrichAndRedactRunOrigin(user, point.runOrigin, canReadSourceProjectConf);
            point.runOrigin = runOriginAndScenarioName.runOrigin;
            point.scenarioName = runOriginAndScenarioName.scenarioName;
        }
    }

    private RunOriginAndScenarioName enrichAndRedactRunOrigin(AuthCtx user, DataQualityRunOrigin runOrigin, boolean canReadSourceProjectConf) throws IOException, DKUSecurityException {
        RunOriginAndScenarioName result = new RunOriginAndScenarioName();
        result.runOrigin = runOrigin;
        if (runOrigin instanceof DataQualityRunOrigin.Build) {
            DataQualityRunOrigin.Build buildOrigin = (DataQualityRunOrigin.Build)runOrigin;
            if (!canReadSourceProjectConf && !this.permissionsService.hasProjectPrivilege(user, buildOrigin.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                result.runOrigin = new DataQualityRunOrigin.RedactedBuild();
            }
        }
        if (runOrigin instanceof DataQualityRunOrigin.ScenarioStep) {
            DataQualityRunOrigin.ScenarioStep scenarioOrigin = (DataQualityRunOrigin.ScenarioStep)runOrigin;
            if (!canReadSourceProjectConf && !this.permissionsService.hasProjectPrivilege(user, scenarioOrigin.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                result.runOrigin = new DataQualityRunOrigin.RedactedScenarioStep();
            } else {
                Scenario scenario = this.scenariosService.getOrNullUnsafe(scenarioOrigin.projectKey, scenarioOrigin.scenarioId);
                if (scenario != null) {
                    result.scenarioName = scenario.getDisplayName();
                }
            }
        }
        return result;
    }

    public UIProjectDataQuality getProjectStatus_NT(SerializedProject prj, List<SerializedDataset> sds, PublicUser owner, String projectKey) throws Exception {
        Map<String, SerializedDataset> nonBrokenDatasets = this.filterDatasetsWithValidRuleset(sds);
        ReadOnlyJobsInternalDB.DataQualityProjectPoint projectPoint = this.readOnlyJobsInternalDB.getLastDataQualityProjectStatus(projectKey);
        List<UIDProjectDatasetDataQuality> items = this.getProjectDatasetDataQualitySummary_NT(prj, nonBrokenDatasets.values());
        long lastBuildDate = items.stream().filter(i -> i.monitored).map(i -> i.lastBuildDate).reduce(-1L, Math::max);
        return new UIProjectDataQuality(owner, lastBuildDate, projectPoint, !nonBrokenDatasets.isEmpty(), items);
    }

    private List<UIDProjectDatasetDataQuality> getProjectDatasetDataQualitySummary_NT(SerializedProject prj, Collection<SerializedDataset> nonBrokenDatasets) throws Exception {
        String projectKey = prj.projectKey;
        ArrayList<UIDProjectDatasetDataQuality> datasetsStatus = new ArrayList<UIDProjectDatasetDataQuality>();
        HashMap<String, Integer> datasetIdSharedProjects = new HashMap<String, Integer>();
        for (ExposedObject obj : prj.exposedObjects.objects) {
            datasetIdSharedProjects.put(obj.localName, obj.rules.size());
        }
        List<AnyLoc> datasetsLocs = nonBrokenDatasets.stream().map(sd -> new AnyLoc(projectKey, sd.getId())).toList();
        Map<String, Long> mapDBDatasetLastBuild = this.readOnlyJobsInternalDB.getLatestBuildTimeForDatasets(new HashSet<AnyLoc>(datasetsLocs));
        Map<String, ReadOnlyJobsInternalDB.DataQualityLastObjectPoint> datasetNameToLastObjectPoint = this.readOnlyJobsInternalDB.getLastDataQualityObjectStatusesForProject(projectKey);
        Map<String, ReadOnlyJobsInternalDB.DataQualityPartitionPoint> npDataPoints = this.readOnlyJobsInternalDB.getLastDataQualityPartitionStatusesForNPProject(projectKey);
        Map<String, PublicUser> loginToPublicUserMap = this.getLoginToPublicUserMapForSd(nonBrokenDatasets);
        for (SerializedDataset sd2 : nonBrokenDatasets) {
            String datasetFullName = new AnyLoc(projectKey, sd2.getId()).getFullName();
            UIDProjectDatasetDataQuality d = new UIDProjectDatasetDataQuality();
            d.dataSteward = loginToPublicUserMap.getOrDefault(sd2.dataSteward, null);
            String defaultDataStewardLogin = DataStewardService.getDefaultDataStewardLogin(sd2);
            d.defaultDataSteward = loginToPublicUserMap.getOrDefault(defaultDataStewardLogin, null);
            d.id = sd2.getId();
            DataQualityRuleSet ruleSet = sd2.getDataQualityRuleSet();
            ReadOnlyJobsInternalDB.DataQualityLastObjectPoint datasetPoint = datasetNameToLastObjectPoint.get(sd2.name);
            d.datasetQuality = sd2.isPartitioned() ? DataQualityDailyStatus.fromDataPoint(datasetPoint) : DataQualityDailyStatus.fromDataPoint(npDataPoints.get(sd2.name));
            d.monitored = ruleSet.monitor;
            d.lastBuildDate = mapDBDatasetLastBuild.getOrDefault(datasetFullName, -1L);
            d.numberProjectDatasetShared = datasetIdSharedProjects.getOrDefault(sd2.getId(), 0);
            d.tags = sd2.tags;
            d.datasetType = sd2.type;
            d.numberEnabledRules = ruleSet.getEnabledRules().size();
            d.isPartitioned = sd2.isPartitioned();
            d.partitioning = sd2.partitioning;
            d.lastRunRuleComputeTime = datasetPoint == null ? -1L : datasetPoint.lastRunRuleComputeTime;
            datasetsStatus.add(d);
        }
        return datasetsStatus;
    }

    public List<UIMonitoredProject> getMonitoredProjects_NT(List<ProjectsService.UIProject> projects) throws Exception {
        ArrayList<UIMonitoredProject> monitoredProjects = new ArrayList<UIMonitoredProject>();
        Map<String, ReadOnlyJobsInternalDB.DataQualityProjectPoint> projectStatuses = this.readOnlyJobsInternalDB.getLastDataQualityProjectStatusesForList(projects.stream().map(p -> p.projectKey).toList());
        Map<String, PublicUser> loginToPublicUserMap = this.getLoginToPublicUserMap(projects.stream().map(p -> p.ownerLogin).toList());
        for (ProjectsService.UIProject prj : projects) {
            if (!projectStatuses.containsKey(prj.projectKey)) continue;
            ReadOnlyJobsInternalDB.DataQualityProjectPoint monitoredProject = projectStatuses.get(prj.projectKey);
            monitoredProjects.add(new UIMonitoredProject(prj.projectKey, monitoredProject.lastRunRuleComputeTime, new DataQualityDailyStatus(monitoredProject), prj.tags, loginToPublicUserMap.getOrDefault(prj.ownerLogin, null), prj.getDisplayName()));
        }
        return monitoredProjects.stream().filter(mp -> mp.status.numberItems > 0).toList();
    }

    public List<DataQualityDailyProjectStatusAPI> getPublicAPIProjectHistoryBetweenDays(String projectKey, long minTimestamp, long maxTimestamp, List<SerializedDataset> sds) throws Exception {
        HashMap<Long, Map> dayToDatasets = new HashMap<Long, Map>();
        Map<String, SerializedDataset> nonBrokenDatasets = this.filterDatasetsWithValidRuleset(sds);
        Map<String, ReadOnlyJobsInternalDB.DataQualityLastObjectPoint> lastDatasetsStatus = this.readOnlyJobsInternalDB.getLastDataQualityObjectStatusesForProject(projectKey);
        List<ReadOnlyJobsInternalDB.DataQualityHistoryObjectPoint> dataQualityHistoryObjectsPoints = this.readOnlyJobsInternalDB.getDataQualityProjectHistoryTimeline(projectKey, minTimestamp, maxTimestamp);
        for (ReadOnlyJobsInternalDB.DataQualityHistoryObjectPoint point : dataQualityHistoryObjectsPoints) {
            String datasetName = nonBrokenDatasets.containsKey(point.objectId) ? nonBrokenDatasets.get(point.objectId).getId() : lastDatasetsStatus.get((Object)point.objectId).displayName;
            dayToDatasets.computeIfAbsent(point.timestamp, timestamp -> new HashMap()).put(datasetName, new DatasetStatusAPI(point));
        }
        return dayToDatasets.entrySet().stream().map(e -> new DataQualityDailyProjectStatusAPI((Long)e.getKey(), (Map)e.getValue())).toList();
    }

    @UIModel
    public static class UIDataQualityRule {
        public String id;
        public String name;
        public String type;
        @Nullable
        public AbstractCheckContext.CheckOutcome outcome;
        @Nullable
        public AbstractCheckContext.CheckOutcome worstOutcome;
        public String message = "";
        public long computationDate = -1L;
        public boolean autoRun;
        public boolean enabled;
        public boolean deleted;
        public Probe.ComputeMode computeMode;
        @Nullable
        public DataQualityRunOrigin runOrigin;
        @Nullable
        public String scenarioName;
        public boolean supportsFailedRowsExtraction;

        private UIDataQualityRule(DataQualityRule rule, @Nullable ReadOnlyJobsInternalDB.CheckDataPoint checkDataPoint, @Nullable AbstractCheckContext.CheckOutcome worstOutcome, boolean enabled, boolean deleted, boolean supportsFailedRowsExtraction) {
            this.id = rule.getId();
            this.name = rule.getDisplayName();
            this.type = rule.getType();
            this.autoRun = rule.autoRun;
            this.enabled = enabled;
            if (checkDataPoint != null) {
                this.outcome = checkDataPoint.outcome;
                this.message = checkDataPoint.message;
                this.computationDate = checkDataPoint.time;
                this.runOrigin = checkDataPoint.runOrigin;
            }
            this.worstOutcome = worstOutcome;
            this.deleted = deleted;
            this.computeMode = rule.computeOnBuildMode;
            this.supportsFailedRowsExtraction = supportsFailedRowsExtraction;
        }

        public static UIDataQualityRule historyPoint(DataQualityRule rule, @Nullable ReadOnlyJobsInternalDB.CheckDataPoint checkDataPoint, @Nullable AbstractCheckContext.CheckOutcome worstOutcome, boolean enabled, boolean deleted, boolean supportsFailedRowsExtraction1) {
            return new UIDataQualityRule(rule, checkDataPoint, worstOutcome, enabled, deleted, supportsFailedRowsExtraction1);
        }

        public static UIDataQualityRule currentStatusPoint(DataQualityRule rule, @Nullable ReadOnlyJobsInternalDB.CheckDataPoint checkDataPoint, boolean supportsFailedRowsExtraction) {
            return new UIDataQualityRule(rule, checkDataPoint, null, rule.enabled, false, supportsFailedRowsExtraction);
        }
    }

    @UIModel
    public static class UIDatasetDataQuality {
        public List<UIDataQualityRule> rules;

        public UIDatasetDataQuality(List<UIDataQualityRule> rules) {
            this.rules = rules;
        }
    }

    private static class RunOriginAndScenarioName {
        public DataQualityRunOrigin runOrigin;
        @Nullable
        public String scenarioName;

        private RunOriginAndScenarioName() {
        }
    }

    @UIModel
    public static class UIProjectDataQuality {
        public PublicUser owner;
        public long lastBuildDate;
        public long lastRunRuleDate;
        public DataQualityDailyStatus status;
        public boolean hasDataset;
        public List<UIDProjectDatasetDataQuality> items;

        public UIProjectDataQuality(PublicUser owner, long lastBuildDate, ReadOnlyJobsInternalDB.DataQualityProjectPoint projectPoint, boolean hasDataset, List<UIDProjectDatasetDataQuality> items) {
            this.owner = owner;
            this.lastBuildDate = lastBuildDate;
            this.lastRunRuleDate = projectPoint == null ? -1L : projectPoint.lastRunRuleComputeTime;
            this.status = DataQualityDailyStatus.fromDataPoint(projectPoint);
            this.hasDataset = hasDataset;
            this.items = items;
        }
    }

    @UIModel
    public static class UIDProjectDatasetDataQuality {
        public String id;
        public boolean monitored;
        public boolean deleted;
        public DataQualityDailyStatus datasetQuality;
        public String datasetType;
        public long lastBuildDate = -1L;
        public long lastRunRuleComputeTime = -1L;
        @UINullable
        public PublicUser dataSteward;
        @UINullable
        public PublicUser defaultDataSteward;
        public int numberEnabledRules = 0;
        public int numberProjectDatasetShared = 0;
        public List<String> tags = new ArrayList<String>();
        public boolean isNowDeleted;
        public boolean isPartitioned = false;
        public PartitioningScheme partitioning = new PartitioningScheme();
    }

    @UIModel
    public static class UIMonitoredProject {
        String projectKey;
        long lastRunRuleDate;
        DataQualityDailyStatus status;
        List<String> tags;
        @UINullable
        PublicUser projectOwner;
        String displayName;

        public UIMonitoredProject(String projectKey, long lastRunRuleDate, DataQualityDailyStatus status, List<String> tags, PublicUser projectOwner, String displayName) {
            this.projectKey = projectKey;
            this.lastRunRuleDate = lastRunRuleDate;
            this.status = status;
            this.tags = tags;
            this.projectOwner = projectOwner;
            this.displayName = displayName;
        }
    }

    public static class DatasetStatusAPI {
        public boolean monitored;
        public boolean deleted;
        public long lastRunRuleComputeTime;
        public AbstractCheckContext.CheckOutcome lastOutcome;
        public AbstractCheckContext.CheckOutcome worstOutcome;

        public DatasetStatusAPI(ReadOnlyJobsInternalDB.DataQualityHistoryObjectPoint p) {
            this.monitored = p.monitored;
            this.deleted = p.deleted;
            this.lastRunRuleComputeTime = p.lastRunRuleComputeTime;
            this.lastOutcome = p.last.getOutcome();
            this.worstOutcome = p.worst.getOutcome();
        }
    }

    public static class DataQualityDailyProjectStatusAPI {
        public final long timestamp;
        public Map<String, DatasetStatusAPI> datasets;

        public DataQualityDailyProjectStatusAPI(long day, Map<String, DatasetStatusAPI> datasets) {
            this.timestamp = day;
            this.datasets = datasets;
        }
    }

    @UIModel
    public static class UIInstanceDataQuality {
        final int numberVisibleProjects;
        final List<UIMonitoredProject> monitoredProjects;

        public UIInstanceDataQuality(int numberVisibleProjects, List<UIMonitoredProject> monitoredProjects) {
            this.numberVisibleProjects = numberVisibleProjects;
            this.monitoredProjects = monitoredProjects;
        }
    }
}

