/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.analysis;

import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.meanings.NoopBasicMeaningsService;
import com.dataiku.dip.pivot.backend.sql.utils.BinUtils;
import com.dataiku.dip.shaker.analysis.NumericalVariableAnalysis;
import com.dataiku.dip.shaker.types.FreeText;
import com.dataiku.dip.shaker.types.Number;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DoubleList;
import com.dataiku.dip.utils.LongList;
import com.dataiku.scoring.pipelines.DatetimeCyclicalEncoder;
import gnu.trove.list.array.TDoubleArrayList;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class NumericalVariableAnalyzer {
    private static final int OUTLIER_EXAMPLES = 6;
    private static final int MIN_SUB_PERIOD_DISTINCT_VALUES = 3;
    private NumericalVariableAnalysis out = new NumericalVariableAnalysis();
    public boolean enableTimePeriodAnalysis;
    private int histogramNbBins;
    public boolean niceBounds = true;
    private IBasicMeaningsService meaningsService;
    int added;
    double sum;
    int missing;
    int bad;
    TDoubleArrayList observations;
    LongList histogramBars = new LongList();
    DoubleList histogramValues = new DoubleList();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis");

    public NumericalVariableAnalyzer(int histogramNbBins) {
        this.histogramNbBins = histogramNbBins;
        this.meaningsService = new NoopBasicMeaningsService();
        this.observations = new TDoubleArrayList();
        this.out.max = Double.NEGATIVE_INFINITY;
        this.out.min = Double.MAX_VALUE;
    }

    public void analyse(MemTable mt, String columnName, boolean[] filters) {
        MemColumn cd = mt.column(columnName);
        if (cd.selectedType != null && cd.selectedType.type.isDouble()) {
            FreeText detector;
            try {
                detector = this.meaningsService.buildSingleDetector(cd.selectedType.type.getMeaningId());
            }
            catch (IOException e) {
                detector = new FreeText();
            }
            int i = 0;
            for (MemRow mr : mt.rows) {
                if (mr.isDeleted() || filters != null && !filters[i++]) continue;
                String val = mr.get(cd);
                double dv = detector.doubleValue(val);
                if (!Double.isNaN(dv) && !Double.isInfinite(dv)) {
                    this.append(dv);
                    continue;
                }
                if (StringUtils.isBlank((String)val)) {
                    ++this.missing;
                    continue;
                }
                ++this.bad;
            }
        } else {
            Number dt = new Number();
            int i = 0;
            for (MemRow mr : mt.rows) {
                if (mr.isDeleted() || filters != null && !filters[i++]) continue;
                String val = mr.get(cd);
                if (dt.validates(val)) {
                    this.append(Double.parseDouble(val));
                    continue;
                }
                if (StringUtils.isBlank((String)val)) {
                    ++this.missing;
                    continue;
                }
                ++this.bad;
            }
        }
    }

    public void append(double data) {
        ++this.added;
        this.observations.add(data);
        this.out.max = Math.max(data, this.out.max);
        this.out.min = Math.min(data, this.out.min);
        this.sum += data;
    }

    public static double median(double[] x, int first, int nb) {
        if (nb == 0) {
            return x[first];
        }
        if (nb % 2 == 0) {
            return (x[first + nb / 2 - 1] + x[first + nb / 2]) / 2.0;
        }
        return x[first + nb / 2];
    }

    public void compute() {
        int i;
        logger.info((Object)("Computing numerical analysis on " + this.added + " values"));
        if (this.added == 0) {
            return;
        }
        double total = (long)this.added + (long)this.bad + (long)this.missing;
        this.out.sum = this.sum;
        this.out.mean = this.sum / (double)this.added;
        this.out.bad = (double)this.bad / total;
        this.out.missing = (double)this.missing / total;
        double[] obs = this.observations.toArray();
        Arrays.sort(obs);
        this.out.quartiles[0] = NumericalVariableAnalyzer.median(obs, 0, this.added / 2);
        this.out.quartiles[1] = this.out.median = NumericalVariableAnalyzer.median(obs, 0, this.added);
        this.out.quartiles[2] = NumericalVariableAnalyzer.median(obs, this.added / 2, this.added / 2);
        if (this.added >= 2) {
            double ssq = 0.0;
            for (double d : obs) {
                ssq += Math.pow(d - this.out.mean, 2.0);
            }
            this.out.stddev = Math.sqrt(ssq / (double)(this.added - 1));
        }
        double maxValue = Double.NaN;
        int maxCardinality = 0;
        double curVal = Double.NaN;
        int curCardinality = 0;
        int cardinality = 0;
        double[] dArray = obs;
        int n = dArray.length;
        for (int j = 0; j < n; ++j) {
            double d = dArray[j];
            if (Double.isNaN(curVal)) {
                curVal = d;
                curCardinality = 1;
                cardinality = 1;
                continue;
            }
            if (d == curVal) {
                ++curCardinality;
                continue;
            }
            if (curCardinality > maxCardinality) {
                maxValue = curVal;
                maxCardinality = curCardinality;
            }
            this.histogramValues.add(curVal);
            this.histogramBars.add((long)curCardinality);
            curVal = d;
            curCardinality = 1;
            ++cardinality;
        }
        if (curCardinality > maxCardinality) {
            maxValue = curVal;
        }
        this.histogramValues.add(curVal);
        this.histogramBars.add((long)curCardinality);
        this.out.mode = maxValue;
        this.out.cardinality = cardinality;
        this.out.nbValues = this.added;
        double iqr = this.out.quartiles[2] - this.out.quartiles[0];
        this.out.lowWhisker = Math.max(this.out.min, this.out.quartiles[0] - iqr * 1.5);
        this.out.highWhisker = Math.min(this.out.max, this.out.quartiles[2] + iqr * 1.5);
        this.out.iqr = iqr;
        ArrayList<Double> outliers = new ArrayList<Double>(6);
        for (i = 0; i < this.added; ++i) {
            if (obs[i] < this.out.lowWhisker) {
                ++this.out.bottomOutliers;
                if (outliers.size() >= 6 || outliers.contains(obs[i])) continue;
                outliers.add(obs[i]);
                continue;
            }
            if (!(obs[i] > this.out.highWhisker)) continue;
            ++this.out.topOutliers;
            if (outliers.size() >= 6 || outliers.contains(obs[i])) continue;
            outliers.add(obs[i]);
        }
        this.out.outlierExamples = new double[outliers.size()];
        for (i = 0; i < outliers.size(); ++i) {
            this.out.outlierExamples[i] = (Double)outliers.get(i);
        }
        double span = this.out.max - this.out.min;
        this.out.relevantPeriods = new HashSet<DatetimeCyclicalEncoder.Period>();
        this.out.irrelevantPeriods = new HashSet<DatetimeCyclicalEncoder.Period>();
        if (this.enableTimePeriodAnalysis) {
            double spanInSeconds = span / 1000.0;
            LocalDateTime origin = LocalDateTime.of(1900, 1, 1, 0, 0, 0);
            this.out.periodHistograms = new HashMap<DatetimeCyclicalEncoder.Period, int[]>();
            for (DatetimeCyclicalEncoder.Period period : DatetimeCyclicalEncoder.Period.values()) {
                this.out.periodHistograms.put(period, new int[this.histogramNbBins]);
                double binDuration = (double)period.durationInSeconds / (double)this.histogramNbBins;
                HashSet<Long> distinctValues = new HashSet<Long>();
                for (double value : obs) {
                    LocalDateTime dateTime = origin.plus(Duration.of((long)value, ChronoUnit.MILLIS));
                    long remainderWithinThePeriod = ChronoUnit.SECONDS.between(DatetimeCyclicalEncoder.getTruncatedDateTime((DatetimeCyclicalEncoder.Period)period, (LocalDateTime)dateTime), dateTime);
                    int[] nArray = this.out.periodHistograms.get(period);
                    int n2 = (int)((double)remainderWithinThePeriod / binDuration);
                    nArray[n2] = nArray[n2] + 1;
                    distinctValues.add(remainderWithinThePeriod);
                }
                if (distinctValues.size() >= 3) {
                    if (spanInSeconds >= (double)period.durationInSeconds) {
                        this.out.relevantPeriods.add(period);
                        continue;
                    }
                    if (!(spanInSeconds <= (double)period.durationInSeconds * 0.5)) continue;
                    this.out.irrelevantPeriods.add(period);
                    continue;
                }
                this.out.irrelevantPeriods.add(period);
            }
        }
        BinUtils.HistogramParams histogramParams = BinUtils.getHistogramParams(this.niceBounds, this.histogramNbBins, this.out.min, this.out.max);
        this.histogramNbBins = histogramParams.nbBins;
        this.out.histogramLowerBounds = BinUtils.buildLowerBounds(this.histogramNbBins, histogramParams.fixedMin, histogramParams.step);
        this.out.histogramUpperBounds = BinUtils.buildUpperBounds(this.histogramNbBins, histogramParams.fixedMin, this.out.max, histogramParams.step);
        this.out.histogram = BinUtils.buildHistogram(this.histogramValues, this.histogramBars, this.out.histogramUpperBounds, this.histogramNbBins);
        this.out.chistogram = BinUtils.buildCompactHistogram(this.out.histogram, this.out.histogramLowerBounds, this.out.histogramUpperBounds, this.histogramNbBins);
        for (int count : this.out.histogram) {
            this.out.longestHistogramBar = Math.max(count, this.out.longestHistogramBar);
        }
    }

    public NumericalVariableAnalysis getOut() {
        if (this.out.isEmpty()) {
            return null;
        }
        return this.out;
    }

    public void setOut(NumericalVariableAnalysis out) {
        this.out = out;
    }
}

