/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.utils.ExceptionUtils;
import java.sql.DatabaseMetaData;

public class DriverVersionExtractor {
    private final DatabaseMetaData meta;

    public DriverVersionExtractor(DatabaseMetaData meta) {
        this.meta = meta;
    }

    public String getFormatterDriverInfos() {
        return String.format("Driver: %s (%s) %s", this.getFormattedDriverName(), this.getFormattedJDBCVersion(), this.getFormattedDriverVersion());
    }

    public String getFormattedDatabaseInfos() {
        return String.format("Database: %s %s %s %s", this.getFormattedDatabaseName(), this.getFormattedDatabaseVersion(), this.getFormattedMaxRowSize(), this.getFormattedMaxStatements());
    }

    private String getFormattedDriverName() {
        try {
            return this.meta.getDriverName();
        }
        catch (Throwable e) {
            return "Unknown driver (" + ExceptionUtils.getMessageWithCauses((Throwable)e) + ")";
        }
    }

    private String getFormattedDriverVersion() {
        try {
            String version = this.meta.getDriverVersion();
            int major = this.meta.getDriverMajorVersion();
            int minor = this.meta.getDriverMinorVersion();
            return String.format("%s (%s.%s)", version, major, minor);
        }
        catch (Throwable e) {
            return "Unknown driver version (" + ExceptionUtils.getMessageWithCauses((Throwable)e) + ")";
        }
    }

    private String getFormattedJDBCVersion() {
        try {
            int major = this.meta.getJDBCMajorVersion();
            int minor = this.meta.getJDBCMinorVersion();
            return String.format("JDBC %s.%s", major, minor);
        }
        catch (Throwable e) {
            return "Unknown JDBC version (" + ExceptionUtils.getMessageWithCauses((Throwable)e) + ")";
        }
    }

    private String getFormattedDatabaseName() {
        try {
            return this.meta.getDatabaseProductName();
        }
        catch (Throwable e) {
            return "Unknown database (" + ExceptionUtils.getMessageWithCauses((Throwable)e) + ")";
        }
    }

    private String getFormattedMaxRowSize() {
        try {
            return String.format("rowSize=%s", this.meta.getMaxRowSize());
        }
        catch (Throwable e) {
            return "rowSize=N/A";
        }
    }

    private String getFormattedMaxStatements() {
        try {
            return String.format("stmts=%s", this.meta.getMaxStatements());
        }
        catch (Throwable e) {
            return "stmts=N/A";
        }
    }

    private String getFormattedDatabaseVersion() {
        try {
            String version = this.meta.getDatabaseProductVersion();
            int major = this.meta.getDatabaseMajorVersion();
            int minor = this.meta.getDatabaseMinorVersion();
            return String.format("%s (%s.%s)", version, major, minor);
        }
        catch (Throwable e) {
            return "Unknown database version (" + ExceptionUtils.getMessageWithCauses((Throwable)e) + ")";
        }
    }
}

