/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.CombinedSelectQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QuerySQLWriter;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SelectQueryBuilder {
    private static ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
    QueryAst.SelectQuery query = new QueryAst.SelectQuery();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.sql.querybuilder");

    public String getCurrentMainAlias() {
        return this.query.from.getAlias();
    }

    public QueryAst.TableLike getFromCopy(String alias) {
        QueryAst.SelectQuery ret = this.query.shallowCopy();
        ret.alias = alias;
        return ret;
    }

    public SelectQueryBuilder where(ExpressionBuilder ... builders) {
        for (ExpressionBuilder eb : builders) {
            if (eb == null) continue;
            this.query.where.add(eb.expr);
        }
        return this;
    }

    public SelectQueryBuilder having(ExpressionBuilder ... builders) {
        for (ExpressionBuilder eb : builders) {
            this.query.having.add(eb.expr);
        }
        return this;
    }

    public SelectQueryBuilder group(String column) {
        this.group(ef.col(column));
        return this;
    }

    public SelectQueryBuilder group(ExpressionBuilder eb) {
        QueryAst.GroupClause grp = new QueryAst.GroupClause();
        grp.expr = eb.expr;
        this.query.groupBy.add(grp);
        return this;
    }

    public SelectQueryBuilder group(SelectRefBuilder srb) {
        QueryAst.GroupClause grp = new QueryAst.GroupClause();
        grp.expr = new QueryAst.ConstExpr(srb.selectRef.index);
        this.query.groupBy.add(grp);
        return this;
    }

    public SelectQueryBuilder order(int index) {
        this.order(new ExpressionBuilder.ExpressionBuilderFactory().cst(index), null);
        return this;
    }

    public SelectQueryBuilder order(String column) {
        this.order(column, null);
        return this;
    }

    public SelectQueryBuilder order(String column, QueryAst.OrderType order) {
        this.order(new ExpressionBuilder.ExpressionBuilderFactory().col(column), order);
        return this;
    }

    public SelectQueryBuilder order(ExpressionBuilder eb) {
        return this.order(eb, null);
    }

    public SelectQueryBuilder order(ExpressionBuilder eb, QueryAst.OrderType order) {
        return this.order(eb, order, order);
    }

    public SelectQueryBuilder order(ExpressionBuilder eb, QueryAst.OrderType order, QueryAst.OrderType nulls) {
        QueryAst.OrderClause ord = new QueryAst.OrderClause();
        ord.expr = eb.expr;
        ord.orderType = order;
        ord.nullOrder = nulls;
        return this.order(ord);
    }

    public SelectQueryBuilder order(QueryAst.OrderClause ord) {
        this.query.orderBy.add(ord);
        return this;
    }

    public SelectQueryBuilder order(SelectRefBuilder srb) {
        this.order(srb, null);
        return this;
    }

    public SelectQueryBuilder order(SelectRefBuilder srb, QueryAst.OrderType order) {
        return this.order(srb, order, order);
    }

    public SelectQueryBuilder order(SelectRefBuilder srb, QueryAst.OrderType order, QueryAst.OrderType nulls) {
        QueryAst.OrderClause ord = new QueryAst.OrderClause();
        ord.expr = new QueryAst.ConstExpr(srb.selectRef.index);
        ord.orderType = order;
        ord.nullOrder = nulls;
        this.query.orderBy.add(ord);
        return this;
    }

    public List<QueryAst.OrderClause> getOrderBy() {
        return this.query.orderBy;
    }

    public SelectQueryBuilder limit(Long maxNbRecords) {
        this.query.limit = maxNbRecords;
        return this;
    }

    public SelectQueryBuilder comment(String com) {
        this.query.comment = com;
        return this;
    }

    public QueryAst.TableLike from(String tableName) {
        return this.from(null, null, tableName, null);
    }

    public QueryAst.TableLike from(String tableName, String as) {
        return this.from(null, null, tableName, as);
    }

    public QueryAst.TableLike from(SQLUtils.SQLTable table, String as) {
        return this.from(table.getCatalog(), table.getSchemaNullIfBlank(), table.getTable(), as);
    }

    public QueryAst.TableLike from(SQLUtils.SQLTable table, String as, QueryAst.SampleClause sample) {
        return this.from(table.getCatalog(), table.getSchemaNullIfBlank(), table.getTable(), as, sample);
    }

    public QueryAst.TableLike from(String catalog, String schema, String tableName, String as) {
        return this.from(catalog, schema, tableName, as, null);
    }

    public QueryAst.TableLike from(String catalog, String schema, String tableName, String as, QueryAst.SampleClause sample) {
        if (StringUtils.isBlank((String)tableName)) {
            throw new QueryUtils.SQLGenerationException("Empty table name");
        }
        this.query.from = new QueryAst.Table(catalog, schema, tableName, as, sample);
        if (as != null) {
            return new QueryAst.Table(null, null, as, null, sample);
        }
        return new QueryAst.Table(catalog, schema, tableName, null, sample);
    }

    public QueryAst.TableLike from(SelectQueryBuilder qb, String as) {
        assert (qb != null);
        assert (as != null);
        qb.query.alias = as;
        this.query.from = qb.query;
        return new QueryAst.Table(null, null, as, null);
    }

    public QueryAst.TableLike from(QueryAst.TableLike table) {
        assert (table != null);
        this.query.from = table;
        return new QueryAst.Table(null, null, table.getAlias(), null);
    }

    public QueryAst.TableLike from(CombinedSelectQueryBuilder c2, String as) {
        c2.combinedTables.alias = as;
        return this.from(c2.combinedTables);
    }

    public QueryAst.TableLike from() {
        return this.query.from;
    }

    public SelectQueryBuilder getQuery(QueryAst.TableLike tableLike) {
        SelectQueryBuilder qb = new SelectQueryBuilder();
        if (tableLike instanceof QueryAst.SelectQuery) {
            qb.query = (QueryAst.SelectQuery)tableLike;
        } else {
            qb.from(tableLike);
        }
        return qb;
    }

    public QueryAst.TableLike with(SelectQueryBuilder qb, String as) {
        qb.query.alias = as;
        this.query.with.add(qb.query);
        return new QueryAst.Table(null, null, as, as);
    }

    public QueryAst.TableLike withInlineQuery(String inlineQuery, String as) {
        QueryAst.InlineQuery table = new QueryAst.InlineQuery(inlineQuery, as);
        this.query.with.add(table);
        return new QueryAst.Table(null, null, as, as);
    }

    public QueryAst.TableLike withInlineQuery(String inlineQuery, List<String> columnNames, String as) {
        QueryAst.InlineQuery table = new QueryAst.InlineQuery(inlineQuery, columnNames, as);
        this.query.with.add(table);
        return new QueryAst.Table(null, null, as, as);
    }

    public SelectRefBuilder select(String column) {
        return this.select(ef.col(column), null);
    }

    public SelectRefBuilder select(String column, String alias) {
        return this.select(ef.col(column), alias);
    }

    public SelectRefBuilder select(ExpressionBuilder eb) {
        return this.select(eb, null);
    }

    public SelectRefBuilder select(ExpressionBuilder eb, String as) {
        QueryAst.SelectRef ref = new QueryAst.SelectRef();
        ref.expr = eb.expr;
        ref.alias = as;
        this.query.selectList.add(ref);
        ref.index = this.query.selectList.size();
        return new SelectRefBuilder(ref);
    }

    public SelectRefBuilder selectUniqueId(String as) {
        return this.select(ef.uniqueId(), as);
    }

    public int getSelectedIndex(String name) {
        int i = -1;
        for (QueryAst.SelectRef sr : this.query.selectList) {
            ++i;
            if (!name.equals(sr.alias)) continue;
            return i;
        }
        i = -1;
        for (QueryAst.SelectRef sr : this.query.selectList) {
            ++i;
            if (sr.expr == null || !(sr.expr instanceof QueryAst.Column) || !name.equals(((QueryAst.Column)sr.expr).name)) continue;
            return i;
        }
        return -1;
    }

    public List<String> getSelectedNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (QueryAst.SelectRef sr : this.query.selectList) {
            if (sr.expr instanceof QueryAst.Comment) continue;
            if (sr.alias != null) {
                ret.add(sr.alias);
                continue;
            }
            if (sr.expr != null && sr.expr instanceof QueryAst.Column) {
                ret.add(((QueryAst.Column)sr.expr).name);
                continue;
            }
            throw new NotImplementedException("Can't get selected name from " + JSON.log((Object)sr));
        }
        return ret;
    }

    public SelectRefBuilder replaceSelect(String name, ExpressionBuilder eb, String as) {
        int selectedIndex = this.getSelectedIndex(name);
        if (selectedIndex < 0) {
            throw new IllegalArgumentException("There is no column name or alias with the name '" + name + "'");
        }
        QueryAst.SelectRef ref = new QueryAst.SelectRef();
        ref.expr = eb.expr;
        ref.alias = as;
        this.query.selectList.set(selectedIndex, ref);
        ref.index = selectedIndex;
        return new SelectRefBuilder(ref);
    }

    public void deleteSelect(String name) {
        int selectedIndex = this.getSelectedIndex(name);
        assert (selectedIndex >= 0);
        this.query.selectList.remove(selectedIndex);
    }

    public void clearSelected() {
        this.query.selectList = new ArrayList<QueryAst.SelectRef>();
    }

    public boolean hasSelectedItems() {
        return !this.query.selectList.isEmpty();
    }

    public boolean hasFilters() {
        return !this.query.where.isEmpty();
    }

    public int getSelectedItemsCount() {
        List<QueryAst.SelectRef> selectList = this.getEffectiveSelectRef(this.query);
        if (selectList != null) {
            return selectList.size();
        }
        return 0;
    }

    public List<String> getSelectedItemsAliases() {
        ArrayList aliases = Lists.newArrayList();
        List<QueryAst.SelectRef> selectList = this.getEffectiveSelectRef(this.query);
        if (selectList != null) {
            for (QueryAst.SelectRef e : selectList) {
                if (e.expr instanceof QueryAst.Comment) continue;
                aliases.add(e.alias);
            }
        }
        return aliases;
    }

    private List<QueryAst.SelectRef> getEffectiveSelectRef(QueryAst.SelectQuery query) {
        if (query.selectList == null || query.selectList.isEmpty()) {
            if (query.from instanceof QueryAst.SelectQuery) {
                return ((QueryAst.SelectQuery)query.from).selectList;
            }
            return null;
        }
        return query.selectList;
    }

    public void selectSubrequestColumnsExceptTemp(SelectQueryBuilder qb) {
        for (QueryAst.SelectRef ref : qb.query.selectList) {
            if (ref.alias != null) {
                if (ref.alias.startsWith("dku_tmp_")) continue;
                this.select(ref.alias);
                continue;
            }
            if (ref.expr instanceof QueryAst.Column) {
                this.select(ef.expr(ref.expr));
                continue;
            }
            throw new QueryUtils.SQLGenerationException("No alias defined in the subquery column");
        }
    }

    public void selectDistinct() {
        this.query.distinct = true;
    }

    public JoinClauseBuilder join(QueryAst.TableLike tableLike, QueryAst.JoinType type) {
        QueryAst.JoinClause join = new QueryAst.JoinClause();
        join.tableLike = tableLike;
        join.type = type;
        this.query.join.add(join);
        return new JoinClauseBuilder(join);
    }

    public JoinClauseBuilder join(SelectQueryBuilder qb, QueryAst.JoinType type, String as) {
        qb.query.alias = as;
        return this.join(qb.query, type);
    }

    public JoinClauseBuilder join(String table, QueryAst.JoinType type) {
        return this.join(table, type, null);
    }

    public JoinClauseBuilder join(String table, QueryAst.JoinType type, String as) {
        QueryAst.Table tableLike = new QueryAst.Table(null, null, table, as);
        return this.join(tableLike, type);
    }

    public JoinClauseBuilder join(SQLUtils.SQLTable table, QueryAst.JoinType type) {
        return this.join(table, type, null);
    }

    public JoinClauseBuilder join(SQLUtils.SQLTable table, QueryAst.JoinType type, String as) {
        QueryAst.Table tableLike = new QueryAst.Table(table.getCatalog(), table.getSchemaNullIfBlank(), table.getTable(), as);
        return this.join(tableLike, type);
    }

    public static QueryAst.TableLike table(String tableName) {
        return SelectQueryBuilder.table(null, null, tableName, tableName);
    }

    public static QueryAst.TableLike table(String tableName, String alias) {
        return SelectQueryBuilder.table(null, null, tableName, alias);
    }

    public static QueryAst.TableLike table(String catalog, String schema, String tableName, String as) {
        return new QueryAst.Table(catalog, schema, tableName, as);
    }

    public static QueryAst.TableLike table(SQLUtils.SQLTable table, String as) {
        return SelectQueryBuilder.table(table.getCatalog(), table.getSchemaNullIfBlank(), table.getTable(), as);
    }

    public static QueryAst.TableLike table(SelectQueryBuilder qb, String as) {
        qb.query.alias = as;
        return qb.query;
    }

    public static QueryAst.Window window(List<ExpressionBuilder> partitionColumns, List<ExpressionBuilder> orderExpressions, List<QueryAst.OrderType> orders) {
        QueryAst.Window window = new QueryAst.Window();
        if (partitionColumns != null) {
            window.partitionExpressions = new ArrayList<QueryAst.Expr>(partitionColumns.size());
            for (ExpressionBuilder eb : partitionColumns) {
                window.partitionExpressions.add(eb.expr);
            }
        }
        if (orderExpressions != null) {
            window.orderExpressions = new ArrayList<QueryAst.Expr>(orderExpressions.size());
            window.orderTypes = new ArrayList<QueryAst.OrderType>(orderExpressions.size());
            for (int i = 0; i < orderExpressions.size(); ++i) {
                ExpressionBuilder eb;
                eb = orderExpressions.get(i);
                window.orderExpressions.add(eb.expr);
                window.orderTypes.add(orders != null && orders.size() > i ? orders.get(i) : null);
            }
        }
        return window;
    }

    public static QueryAst.Window unboundedWindow(QueryAst.Window window) {
        if (window.frameMode == null) {
            return window;
        }
        QueryAst.Window ret = new QueryAst.Window();
        ret.partitionExpressions = window.partitionExpressions;
        ret.orderExpressions = window.orderExpressions;
        ret.orderTypes = window.orderTypes;
        return ret;
    }

    public static SelectQueryBuilder wrappedFrom(SelectQueryBuilder queryBuilder) {
        SelectQueryBuilder qb = new SelectQueryBuilder();
        if (queryBuilder.query.from instanceof QueryAst.Table) {
            QueryAst.Table table = (QueryAst.Table)queryBuilder.query.from;
            qb.from(table.catalog, table.schema, table.name, table.alias);
        } else {
            QueryAst.SelectQuery sq;
            qb.query = sq = (QueryAst.SelectQuery)queryBuilder.query.from;
        }
        return qb;
    }

    public void ensureAliasesMaxLength(int maxLength) {
        HashSet aliases = Sets.newHashSet();
        for (QueryAst.SelectRef e : this.query.selectList) {
            if (e.expr instanceof QueryAst.Comment) continue;
            Object alias = e.alias;
            if (StringUtils.isBlank((String)alias)) {
                alias = "col_" + aliases.size();
            }
            if (((String)alias).length() > maxLength) {
                alias = ((String)alias).substring(0, maxLength);
            }
            if (aliases.contains(alias)) {
                String base = ((String)alias).substring(0, Math.min(maxLength - 5, ((String)alias).length()));
                for (int i = 0; i < 10000 && aliases.contains(alias = base + "_" + i); ++i) {
                }
            }
            e.alias = alias;
            aliases.add(alias);
        }
    }

    public String toSQL(SQLDialect dialect) {
        return QuerySQLWriter.generateSafeSQL(dialect, this.query);
    }

    public class SelectRefBuilder {
        public QueryAst.SelectRef selectRef;

        SelectRefBuilder(QueryAst.SelectRef selectRef) {
            this.selectRef = selectRef;
        }

        public int getIndex() {
            return this.selectRef.index;
        }
    }

    public class JoinClauseBuilder {
        protected QueryAst.JoinClause join;

        public JoinClauseBuilder(QueryAst.JoinClause join) {
            this.join = join;
        }

        public JoinClauseBuilder on(ExpressionBuilder ... builders) {
            for (ExpressionBuilder eb : builders) {
                this.join.on.add(eb.expr);
            }
            return this;
        }

        public void withOperator(String operator) {
            this.join.operatorBetweenConditions = operator;
        }
    }
}

