/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.DSSFileContentCompressors;
import com.dataiku.dip.transactions.fs.FileContentCompressor;
import com.dataiku.dip.transactions.git.CommitQueuesManager;
import com.dataiku.dip.transactions.git.DSSCommitBehavior;
import com.dataiku.dip.transactions.git.DSSCommitQueuesBehavior;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.ICommitBehavior;
import com.dataiku.dip.transactions.git.IGitManager;
import com.dataiku.dip.transactions.git.jgit.DSSSingleRepositoryGitManager;
import com.dataiku.dip.transactions.git.jgit.DevZoneJGitManager;
import com.dataiku.dip.transactions.git.jgit.MultiRepositoryProjectsGitManager;
import java.io.File;
import java.io.IOException;

public class DSSTransactionProviderSettings
extends TransactionProvider.TransactionProviderSettings {
    private final boolean devZone;

    public DSSTransactionProviderSettings(boolean useMainExclusiveLock, boolean forceCacheV1, boolean gitSupport, boolean devZone, File largeFileTempDir, FileContentCompressor compressor) {
        super(useMainExclusiveLock, forceCacheV1, gitSupport, compressor, largeFileTempDir);
        this.devZone = devZone;
        this.nbWriteThreads = DKUApp.getParams().getIntParam("dku.core.fs.nbWriteThreads", Integer.valueOf(8));
        this.enableCRC32Check = DKUApp.getParams().getBoolParam("dku.core.fs.enableCRC32Check", false);
    }

    public DSSTransactionProviderSettings(boolean useMainExclusiveLock, boolean forceCacheV1, boolean gitSupport, boolean devZone) throws IOException {
        this(useMainExclusiveLock, forceCacheV1, gitSupport, devZone, DSSTempUtils.getTempFolderWithSpecificName((String)"txn", (String)"large-files"), DSSTransactionProviderSettings.getFileContentCompressor());
    }

    private static FileContentCompressor getFileContentCompressor() {
        return DSSFileContentCompressors.COMPRESSORS.getOrDefault(DKUApp.getParams().getParam("dku.core.fs.cache.compression"), DSSFileContentCompressors.LZ4_COMPRESSOR);
    }

    public CommitQueuesManager buildCommitQueuesManager(File root) throws IOException {
        Object gitManager;
        Object gitDefaultBaseBranch = null;
        if (this.devZone) {
            gitManager = new DevZoneJGitManager(root);
        } else {
            DSSGitModel.GitMode mode = ApplicationConfigurator.getGitMode();
            switch (mode) {
                case PROJECT: {
                    gitManager = new MultiRepositoryProjectsGitManager(root);
                    break;
                }
                case GLOBAL: {
                    gitManager = new DSSSingleRepositoryGitManager(root);
                    break;
                }
                default: {
                    throw new Error("unreachable");
                }
            }
        }
        return new CommitQueuesManager((CommitQueuesManager.ICommitQueuesBehavior)new DSSCommitQueuesBehavior((IGitManager)gitManager));
    }

    public ICommitBehavior buildCommitBehavior() {
        return new DSSCommitBehavior();
    }
}

