/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git.jgit;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.CommitEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeletedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.transactions.TransactionCodes;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.CommitDef;
import com.dataiku.dip.transactions.git.DSSCommitDef;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.jgit.DSSGitUtils;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.EmptyCommitException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class MultiRepositoryProjectsGitManager
extends JGitManager {
    Git globalGit;
    Map<String, Git> projectGits = new HashMap<String, Git>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.git");

    public MultiRepositoryProjectsGitManager(File root) throws IOException {
        this.root = root;
        this.globalGit = this.initRepository(root, null);
    }

    String getDefaultBranch() {
        return DSSGitUtils.getDefaultBranchUnreliably();
    }

    public void postInit() {
        PubSubService pubSub = (PubSubService)((Object)SpringUtils.getBean(PubSubService.class));
        if (pubSub != null) {
            logger.info((Object)"Git manager registering deletion hook");
            pubSub.subscribe("project-deleted", (DSSEventListener)new DSSEventListener<ProjectDeletedEvent>(){

                public void on(ProjectDeletedEvent evt) {
                    MultiRepositoryProjectsGitManager.this.invalidateSubGit(evt.projectKey);
                }
            });
        }
    }

    public synchronized void invalidateSubGit(String projectKey) {
        logger.info((Object)("Removing cached git for " + projectKey));
        Git removedSubGit = this.projectGits.remove(projectKey);
        if (removedSubGit != null) {
            removedSubGit.close();
        }
    }

    public synchronized void invalidateSubGits() {
        Iterator<Map.Entry<String, Git>> it = this.projectGits.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Git> entry = it.next();
            logger.info((Object)("Removing cached git for " + entry.getKey()));
            Git removedSubGit = entry.getValue();
            if (removedSubGit != null) {
                removedSubGit.close();
            }
            it.remove();
        }
    }

    public Git getGlobalGit() {
        return this.globalGit;
    }

    public JGitManager.SubGit getSubGit(String projectKey) throws IOException {
        Git projectGit = this.buildProjectGit(projectKey, null);
        return new JGitManager.SubGit(projectGit, "");
    }

    public synchronized String commit(CommitDef def) throws IOException {
        String ret;
        DSSCommitDef commitDef = (DSSCommitDef)def;
        if (StringUtils.isBlank((String)commitDef.itemId)) {
            ret = commitDef.changes != null ? this.basicCommitChanges(this.globalGit, this.root, this.gitProtectedFiles, commitDef.author, commitDef.message, Lists.newArrayList((Iterable)commitDef.changes)) : this.basicCommitPatterns(this.globalGit, this.gitProtectedFiles, commitDef.author, commitDef.message, commitDef.filePatterns);
        } else if (commitDef.changes != null) {
            ret = this.commitProjectChanges(commitDef);
        } else {
            Git projectGit = this.buildProjectGit(commitDef.itemId, commitDef.author);
            ret = this.basicCommitPatterns(projectGit, this.gitProtectedFiles, commitDef.author, commitDef.message, commitDef.filePatterns);
        }
        try {
            if (ret != null) {
                PubSubService pubSub = (PubSubService)((Object)SpringUtils.getBean(PubSubService.class));
                pubSub.publish(new CommitEvent(commitDef.message, commitDef.itemId, commitDef.author, ret));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return ret;
    }

    public synchronized void close() {
        if (this.globalGit != null) {
            this.globalGit.close();
            this.globalGit = null;
        }
        for (Git git : this.projectGits.values()) {
            git.close();
        }
        this.projectGits.clear();
    }

    private synchronized Git buildProjectGit(String projectKey, @Nullable GitModel.GitAuthor gitAuthor) throws IOException {
        Git cachedGit = this.projectGits.get(projectKey);
        File repositoryRoot = new File(this.root, "projects/" + projectKey);
        if (cachedGit != null) {
            if (new File(repositoryRoot, ".git").isDirectory()) {
                return cachedGit;
            }
            this.invalidateSubGit(projectKey);
        }
        Git projectGit = this.initRepository(new File(this.root, "projects/" + projectKey), gitAuthor);
        StoredConfig config = projectGit.getRepository().getConfig();
        String currentExcludesFile = config.getString("core", null, "excludesFile");
        String newExcludesFile = Paths.get(this.root.toString(), ".dku-projects-gitignore").normalize().toString();
        if (!newExcludesFile.equals(currentExcludesFile)) {
            config.setString("core", null, "excludesFile", newExcludesFile);
            config.save();
            logger.info((Object)("Updated Git excludesFile configuration for project to: " + newExcludesFile));
        }
        this.projectGits.put(projectKey, projectGit);
        return projectGit;
    }

    private String commitProjectChanges(DSSCommitDef def) throws IOException {
        for (RelFile rf : def.changes) {
            Validate.isTrue((boolean)new RelFile(new String[]{"projects", def.itemId}).isAncestorOf(rf));
        }
        try {
            Git projectGit = this.buildProjectGit(def.itemId, def.author);
            AddCommand add = projectGit.add();
            RmCommand rm2 = projectGit.rm();
            AddCommand update = projectGit.add().setUpdate(true);
            boolean hasRm = false;
            boolean hasAdd = false;
            boolean hasUpdate = false;
            for (RelFile rf : def.changes) {
                String pathRelativeToProject = rf.getFullPath();
                String prefix = "projects/" + def.itemId + "/";
                assert (pathRelativeToProject.startsWith(prefix));
                RelFile toProjectRF = RelFile.fromPath((String)(pathRelativeToProject = pathRelativeToProject.substring(prefix.length())));
                if (!this.gitProtectedFiles.isProtected(toProjectRF)) {
                    File file = rf.resolve(this.root);
                    if (file.exists()) {
                        add.addFilepattern(pathRelativeToProject);
                        hasAdd = true;
                        if (!file.isDirectory()) continue;
                        update.addFilepattern(pathRelativeToProject);
                        hasUpdate = true;
                        continue;
                    }
                    rm2.addFilepattern(pathRelativeToProject);
                    hasRm = true;
                    continue;
                }
                logger.info((Object)("Protected file: " + String.valueOf(rf)));
            }
            if (hasRm) {
                rm2.call();
            }
            if (hasAdd) {
                add.call();
            }
            if (hasUpdate) {
                update.call();
            }
            RevCommit rev = projectGit.commit().setAllowEmpty(false).setSign(Boolean.valueOf(false)).setAuthor(def.author.name, def.author.getEmailOrName()).setMessage(def.message).call();
            return rev.name();
        }
        catch (EmptyCommitException e) {
            logger.info((Object)"No changes to commit");
            return null;
        }
        catch (GitAPIException | JGitInternalException e) {
            throw new CodedIOException((InfoMessage.MessageCode)TransactionCodes.ERR_TRANSACTION_GIT_COMMIT_FAILED, "Unable to commit transaction", e);
        }
    }
}

