/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.fs.FilesystemDatasetConfig;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.PathBasedExtensibleOutputWriter;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class DatasetFileTransferer {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.transfer");

    public void dumpDatasetToZip(AuthCtx authCtx, String projectKey, ReadWriteFS zipWriteFS, RelFile to, Dataset dataset) throws Exception {
        if (dataset.getPartitioningSchema().isPartitioned()) {
            throw ErrorContext.iaef((String)"Dumping partitioned datasets to zip is not supported: %s", (Object)dataset.getFullName(), (Object[])new Object[0]);
        }
        WarningsContext wc = new WarningsContext();
        StreamColumnFactory scf = new StreamColumnFactory();
        StreamRowFactory srf = new StreamRowFactory();
        String outputDir = FilePartitioner.computePartitionRelPathAsFolder(new Partition(null), new PartitioningScheme());
        CSVFormatConfig outputFormatParams = CSVFormatConfig.getStandardTabExcelFormat();
        ResplittableExtensibleReadWriteFSOutputWriter wr = new ResplittableExtensibleReadWriteFSOutputWriter(authCtx, projectKey, zipWriteFS, to, outputDir, 0, 1, "csv", outputFormatParams, dataset.getSchema(), wc, Output.WriteMode.APPEND, outputFormatParams.compress, null);
        wr.init((ColumnFactory)scf);
        try {
            UniversalSingleThreadPusher.push(authCtx, dataset, StreamableDatasetSelection.full(), (ProcessorOutput)wr, (ColumnFactory)scf, (RowFactory)srf);
            wr.lastRowEmitted();
        }
        catch (Exception e) {
            wr.cancel();
            throw e;
        }
    }

    public void loadDatasetFromDir(AuthCtx authCtx, File srcDir, Dataset dataset) throws Exception {
        logger.infoV("Starting to load dataset %s from %s", new Object[]{dataset.getFullName(), srcDir});
        StreamColumnFactory scf = new StreamColumnFactory();
        StreamRowFactory srf = new StreamRowFactory();
        Output.WriteMode mode = Output.WriteMode.OVERWRITE;
        try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, dataset);){
            if (!dh.outputHandlesClear()) {
                if (dh.getMeta().handlesClearForOverwriteMode()) {
                    dh.clearAllData();
                }
                mode = Output.WriteMode.APPEND;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Could not empty dataset first", (Throwable)e);
        }
        ToDatasetStreamer streamer = ToDatasetStreamer.newWithAutoBucketing(authCtx, dataset, new Partition(null), (ColumnFactory)scf, new WarningsContext(), mode);
        ProcessorOutput out = streamer.getAsOutput();
        Dataset inputDataset = new Dataset().withType("Filesystem").withFullName("XXX.source");
        FilesystemDatasetConfig fdc = new FilesystemDatasetConfig();
        fdc.path = srcDir.getAbsolutePath();
        inputDataset.setParams(fdc);
        inputDataset.setSchema(dataset.getSchema());
        inputDataset.setFormatType("csv");
        inputDataset.setFormatParams(CSVFormatConfig.getStandardTabExcelFormat());
        UniversalSingleThreadPusher.push(authCtx, inputDataset, (StreamableDatasetSelection)null, out, (ColumnFactory)scf, (RowFactory)srf);
        logger.info((Object)"done, closing output");
        out.lastRowEmitted();
    }

    public static class ResplittableExtensibleReadWriteFSOutputWriter
    extends PathBasedExtensibleOutputWriter {
        private final ReadWriteFS provider;
        private final RelFile to;

        public ResplittableExtensibleReadWriteFSOutputWriter(AuthCtx authCtx, String projectKey, ReadWriteFS provider, RelFile to, String basePath, int splitId, int nbChunks, String formatType, FormatParams formatParams, Schema schema, WarningsContext warningsContext, Output.WriteMode writeMode, String compress, SerializedDataset.ReadWriteOptions readWriteOptions) {
            super(authCtx, projectKey, basePath, splitId, nbChunks, formatType, formatParams, schema, warningsContext, writeMode, compress, readWriteOptions);
            this.provider = provider;
            this.to = to;
        }

        @Override
        protected boolean isTransactionalMode() {
            return false;
        }

        @Override
        protected OutputStream writeToStream(String path) throws IOException {
            return this.provider.writeStream(this.to.appendChildPath(path));
        }

        @Override
        protected boolean fileExists(String path) {
            return false;
        }
    }
}

